/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.AllocateLogicalNote;
import com.sonicsw.mtstorage.impl.AsyncDeleteNote;
import com.sonicsw.mtstorage.impl.BTreeAddValueNote;
import com.sonicsw.mtstorage.impl.BTreeCopyNote;
import com.sonicsw.mtstorage.impl.BTreeCreateLeafNote;
import com.sonicsw.mtstorage.impl.BTreeCreateNodeNote;
import com.sonicsw.mtstorage.impl.BTreeCreateTreeLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeDeleteLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeEmptyNodeNote;
import com.sonicsw.mtstorage.impl.BTreeInitRootNote;
import com.sonicsw.mtstorage.impl.BTreeInsertNote;
import com.sonicsw.mtstorage.impl.BTreePutLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeRemoveAnyLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeRemoveKeyNote;
import com.sonicsw.mtstorage.impl.BTreeRemoveLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeRemoveSecondaryPointerNote;
import com.sonicsw.mtstorage.impl.BTreeRemoveValueNote;
import com.sonicsw.mtstorage.impl.BTreeReplaceNote;
import com.sonicsw.mtstorage.impl.BTreeRootFirstEntryNote;
import com.sonicsw.mtstorage.impl.BTreeSecondaryCreateNote;
import com.sonicsw.mtstorage.impl.BTreeSetSecondaryDbkNote;
import com.sonicsw.mtstorage.impl.BTreeSplitNote;
import com.sonicsw.mtstorage.impl.BadLogicalNote;
import com.sonicsw.mtstorage.impl.ChainAnchorNote;
import com.sonicsw.mtstorage.impl.CheckpointDoneNote;
import com.sonicsw.mtstorage.impl.CheckpointNote;
import com.sonicsw.mtstorage.impl.CheckpointV2Note;
import com.sonicsw.mtstorage.impl.CreateNote;
import com.sonicsw.mtstorage.impl.DeleteBlobNote;
import com.sonicsw.mtstorage.impl.DeleteByAsyncThreadLogicalNote;
import com.sonicsw.mtstorage.impl.DeleteLogicalNote;
import com.sonicsw.mtstorage.impl.DeleteNote;
import com.sonicsw.mtstorage.impl.INote;
import com.sonicsw.mtstorage.impl.NextFragmentNote;
import com.sonicsw.mtstorage.impl.PageAllocationNote;
import com.sonicsw.mtstorage.impl.PageChainNextNote;
import com.sonicsw.mtstorage.impl.PageChainPrevNote;
import com.sonicsw.mtstorage.impl.PageTypeNote;
import com.sonicsw.mtstorage.impl.RecentTransactionNote;
import com.sonicsw.mtstorage.impl.ReplaceNote;
import com.sonicsw.mtstorage.impl.TransactionBeginNote;
import com.sonicsw.mtstorage.impl.TransactionEndNote;
import com.sonicsw.mtstorage.impl.UpdateLogicalNote;

final class NoteFactory {
    NoteFactory() {
    }

    static boolean isCheckpointNote(byte type) {
        return type == 42 || type == 44;
    }

    static boolean isTransactionEndNote(byte type) {
        return type == 41;
    }

    static INote createNote(byte noteType, byte[] buffer, int offset) {
        AbstractNote note = null;
        switch (noteType) {
            case 1: {
                note = new ChainAnchorNote();
                break;
            }
            case 2: {
                note = new CreateNote();
                break;
            }
            case 3: {
                note = new DeleteBlobNote();
                break;
            }
            case 4: {
                note = new DeleteNote();
                break;
            }
            case 5: {
                note = new PageAllocationNote();
                break;
            }
            case 6: {
                note = new PageChainPrevNote();
                break;
            }
            case 7: {
                note = new PageChainNextNote();
                break;
            }
            case 8: {
                note = new PageTypeNote();
                break;
            }
            case 9: {
                note = new RecentTransactionNote();
                break;
            }
            case 10: {
                note = new ReplaceNote();
                break;
            }
            case 11: {
                note = new NextFragmentNote();
                break;
            }
            case 12: {
                note = new BTreeCreateNodeNote();
                break;
            }
            case 13: {
                note = new BTreeCreateLeafNote();
                break;
            }
            case 14: {
                note = new BTreeCopyNote();
                break;
            }
            case 15: {
                note = new BTreeEmptyNodeNote();
                break;
            }
            case 16: {
                note = new BTreeSplitNote();
                break;
            }
            case 17: {
                note = new BTreeReplaceNote();
                break;
            }
            case 18: {
                note = new BTreeInsertNote();
                break;
            }
            case 19: {
                note = new BTreeInitRootNote();
                break;
            }
            case 20: {
                note = new BTreeRootFirstEntryNote();
                break;
            }
            case 21: {
                note = new BTreeAddValueNote();
                break;
            }
            case 22: {
                note = new BTreeRemoveValueNote();
                break;
            }
            case 23: {
                note = new BTreeRemoveKeyNote();
                break;
            }
            case 24: {
                note = new BTreeSecondaryCreateNote();
                break;
            }
            case 25: {
                note = new BTreeSetSecondaryDbkNote();
                break;
            }
            case 26: {
                note = new BTreeRemoveSecondaryPointerNote();
                break;
            }
            case 40: {
                note = new TransactionBeginNote();
                break;
            }
            case 41: {
                note = new TransactionEndNote();
                break;
            }
            case 42: {
                note = new CheckpointNote();
                break;
            }
            case 43: {
                note = new CheckpointDoneNote();
                break;
            }
            case 44: {
                note = new CheckpointV2Note();
                break;
            }
            case 50: {
                note = new UpdateLogicalNote();
                break;
            }
            case 51: {
                note = new DeleteLogicalNote();
                break;
            }
            case 52: {
                note = new AllocateLogicalNote();
                break;
            }
            case 54: {
                note = new BTreeCreateTreeLogicalNote();
                break;
            }
            case 55: {
                note = new BTreeRemoveLogicalNote();
                break;
            }
            case 56: {
                note = new BTreeRemoveAnyLogicalNote();
                break;
            }
            case 57: {
                note = new BTreePutLogicalNote();
                break;
            }
            case 58: {
                note = new BTreeDeleteLogicalNote();
                break;
            }
            case 59: {
                note = new BadLogicalNote();
                break;
            }
            case 60: {
                note = new DeleteByAsyncThreadLogicalNote();
                break;
            }
            case 80: {
                note = new AsyncDeleteNote();
                break;
            }
            default: {
                throw new Error("Unknown type " + noteType);
            }
        }
        note.initNote(buffer, offset);
        return note;
    }
}

