/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IPageNote;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class RecentTransactionNote
extends AbstractNote
implements IPageNote,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 9;
    byte[] m_scratchBuffer = new byte[8];
    long m_pageNumber;
    long m_oldTransactionNum;
    long m_newTransactionNum;

    RecentTransactionNote() {
    }

    @Override
    public long getPageNum() {
        return this.m_pageNumber;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)9);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_pageNumber);
        writer.write(this.m_scratchBuffer, 0, 8);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_oldTransactionNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_newTransactionNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        return 25;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_pageNumber = BitUtil.getLong(buffer, currentOffset);
        this.m_oldTransactionNum = BitUtil.getLong(buffer, currentOffset += 8);
        this.m_newTransactionNum = BitUtil.getLong(buffer, currentOffset += 8);
    }

    void initNote(long pageNumber, long oldTransactionNum, long newTransactionNum) {
        this.m_pageNumber = pageNumber;
        this.m_oldTransactionNum = oldTransactionNum;
        this.m_newTransactionNum = newTransactionNum;
    }
}

