/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.ActionReader;
import com.sonicsw.mtstorage.impl.IAction;
import com.sonicsw.mtstorage.impl.ILogicalNote;
import com.sonicsw.mtstorage.impl.LogReader;
import com.sonicsw.mtstorage.impl.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

final class SnapshotManager {
    static final Long OBJECT_NOT_IN_SNAPSHUT = new Long(-1L);
    static final Long OBJECT_CREATED_AFTER_SNAPSHUT = null;
    private static final String SMALLEST_POINTER = "S";
    private CurrentSnapshot m_currentSnapshot = new CurrentSnapshot();
    private ArrayList m_snapshots = new ArrayList();
    private HashMap m_snapshotIndex = new HashMap();
    private Logger m_logger;

    SnapshotManager(Logger logger) {
        if (logger == null) {
            return;
        }
        this.m_logger = logger;
    }

    void getMetrics(Properties props, String dbName) {
        props.setProperty(dbName + ".snapshotsSize_statistics", new Long(this.size()).toString());
    }

    boolean isSnapshot(Long snapshotID) {
        if (snapshotID == null) {
            return false;
        }
        return this.m_snapshotIndex.containsKey(snapshotID);
    }

    void createSnapshot(Long snapshotID) {
        Snapshot newSnapshot = new Snapshot(snapshotID);
        this.m_snapshots.add(newSnapshot);
        this.m_snapshotIndex.put(snapshotID, newSnapshot);
    }

    void deleteSnapshot(Long snapshotID) {
        Snapshot snapshot = (Snapshot)this.m_snapshotIndex.remove(snapshotID);
        int snapshotIndex = this.m_snapshots.indexOf(snapshot);
        this.m_snapshots.remove(snapshotIndex);
        if (snapshotIndex > 0) {
            ((Snapshot)this.m_snapshots.get(snapshotIndex - 1)).copyInto(snapshot);
        }
    }

    Long getSmallestPointer() {
        Long theSmallest = null;
        for (int i = 0; i < this.m_snapshots.size(); ++i) {
            Long smallest = ((Snapshot)this.m_snapshots.get(i)).getSmallest();
            if (smallest == null || theSmallest != null && theSmallest <= smallest) continue;
            theSmallest = smallest;
        }
        return theSmallest;
    }

    private int size() {
        int result = 0;
        for (int i = 0; i < this.m_snapshots.size(); ++i) {
            result += ((Snapshot)this.m_snapshots.get(i)).size();
        }
        return result + this.m_currentSnapshot.size();
    }

    IAction getAction(Long snapshotID, Long dbkey, boolean infoOnly) throws IOException {
        Long logPointer = this.getLogPointer(snapshotID, dbkey);
        if (logPointer == OBJECT_CREATED_AFTER_SNAPSHUT) {
            throw new IOException(dbkey + " was not found ");
        }
        if (logPointer.equals(OBJECT_NOT_IN_SNAPSHUT)) {
            return null;
        }
        LogReader logReader = this.m_logger.getNewReader(logPointer);
        ILogicalNote logicalNote = (ILogicalNote)logReader.getNext();
        return new ActionReader().getAction(logReader, logicalNote, infoOnly);
    }

    private Long getLogPointer(Long snapshotID, Long dbkey) throws IOException {
        int snapshotIndex;
        Snapshot snapshot = (Snapshot)this.m_snapshotIndex.get(snapshotID);
        if (snapshot == null) {
            throw new IOException("Snapshot " + snapshotID + " does not exist.");
        }
        for (int i = snapshotIndex = this.m_snapshots.indexOf(snapshot); i < this.m_snapshots.size(); ++i) {
            snapshot = (Snapshot)this.m_snapshots.get(i);
            if (!snapshot.containsDbkey(dbkey)) continue;
            return snapshot.getLogPointer(dbkey);
        }
        if (this.m_currentSnapshot.containsDbkey(dbkey)) {
            return this.m_currentSnapshot.getLogPointer(dbkey);
        }
        return OBJECT_NOT_IN_SNAPSHUT;
    }

    void objectModified(Long transactionID, Long dbkey, Long logicalNoteID) {
        this.m_currentSnapshot.objectModified(transactionID, dbkey, logicalNoteID);
    }

    void objectCreated(Long transactionID, Long dbkey) {
        this.m_currentSnapshot.objectCreated(transactionID, dbkey);
    }

    void transactionCommitted(Long transactionID) {
        SnapshotTable transactionTable = this.m_currentSnapshot.transactionCommitted(transactionID);
        if (transactionTable == null || this.m_snapshots.isEmpty()) {
            return;
        }
        ((Snapshot)this.m_snapshots.get(this.m_snapshots.size() - 1)).copyInto(transactionTable);
    }

    void transactionRolledback(Long transactionID) {
        this.m_currentSnapshot.transactionRolledback(transactionID);
    }

    public static void main(String[] args) throws Exception {
        SnapshotManager manager = new SnapshotManager(null);
        ArrayList<TestSnapshot> snapShots = new ArrayList<TestSnapshot>();
        Long transID = new Long(0L);
        for (int i = 0; i < 1000000; ++i) {
            if (i % 20 == 0) {
                manager.transactionCommitted(transID);
                transID = new Long(i);
            }
            Long dbk = new Long(i % 3000);
            Long pointer = new Long(i + 1000000);
            if (i % 2 == 0) {
                manager.objectModified(transID, dbk, pointer);
            } else {
                manager.objectCreated(transID, dbk);
            }
            for (int j = 0; j < snapShots.size(); ++j) {
                ((TestSnapshot)snapShots.get(j)).changed(dbk, pointer);
            }
            if (i % 100 != 0) continue;
            if (snapShots.size() > 20) {
                TestSnapshot oldSnap = (TestSnapshot)snapShots.remove(0);
                Long oldSnapID = oldSnap.getID();
                manager.deleteSnapshot(oldSnapID);
                oldSnap.done();
            }
            Long snapID = new Long(i);
            snapShots.add(new TestSnapshot(manager, snapID));
            manager.createSnapshot(snapID);
            System.out.println("CREATED SNAPSHOT " + snapID);
        }
    }

    static class TestSnapshot {
        HashMap m_modifications;
        Long m_id;
        SnapshotManager m_manager;

        TestSnapshot(SnapshotManager manager, Long id) {
            this.m_id = id;
            this.m_modifications = new HashMap();
            this.m_manager = manager;
        }

        Long getID() {
            return this.m_id;
        }

        void done() {
            System.out.println("SNAPSHOT " + this.m_id + " DONE WITH " + this.m_modifications.size() + " MODIFICATIONS");
        }

        void changed(Long dbk, Long pointer) throws Exception {
            Long snapPointer = this.m_manager.getLogPointer(this.m_id, dbk);
            boolean changedBefore = this.m_modifications.containsKey(dbk);
            Long beforeVal = (Long)this.m_modifications.get(dbk);
            if (snapPointer == OBJECT_CREATED_AFTER_SNAPSHUT) {
                if (changedBefore && beforeVal != null) {
                    throw new Error("Snap shot instable 1");
                }
                if (!changedBefore) {
                    this.m_modifications.put(dbk, null);
                }
            } else {
                if (snapPointer.equals(OBJECT_NOT_IN_SNAPSHUT)) {
                    throw new Error("Object not found in snapshot");
                }
                if (changedBefore && beforeVal == null) {
                    throw new Error("Snap shot instable 2");
                }
                if (changedBefore && !beforeVal.equals(snapPointer)) {
                    throw new Error("Snap shot instable 3");
                }
                if (!changedBefore) {
                    this.m_modifications.put(dbk, pointer);
                }
            }
        }
    }

    private class SnapshotTable
    extends HashMap {
        private SnapshotTable() {
        }

        void objectModified(Long dbkey, Long logicalNoteID) {
            if (this.containsKey(dbkey)) {
                return;
            }
            Long smallest = (Long)this.get(SnapshotManager.SMALLEST_POINTER);
            if (this.newSmaller(logicalNoteID, smallest)) {
                this.put(SnapshotManager.SMALLEST_POINTER, logicalNoteID);
            }
            this.put(dbkey, logicalNoteID);
        }

        void objectCreated(Long dbkey) {
            if (this.containsKey(dbkey)) {
                return;
            }
            this.put(dbkey, null);
        }

        void substract(SnapshotTable src) {
            for (Object tmp : src.keySet()) {
                if (tmp instanceof String) continue;
                this.remove(tmp);
            }
        }

        void merge(SnapshotTable src) {
            Long smallest = (Long)this.get(SnapshotManager.SMALLEST_POINTER);
            for (Object tmp : src.keySet()) {
                Long dbkey;
                if (tmp instanceof String || this.containsKey(dbkey = (Long)tmp)) continue;
                Long logPointer = (Long)src.get(dbkey);
                this.put(dbkey, logPointer);
                if (!this.newSmaller(logPointer, smallest)) continue;
                smallest = logPointer;
            }
            if (smallest != null) {
                this.put(SnapshotManager.SMALLEST_POINTER, smallest);
            }
        }

        private boolean newSmaller(Long newPointer, Long oldPointer) {
            return newPointer != null && (oldPointer == null || newPointer < oldPointer);
        }
    }

    private final class CurrentSnapshot {
        private HashMap m_byTransactionTable = new HashMap();
        SnapshotTable m_allDbkeys;

        int size() {
            return this.m_allDbkeys.size();
        }

        CurrentSnapshot() {
            this.m_allDbkeys = new SnapshotTable();
        }

        void objectModified(Long transactionID, Long dbkey, Long logicalNoteID) {
            this.getTransactionSnapshot(transactionID).objectModified(dbkey, logicalNoteID);
            this.m_allDbkeys.objectModified(dbkey, logicalNoteID);
        }

        void objectCreated(Long transactionID, Long dbkey) {
            this.getTransactionSnapshot(transactionID).objectCreated(dbkey);
            this.m_allDbkeys.objectCreated(dbkey);
        }

        Long getLogPointer(Long dbkey) throws IOException {
            return (Long)this.m_allDbkeys.get(dbkey);
        }

        boolean containsDbkey(Long dbkey) {
            return this.m_allDbkeys.containsKey(dbkey);
        }

        SnapshotTable transactionCommitted(Long transactionID) {
            SnapshotTable table = (SnapshotTable)this.m_byTransactionTable.remove(transactionID);
            if (table != null) {
                this.m_allDbkeys.substract(table);
            }
            return table;
        }

        void transactionRolledback(Long transactionID) {
            SnapshotTable table = (SnapshotTable)this.m_byTransactionTable.remove(transactionID);
            if (table != null) {
                this.m_allDbkeys.substract(table);
            }
        }

        private SnapshotTable getTransactionSnapshot(Long transactionID) {
            SnapshotTable transactionTable = (SnapshotTable)this.m_byTransactionTable.get(transactionID);
            if (transactionTable == null) {
                transactionTable = new SnapshotTable();
                this.m_byTransactionTable.put(transactionID, transactionTable);
            }
            return transactionTable;
        }
    }

    private final class Snapshot {
        private long m_snapshotID;
        private SnapshotTable m_snapshotTable;

        int size() {
            return this.m_snapshotTable.size();
        }

        Snapshot(long snapshotID) {
            this.m_snapshotID = snapshotID;
            this.m_snapshotTable = new SnapshotTable();
        }

        void copyInto(Snapshot src) {
            this.m_snapshotTable.merge(src.m_snapshotTable);
        }

        void copyInto(SnapshotTable src) {
            this.m_snapshotTable.merge(src);
        }

        long getID() {
            return this.m_snapshotID;
        }

        boolean containsDbkey(Long dbkey) {
            return this.m_snapshotTable.containsKey(dbkey);
        }

        Long getLogPointer(Long dbkey) {
            return (Long)this.m_snapshotTable.get(dbkey);
        }

        Long getSmallest() {
            return (Long)this.m_snapshotTable.get(SnapshotManager.SMALLEST_POINTER);
        }
    }
}

