/*
 * Decompiled with CFR 0.152.
 */
package com.odi;

import com.odi.ObjectException;
import com.odi.imp.ObjRefUtils;
import com.odi.imp.ObjectReference;

public final class ObjectNotExportedException
extends ObjectException {
    private Object unexportedObject;
    private ObjectReference unexportedObjRef;
    private Object referencingObject;
    private ObjectReference referencingObjRef;

    public ObjectNotExportedException(String message, Object unexportedObject, ObjectReference unexportedObjRef) {
        super(message);
        this.unexportedObject = unexportedObject;
        this.unexportedObjRef = unexportedObjRef;
    }

    private static String makeMessage(ObjectReference referencingObjRef, ObjectReference unexportedObjRef) {
        return "Inter-segment reference to the unexported object \"" + ObjRefUtils.typedOIDString(unexportedObjRef) + "\" from the object \"" + ObjRefUtils.typedOIDString(referencingObjRef) + ".";
    }

    public ObjectNotExportedException(Object referencingObject, ObjectReference referencingObjRef, ObjectNotExportedException exception) {
        super(ObjectNotExportedException.makeMessage(referencingObjRef, exception.unexportedObjRef));
        this.unexportedObject = exception.unexportedObject;
        this.referencingObject = referencingObject;
        this.referencingObjRef = referencingObjRef;
    }

    public Object getUnexportedObject() {
        return this.unexportedObject;
    }

    public Object getReferencingObject() {
        return this.referencingObject;
    }
}

