/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter;

import com.odi.filter.AnnotationConstants;
import com.odi.filter.ClassAction;
import com.odi.filter.FilterEnv;
import com.odi.filter.MethodAnnotater;
import com.odi.filter.classfile.ClassAttribute;
import com.odi.filter.classfile.ClassMethod;
import com.odi.filter.classfile.CodeAttribute;
import com.odi.filter.classfile.Descriptor;
import com.odi.filter.classfile.GenericAttribute;
import java.util.Enumeration;
import java.util.Hashtable;

class MethodAction
implements AnnotationConstants {
    private ClassAction theClass;
    private ClassMethod theMethod;
    private MethodAnnotater annotater;
    private static Hashtable safeGenericAttributes = new Hashtable();

    boolean needsAnnotation() {
        return this.annotater.needsAnnotation();
    }

    ClassMethod method() {
        return this.theMethod;
    }

    MethodAction(ClassAction classAction, ClassMethod method) {
        this.theClass = classAction;
        this.theMethod = method;
        this.annotater = new MethodAnnotater(classAction, method);
    }

    void check(FilterEnv env) {
        CodeAttribute codeAttr;
        this.annotater.checkMethod(env);
        if (env.verbose() && (codeAttr = this.theMethod.codeAttribute()) != null) {
            Enumeration e = codeAttr.attributes().elements();
            while (e.hasMoreElements()) {
                ClassAttribute attr = (ClassAttribute)e.nextElement();
                if (!(attr instanceof GenericAttribute) || safeGenericAttributes.get(attr.attrName().asString()) != null) continue;
                String userClass = this.theClass.classControl().userClassName();
                String msg = "method " + userClass + "." + this.theMethod.name().asString() + Descriptor.userMethodArgs(this.theMethod.signature().asString()) + " contains an unrecognized attribute of type " + attr.attrName().asString() + ".  " + "Please check with technical support to see " + "whether this is a problem.";
                env.warning(msg, userClass);
            }
        }
    }

    void retarget(FilterEnv env, Hashtable classTranslations) {
    }

    void annotate(FilterEnv env) {
        this.annotater.annotateMethod(env);
    }

    private static void addSafeAttribute(String attrName) {
        safeGenericAttributes.put(attrName, attrName);
    }

    static {
        MethodAction.addSafeAttribute("COM_Class_type");
        MethodAction.addSafeAttribute("COM_DispMethod");
        MethodAction.addSafeAttribute("COM_ExposedAs");
        MethodAction.addSafeAttribute("COM_ExposedAs_Group");
        MethodAction.addSafeAttribute("COM_FuncDesc");
        MethodAction.addSafeAttribute("COM_Guid");
        MethodAction.addSafeAttribute("COM_GuidPool");
        MethodAction.addSafeAttribute("COM_MapsTo");
        MethodAction.addSafeAttribute("COM_MethodPool");
        MethodAction.addSafeAttribute("COM_ProxiesTo");
        MethodAction.addSafeAttribute("COM_Safety");
        MethodAction.addSafeAttribute("COM_TypeDesc");
        MethodAction.addSafeAttribute("COM_VarTypeDesc");
        MethodAction.addSafeAttribute("COM_VtblMethod");
    }
}

