/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter.classfile;

import com.odi.filter.classfile.ClassPrint;
import com.odi.filter.classfile.Insn;
import com.odi.filter.classfile.InsnError;
import com.odi.filter.classfile.InsnReadEnv;
import com.odi.filter.classfile.InsnTarget;
import java.io.PrintStream;

public class InsnLookupSwitch
extends Insn {
    private InsnTarget defaultOp;
    private int[] matchesOp;
    private InsnTarget[] targetsOp;

    @Override
    public int nStackArgs() {
        return 1;
    }

    @Override
    public int nStackResults() {
        return 0;
    }

    @Override
    public String argTypes() {
        return "I";
    }

    @Override
    public String resultTypes() {
        return "";
    }

    @Override
    public boolean branches() {
        return true;
    }

    @Override
    public void markTargets() {
        this.defaultOp.setBranchTarget();
        for (int i = 0; i < this.targetsOp.length; ++i) {
            this.targetsOp[i].setBranchTarget();
        }
    }

    public InsnTarget defaultTarget() {
        return this.defaultOp;
    }

    public int[] switchCases() {
        return this.matchesOp;
    }

    public InsnTarget[] switchTargets() {
        return this.targetsOp;
    }

    public InsnLookupSwitch(InsnTarget defaultOp, int[] matchesOp, InsnTarget[] targetsOp) {
        this(defaultOp, matchesOp, targetsOp, -1);
    }

    InsnLookupSwitch(InsnTarget defaultOp, int[] matchesOp, InsnTarget[] targetsOp, int offset) {
        super(171, offset);
        this.defaultOp = defaultOp;
        this.matchesOp = matchesOp;
        this.targetsOp = targetsOp;
        if (defaultOp == null || targetsOp == null || matchesOp == null || targetsOp.length != matchesOp.length) {
            throw new InsnError("attempt to create an opc_lookupswitch with invalid operands");
        }
    }

    @Override
    void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.println(this.offset() + "  opc_lookupswitch  ");
        for (int i = 0; i < this.matchesOp.length; ++i) {
            ClassPrint.spaces(out, indent + 2);
            out.println(this.matchesOp[i] + " -> " + this.targetsOp[i].offset());
        }
        ClassPrint.spaces(out, indent + 2);
        out.println("default -> " + this.defaultOp.offset());
    }

    @Override
    int store(byte[] buf, int index) {
        buf[index++] = (byte)this.opcode();
        index = index + 3 & 0xFFFFFFFC;
        index = InsnLookupSwitch.storeInt(buf, index, this.defaultOp.offset() - this.offset());
        index = InsnLookupSwitch.storeInt(buf, index, this.targetsOp.length);
        for (int i = 0; i < this.targetsOp.length; ++i) {
            index = InsnLookupSwitch.storeInt(buf, index, this.matchesOp[i]);
            index = InsnLookupSwitch.storeInt(buf, index, this.targetsOp[i].offset() - this.offset());
        }
        return index;
    }

    @Override
    int size() {
        int basic = (this.offset() + 4 & 0xFFFFFFFC) - this.offset() + 8;
        return basic + this.targetsOp.length * 8;
    }

    static InsnLookupSwitch read(InsnReadEnv insnEnv, int myPC) {
        int thisPC = myPC + 1;
        for (int pads = (thisPC + 3 & 0xFFFFFFFC) - thisPC; pads > 0; --pads) {
            insnEnv.getByte();
        }
        InsnTarget defaultTarget = insnEnv.getTarget(insnEnv.getInt() + myPC);
        int npairs = insnEnv.getInt();
        int[] matches = new int[npairs];
        InsnTarget[] offsets = new InsnTarget[npairs];
        for (int i = 0; i < npairs; ++i) {
            matches[i] = insnEnv.getInt();
            offsets[i] = insnEnv.getTarget(insnEnv.getInt() + myPC);
        }
        return new InsnLookupSwitch(defaultTarget, matches, offsets, myPC);
    }
}

