/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util.concurrent;

import com.odi.LockWaitInterruptedException;
import com.odi.util.concurrent.ReadWriteLock;
import com.odi.util.concurrent.Sync;

public class WriterPreferenceReadWriteLock
implements ReadWriteLock {
    protected long activeReaders_ = 0L;
    protected Thread activeWriter_ = null;
    protected long waitingReaders_ = 0L;
    protected long waitingWriters_ = 0L;
    protected final ReaderLock readerLock_ = new ReaderLock();
    protected final WriterLock writerLock_ = new WriterLock();

    @Override
    public Sync writeLock() {
        return this.writerLock_;
    }

    @Override
    public Sync readLock() {
        return this.readerLock_;
    }

    public synchronized long getWaitingReadersCount() {
        return this.waitingReaders_;
    }

    public synchronized long getWaitingWritersCount() {
        return this.waitingWriters_;
    }

    public synchronized long getActiveReadersCount() {
        return this.activeReaders_;
    }

    public synchronized Thread getActiveWriter() {
        return this.activeWriter_;
    }

    protected synchronized void cancelledWaitingReader() {
        --this.waitingReaders_;
    }

    protected synchronized void cancelledWaitingWriter() {
        --this.waitingWriters_;
    }

    protected boolean allowReader() {
        return this.activeWriter_ == null && this.waitingWriters_ == 0L;
    }

    protected synchronized boolean startRead() {
        boolean allowRead = this.allowReader();
        if (allowRead) {
            ++this.activeReaders_;
        }
        return allowRead;
    }

    protected synchronized boolean startWrite() {
        boolean allowWrite;
        boolean bl = allowWrite = this.activeWriter_ == null && this.activeReaders_ == 0L;
        if (allowWrite) {
            this.activeWriter_ = Thread.currentThread();
        }
        return allowWrite;
    }

    protected synchronized boolean startReadFromNewReader() {
        boolean pass = this.startRead();
        if (!pass) {
            ++this.waitingReaders_;
        }
        return pass;
    }

    protected synchronized boolean startWriteFromNewWriter() {
        boolean pass = this.startWrite();
        if (!pass) {
            ++this.waitingWriters_;
        }
        return pass;
    }

    protected synchronized boolean startReadFromWaitingReader() {
        boolean pass = this.startRead();
        if (pass) {
            --this.waitingReaders_;
        }
        return pass;
    }

    protected synchronized boolean startWriteFromWaitingWriter() {
        boolean pass = this.startWrite();
        if (pass) {
            --this.waitingWriters_;
        }
        return pass;
    }

    protected synchronized Signaller endRead() {
        if (--this.activeReaders_ == 0L && this.waitingWriters_ > 0L) {
            return this.writerLock_;
        }
        return null;
    }

    protected synchronized Signaller endWrite() {
        this.activeWriter_ = null;
        if (this.waitingReaders_ > 0L && this.allowReader()) {
            return this.readerLock_;
        }
        if (this.waitingWriters_ > 0L) {
            return this.writerLock_;
        }
        return null;
    }

    protected class WriterLock
    extends Signaller
    implements Sync {
        protected WriterLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acquire() throws LockWaitInterruptedException {
            InterruptedException ie = null;
            WriterLock writerLock = this;
            synchronized (writerLock) {
                if (!WriterPreferenceReadWriteLock.this.startWriteFromNewWriter()) {
                    try {
                        do {
                            this.wait();
                        } while (!WriterPreferenceReadWriteLock.this.startWriteFromWaitingWriter());
                        return;
                    }
                    catch (InterruptedException ex) {
                        WriterPreferenceReadWriteLock.this.cancelledWaitingWriter();
                        this.notify();
                        ie = ex;
                    }
                }
            }
            if (ie != null) {
                WriterPreferenceReadWriteLock.this.readerLock_.signalWaiters();
                throw new LockWaitInterruptedException("Thread " + Thread.currentThread() + " get interrupted while waiting for a write lock");
            }
        }

        @Override
        public void release() {
            Signaller s = WriterPreferenceReadWriteLock.this.endWrite();
            if (s != null) {
                s.signalWaiters();
            }
        }

        @Override
        synchronized void signalWaiters() {
            this.notify();
        }
    }

    protected class ReaderLock
    extends Signaller
    implements Sync {
        protected ReaderLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void acquire() throws LockWaitInterruptedException {
            InterruptedException ie = null;
            ReaderLock readerLock = this;
            synchronized (readerLock) {
                if (!WriterPreferenceReadWriteLock.this.startReadFromNewReader()) {
                    try {
                        do {
                            this.wait();
                        } while (!WriterPreferenceReadWriteLock.this.startReadFromWaitingReader());
                        return;
                    }
                    catch (InterruptedException ex) {
                        WriterPreferenceReadWriteLock.this.cancelledWaitingReader();
                        ie = ex;
                    }
                }
            }
            if (ie != null) {
                WriterPreferenceReadWriteLock.this.writerLock_.signalWaiters();
                throw new LockWaitInterruptedException(Thread.currentThread() + " get interrupted while waiting for a read lock");
            }
        }

        @Override
        public void release() {
            Signaller s = WriterPreferenceReadWriteLock.this.endRead();
            if (s != null) {
                s.signalWaiters();
            }
        }

        @Override
        synchronized void signalWaiters() {
            this.notifyAll();
        }
    }

    protected abstract class Signaller {
        protected Signaller() {
        }

        abstract void signalWaiters();
    }
}

