/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.io;

import com.progress.blackbird.evs.IEvsDispatcher;
import com.progress.blackbird.io.EIOConnectionAlreadyConnectedException;
import com.progress.blackbird.io.EIOConnectionClosedException;
import com.progress.blackbird.io.EIOConnectionFailedException;
import com.progress.blackbird.io.EIOConnectionNotConnectedException;
import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOFlushPendingException;
import com.progress.blackbird.io.EIOInboundStreamClosedException;
import com.progress.blackbird.io.EIOInboundStreamOpenException;
import com.progress.blackbird.io.EIOTimeoutException;
import com.progress.blackbird.io.IIOConnectionFlushCompletionHandler;
import com.progress.blackbird.io.IIOConnectionPacketHandler;
import com.progress.blackbird.io.IIOConnectionStatistics;
import com.progress.blackbird.io.IIOPacket;
import com.progress.blackbird.sys.SysListHead;

public interface IIOConnection {
    public static final int IOFLAG_PACKET_ABDICATE = 1;
    public static final int IOFLAG_FLUSH_SUPPRESS = 2;
    public static final int IOFLAG_FLUSH_FORCE = 4;

    public boolean isThreaded();

    public IIOConnectionStatistics getStatistics();

    public void connect() throws EIOConnectionAlreadyConnectedException, EIOConnectionClosedException, EIOException;

    public boolean isConnected() throws EIOConnectionClosedException, EIOException;

    public IIOConnection accept(int var1) throws EIOConnectionClosedException, EIOTimeoutException, EIOException;

    public SysListHead receive(int var1) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOTimeoutException, EIOInboundStreamOpenException, EIOException;

    public void read(IEvsDispatcher var1, IIOConnectionPacketHandler var2) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamOpenException, EIOInboundStreamClosedException, EIOException;

    public IIOConnectionPacketHandler setPacketHandler(IIOConnectionPacketHandler var1) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamClosedException, EIOException;

    public boolean write(IIOPacket var1, FlushContext var2, int var3) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException;

    public void flush(FlushContext var1) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOFlushPendingException, EIOException;

    public boolean isInboundStreamOpen() throws EIOConnectionClosedException, EIOException;

    public int getOutboundStreamBufferSize() throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOException;

    public void fail(Exception var1) throws EIOConnectionNotConnectedException, EIOConnectionClosedException, EIOConnectionFailedException, EIOInboundStreamClosedException, EIOException;

    public void close() throws EIOInboundStreamOpenException, EIOFlushPendingException, EIOException;

    public boolean isClosed() throws EIOException;

    public boolean isFailed() throws EIOConnectionClosedException, EIOException;

    public static final class AsyncFlushContext
    extends FlushContext {
        public IEvsDispatcher dispatcher;
        public IIOConnectionFlushCompletionHandler completionHandler;
        public boolean inProgress;
        public boolean syncCompletion;
        public EIOException status;

        public AsyncFlushContext(IEvsDispatcher iEvsDispatcher, IIOConnectionFlushCompletionHandler iIOConnectionFlushCompletionHandler) {
            super(2);
            this.init(iEvsDispatcher, iIOConnectionFlushCompletionHandler);
        }

        public final void init(IEvsDispatcher iEvsDispatcher, IIOConnectionFlushCompletionHandler iIOConnectionFlushCompletionHandler) {
            this.dispatcher = iEvsDispatcher;
            this.completionHandler = iIOConnectionFlushCompletionHandler;
        }

        public final void init(IEvsDispatcher iEvsDispatcher) {
            this.dispatcher = iEvsDispatcher;
        }

        @Override
        public final void reset() {
            this.inProgress = false;
            this.syncCompletion = false;
            this.status = null;
        }

        public final String toString() {
            return "[inProgress=" + this.inProgress + ", syncCompletion=" + this.syncCompletion + ", status=" + (this.status == null ? "ok" : this.status.getMessage()) + "]";
        }
    }

    public static final class SyncNonBlockingFlushContext
    extends FlushContext {
        public boolean complete;

        public SyncNonBlockingFlushContext() {
            super(1);
        }

        @Override
        public final void reset() {
            this.complete = false;
        }

        public final String toString() {
            return "[complete=" + this.complete + "]";
        }
    }

    public static final class SyncBlockingFlushContext
    extends FlushContext {
        public boolean complete;

        public SyncBlockingFlushContext() {
            super(0);
        }

        @Override
        public final void reset() {
            this.complete = false;
        }

        public final String toString() {
            return "[complete=" + this.complete + "]";
        }
    }

    public static abstract class FlushContext {
        public static final int FLUSH_MODE_SYNC_BLOCKING = 0;
        public static final int FLUSH_MODE_SYNC_NON_BLOCKING = 1;
        public static final int FLUSH_MODE_ASYNC = 2;
        public final int flushMode;

        FlushContext(int n) {
            this.flushMode = n;
        }

        public abstract void reset();
    }
}

