/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.pdu.PDUPacket;
import com.progress.blackbird.pdu.PDUPacketHeader;
import com.progress.blackbird.sys.SysInteractive;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public abstract class PDUPacketRequest
extends PDUPacket {
    private long correlationId;
    private static final int BODY_WIRE_SIZE = 8;

    PDUPacketRequest(short s) {
        super(s);
        this.getHeader().setZeroLatency(true);
        this.getHeader().setSynchronous(true);
    }

    PDUPacketRequest(PDUPacketHeader pDUPacketHeader, DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        super(pDUPacketHeader, dataInputStream);
    }

    PDUPacketRequest(PDUPacketHeader pDUPacketHeader, PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        super(pDUPacketHeader, printStream, bufferedReader);
    }

    @Override
    void serializeBody(DataOutputStream dataOutputStream) throws EIOException {
        try {
            dataOutputStream.writeLong(this.correlationId);
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    void deserializeBody(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        try {
            if (dataInputStream.available() < this.getBodyWireSize()) {
                throw new EIOInsufficientDataException(this.getBodyWireSize() - dataInputStream.available());
            }
            this.setCorrelationId(dataInputStream.readLong());
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    void deserializeBody(PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        this.setCorrelationId((long)SysInteractive.ask("Correlation id", printStream, bufferedReader, 0.0));
    }

    @Override
    void cloneBody(PDUPacket pDUPacket) {
    }

    @Override
    int getBodyWireSize() {
        return 8;
    }

    @Override
    String bodyToString() {
        return "{" + this.correlationId + "}";
    }

    public final void setCorrelationId(long l) {
        this.correlationId = l;
    }

    public final long getCorrelationId() {
        return this.correlationId;
    }
}

