/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractContentBuffer;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.Logger;
import com.sonicsw.mtstorage.impl.Page;
import java.io.IOException;

abstract class AbstractContentPage
extends Page {
    private static final short NEXT_CHAIN_PAGE_OFFSET = 10;
    private static final short PREV_CHAIN_PAGE_OFFSET = 18;
    private static final short CHAIN_NUMBER_OFFSET = 26;
    protected static final short CONTENT_BUFFER_OFFSET = 27;
    protected static final short CONTENT_BUFFER_CAPACITY = (short)(Page.PAGE_LENGTH - 27);
    protected AbstractContentBuffer m_contentBuffer;

    AbstractContentPage() {
    }

    @Override
    void initValues() {
        super.initValues();
        this.setChainNext(0L);
        this.setChainPrev(0L);
        this.setChainNum((byte)-1);
        this.m_contentBuffer = null;
    }

    abstract void createBuffer(boolean var1, Logger var2);

    void setChainNum(byte chainNum) {
        this.m_buffer[26] = chainNum;
    }

    byte getChainNum() {
        return this.m_buffer[26];
    }

    void setChainNext(long nextPage) {
        BitUtil.putLong(this.m_buffer, 10, nextPage);
    }

    long getChainNext() {
        return BitUtil.getLong(this.m_buffer, 10);
    }

    void setChainPrev(long prevPage) {
        BitUtil.putLong(this.m_buffer, 18, prevPage);
    }

    long getChainPrev() {
        return BitUtil.getLong(this.m_buffer, 18);
    }

    AbstractContentBuffer getContentBuffer() {
        return this.m_contentBuffer;
    }

    abstract boolean isFree();

    abstract boolean isFull(boolean var1, int var2);

    boolean needsReorg() {
        return this.m_contentBuffer.getNeedsReorg();
    }

    boolean canReorg(long currentTransaction) {
        return this.m_contentBuffer.canReorg(currentTransaction);
    }

    void doReorg() throws IOException {
        this.m_contentBuffer.doReorg();
    }

    @Override
    void setPageType(byte type) {
        super.setPageType(type);
        if (this.m_contentBuffer != null) {
            this.m_contentBuffer.setPageType(type);
        }
    }
}

