/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.IObjectInfo;
import com.sonicsw.mtstorage.impl.IAction;
import com.sonicsw.mtstorage.impl.ObjectInfo;
import com.sonicsw.mtstorage.impl.Storage;
import java.io.IOException;

final class DeleteAction
implements IAction {
    private long m_dbkey;
    private byte m_pageType;
    private byte[] m_deletedData;
    private long m_dataLength;
    private int m_classType;
    private long m_transID;
    private boolean m_deleteByAsyncThread;

    DeleteAction() {
    }

    @Override
    public long getTransactionID() {
        return this.m_transID;
    }

    @Override
    public IObjectInfo getObject(byte[] destination, int offset) {
        System.arraycopy(this.m_deletedData, 0, destination, offset, (int)this.m_dataLength);
        return new ObjectInfo(this.m_classType, (int)this.m_dataLength);
    }

    @Override
    public IObjectInfo getObjectInfo() {
        return new ObjectInfo(this.m_classType, (int)this.m_dataLength);
    }

    long getDbkey() {
        return this.m_dbkey;
    }

    long getPageType() {
        if (this.blobDeleteAction()) {
            return 1L;
        }
        return this.m_pageType;
    }

    boolean blobDeleteAction() {
        return this.m_deletedData == null;
    }

    byte[] getDeletedData() {
        return this.m_deletedData;
    }

    long getDataLength() {
        return this.m_dataLength;
    }

    int getClassType() {
        return this.m_classType;
    }

    void init(long transID, long dbkey, byte pageType, int classType, byte[] deletedData, long dataLength, boolean deleteByAsyncThread) {
        if (deletedData == null) {
            throw new Error("The deleted data buffer can be null only if it's a blob delete action.");
        }
        this.m_transID = transID;
        this.m_dbkey = dbkey;
        this.m_pageType = pageType;
        this.m_classType = classType;
        this.m_deletedData = deletedData;
        this.m_dataLength = dataLength;
        this.m_deleteByAsyncThread = deleteByAsyncThread;
    }

    void init(long transID, long dbkey, boolean deleteByAsyncThread) {
        this.m_transID = transID;
        this.m_dbkey = dbkey;
        this.m_deletedData = null;
        this.m_dataLength = 0L;
        this.m_deleteByAsyncThread = deleteByAsyncThread;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.m_dbkey + " length: " + this.m_dataLength + " class type: " + this.m_classType;
    }

    @Override
    public void undoAction(Storage storage) throws IOException {
        Long transID = new Long(this.m_transID);
        storage.allocate(transID, this.m_classType, this.m_pageType, (int)this.m_dataLength, this.m_dbkey, this.m_deleteByAsyncThread);
        storage.update(transID, this.m_dbkey, this.m_deletedData, 0, (int)this.m_dataLength);
    }
}

