/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.Dbkey;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IObjectsBufferNote;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class DeleteNote
extends AbstractNote
implements IObjectsBufferNote,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 4;
    byte[] m_scratchBuffer = new byte[8];
    long m_dbkey;
    byte m_pageType;
    byte[] m_oldValue;
    int m_offset;
    short m_length;
    boolean m_lead;
    boolean m_last;
    int m_classType;
    long m_totalObjectLength;
    long m_nextFragmentDbkey;

    DeleteNote() {
    }

    public String toString() {
        return this.getClass().getName() + " dbk " + this.m_dbkey + " lead " + this.m_lead;
    }

    @Override
    public long getDbkey() {
        return this.m_dbkey;
    }

    @Override
    public long getPageNum() {
        return Dbkey.getPageNumber(this.m_dbkey);
    }

    @Override
    public byte getSlotNum() {
        return Dbkey.getSlot(this.m_dbkey);
    }

    long getObjectLength() {
        if (!this.m_lead) {
            throw new Error("Only the leading fragment can return the object's length.");
        }
        if (this.m_lead && !this.m_last) {
            return this.m_totalObjectLength;
        }
        return this.m_length;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)4);
        writer.write(this.m_pageType);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_dbkey);
        writer.write(this.m_scratchBuffer, 0, 8);
        BitUtil.putShort(this.m_scratchBuffer, 0, this.m_length);
        writer.write(this.m_scratchBuffer, 0, 2);
        writer.write(this.m_oldValue, this.m_offset, this.m_length);
        writer.write((byte)(this.m_lead ? 1 : 0));
        writer.write((byte)(this.m_last ? 1 : 0));
        int noteLength = 14 + this.m_length;
        if (this.m_lead) {
            BitUtil.putInt(this.m_scratchBuffer, 0, this.m_classType);
            writer.write(this.m_scratchBuffer, 0, 4);
            noteLength += 4;
        }
        if (this.m_lead && !this.m_last) {
            BitUtil.putLong(this.m_scratchBuffer, 0, this.m_totalObjectLength);
            writer.write(this.m_scratchBuffer, 0, 8);
            noteLength += 8;
        }
        if (!this.m_last) {
            BitUtil.putLong(this.m_scratchBuffer, 0, this.m_nextFragmentDbkey);
            writer.write(this.m_scratchBuffer, 0, 8);
            noteLength += 8;
        }
        return noteLength;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_pageType = buffer[currentOffset++];
        this.m_dbkey = BitUtil.getLong(buffer, currentOffset);
        this.m_oldValue = buffer;
        this.m_length = BitUtil.getShort(buffer, currentOffset += 8);
        this.m_offset = currentOffset += 2;
        currentOffset += this.m_length;
        this.m_lead = buffer[currentOffset++] == 1;
        boolean bl = this.m_last = buffer[currentOffset++] == 1;
        if (this.m_lead) {
            this.m_classType = BitUtil.getInt(buffer, currentOffset);
            currentOffset += 4;
        }
        if (this.m_lead && !this.m_last) {
            this.m_totalObjectLength = BitUtil.getLong(buffer, currentOffset);
            currentOffset += 8;
        }
        if (!this.m_last) {
            this.m_nextFragmentDbkey = BitUtil.getLong(buffer, currentOffset);
        }
    }

    void initNote(long dbkey, byte pageType, byte[] oldValue, int offset, short length, boolean lead, boolean last, int classType, long totalObjectLength, long nextFragmentDbkey) {
        this.m_dbkey = dbkey;
        this.m_pageType = pageType;
        this.m_oldValue = oldValue;
        this.m_offset = offset;
        this.m_length = length;
        this.m_lead = lead;
        this.m_last = last;
        this.m_classType = classType;
        this.m_totalObjectLength = totalObjectLength;
        this.m_nextFragmentDbkey = nextFragmentDbkey;
    }
}

