/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.replication;

import com.sonicsw.mtstorage.replication.BlackbirdCommunicationManager;
import com.sonicsw.mtstorage.replication.PeerConnection;
import com.sonicsw.mtstorage.replication.ftchannel.IActiveChannel;
import com.sonicsw.mtstorage.replication.ftchannel.IChannelListener;
import com.sonicsw.mtstorage.replication.ftchannel.IPassiveChannel;
import com.sonicsw.mtstorage.replication.ftchannel.PermanentException;
import com.sonicsw.mtstorage.replication.ftchannel.blackbird.PassiveChannel;
import com.sonicsw.mtstorage.replication.ftchannel.socket.ActiveChannel;
import com.sonicsw.mtstorage.replication.util.Tracer;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.HashMap;

final class BackupConnection
extends PeerConnection {
    private static final boolean USE_BLACKBIRD = System.getProperty("_TEST_do_not_use_blackbird") == null;
    private static final long CONNECT_INTERVAL = 30000L;
    private IActiveChannel m_activeChannel = null;
    private boolean m_closing = false;
    private boolean m_connected = false;
    private boolean m_alwaysRetry = false;
    private IPassiveChannel m_alertChannel = null;
    private HashMap m_commParameters;

    BackupConnection() {
    }

    @Override
    void open(HashMap[] connsConfigs, HashMap commParameters, IChannelListener channelListener, BlackbirdCommunicationManager.ConnectionHandler connHandler, boolean alwaysRetry) {
        this.m_commParameters = commParameters;
        this.m_alwaysRetry = alwaysRetry;
        this.m_alertChannel = USE_BLACKBIRD ? new PassiveChannel() : new com.sonicsw.mtstorage.replication.ftchannel.socket.PassiveChannel();
        try {
            this.m_alertChannel.open(BackupConnection.filterConnectionParameters(connsConfigs, false, false), null, false, false, false);
        }
        catch (IOException e) {
            connHandler.connectFailed(alwaysRetry ? e : new PermanentException(e));
            return;
        }
        this.connectAsync(BackupConnection.filterConnectionParameters(connsConfigs, true, false), channelListener, connHandler);
        this.listenToPrimaryStartup(this.m_alertChannel);
    }

    @Override
    void doNotReportFailure() {
        if (this.m_activeChannel != null) {
            try {
                this.m_activeChannel.doNotReportFailure();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    boolean isConnected() {
        return this.m_connected;
    }

    @Override
    void send(byte[] data, int offset, int length) throws IOException {
        if (this.m_activeChannel == null) {
            throw new IOException("The connection is down");
        }
        this.m_activeChannel.send(data, offset, length);
    }

    private void listenToPrimaryStartup(final IPassiveChannel alertChannel) {
        if (this.m_connected || this.m_closing) {
            alertChannel.close();
            return;
        }
        Thread alertThread = new Thread("Listent To Primary Startup Thread "){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    IActiveChannel primaryAlertChannel = alertChannel.accept(null);
                    primaryAlertChannel.close(false);
                    Tracer.TRACE("BACKUP is notified that PRIMARY is started. Connecting to PRIMARY...");
                    BackupConnection.this.tryAgain();
                }
                catch (InterruptedIOException e) {
                }
                catch (IOException e) {
                    Tracer.TRACE(e);
                }
                finally {
                    alertChannel.close();
                }
            }
        };
        alertThread.setDaemon(true);
        alertThread.start();
    }

    private synchronized void waitBeforeTryingAgain() {
        try {
            this.wait(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void tryAgain() {
        this.notifyAll();
    }

    @Override
    synchronized void close(boolean markOnly) {
        if (this.m_closing) {
            return;
        }
        this.m_closing = true;
        this.notifyAll();
        if (this.m_activeChannel != null) {
            this.m_activeChannel.close(markOnly);
        }
        this.interruptAlertAccept();
    }

    private void interruptAlertAccept() {
        if (this.m_alertChannel != null) {
            this.m_alertChannel.interruptAccept();
        }
    }

    private void connectAsync(final HashMap[] connsConfigs, final IChannelListener channelListener, final BlackbirdCommunicationManager.ConnectionHandler connHandler) {
        this.m_activeChannel = USE_BLACKBIRD ? new com.sonicsw.mtstorage.replication.ftchannel.blackbird.ActiveChannel() : new ActiveChannel();
        Thread acceptThread = new Thread("BackupConnection Connect Thread"){

            @Override
            public void run() {
                boolean connectFailed = false;
                while (!BackupConnection.this.m_closing) {
                    try {
                        BackupConnection.this.m_activeChannel.open(connsConfigs, BackupConnection.this.m_commParameters, channelListener, BackupConnection.this.m_alwaysRetry, false, !connectFailed);
                        BackupConnection.this.m_connected = true;
                        connHandler.connected();
                        BackupConnection.this.interruptAlertAccept();
                        return;
                    }
                    catch (IOException e) {
                        connHandler.connectFailed(e);
                        connectFailed = true;
                        BackupConnection.this.waitBeforeTryingAgain();
                        continue;
                    }
                    catch (PermanentException e) {
                        BackupConnection.this.close(true);
                        connHandler.connectFailed(e);
                        return;
                    }
                    break;
                }
                return;
            }
        };
        acceptThread.setDaemon(true);
        acceptThread.start();
    }
}

