/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter;

import com.odi.filter.ClassAction;
import com.odi.filter.FilterEnv;
import com.odi.filter.FilterError;
import com.odi.filter.classfile.ClassFile;
import com.odi.filter.classfile.ConstClass;
import com.odi.filter.util.ClassFileSource;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ClassControl {
    public static final int PersistUnknown = 0;
    public static final int PersistCapable = 1;
    public static final int PersistAware = 2;
    public static final int TransientOnly = 3;
    public static final int UpdateUnknown = 0;
    public static final int UpdateNew = 1;
    public static final int UpdateNewer = 2;
    public static final int UpdateNotNeeded = 3;
    private ClassFileSource theClassSource;
    private ClassFile theClass;
    private int persistenceType = 0;
    private int initialPersistenceType = 0;
    private boolean implicitlyPersistent = false;
    private boolean explicitlyMentioned = false;
    private int updateType = 0;
    private ClassAction classAction;
    private boolean classUpdated;
    private boolean classRenamed;
    private Hashtable noAnnotateFieldCache;

    public boolean updated() {
        return this.classUpdated;
    }

    public boolean renamed() {
        return this.classRenamed;
    }

    public void noteUpdate(FilterEnv filterEnv) {
        this.checkClassFileFormat(filterEnv);
        this.classUpdated = true;
    }

    public ClassFile classFile() {
        return this.theClass;
    }

    public int persistType() {
        return this.persistenceType;
    }

    public int initialPersistType() {
        return this.initialPersistenceType;
    }

    public boolean persistAware(FilterEnv env) {
        if (this.persistenceType == 0) {
            this.checkPersistAware(env);
        }
        return this.persistenceType == 1 || this.persistenceType == 2;
    }

    public boolean persistCapable(FilterEnv env) {
        if (this.persistenceType == 0) {
            this.checkPersistAware(env);
        }
        return this.persistenceType == 1;
    }

    public boolean filterRequired(FilterEnv env) {
        if (this.updateType == 0) {
            this.checkUpdateType(env);
        }
        return this.updateType == 1 || this.updateType == 2 || env.forceOverwrite();
    }

    public void requireUpdate() {
        this.updateType = 1;
    }

    public boolean annotateable(FilterEnv env) {
        return this.initialPersistenceType == 1 || this.initialPersistenceType == 2 || this.isImplicitlyPersistent();
    }

    public void setPersistType(int ptype) {
        this.persistenceType = ptype;
    }

    public void setInitialPersistType(int ptype) {
        this.initialPersistenceType = ptype;
        this.persistenceType = ptype;
    }

    public boolean isImplicitlyPersistent() {
        return this.implicitlyPersistent;
    }

    public void setImplicitlyPersistent(boolean wasPromoted) {
        this.implicitlyPersistent = wasPromoted;
    }

    public boolean isExplicitlyNamed() {
        return this.explicitlyMentioned;
    }

    public void setExplicitlyNamed(boolean wasNamed) {
        this.explicitlyMentioned = wasNamed;
    }

    public Boolean getNoAnnotateField(String fieldName) {
        if (this.noAnnotateFieldCache == null) {
            return null;
        }
        return (Boolean)this.noAnnotateFieldCache.get(fieldName);
    }

    public void setNoAnnotateField(String fieldName, Boolean noAnnotate) {
        if (this.noAnnotateFieldCache == null) {
            this.noAnnotateFieldCache = new Hashtable(7);
        }
        this.noAnnotateFieldCache.put(fieldName, noAnnotate);
    }

    public ClassAction action() {
        return this.classAction;
    }

    public ClassControl(ClassFileSource theSource, FilterEnv filterEnv) {
        this.theClassSource = theSource;
        this.buildTheClass(true, true, filterEnv.getJDK12CompilerCompatibility());
        this.theClassSource.setExpectedClassName(this.className());
        this.classAction = new ClassAction(this);
    }

    public ClassControl(ClassFileSource theSource, ClassFile theFile, FilterEnv filterEnv) {
        this.theClassSource = theSource;
        this.theClass = theFile;
        this.theClassSource.setExpectedClassName(this.className());
        this.classAction = new ClassAction(this);
    }

    public void scan1(FilterEnv filterEnv) {
        if (this.annotateable(filterEnv) || this.implementsIPersistent(filterEnv)) {
            filterEnv.message("scanning " + this.userClassName());
            this.classAction.scan1(filterEnv, this.filterRequired(filterEnv));
        }
    }

    public void scan2(FilterEnv filterEnv) {
        if (this.annotateable(filterEnv)) {
            filterEnv.message("computing annotations for " + this.userClassName());
            this.classAction.scan2(filterEnv, this.filterRequired(filterEnv));
        }
    }

    public void augmentInterfaces(FilterEnv filterEnv) {
        if (this.annotateable(filterEnv)) {
            this.classAction.augmentInterfaces(filterEnv, this.filterRequired(filterEnv));
        }
    }

    public void retarget(FilterEnv filterEnv, Hashtable classTranslations) {
        if (classTranslations.get(this.className()) != null) {
            this.classRenamed = true;
        }
        filterEnv.message("retargetting class references for " + this.userClassName());
        this.classAction.retarget(filterEnv, classTranslations, this.filterRequired(filterEnv));
        this.theClassSource.setExpectedClassName(this.className());
    }

    public void annotate(FilterEnv filterEnv) {
        if (this.annotateable(filterEnv)) {
            if (this.filterRequired(filterEnv)) {
                filterEnv.message("doing annotations for " + this.userClassName());
                this.classAction.annotate(filterEnv);
            } else {
                filterEnv.message("skipping " + this.userClassName() + " because it is already up to date.");
            }
        }
    }

    public String className() {
        ConstClass cname = this.theClass.className();
        return cname == null ? null : cname.asString();
    }

    public String userClassName() {
        return ClassControl.userClassFromVMClass(this.className());
    }

    public static String userClassFromVMClass(String vmName) {
        return vmName.replace('/', '.');
    }

    public static String vmClassFromUserClass(String userName) {
        return userName.replace('.', '/');
    }

    public String pkg() {
        return ClassControl.packageOf(this.className());
    }

    public static String packageOf(String vmName) {
        int last = vmName.lastIndexOf(47);
        if (last < 0) {
            return "";
        }
        return vmName.substring(0, last);
    }

    public String unpackagedName() {
        return ClassControl.unpackagedNameOf(this.className());
    }

    public static String unpackagedNameOf(String vmName) {
        int last = vmName.lastIndexOf(47);
        if (last < 0) {
            return vmName;
        }
        return vmName.substring(last + 1);
    }

    public String sourceName() {
        return this.theClassSource.containingFilePath();
    }

    public ClassFileSource source() {
        return this.theClassSource;
    }

    public boolean implementsIPersistent(FilterEnv env) {
        return this.implementsInterface("com/odi/IPersistent", null, env);
    }

    public boolean hasIPersistentHooksProvided(FilterEnv env) {
        return this.implementsInterface("com/odi/IPersistentHooks", new Checker(){

            @Override
            boolean checkClass(ClassControl aClass) {
                return aClass != ClassControl.this && aClass.action().getImplementsPersistenceHooks();
            }
        }, env);
    }

    boolean implementsInterface(String implementClassName, Checker ccChecker, FilterEnv env) {
        String currClassName = this.className();
        while (currClassName != null) {
            ClassControl cc = env.findClass(currClassName);
            if (cc == null) {
                return false;
            }
            ClassFile cf = cc.classFile();
            Enumeration interfaces = cf.interfaces().elements();
            while (interfaces.hasMoreElements()) {
                ConstClass i = (ConstClass)interfaces.nextElement();
                String interfaceName = i.asString();
                ClassControl icc = env.findClass(interfaceName);
                if (icc == null) {
                    env.error("Class " + interfaceName + " could not be found.");
                    return false;
                }
                if (!interfaceName.equals(implementClassName) && !icc.implementsInterface(implementClassName, ccChecker, env)) continue;
                return true;
            }
            if (ccChecker != null && ccChecker.checkClass(cc)) {
                return true;
            }
            ConstClass superClass = cf.superName();
            if (superClass == null) {
                return false;
            }
            currClassName = superClass.asString();
        }
        return false;
    }

    boolean inherits(String inheritClassName, FilterEnv env) {
        String currClassName = this.className();
        while (currClassName != null) {
            if (currClassName.equals(inheritClassName)) {
                return true;
            }
            ClassControl cc = env.findClass(currClassName);
            if (cc == null) {
                return false;
            }
            ClassFile cf = cc.classFile();
            ConstClass superClass = cf.superName();
            if (superClass == null) {
                return false;
            }
            currClassName = superClass.asString();
        }
        return false;
    }

    ClassControl findMethodClass(FilterEnv env, String methodName, String methodSig) {
        ClassControl cc;
        String currClassName = this.className();
        while (currClassName != null && (cc = env.findClass(currClassName)) != null) {
            ClassFile cf = cc.classFile();
            if (cf.findMethod(methodName, methodSig) != null) {
                return cc;
            }
            ConstClass superClass = cf.superName();
            if (superClass == null) {
                return null;
            }
            currClassName = superClass.asString();
        }
        env.error("Class " + ClassControl.userClassFromVMClass(currClassName) + " could not be found while trying to locate method " + methodName);
        return null;
    }

    ClassControl findBasestPersistCapable(FilterEnv env) {
        ClassControl cc;
        String currClassName = this.className();
        ClassControl ret = null;
        while (currClassName != null && (cc = env.findClass(currClassName)) != null) {
            ConstClass superClass;
            if (cc.persistCapable(env)) {
                ret = cc;
            }
            if ((superClass = cc.classFile().superName()) == null) {
                return ret;
            }
            currClassName = superClass.asString();
        }
        env.error("Class " + ClassControl.userClassFromVMClass(currClassName) + " could not be found while trying to locate Base class.");
        return null;
    }

    void write(File destFile) throws IOException, FileNotFoundException {
        DataOutputStream dos = this.theClassSource.getOutputStream(destFile);
        this.theClass.write(dos);
        dos.close();
    }

    private void checkClassFileFormat(FilterEnv filterEnv) {
        int major = this.theClass.getMajorVersion();
        int minor = this.theClass.getMinorVersion();
        if (major == 45 && minor == 3 || major == 46 && minor == 0 || major == 47 && minor == 0 || major == 48 && minor == 0) {
            return;
        }
        filterEnv.error("The format of class '" + this.theClass.className().asString() + "' is of type " + this.theClass.getClassFormatVersionString() + ".  Classes of this format cannot be currently annotated.");
    }

    private void checkPersistAware(FilterEnv filterEnv) {
        if (this.persistenceType == 0) {
            this.persistenceType = this.action().hasAnnotatedAttribute(filterEnv) ? (this.action().hasClassInfoStatic() && this.implementsIPersistent(filterEnv) ? 1 : 2) : (this.implementsIPersistent(filterEnv) || this.classFile().isInterface() ? 1 : 3);
        }
    }

    private void checkUpdateType(FilterEnv filterEnv) {
        if (this.updateType == 0) {
            String pkg = this.pkg();
            String xlat = (String)filterEnv.translations.get(pkg);
            String lookupName = xlat != null ? (xlat.length() == 0 ? this.unpackagedName() : xlat + "/" + this.unpackagedName()) : this.className();
            ClassFileSource annotatedSource = filterEnv.updateInPlace() && !this.theClassSource.isZipped() ? this.theClassSource : filterEnv.lookupDestClass(lookupName);
            if (annotatedSource == null) {
                this.updateType = 1;
            } else {
                try {
                    long annModDate = annotatedSource.modificationDate();
                    long srcModDate = this.source().modificationDate();
                    this.updateType = annModDate < srcModDate ? 2 : (annotatedSource == this.theClassSource && !this.action().hasAnnotatedAttribute(filterEnv) ? (this.persistType() == 1 || this.persistType() == 2 ? 2 : 3) : (this.persistType() == 1 && !this.classInfoExists(filterEnv, lookupName) ? 2 : 3));
                }
                catch (FileNotFoundException e) {
                    this.updateType = 1;
                }
            }
        }
    }

    private boolean classInfoExists(FilterEnv filterEnv, String myName) {
        String classInfoName = myName + "ClassInfo";
        return filterEnv.canFindClass(classInfoName) || filterEnv.lookupDestClass(classInfoName) != null;
    }

    private void buildTheClass(boolean allowJDK12ClassFiles, boolean allowJDK13ClassFiles, boolean jdk12CompilerCompatibility) {
        try {
            DataInputStream dis;
            try {
                dis = this.theClassSource.classFileContents();
            }
            catch (FileNotFoundException e) {
                throw new FilterError("The file " + this.sourceName() + " wasn't found");
            }
            this.theClass = new ClassFile(dis, allowJDK12ClassFiles, allowJDK13ClassFiles);
            if (jdk12CompilerCompatibility) {
                this.theClass.moveEnclosingPointerToFront();
            }
            dis.close();
        }
        catch (IOException e) {
            throw new FilterError("I/O error while reading " + this.sourceName());
        }
    }

    abstract class Checker {
        Checker() {
        }

        abstract boolean checkClass(ClassControl var1);
    }
}

