/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter.util;

import com.odi.filter.util.ClassFileSource;
import com.odi.filter.util.ClassPackageEnumeration;
import com.odi.filter.util.ClassPathElement;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;

public class ClassPath {
    private String theClassPathSpec;
    private ClassPathElement theClassPath;

    public ClassPath(String path) {
        this.theClassPathSpec = path;
        this.parsePath();
    }

    public ClassFileSource findClass(String className) {
        return ClassPath.findClass(className, this.theClassPath);
    }

    static ClassFileSource findClass(String className, ClassPathElement path) {
        for (ClassPathElement e = path; e != null; e = e.next()) {
            ClassFileSource source = e.sourceOf(className);
            if (source == null) continue;
            source.setSourceElement(e);
            return source;
        }
        return null;
    }

    public static String fileNameOf(String className, char separator) {
        StringBuffer path = new StringBuffer();
        StringTokenizer parser = new StringTokenizer(className, "./", false);
        boolean first = true;
        while (parser.hasMoreElements()) {
            if (!first) {
                path.append(separator);
            }
            path.append(parser.nextToken());
            first = false;
        }
        path.append(".class");
        return path.toString();
    }

    public static String fileNameOf(String className) {
        return ClassPath.fileNameOf(className, File.separatorChar);
    }

    public static String zipFileNameOf(String className) {
        return ClassPath.fileNameOf(className, '/');
    }

    public static String classNameOf(String fileName) {
        int fnlen = fileName.length();
        if (fnlen > 6 && fileName.regionMatches(true, fnlen - 6, ".class", 0, 6)) {
            fileName = fileName.substring(0, fileName.length() - 6);
            StringBuffer className = new StringBuffer();
            StringTokenizer parser = new StringTokenizer(fileName, "\\/", false);
            boolean first = true;
            while (parser.hasMoreElements()) {
                if (!first) {
                    className.append('/');
                }
                className.append(parser.nextToken());
                first = false;
            }
            return className.toString();
        }
        return null;
    }

    public boolean remove(File directory) {
        boolean matched = false;
        ClassPathElement firstElement = this.theClassPath;
        ClassPathElement prevElement = null;
        for (ClassPathElement cpe = firstElement; cpe != null; cpe = cpe.next()) {
            if (cpe.matches(directory)) {
                matched = true;
                if (prevElement == null) {
                    firstElement = cpe.next();
                    continue;
                }
                prevElement.setNext(cpe.next());
                continue;
            }
            prevElement = cpe;
        }
        this.theClassPath = firstElement;
        return matched;
    }

    public void append(File directory) {
        this.append(ClassPathElement.create(directory.getPath()));
    }

    public void append(ClassPathElement anElement) {
        if (this.theClassPath == null) {
            this.theClassPath = anElement;
        } else {
            this.theClassPath.append(anElement);
        }
    }

    public Enumeration classesInPackage(String packageName) {
        return new ClassPackageEnumeration(this, packageName);
    }

    ClassPathElement getPathElements() {
        return this.theClassPath;
    }

    private void parsePath() {
        StringTokenizer parser = new StringTokenizer(this.theClassPathSpec, File.pathSeparator, false);
        ClassPathElement lastElement = null;
        while (parser.hasMoreElements()) {
            ClassPathElement anElement = ClassPathElement.create(parser.nextToken());
            if (lastElement == null) {
                this.theClassPath = anElement;
            } else {
                lastElement.append(anElement);
            }
            lastElement = anElement;
        }
    }
}

