/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.ChangeSynchronization;
import com.odi.ClassInfo;
import com.odi.ClassNotRegisteredException;
import com.odi.Cluster;
import com.odi.DatabaseNotOpenException;
import com.odi.ExternalReference;
import com.odi.FatalApplicationException;
import com.odi.FatalInternalException;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.NoSessionException;
import com.odi.NoTransactionInProgressException;
import com.odi.ObjectException;
import com.odi.ObjectNotFoundException;
import com.odi.ObjectNotPersistenceCapableException;
import com.odi.ObjectNotPersistentException;
import com.odi.ObjectStore;
import com.odi.ObjectStoreConstants;
import com.odi.ObjectStoreException;
import com.odi.Persistent;
import com.odi.Placement;
import com.odi.Session;
import com.odi.Transaction;
import com.odi.TransactionInProgressException;
import com.odi.TransactionSynchronization;
import com.odi.UpdateReadOnlyException;
import com.odi.WrongSessionException;
import com.odi.imp.Database;
import com.odi.imp.GenericObject;
import com.odi.imp.GenericObjectFactory;
import com.odi.imp.HashBucket;
import com.odi.imp.IPersistentCacheHooks;
import com.odi.imp.MutatingObjRef;
import com.odi.imp.ObjRefUtils;
import com.odi.imp.ObjectAccess;
import com.odi.imp.ObjectReference;
import com.odi.imp.ObjectReferenceFactory;
import com.odi.imp.ObjectReferencesEnumeration;
import com.odi.imp.ObjectTable;
import com.odi.imp.Pool;
import com.odi.imp.Reference;
import com.odi.imp.ReferenceType;
import com.odi.imp.SchemaManager;
import com.odi.imp.Segment;
import com.odi.imp.Server;
import com.odi.imp.TypeCodeConstants;
import com.odi.imp.UnregisteredType;
import com.odi.imp.Utilities;
import com.odi.imp.WeakCache;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;

public final class ObjectManager
extends Session
implements TypeCodeConstants,
ObjectStoreConstants {
    com.odi.imp.Transaction tx;
    public Server sv;
    private ObjectTable OT;
    public SchemaManager schemaManager;
    private String serverHost;
    public ObjectAccess objectAccess;
    Pool theGOPool = new Pool(new GenericObjectFactory());
    private String productNameString;
    private String storageSystem;
    public int product;
    boolean createObjectsLazily = false;
    private Hashtable lazyArrayRefObjects = null;
    Properties plist = null;
    private int lastTransactionRetainType = 1;
    int defaultAbortRetain = 2;
    int defaultCommitRetain = 2;
    private ObjectReference flushedObjectReference;
    public static final int ANY_ALIGNMENT = 0;
    private char[] charBuffer = new char[128];
    private int newObjectCount = 0;
    private int countFetch = 0;
    private int countDeepFetch = 0;
    private int countDirty = 0;
    private int countEvict = 0;
    private int countCommit = 0;
    private int countAbort = 0;
    private int countFlushContents = 0;
    private int countCacheContents = 0;
    private int countClearContents = 0;
    private int countInitializeContents = 0;
    private int countInitializeContentsFromCache = 0;
    private int countClientInvalidatedObjects = 0;
    private int countCreate = 0;
    private int countMigrateEmpty = 0;
    private int countMigrateFull = 0;
    private int countResolveLazyRefs = 0;
    private int countGetLazyRefs = 0;
    public ObjectReferenceFactory objRefFactory = null;
    private Placement placementForSerial;
    boolean cachingIsDisabled;
    int txnAgeForCaching = 100;
    int maxCachedObjects = 5000;
    private int cachedObjectCount = 0;
    private boolean cacheFullForThisTxn = false;
    private short checkCacheFullForTxnIndex = 0;
    long[] transactionIds = new long[256];
    short currentTransactionIndex = 0;
    private Stack cachedObjectIterators = new Stack();
    private MutatingObjRef tempObjRef;
    private int lastDatabaseId = -1;
    private int lastSegmentId;
    private int lastClusterId;
    private Cluster lastCluster;
    Vector transactionSynchronizationHandlers = null;
    Vector changeSynchronizationHandlers = null;
    boolean changeSynchronizationEnabled = false;

    public static void fetch(Object object) {
        ObjectManager om = ObjectManager.findCurrent();
        if (om != null) {
            om.fetchObject(object);
        }
    }

    public static void fetch(IPersistent pobject) {
        ObjectManager.assureCurrent(6).fetchObject(pobject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deepFetch(Object object) {
        ObjectManager om;
        if (object == null) {
            return;
        }
        if (!(object instanceof IPersistent) && !Utilities.isArray(object)) {
            return;
        }
        ObjectManager objectManager = om = object instanceof IPersistent ? ObjectManager.assureCurrent() : ObjectManager.findCurrent();
        if (om == null) {
            return;
        }
        if (om.isPersistentObject(object)) {
            IdentitySet fetchedObjects = new IdentitySet(53);
            IdentitySet retryRoots = new IdentitySet(53);
            ObjectManager objectManager2 = om;
            synchronized (objectManager2) {
                om.deepFetchObject(object, fetchedObjects, retryRoots, 100);
                while (!retryRoots.isEmpty()) {
                    Object o = retryRoots.pop();
                    om.deepFetchObject(o, fetchedObjects, retryRoots, 100);
                }
            }
        } else {
            throw new ObjectStoreException("deepFetch for transient objects not implemented yet. Call migrate on the object first.");
        }
    }

    public static void dirty(Object object) {
        ObjectManager om = ObjectManager.findCurrent();
        if (om != null) {
            om.dirtyObject(object);
        }
    }

    public static void dirty(IPersistent pobject) {
        ObjectManager om = ObjectManager.assureCurrent();
        if (om.tx != null || om.lastTransactionRetainType != 4) {
            om.assureTransactionCompatible(7);
        }
        om.dirtyObject(pobject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCached(Object object) {
        ObjectManager om;
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            return om.isCachedObject(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evictAll(int retain) {
        ObjectManager.checkRetain(retain, false, true);
        ObjectManager om = ObjectManager.findCurrent();
        if (om != null) {
            ObjectManager objectManager = om;
            synchronized (objectManager) {
                boolean outsideTransaction;
                boolean bl = outsideTransaction = om.tx == null;
                if (!outsideTransaction) {
                    om.commitInternal(retain, true);
                    if (retain == 3) {
                        return;
                    }
                }
                WeakCache.WeakCacheEnumeration objects = om.OT.getObjects();
                while (objects.hasMoreElements()) {
                    Object object = objects.nextElement();
                    if (outsideTransaction) {
                        om.evictObjectOutsideTransaction(object, retain);
                        continue;
                    }
                    om.evictObject(object, retain);
                }
                if (!outsideTransaction && retain == 1) {
                    om.tx.serverAfterBegin();
                }
            }
        }
    }

    static void checkRetain(int retain, boolean allowRetainUpdate, boolean allowRetainTransient) {
        switch (retain) {
            case 1: 
            case 2: 
            case 3: {
                return;
            }
            case 4: {
                if (allowRetainUpdate) {
                    return;
                }
            }
            case 5: {
                if (!allowRetainTransient) break;
                return;
            }
        }
        throw new IllegalArgumentException("Invalid retain argument: " + ObjectManager.retainTypeName(retain));
    }

    public static String retainTypeName(int retainType) {
        switch (retainType) {
            case 1: {
                return "ObjectStore.RETAIN_STALE";
            }
            case 2: {
                return "ObjectStore.RETAIN_HOLLOW";
            }
            case 3: {
                return "ObjectStore.RETAIN_READONLY";
            }
            case 4: {
                return "ObjectStore.RETAIN_UPDATE";
            }
            case 5: {
                return "ObjectStore.RETAIN_TRANSIENT";
            }
        }
        return Integer.toString(retainType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evict(Object object, int retain) {
        ObjectManager om;
        if (object instanceof IPersistent) {
            ObjectManager.evict((IPersistent)object, retain);
            return;
        }
        ObjectManager.checkRetain(retain, false, false);
        if (ObjectManager.isOTObject(object) && (om = ObjectManager.findCurrent()) != null) {
            ObjectManager objectManager = om;
            synchronized (objectManager) {
                if (om.tx == null) {
                    om.evictObjectOutsideTransaction(object, retain);
                } else {
                    om.evictObject(object, retain);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evict(IPersistent object, int retain) {
        ObjectManager.checkRetain(retain, false, false);
        if (ObjectManager.isPersistent(object)) {
            ObjectManager om;
            ObjectManager objectManager = om = ObjectManager.assureCurrent();
            synchronized (objectManager) {
                if (om.tx == null) {
                    om.evictObjectOutsideTransaction(object, retain);
                } else {
                    om.evictObject(object, retain);
                }
            }
        }
    }

    public static void migrate(Object object, Placement placement) {
        ObjectManager.assureCurrent(7).migrateObject(object, placement);
    }

    public static Object getExtRef(ExternalReference extref) {
        return ObjectManager.assureCurrent(6).getExtRefObject(extref);
    }

    public static void setExtRef(Object object, ExternalReference extref) {
        ObjectManager.assureCurrent(6).setExtRefObject(object, extref);
    }

    public static Iterator getCachedObjects() {
        return ObjectManager.assureCurrent().getCachedObjectsIterator();
    }

    public static void decache(Object cachedObject) {
        ObjectManager.assureCurrent().decacheObject(cachedObject);
    }

    public static void clearCache() {
        ObjectManager om = ObjectManager.assureCurrent();
        om.clearAllCachedObjects();
    }

    public static void clearCache(int nTransactions) {
        if (nTransactions <= 0) {
            throw new IllegalArgumentException("The value for nTransactions should be greater than 0.");
        }
        if (nTransactions > 255) {
            nTransactions = 255;
        }
        ObjectManager.assureCurrent().clearCachedObjects(nTransactions);
    }

    public static int getCachedObjectTxnAge(Object cachedObject) {
        return ObjectManager.assureCurrent().getObjectTransactionAge(cachedObject);
    }

    synchronized Iterator getCachedObjectsIterator() {
        return new CachedObjectIterator(this);
    }

    private void addCachedObjectIterator(CachedObjectIterator iter) {
        this.cachedObjectIterators.addElement(iter);
    }

    private void removeCachedObjectIterator(CachedObjectIterator iter) {
        this.cachedObjectIterators.removeElement(iter);
    }

    synchronized void decacheObject(Object cachedObject) {
        ObjectReference objRef = this.isPersistentObjectInternal(cachedObject);
        if (objRef == null) {
            return;
        }
        if (this.isCachedObject(cachedObject, objRef)) {
            this.clearContents(cachedObject);
            this.OT.adjustReadBarrier(cachedObject, objRef, ObjectTable.READ_BARRIER_UP);
            this.decrementCachedObjectCount();
        }
    }

    synchronized void clearCachedObjects(int nTransactions) {
        this.expireCache(nTransactions, true);
    }

    synchronized void clearAllCachedObjects() {
        this.expireFullCache();
    }

    synchronized boolean isCachedObject(Object object) {
        ObjectReference objRef = this.isPersistentObjectInternal(object);
        if (objRef == null) {
            return false;
        }
        return this.isCachedObject(object, objRef);
    }

    synchronized int getObjectTransactionAge(Object object) {
        ObjectReference objRef = this.isPersistentObjectInternal(object);
        if (objRef != null && this.isCachedObject(object, objRef)) {
            int age = this.currentTransactionIndex - objRef.getTxnIndex();
            if (age < 0) {
                age += 256;
            }
            return age;
        }
        return -1;
    }

    public synchronized Object resolveLazyReference(Placement place, Reference lazyRef, int AFTypeCode, int arrayElementCount) {
        Object o;
        if (lazyRef.isNull()) {
            return null;
        }
        this.assureTransactionCompatible(6);
        ++this.countResolveLazyRefs;
        lazyRef.REFTYPE().resolveObjectReference(this.tempObjRef, place, lazyRef, AFTypeCode, arrayElementCount);
        if (AFTypeCode == 17 || Utilities.isArrayTypeCode(AFTypeCode)) {
            this.sv.elaborateLazyReference(this.tempObjRef, true);
        }
        if ((o = this.OT.findObject(this.tempObjRef)) != null) {
            return o;
        }
        return this.createHollowObject(this.tempObjRef);
    }

    public Object resolveLazyReference(Reference lazyRef, Placement cluster) {
        return this.resolveLazyReference(cluster, lazyRef, 17, 0);
    }

    public synchronized Reference getLazyReference(ReferenceType refType, Object object) {
        if (object == null) {
            return refType.NULL();
        }
        this.assureTransactionCompatible(6);
        ++this.countGetLazyRefs;
        ObjectReference objRef = this.getObjRef(object, false);
        return refType.getReference(objRef);
    }

    public static void destroy(Object object) {
        ObjectManager om;
        if (object == null) {
            return;
        }
        if (object instanceof IPersistent && ObjectManager.isPersistent((IPersistent)object)) {
            ObjectManager.assureCurrent().destroyObject(object);
        } else if (ObjectManager.isOTObject(object) && (om = ObjectManager.findCurrent()) != null) {
            om.destroyObject(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Database databaseOf(Object object) {
        ObjectManager om;
        ObjectManager objectManager = om = ObjectManager.assureCurrent(6);
        synchronized (objectManager) {
            return om.dbOf(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Segment segmentOf(Object object) {
        ObjectManager om;
        ObjectManager objectManager = om = ObjectManager.assureCurrent(6);
        synchronized (objectManager) {
            return om.segOf(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static com.odi.imp.Cluster clusterOf(Object object) {
        ObjectManager om;
        ObjectManager objectManager = om = ObjectManager.assureCurrent(6);
        synchronized (objectManager) {
            return om.cluOf(object);
        }
    }

    public Database getDatabase(int databaseId) {
        return this.sv.getDatabase(databaseId);
    }

    public static boolean isPersistent(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof IPersistent) {
            return ObjectManager.isPersistent((IPersistent)o);
        }
        return ObjectManager.assureCurrent().isPersistentObject(o);
    }

    public static boolean isPersistent(Object[] o) {
        return o == null ? false : ObjectManager.assureCurrent().isPersistentObject(o);
    }

    public static boolean isPersistent(IPersistent o) {
        if (o == null) {
            return false;
        }
        ObjectReference ref = o.ODIgetRef();
        if (ref == null) {
            return false;
        }
        if (ObjRefUtils.isInvalid(ref)) {
            ObjectManager.assureCurrent().getObjRef(o);
        }
        return true;
    }

    public static boolean isStale(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof IPersistent)) {
            return false;
        }
        ObjectReference ref = ((IPersistent)object).ODIgetRef();
        if (ref == null) {
            return false;
        }
        return ObjRefUtils.isStale(ref) || ObjRefUtils.isDestroyed(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDestroyed(Object object) {
        ObjectReference ref;
        if (object == null) {
            return false;
        }
        ObjectManager om = null;
        if (object instanceof IPersistent) {
            ref = ((IPersistent)object).ODIgetRef();
            if (ref != null) {
                om = ObjectManager.assureCurrent();
            }
        } else {
            if (!ObjectManager.isOTObject(object)) {
                return false;
            }
            om = ObjectManager.findCurrent();
            if (om == null) {
                return false;
            }
            ObjectManager objectManager = om;
            synchronized (objectManager) {
                ref = om.OT.findObjRef(object, false, false);
            }
        }
        return om == null ? false : om.isObjectDestroyed(object, ref);
    }

    public synchronized boolean isObjectDestroyed(Object object, ObjectReference objRef) {
        if (objRef == null) {
            return false;
        }
        if (ObjRefUtils.isDestroyed(objRef)) {
            return true;
        }
        if (!ObjRefUtils.hasRB(objRef)) {
            return false;
        }
        if (ObjectManager.isPrefetchedObject(object)) {
            return false;
        }
        try {
            this.fetchObject(object, false);
            return false;
        }
        catch (ObjectNotFoundException onfe) {
            ObjRefUtils.setDestroyed(objRef, true);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isObjectDestroyed(Object object) {
        ObjectReference ref;
        if (object == null) {
            return false;
        }
        if (object instanceof IPersistent) {
            ref = ((IPersistent)object).ODIgetRef();
        } else {
            if (!ObjectManager.isOTObject(object)) {
                return false;
            }
            ObjectManager objectManager = this;
            synchronized (objectManager) {
                ref = this.OT.findObjRef(object, false, false);
            }
        }
        return ref == null ? false : ObjRefUtils.isDestroyed(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAutoOpenMode(int openMode) {
        ObjectManager om;
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            if (openMode != 6 && openMode != 7 && openMode != 3 && openMode != 10 && openMode != 99) {
                throw new IllegalArgumentException("Invalid auto-open mode: " + openMode);
            }
            om.sv.serverSetAutoOpenMode(openMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAutoOpenMode() {
        ObjectManager om;
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            return om.sv.serverGetAutoOpenMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acquireLock(Object object, int lockType, int timeoutMillis) {
        ObjectManager om;
        if (object == null) {
            Utilities.throwNullArgumentException("ObjectStore", "acquireLock", "object");
        }
        ObjectManager.checkAcquireLockArguments(lockType, timeoutMillis, "ObjectStore");
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            om.acquireLockObject(object, lockType, timeoutMillis);
        }
    }

    static void checkAcquireLockArguments(int lockType, int timeoutMillis, String className) {
        if (lockType != 6 && lockType != 7) {
            throw new IllegalArgumentException("Invalid lockType argument to " + className + ".acquireLock: " + lockType);
        }
        if (timeoutMillis != -1 && timeoutMillis < 0) {
            throw new IllegalArgumentException("Invalid negative value for the timeoutMillis argument to " + className + ".acquireLock: " + timeoutMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void instanceBecome(Object otherObject, Object thisObject) {
        ObjectManager om = ObjectManager.assureCurrent(7);
        if (om != null) {
            ObjectManager objectManager = om;
            synchronized (objectManager) {
                om.doInstanceBecome(otherObject, thisObject);
            }
        }
    }

    private void doInstanceBecome(Object otherObject, Object thisObject) {
        this.assureTransactionCompatible(7);
        if (otherObject == null) {
            Utilities.throwNullArgumentException("ObjectStore", "_instanceBecome", "otherObject");
        } else if (thisObject == null) {
            Utilities.throwNullArgumentException("ObjectStore", "_instanceBecome", "thisObject");
        }
        this.fetchObject(thisObject);
        ObjectReference otherRef = this.isPersistentObjectInternal(otherObject);
        ObjectReference thisRef = this.isPersistentObjectInternal(thisObject);
        if (thisRef == null || otherRef == null) {
            throw new ObjectNotPersistentException((Object)"Both objects must be persistent in a call to ObjectStore._instanceBecome()");
        }
        this.sv.serverInstanceBecome(otherRef, thisRef);
        long loc = otherRef.getLocation();
        int AFT = otherRef.getAFTypeCode();
        this.destroyObjectInternal(otherObject, otherRef);
        this.dirtyObject(thisObject);
        this.OT.removeAssociation(thisObject, thisRef);
        this.tempObjRef.set(thisRef);
        this.tempObjRef.location = loc;
        this.tempObjRef.AFTypeCode = AFT;
        this.OT.enterWritableAssociation(this.tempObjRef, thisObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void classBecome(Hashtable table) {
        ObjectManager om = ObjectManager.assureCurrent(7);
        if (om != null) {
            ObjectManager objectManager = om;
            synchronized (objectManager) {
                om.assureTransactionCompatible(7);
                om.sv.serverClassBecome(table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameClass(String oldClassName, String newClassName) {
        ObjectManager om = ObjectManager.assureCurrent(7);
        if (om != null) {
            ObjectManager objectManager = om;
            synchronized (objectManager) {
                om.assureTransactionCompatible(7);
                om.sv.serverRenameClass(oldClassName, newClassName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteClass(String className) {
        ObjectManager om = ObjectManager.assureCurrent(7);
        if (om != null) {
            ObjectManager objectManager = om;
            synchronized (objectManager) {
                om.assureTransactionCompatible(7);
                om.sv.serverDeleteClass(className);
            }
        }
    }

    public static void setPlacementForSerialization(Placement placement) {
        ObjectManager.assureCurrent().setPlacementForSerial(placement);
    }

    private synchronized void setPlacementForSerial(Placement placement) {
        if (placement == null) {
            Utilities.throwNullArgumentException("com.odi.util.OSTreeMap", "setPlacementForSerialization", "placement");
        }
        this.placementForSerial = placement;
    }

    public static Placement getPlacementForSerialization(boolean throwsException) {
        return ObjectManager.assureCurrent().getPlacementForSerial(throwsException);
    }

    private synchronized Placement getPlacementForSerial(boolean throwsException) {
        if (this.placementForSerial == null) {
            this.placementForSerial = ObjectManager.assureCurrent().sv.getCurrentDatabase();
        }
        if (this.placementForSerial == null && throwsException) {
            throw new ObjectStoreException("Need to call ObjectStore.setPlacementForSerialization()");
        }
        return this.placementForSerial;
    }

    private synchronized void migrateObject(Object object, Placement place) {
        this.assureDatabaseCompatible((Database)place.getDatabase(), 7);
        ObjectReference objRef = this.findObjRef(object);
        if (objRef != null) {
            if (place != ObjRefUtils.getCluster(objRef) && place != ObjRefUtils.getSegment(objRef) && place != ObjRefUtils.getDatabase(objRef)) {
                throw new IllegalArgumentException("Incorrect object argument, " + object + ", supplied to ObjectStore.migrate(). " + "The object:" + ObjRefUtils.typedOIDString(objRef) + " is already persistent at a different location from the " + "one specified in the placement argument to migrate.");
            }
            return;
        }
        this.noteAsPersistent((com.odi.imp.Cluster)place.getCluster(), object);
    }

    public void forceFetchObject(Object object) {
        this.fetchObject(object, true);
    }

    public final void fetchObject(Object object) {
        this.fetchObject(object, false);
    }

    private synchronized void fetchObject(Object object, boolean force) {
        ObjectReference objRef = this.isPersistentObjectInternal(object);
        if (objRef == null) {
            return;
        }
        if (!force && !this.hasReadBarrier(object, objRef)) {
            return;
        }
        this.assureTransactionCompatible(6);
        ++this.countFetch;
        this.initializeObject(object, objRef);
        this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_DOWN);
    }

    private void deepFetchObject(Object object, IdentitySet fetchedObjects, IdentitySet retryRoots, int depthCount) {
        if (depthCount == 0) {
            retryRoots.put(object);
            return;
        }
        if (!(object instanceof IPersistent) && !Utilities.isArray(object)) {
            return;
        }
        if (fetchedObjects.get(object) != null) {
            return;
        }
        ++this.countDeepFetch;
        GenericObject genObj = this.fetchOrMigrateObject(object);
        this.fetchObjectsReferencedBy(genObj, fetchedObjects, object, retryRoots, --depthCount);
    }

    private GenericObject fetchOrMigrateObject(Object object) {
        GenericObject genObj = null;
        ObjectReference objRef = this.getObjRef(object);
        if (this.isCachedObject(object, objRef)) {
            this.assureTransactionCompatible(6);
            if (this.initializeObjectFromCache(object, objRef)) {
                this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_DOWN);
            }
        }
        if (!this.hasReadBarrier(object, objRef)) {
            genObj = GenericObject.allocate(this, objRef);
            this.flushContents(object, genObj);
        } else {
            this.assureTransactionCompatible(6);
            genObj = this.initializeObjectFromDB(object, objRef, false);
            this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_DOWN);
        }
        return genObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchObjectsReferencedBy(GenericObject genObj, IdentitySet fetchedObjects, Object object, IdentitySet retryRoots, int depthCount) {
        ObjectReferencesEnumeration objRefEnum = this.schemaManager.getObjectReferencesEnumeration(genObj.objRef.getAFTypeCode(), genObj.objRef.getArrayElementCount());
        try {
            if (objRefEnum == null || !objRefEnum.hasMoreElements()) {
                return;
            }
            fetchedObjects.put(object);
            while (objRefEnum.hasMoreElements()) {
                Object target;
                int offset = objRefEnum.nextElement();
                if (objRefEnum.isLazyRef() || (target = this.createObjectFromObjRef(genObj.rep, offset)) == null) continue;
                this.deepFetchObject(target, fetchedObjects, retryRoots, depthCount);
            }
        }
        finally {
            genObj.deallocate();
        }
    }

    Object createObjectFromObjRef(byte[] rep, int offset) {
        if (this.objectAccess.isNull(rep, offset) || this.objectAccess.isImmediateObject(rep, offset)) {
            return null;
        }
        return this.OT.findObject(rep, offset);
    }

    boolean isPersistentObject(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof IPersistent ? ObjectManager.isPersistent((IPersistent)object) : this.OT.findObjRef(object) != null;
    }

    ObjectReference isPersistentObjectInternal(Object object) {
        ObjectReference ref = this.OT.findObjRef(object);
        if (ref == null) {
            return null;
        }
        if (object instanceof IPersistent && !this.OT.isPersistentThisTable(object)) {
            throw new WrongSessionException("Attempt to use object of type " + object.getClass().getName() + " in a wrong session.");
        }
        return ref;
    }

    public synchronized boolean isPersistentThisSession(Object object) {
        return object == null ? false : this.OT.isPersistentThisTable(object);
    }

    public static synchronized String describe(Object object) {
        return ObjectManager.assureCurrent().describeInternal(object);
    }

    private String describeInternal(Object object) {
        try {
            ObjectReference ref = this.OT.findObjRef(object);
            if (ref == null) {
                return "transient";
            }
            return "{" + ObjRefUtils.OIDString(ref) + "," + ref.getAFTypeCode() + ", " + ref.getArrayDimensions() + ", " + ref.getArrayElementCount() + (this.hasReadBarrier(object, ref) ? ", RB" : "") + (this.hasWriteBarrier(object, ref) ? ", WB" : "") + "}";
        }
        catch (ObjectException e) {
            return "stale";
        }
    }

    public static String objectIDString(Object object) {
        if (object instanceof IPersistent) {
            return object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
        }
        if (object instanceof String) {
            return "String \"" + object + "\"";
        }
        if (Utilities.isArray(object)) {
            return object.toString();
        }
        if (Utilities.isPrimitiveWrapperInstance(object) || Utilities.isBuiltinInstance(object)) {
            return object.getClass().getName() + " " + object;
        }
        throw new ObjectNotPersistenceCapableException(object);
    }

    private Object getExtRefObject(ExternalReference extref) {
        if (extref.isNull()) {
            return null;
        }
        Database db = (Database)extref.getDatabase();
        int segmentId = extref.getSegmentId();
        int clusterId = extref.getClusterId();
        long location = extref.getLocation();
        if (db == null || segmentId < 0 || clusterId < 0 && clusterId != -4) {
            throw new ObjectNotFoundException("Invalid ExternalReference contents " + db + " " + segmentId + " " + clusterId + " " + location);
        }
        return this.getObject(db, segmentId, clusterId, location);
    }

    public synchronized Object getObject(Database db, int segmentId, int clusterId, long location) {
        this.assureTransactionCompatible(6);
        db.checkCurrent();
        return this.getJavaReference(this.sv.serverGetExtRef(db.getDatabaseId(), segmentId, clusterId, location), 0);
    }

    private synchronized void setExtRefObject(Object object, ExternalReference extref) {
        if (object == null) {
            extref.setNull();
        } else {
            ObjectReference objRef = this.getObjRef(object);
            if (!this.isPersistentObject(object)) {
                throw new ObjectNotPersistentException(object);
            }
            extref.setClusterId(ObjRefUtils.getClusterId(objRef));
            extref.setDatabase(ObjRefUtils.getDatabase(objRef));
            extref.setSegmentId(ObjRefUtils.getSegmentId(objRef));
            extref.setLocation(objRef.getLocation());
        }
    }

    private synchronized void destroyObject(Object object) {
        if (!this.isPersistentObject(object)) {
            return;
        }
        if (this.tx != null || this.lastTransactionRetainType != 4) {
            this.assureTransactionCompatible(7);
        }
        this.callDestroyHandlers(object);
        ObjectReference objRef = this.getObjRef(object);
        this.destroyObjectInternal(object, objRef);
        ObjRefUtils.getDatabase(objRef).serverDestroyObject(objRef);
    }

    private void destroyObjectInternal(Object object, ObjectReference objRef) {
        if (!this.hasReadBarrier(object, objRef) && !ObjRefUtils.isNewlyPersistent(objRef)) {
            this.clearContents(object);
        }
        this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_UP);
        this.OT.destroyAssociation(object, objRef);
    }

    private synchronized void dirtyObject(Object object) {
        boolean retainUpdateMode;
        ObjectReference objRef = this.isPersistentObjectInternal(object);
        if (objRef == null) {
            return;
        }
        boolean bl = retainUpdateMode = this.tx == null && this.lastTransactionRetainType == 4;
        if (!retainUpdateMode) {
            this.assureTransactionCompatible(7);
        }
        if (!this.hasWriteBarrier(object, objRef)) {
            return;
        }
        if (this.hasReadBarrier(object, objRef)) {
            if (retainUpdateMode) {
                throw new ObjectException("Calling dirty() on a hollow object outside a transaction is not allowed.");
            }
            this.initializeObject(object, objRef);
        }
        if (ObjectStore.getLazyWriteLocking() || retainUpdateMode) {
            this.assureDatabaseCompatible(this.dbOf(object), 7);
        } else {
            this.sv.serverWriteLock(objRef);
        }
        ++this.countDirty;
        this.OT.makeWritable(object, objRef);
    }

    private void evictObjectChanges(Object object, ObjectReference objRef) {
        if (this.hasWriteBarrier(object, objRef)) {
            return;
        }
        GenericObject genObj = null;
        if (this.changeSynchronizationEnabled) {
            int csize = this.changeSynchronizationHandlers.size();
            if (ObjRefUtils.isNewlyPersistent(objRef)) {
                for (int i = 0; i < csize; ++i) {
                    ((ChangeSynchronization)this.changeSynchronizationHandlers.get(i)).afterCreated(object);
                    if (this.tx != null) continue;
                    throw new NoTransactionInProgressException();
                }
            } else {
                for (int i = 0; i < csize; ++i) {
                    ((ChangeSynchronization)this.changeSynchronizationHandlers.get(i)).afterUpdated(object);
                    if (this.tx != null) continue;
                    throw new NoTransactionInProgressException();
                }
            }
        }
        try {
            genObj = GenericObject.allocate(this, objRef);
            this.flushContents(object, genObj);
            genObj.store(object);
            this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_DOWN);
        }
        catch (ObjectNotPersistenceCapableException ONPCE) {
            ONPCE.appendPath(object.getClass().getName());
            throw ONPCE;
        }
        finally {
            if (genObj != null) {
                genObj.deallocate();
            }
        }
    }

    private final ObjectReference evictNewObject(Object object, com.odi.imp.Cluster place, boolean soft) {
        GenericObject genObj = null;
        try {
            genObj = GenericObject.allocate(this, place, object, soft);
            if (genObj == null) {
                ObjectReference objectReference = null;
                return objectReference;
            }
            if (this.changeSynchronizationEnabled) {
                int csize = this.changeSynchronizationHandlers.size();
                for (int i = 0; i < csize; ++i) {
                    ((ChangeSynchronization)this.changeSynchronizationHandlers.get(i)).afterCreated(object);
                    if (this.tx != null) continue;
                    throw new NoTransactionInProgressException();
                }
            }
            this.flushContents(object, genObj);
            ObjectReference objRef = this.findObjRef(object);
            if (objRef != null) {
                genObj.objRef = objRef;
                genObj.store(object);
                this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_DOWN);
            } else {
                ++this.countMigrateFull;
                genObj.createFullObject(object);
                objRef = this.OT.enterAssociation(genObj.objRef, object, ObjectTable.READ_BARRIER_DOWN);
                ++this.newObjectCount;
                ObjRefUtils.setNewlyPersistent(objRef, true);
            }
            ObjectReference objectReference = objRef;
            return objectReference;
        }
        catch (ObjectNotPersistenceCapableException ONPCE) {
            ONPCE.appendPath(object.getClass().getName());
            throw ONPCE;
        }
        finally {
            if (genObj != null) {
                genObj.deallocate();
            }
        }
    }

    private final ObjectReference evictNewObject(Object object, com.odi.imp.Cluster place) {
        return this.evictNewObject(object, place, !ObjectManager.isPrefetchedObject(object));
    }

    public synchronized com.odi.Segment segmentOfpreFlushContentsObject() {
        this.assureTransactionCompatible(6);
        if (this.flushedObjectReference == null) {
            throw new ObjectStoreException("Not currently in the dynamic scope of a flushContents()");
        }
        return this.segOf(this.flushedObjectReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushContents(Object object, GenericObject genObj) {
        ++this.countFlushContents;
        if (object instanceof IPersistent) {
            ObjectReference savedFlushedObjectReference = this.flushedObjectReference;
            try {
                IPersistent pObj = (IPersistent)object;
                this.flushedObjectReference = genObj.getObjRef();
                if (pObj instanceof IPersistentHooks) {
                    ((IPersistentHooks)((Object)pObj)).preFlushContents();
                }
                pObj.flushContents(genObj);
            }
            finally {
                this.flushedObjectReference = savedFlushedObjectReference;
            }
        } else if (object instanceof String) {
            String string = (String)object;
            int length = string.length();
            ObjectAccess.encodeString(genObj.rep, 0, this.getChars(string, length), length);
        } else if (Utilities.isArray(object)) {
            this.objectAccess.encodeArrayContents(genObj, object);
        } else if (Utilities.isPrimitiveWrapperInstance(object)) {
            Utilities.encodeWrapperObject(genObj, object);
        } else if (Utilities.isBuiltinInstance(object)) {
            Utilities.encodeBuiltinObject(genObj, object);
        } else {
            throw new ObjectNotPersistenceCapableException(object);
        }
    }

    private void clearContents(Object object) {
        ++this.countClearContents;
        if (object instanceof IPersistent) {
            IPersistent pObj = (IPersistent)object;
            if (pObj instanceof IPersistentHooks) {
                ((IPersistentHooks)((Object)pObj)).preClearContents();
            }
            pObj.clearContents();
        } else if (Utilities.isArray(object)) {
            Utilities.clearArray(object);
        } else {
            if (ObjectManager.isPrefetchedObject(object)) {
                return;
            }
            throw new ObjectNotPersistenceCapableException(object);
        }
    }

    private void cacheObject(Object object, ObjectReference objRef) {
        if (this.cacheContents(object, objRef)) {
            this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_CACHED);
        } else {
            this.clearContents(object);
            this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_UP);
        }
    }

    private boolean cacheContents(Object object, ObjectReference objRef) {
        if (this.cachedObjectCount >= this.maxCachedObjects) {
            if (this.checkCacheFullForTxnIndex != this.currentTransactionIndex) {
                this.checkCacheFullForTxnIndex = this.currentTransactionIndex;
                this.cacheFullForThisTxn = false;
            }
            if (this.cacheFullForThisTxn) {
                return false;
            }
            if (!this.makeSpaceForOneObjectInCache()) {
                return false;
            }
        }
        ++this.cachedObjectCount;
        ++this.countCacheContents;
        if (object instanceof IPersistentCacheHooks) {
            ((IPersistentCacheHooks)object).preFlushContentsToCache();
        }
        if (!(object instanceof IPersistent)) {
            objRef.saveElement0(object);
        }
        objRef.setTxnIndex(this.currentTransactionIndex);
        return true;
    }

    private boolean makeSpaceForOneObjectInCache() {
        Object cachedObject = this.OT.getOldestCachedObject();
        if (cachedObject != null) {
            ObjectReference cachedObjRef = this.OT.getOldestCachedObjectReference();
            if (cachedObjRef.getTxnIndex() != this.currentTransactionIndex) {
                this.clearContents(cachedObject);
                this.OT.adjustReadBarrier(cachedObject, cachedObjRef, ObjectTable.READ_BARRIER_UP);
                this.decrementCachedObjectCount();
            } else {
                this.cacheFullForThisTxn = true;
                return false;
            }
        }
        return true;
    }

    private short getNextTxnIndex() {
        short nextTxnIndex = (short)(this.currentTransactionIndex + 1);
        if (nextTxnIndex > 255) {
            if (nextTxnIndex != 256) {
                throw new FatalInternalException("illegal transaction index increment");
            }
            nextTxnIndex = 0;
        }
        return nextTxnIndex;
    }

    private void incrementTxnIndex() {
        this.expireCache(this.txnAgeForCaching, false);
        this.currentTransactionIndex = this.getNextTxnIndex();
        this.transactionIds[this.currentTransactionIndex] = this.tx.getCurrentTransactionId();
    }

    private void terminateCachedObjectIterators() {
        CachedObjectIterator lastCOI = null;
        while (!this.cachedObjectIterators.isEmpty()) {
            CachedObjectIterator thisCOI = (CachedObjectIterator)this.cachedObjectIterators.peek();
            if (thisCOI == lastCOI) {
                throw new FatalInternalException("iterator didn't correctly terminate");
            }
            lastCOI = thisCOI;
            thisCOI.terminate();
        }
    }

    private void evictObject(Object object, int retain) {
        ObjectReference objRef = this.OT.findObjRef(object);
        if (objRef == null) {
            return;
        }
        this.evictObjectChanges(object, objRef);
        this.adjustReadBarrier(object, objRef, retain);
        ++this.countEvict;
        if (retain == 1) {
            this.OT.removeAssociation(object, objRef);
        }
    }

    private void evictObjectOutsideTransaction(Object object, int retainType) {
        if (!this.isPersistentObject(object) || retainType == 3) {
            return;
        }
        this.clearContents(object);
        ObjectReference objRef = this.getObjRef(object);
        this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_UP);
        if (retainType == 1) {
            this.OT.removeAssociation(object, objRef);
        }
    }

    private void adjustReadBarrier(Object object, ObjectReference objRef, int retainType) {
        switch (retainType) {
            case 1: 
            case 2: {
                ObjectReference objectReference = objRef = objRef == null ? this.getObjRef(object) : objRef;
                if (!ObjRefUtils.isNewlyPersistent(objRef)) {
                    if (retainType == 1 || this.cachingIsDisabled) {
                        this.clearContents(object);
                        this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_UP);
                        break;
                    }
                    if (this.hasReadBarrier(object, objRef)) break;
                    this.cacheObject(object, objRef);
                    break;
                }
                this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_DOWN);
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new FatalInternalException("Invalid retainType " + retainType + " passed to evictObjectContents");
            }
        }
    }

    private void evictObjectContents(Object object, ObjectReference objRef, int retainType) {
        this.evictObjectChanges(object, objRef);
        this.adjustReadBarrier(object, objRef, retainType);
    }

    Database dbOf(Object object) {
        ObjectReference objRef = this.getObjRef(object);
        return ObjRefUtils.getDatabase(objRef);
    }

    public Segment segOf(Object object) {
        ObjectReference objRef = this.getObjRef(object);
        return this.segOf(objRef);
    }

    private Segment segOf(ObjectReference objRef) {
        Segment segment = ObjRefUtils.getSegment(objRef);
        Database db = (Database)segment.getDatabase();
        if (ObjRefUtils.isStale(objRef)) {
            throw new ObjectException("Cannot determine containing segment on a stale object");
        }
        return segment;
    }

    public com.odi.imp.Cluster cluOf(Object object) {
        ObjectReference objRef = this.getObjRef(object);
        return this.cluOf(objRef);
    }

    private com.odi.imp.Cluster cluOf(ObjectReference objRef) {
        com.odi.imp.Cluster clu = ObjRefUtils.getCluster(objRef);
        Database db = (Database)clu.getSegment().getDatabase();
        if (ObjRefUtils.isStale(objRef)) {
            throw new ObjectException("Cannot determine containing segment on a stale object");
        }
        return clu;
    }

    private void acquireLockObject(Object object, int lockType, int timeoutMillis) {
        this.assureTransactionCompatible(lockType);
        ObjectReference objRef = null;
        try {
            objRef = this.getObjRef(object);
        }
        catch (ObjectNotPersistenceCapableException e) {
            throw new ObjectNotPersistentException(object);
        }
        if (lockType == 6 && !this.hasReadBarrier(object, objRef)) {
            return;
        }
        this.sv.serverAcquireLock(objRef, lockType, timeoutMillis);
    }

    private Object createHollowObject(byte[] buffer, int objRefOffset) {
        if (this.objectAccess.isImmediateObject(buffer, objRefOffset)) {
            return this.decodeImmediateObject(buffer, objRefOffset);
        }
        this.tempObjRef.setAttributes(buffer, objRefOffset);
        return this.createHollowObject(this.tempObjRef);
    }

    private Object createHollowObject(ObjectReference objRef) {
        int readBarrierType;
        ++this.countCreate;
        int AFTypeCode = objRef.getAFTypeCode();
        Object hollowObject = null;
        if (ObjectManager.isPrefetched(AFTypeCode)) {
            try {
                hollowObject = this.fetchStringWrapperOrBuiltin(objRef);
            }
            catch (ObjectNotFoundException e) {
                return null;
            }
            readBarrierType = ObjectTable.READ_BARRIER_DOWN;
        } else {
            try {
                hollowObject = objRef.getArrayDimensions() > 0 ? this.createHollowArray(objRef) : this.schemaManager.getClassInfo(AFTypeCode).create();
            }
            catch (ClassNotRegisteredException cnr) {
                if (Boolean.valueOf(this.getProperty("com.odi.trapUnregisteredType")).booleanValue()) {
                    throw new FatalApplicationException("Class information for class " + cnr.getClassName() + " is not available");
                }
                hollowObject = new UnregisteredType(objRef);
            }
            catch (ClassNotFoundException cnf) {
                if (Boolean.valueOf(this.getProperty("com.odi.trapUnregisteredType")).booleanValue()) {
                    throw new FatalApplicationException(cnf.getMessage());
                }
                hollowObject = new UnregisteredType[]{};
            }
            readBarrierType = ObjectTable.READ_BARRIER_UP;
        }
        this.OT.enterAssociation(objRef, hollowObject, readBarrierType);
        return hollowObject;
    }

    public Object decodeImmediateObject(byte[] buffer, int objRefOffset) {
        if (this.objectAccess.isImmediateString(buffer, objRefOffset)) {
            return this.objectAccess.decodeImmStringRef(buffer, objRefOffset);
        }
        return Utilities.decodeWrapperObject(this.objectAccess, buffer, objRefOffset);
    }

    void encodeImmediateObject(byte[] buffer, int objRefOffset, Object object) {
        if (object instanceof String) {
            this.objectAccess.encodeImmStringRef(buffer, objRefOffset, (String)object);
        } else {
            Utilities.encodeWrapperObject(this.objectAccess, buffer, objRefOffset, object);
        }
    }

    private Object fetchStringWrapperOrBuiltin(ObjectReference ref) {
        int AFTypeCode = ref.getAFTypeCode();
        GenericObject genObj = GenericObject.allocate(this, ref);
        genObj.fetch();
        Object object = null;
        if (Utilities.isStringTypeCode(AFTypeCode)) {
            int length = genObj.objRef.getArrayElementCount();
            object = ObjectAccess.decodeString(genObj.rep, 0, length, this.getCharBuffer(length));
        } else if (Utilities.isWrapperTypeCode(AFTypeCode)) {
            object = Utilities.decodeWrapperObject(genObj, AFTypeCode);
        } else {
            MutatingObjRef mutating = this.objRefFactory.createMutating(this.tempObjRef);
            object = Utilities.decodeBuiltinObject(genObj, AFTypeCode);
            this.tempObjRef.set(mutating);
        }
        genObj.deallocate();
        return object;
    }

    Object createHollowArray(ObjectReference arrayRef) throws ClassNotFoundException {
        Class elementType;
        int elementTypeCode = Utilities.arrayElementTypeCode(arrayRef.getAFTypeCode());
        int arrayElementCount = arrayRef.getArrayElementCount();
        int arrayDimensions = arrayRef.getArrayDimensions();
        if (elementTypeCode == 15) {
            elementType = String.class;
            --arrayDimensions;
        } else {
            elementType = this.schemaManager.getClassDescriptor(elementTypeCode);
        }
        if (arrayDimensions == 1) {
            return Array.newInstance(elementType, arrayElementCount);
        }
        int[] dims = new int[arrayDimensions];
        dims[0] = arrayElementCount;
        Object[] hollowArray = (Object[])Array.newInstance(elementType, dims);
        if (hollowArray.length > 0) {
            hollowArray[0] = null;
        }
        return hollowArray;
    }

    private void initializeObject(Object object, ObjectReference objRef) {
        if (this.isCachedObject(object, objRef) && this.initializeObjectFromCache(object, objRef)) {
            return;
        }
        this.initializeObjectFromDB(object, objRef, true);
    }

    private GenericObject initializeObjectFromDB(Object object, ObjectReference objRef, boolean deallocateGenObj) {
        GenericObject genObj = GenericObject.allocate(this, objRef);
        try {
            genObj.fetch();
        }
        catch (DatabaseNotOpenException e) {
            int autoOpenMode = ObjectStore.getAutoOpenMode();
            if (autoOpenMode == 99) {
                throw e;
            }
            Database db = ObjRefUtils.getDatabase(genObj.getObjRef());
            db.open(autoOpenMode);
            genObj.fetch();
        }
        this.initializeContents(object, genObj);
        if (deallocateGenObj) {
            genObj.deallocate();
            return null;
        }
        return genObj;
    }

    private boolean initializeObjectFromCache(Object object, ObjectReference objRef) {
        this.decrementCachedObjectCount();
        if (this.sv.checkCachedObjectValid(objRef, this.transactionIds[objRef.getTxnIndex()])) {
            objRef.restoreElement0(object);
            if (object instanceof IPersistentCacheHooks) {
                ((IPersistentCacheHooks)object).postInitializeContentsFromCache();
            }
            ++this.countInitializeContentsFromCache;
            return true;
        }
        this.clearContents(object);
        this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_UP);
        ++this.countClientInvalidatedObjects;
        return false;
    }

    private void initializeContents(Object object, GenericObject genObj) {
        ++this.countInitializeContents;
        if (object instanceof IPersistent) {
            IPersistent pObj = (IPersistent)object;
            pObj.initializeContents(genObj);
            if (pObj instanceof IPersistentHooks) {
                ((IPersistentHooks)((Object)pObj)).postInitializeContents();
            }
        } else if (Utilities.isArray(object)) {
            this.objectAccess.decodeArrayContents(genObj, object);
        } else {
            if (ObjectManager.isPrefetchedObject(object)) {
                throw new FatalInternalException("Strings and primitive wrapppers are always pre-fetched and should not require initialization.");
            }
            throw new ObjectNotPersistenceCapableException(object);
        }
    }

    IPersistent getEmbeddedObject(byte[] rep, int start, IPersistent object) {
        int AFTypeCode = this.schemaManager.getAFTypeCode(object);
        GenericObject genObj = GenericObject.allocateEmbedded(this, null, AFTypeCode);
        System.arraycopy(rep, start, genObj.getData(), 0, Math.min(rep.length, genObj.getData().length));
        this.initializeContents(object, genObj);
        genObj.deallocate();
        return object;
    }

    void setEmbeddedObject(GenericObject enclosingGenericObject, int start, IPersistent object) {
        int AFTypeCode = this.schemaManager.getAFTypeCode(object);
        GenericObject genObj = GenericObject.allocateEmbedded(this, enclosingGenericObject.getObjRef(), AFTypeCode);
        this.flushContents(object, genObj);
        byte[] enclosingRep = enclosingGenericObject.getData();
        System.arraycopy(genObj.getData(), 0, enclosingRep, start, Math.min(enclosingRep.length, genObj.getData().length));
        genObj.deallocate();
    }

    private ObjectReference noteAsPersistent(com.odi.imp.Cluster cluster, Object object) {
        ObjectReference objRef = this.createPersistentPlaceHolder(cluster, object);
        ++this.newObjectCount;
        ObjRefUtils.setNewlyPersistent(objRef, true);
        objRef = this.OT.enterWritableAssociation(objRef, object);
        if (ObjectManager.isPrefetchedObject(object)) {
            this.evictObject(object, 3);
        }
        return objRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ObjectReference associateObjectRef(Object object, com.odi.imp.Cluster cluster) {
        ObjectReference objRef = null;
        if (this.createObjectsLazily && !this.isLazyObject(object)) {
            try {
                this.noteLazyObject(object);
                objRef = this.evictNewObject(object, cluster);
            }
            finally {
                if (this.tx != null) {
                    this.forgetLazyObject(object);
                }
            }
        }
        return objRef == null ? this.noteAsPersistent(cluster, object) : objRef;
    }

    public Object getJavaReference(byte[] networkObjRep, int objRefOffset) {
        if (this.objectAccess.isNull(networkObjRep, objRefOffset)) {
            return null;
        }
        if (this.objectAccess.isImmediateObject(networkObjRep, objRefOffset)) {
            return this.createHollowObject(networkObjRep, objRefOffset);
        }
        Object object = this.OT.findObject(networkObjRep, objRefOffset);
        return object == null ? this.createHollowObject(networkObjRep, objRefOffset) : object;
    }

    public Object getJavaReference(ObjectReference objRef) {
        if (ObjRefUtils.isNull(objRef)) {
            return null;
        }
        Object object = this.OT.findObject(objRef);
        return object == null ? this.createHollowObject(objRef) : object;
    }

    public void putJavaReference(byte[] buffer, int objRefOffset, Object object, com.odi.imp.Cluster cluster, boolean useImmediateStrings) {
        if (object == null) {
            this.objectAccess.encodeNull(buffer, objRefOffset);
            return;
        }
        ObjectReference objRef = this.findObjRef(object, false);
        if (objRef == null) {
            if (this.isImmediateObject(object, useImmediateStrings)) {
                this.encodeImmediateObject(buffer, objRefOffset, object);
                return;
            }
            objRef = this.associateObjectRef(object, cluster);
        }
        this.objectAccess.encodeObjRef(buffer, objRefOffset, objRef);
    }

    public boolean isImmediateObject(Object object, boolean useImmediateStrings) {
        return this.objectAccess.isImmRefEncodable(object, useImmediateStrings);
    }

    static boolean isOTObject(Object object) {
        return Utilities.isArray(object) || object instanceof String || Utilities.isPrimitiveWrapperInstance(object) || Utilities.isBuiltinInstance(object);
    }

    static boolean isPrefetchedObject(Object object) {
        return object instanceof String || Utilities.isPrimitiveWrapperInstance(object) || Utilities.isBuiltinInstance(object);
    }

    static boolean isPrefetched(int AFTypeCode) {
        return Utilities.isStringTypeCode(AFTypeCode) || Utilities.isWrapperTypeCode(AFTypeCode) || Utilities.isBuiltinTypeCode(AFTypeCode);
    }

    ObjectReference findObjRef(Object object) {
        return this.OT.findObjRef(object);
    }

    public ObjectReference findObjRef(Object object, boolean checkIsDestroyed) {
        return this.OT.findObjRef(object, checkIsDestroyed);
    }

    public Object findObject(ObjectReference objRef) {
        return this.OT.findObject(objRef);
    }

    public static ObjectReference _getObjRef(Object object) {
        return ObjectManager.assureCurrent(6).getObjRef(object);
    }

    public final ObjectReference getObjRef(Object object) {
        return this.getObjRef(object, true);
    }

    public static void show(String name, Object object) {
        ObjectReference objRef = ObjectManager._getObjRef(object);
        System.out.println(name + ": ObjRef=(" + objRef.getLocation() + "," + objRef.getPlacement().getCluster().getClusterId() + "," + objRef.getAFTypeCode() + "," + objRef.getArrayElementCount() + ")");
    }

    public ObjectReference getObjRef(Object object, boolean checkIsDestroyed) {
        ObjectReference objRef = this.OT.findObjRef(object, checkIsDestroyed);
        if (objRef == null) {
            if (object instanceof IPersistent) {
                ClassInfo.get(object.getClass().getName());
                throw new ObjectNotPersistentException(object);
            }
            if (Utilities.isArray(object) || ObjectManager.isPrefetchedObject(object)) {
                throw new ObjectNotPersistentException(object);
            }
            throw new ObjectNotPersistenceCapableException(object);
        }
        return objRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectReference getObjectReference(Object object) {
        ObjectManager om;
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            return om.getObjRef(object);
        }
    }

    public synchronized int getClassAFTypeCode(String className) {
        return this.schemaManager.getClassAFTypeCode(className);
    }

    void begin(com.odi.imp.Transaction transaction, boolean resetReadBarriers) {
        this.tx = transaction;
        this.newObjectCount = 0;
        this.flushedObjectReference = null;
        if (!this.sv.checkCachedObjectsValid()) {
            this.expireFullCache();
        }
        switch (this.lastTransactionRetainType) {
            case 4: {
                this.resetDirtiedObjects();
            }
            case 3: {
                if (!resetReadBarriers) break;
                this.resetReadBarriers();
                this.OT.readableObjectCleanup(true);
                break;
            }
            case 1: 
            case 2: {
                this.OT.readableObjectCleanup(true);
            }
        }
        this.OT.dirtyObjectCleanup(true);
        this.terminateCachedObjectIterators();
        this.incrementTxnIndex();
        boolean bl = this.changeSynchronizationEnabled = (this.tx.getType() == 7 || this.tx.getType() == 4) && this.changeSynchronizationHandlers != null;
        if (this.transactionSynchronizationHandlers != null) {
            int csize = this.transactionSynchronizationHandlers.size();
            for (int i = 0; i < csize; ++i) {
                ((TransactionSynchronization)this.transactionSynchronizationHandlers.get(i)).afterBegin();
                if (this.tx != null) continue;
                throw new NoTransactionInProgressException();
            }
        }
    }

    void commit(int retainType) {
        ++this.countCommit;
        this.commitInternal(retainType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitInternal(int retainType, boolean evicting) {
        ObjectManager.checkRetain(retainType, true, true);
        boolean cleanCommit = false;
        try {
            Object dirtyObject;
            this.enableLazyObjectCreation();
            while ((dirtyObject = this.OT.pickDirtyObject()) != null) {
                this.evictObjectContents(dirtyObject, this.OT.pickDirtyObjectReference(), retainType);
            }
            if (!evicting && this.transactionSynchronizationHandlers != null) {
                int csize = this.transactionSynchronizationHandlers.size();
                this.changeSynchronizationEnabled = false;
                for (int i = 0; i < csize; ++i) {
                    ((TransactionSynchronization)this.transactionSynchronizationHandlers.get(i)).beforeCompletion();
                    if (this.tx != null) continue;
                    throw new NoTransactionInProgressException();
                }
            }
            if (!evicting || evicting && retainType == 1) {
                this.schemaManager.commitTransaction();
            }
            while ((dirtyObject = this.OT.pickDirtyObject()) != null) {
                this.evictObjectContents(dirtyObject, this.OT.pickDirtyObjectReference(), retainType);
            }
            cleanCommit = true;
        }
        finally {
            this.disableLazyObjectCreation();
            this.OT.dirtyObjectCleanup(cleanCommit);
        }
    }

    public Enumeration getBuckets() {
        return this.OT.getBuckets();
    }

    public void validateOT() {
        this.OT.validate();
    }

    void finalizeCommit(int retainType) {
        boolean needsFinalization;
        WeakCache.WeakCacheEnumeration cleanObjects = retainType == 1 ? this.OT.getObjects() : this.OT.getReadableObjects();
        boolean bl = needsFinalization = retainType != 3 && retainType != 4;
        while (cleanObjects.hasMoreElements() && (this.newObjectCount > 0 || needsFinalization)) {
            Object object = cleanObjects.nextElement();
            ObjectReference objRef = (ObjectReference)cleanObjects.currentKey();
            if (ObjRefUtils.isNewlyPersistent(objRef)) {
                ObjRefUtils.setNewlyPersistent(objRef, false);
                --this.newObjectCount;
            }
            if (!needsFinalization) continue;
            this.finalizeObject(object, retainType, objRef);
        }
        if (this.newObjectCount < 0) {
            throw new FatalInternalException("Unexpected new object count:" + this.newObjectCount);
        }
        switch (retainType) {
            case 1: {
                this.OT.forgetStaleObjects();
            }
            case 2: {
                this.OT.readableObjectCleanup(true);
                break;
            }
        }
        this.lastTransactionRetainType = retainType;
        this.tx = null;
    }

    private void finalizeObject(Object object, int retainType, ObjectReference objRef) {
        this.adjustReadBarrier(object, objRef, retainType);
        if (retainType == 1) {
            this.OT.removeAssociation(object, objRef);
        }
    }

    void forgetObjectsInDatabase(Database db, boolean destroy, boolean retainAsTransient) {
        WeakCache.WeakCacheEnumeration retainedObjects = this.OT.getObjects();
        while (retainedObjects.hasMoreElements()) {
            Object object = retainedObjects.nextElement();
            ObjectReference objRef = (ObjectReference)retainedObjects.currentKey();
            if (db != null && ObjRefUtils.getDatabase(objRef) != db) continue;
            if (destroy) {
                this.destroyObjectInternal(object, objRef);
            } else {
                this.OT.removeAssociation(object, objRef);
            }
            if (!retainAsTransient || !(object instanceof IPersistent)) continue;
            IPersistent po = (IPersistent)object;
            po.ODIsetState((byte)0);
            po.ODIsetRef(null);
        }
    }

    void checkDatabaseCloseRetainArgument(boolean retainAsTransient) {
        if (retainAsTransient && this.lastTransactionRetainType != 4 && this.lastTransactionRetainType != 3) {
            throw new ObjectStoreException("Attempt to call Database.close(retainAsTransient), but\nthe most recent call to Transaction.commit() did not\nspecify ObjectStore.RETAIN_UPDATE or ObjectStore.RETAIN_READONLY.");
        }
    }

    private void resetReadBarriers() {
        WeakCache.WeakCacheEnumeration retainedObjects = this.OT.getReadableObjects();
        while (retainedObjects.hasMoreElements()) {
            ObjectReference objRef;
            Object object = retainedObjects.nextElement();
            if (!this.hasReadBarrier(object, objRef = (ObjectReference)retainedObjects.currentKey())) {
                if (!this.cachingIsDisabled) {
                    this.cacheObject(object, objRef);
                    continue;
                }
                if (this.sv.objectValid(objRef)) continue;
                this.clearContents(object);
                this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_UP);
                continue;
            }
            throw new FatalInternalException(object + " is on readable list but is not readable");
        }
    }

    private void resetDirtiedObjects() {
        WeakCache.WeakCacheEnumeration retainedObjects = this.OT.getWritableObjects();
        while (retainedObjects.hasMoreElements()) {
            Object object = retainedObjects.nextElement();
            this.clearContents(object);
            this.OT.adjustReadBarrier(object, (ObjectReference)retainedObjects.currentKey(), ObjectTable.READ_BARRIER_UP);
        }
    }

    private void expireCache(int nTransactions, boolean explicitDecache) {
        short txnIndex = explicitDecache ? this.currentTransactionIndex : this.getNextTxnIndex();
        WeakCache.WeakCacheEnumeration cachedObjects = this.OT.getOldestCachedObjects();
        while (cachedObjects.hasMoreElements()) {
            Object object = cachedObjects.nextElement();
            ObjectReference objRef = (ObjectReference)cachedObjects.currentKey();
            int age = txnIndex - objRef.getTxnIndex();
            if (age < 0) {
                age += 256;
            }
            if (age <= nTransactions) break;
            this.clearContents(object);
            this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_UP);
            this.decrementCachedObjectCount();
        }
    }

    private void expireFullCache() {
        WeakCache.WeakCacheEnumeration cachedObjects = this.OT.getOldestCachedObjects();
        while (cachedObjects.hasMoreElements()) {
            Object object = cachedObjects.nextElement();
            ObjectReference objRef = (ObjectReference)cachedObjects.currentKey();
            this.clearContents(object);
            this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_UP);
            this.decrementCachedObjectCount();
        }
    }

    private void abortObject(Object object, ObjectReference objRef, int retain) {
        boolean newlyPersistent = ObjRefUtils.isNewlyPersistent(objRef);
        if (!newlyPersistent) {
            switch (retain) {
                case 4: {
                    break;
                }
                case 3: {
                    if (this.hasWriteBarrier(object, objRef)) break;
                    this.clearContents(object);
                    this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_UP);
                    break;
                }
                case 1: {
                    if (this.hasReadBarrier(object, objRef) && !this.isCachedObject(object, objRef)) break;
                    this.clearContents(object);
                    this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_UP);
                    break;
                }
                case 2: {
                    if (this.hasReadBarrier(object, objRef)) break;
                    if (this.cachingIsDisabled || !this.hasWriteBarrier(object, objRef)) {
                        this.clearContents(object);
                        this.OT.adjustReadBarrier(object, objRef, ObjectTable.READ_BARRIER_UP);
                        break;
                    }
                    this.cacheObject(object, objRef);
                }
            }
        }
        if (newlyPersistent || retain == 1) {
            this.OT.removeAssociation(object, objRef);
        } else {
            this.adjustReadBarrier(object, objRef, retain);
        }
        if (newlyPersistent && object instanceof IPersistent) {
            IPersistent po = (IPersistent)object;
            po.ODIsetState((byte)0);
            po.ODIsetRef(null);
        }
    }

    void abort(int retain) {
        ObjectManager.checkRetain(retain, true, true);
        boolean commitOrCheckpointInProgress = this.tx.commitOrCheckpointInProgress;
        ++this.countAbort;
        WeakCache.WeakCacheEnumeration objects = this.OT.getObjects();
        while (objects.hasMoreElements()) {
            Object obj = objects.nextElement();
            ObjectReference objRef = (ObjectReference)objects.currentKey();
            this.abortObject(obj, objRef, retain);
        }
        this.tx = null;
        this.newObjectCount = 0;
        if (retain != 4) {
            this.OT.dirtyObjectCleanup(true);
        }
        if (retain == 1 || retain == 2) {
            this.OT.readableObjectCleanup(!commitOrCheckpointInProgress);
        }
        if (this.lazyArrayRefObjects != null) {
            this.lazyArrayRefObjects.clear();
        }
        this.lastTransactionRetainType = retain;
    }

    public int forgetRetainedObjectsInSegment(Segment segment) {
        if (this.lastTransactionRetainType == 1) {
            return 0;
        }
        return this.forgetObjectsInSegment(segment, false);
    }

    int forgetObjectsInSegment(Segment segment, boolean destroy) {
        WeakCache.WeakCacheEnumeration retainedObjects = this.OT.getObjects();
        int numObjects = 0;
        while (retainedObjects.hasMoreElements()) {
            Object object = retainedObjects.nextElement();
            ObjectReference objRef = (ObjectReference)retainedObjects.currentKey();
            if (ObjRefUtils.getSegment(objRef) != segment) continue;
            ++numObjects;
            if (destroy) {
                this.destroyObjectInternal(object, objRef);
                continue;
            }
            this.OT.removeAssociation(object, objRef);
        }
        return numObjects;
    }

    int forgetObjectsInCluster(com.odi.imp.Cluster cluster, boolean destroy) {
        WeakCache.WeakCacheEnumeration retainedObjects = this.OT.getObjects();
        int numObjects = 0;
        while (retainedObjects.hasMoreElements()) {
            Object object = retainedObjects.nextElement();
            ObjectReference objRef = (ObjectReference)retainedObjects.currentKey();
            if (ObjRefUtils.getCluster(objRef) != cluster) continue;
            ++numObjects;
            if (destroy) {
                this.destroyObjectInternal(object, objRef);
                continue;
            }
            this.OT.removeAssociation(object, objRef);
        }
        return numObjects;
    }

    boolean hasReadBarrier(Object object, ObjectReference objRef) {
        return object instanceof IPersistent ? Persistent.hasReadBarrier((IPersistent)object) : ObjRefUtils.hasRB(objRef);
    }

    boolean hasWriteBarrier(Object object, ObjectReference objRef) {
        return object instanceof IPersistent ? Persistent.hasWriteBarrier((IPersistent)object) : ObjRefUtils.hasWB(objRef);
    }

    public boolean isCachedObject(Object object, ObjectReference objRef) {
        return object instanceof IPersistent ? Persistent.isCached((IPersistent)object) : ObjRefUtils.isCached(objRef);
    }

    public boolean isHollowObject(Object object) {
        if (object instanceof IPersistent) {
            return Persistent.hasReadBarrier((IPersistent)object);
        }
        ObjectReference objRef = this.OT.findObjRef(object);
        return objRef == null ? false : ObjRefUtils.hasRB(objRef);
    }

    private ObjectReference createPersistentPlaceHolder(com.odi.imp.Cluster cluster, Object object) {
        ++this.countMigrateEmpty;
        return this.sv.serverCreateEmptyObject(cluster, object, this.schemaManager.getAFTypeCode(object), this.computeArrayElementCount(object), 0);
    }

    Placement getPlacement(int databaseId, int segmentId, int clusterId) {
        if (databaseId == this.lastDatabaseId && segmentId == this.lastSegmentId && clusterId == this.lastClusterId) {
            return this.lastCluster;
        }
        Segment segment = (Segment)this.sv.getDatabase(databaseId).getSegmentObject(segmentId);
        if (clusterId == -4) {
            return segment;
        }
        this.lastDatabaseId = databaseId;
        this.lastSegmentId = segmentId;
        this.lastClusterId = clusterId;
        this.lastCluster = segment.getClusterObject(clusterId);
        return this.lastCluster;
    }

    public ObjectReference createObjectWithDefaultContents(Placement placement, int AFTypeCode, boolean isArray, int arrayElementCount) {
        if (!isArray) {
            arrayElementCount = -1;
        }
        com.odi.imp.Cluster cluster = (com.odi.imp.Cluster)placement.getCluster();
        this.assureDatabaseCompatible((Database)cluster.getSegment().getDatabase(), 7);
        ++this.countMigrateFull;
        ObjectReference objRef = this.sv.serverCreateEmptyObject(cluster, null, AFTypeCode, arrayElementCount, 0);
        ObjRefUtils.setNewlyPersistent(objRef, true);
        GenericObject go = GenericObject.allocate(this, objRef);
        go.setDefaultContents();
        go.store(null);
        go.deallocate();
        return objRef;
    }

    final int computeArrayElementCount(Object object) {
        int arrayElementCount;
        int n = arrayElementCount = Utilities.isArray(object) ? Utilities.getArrayElementCount(object) : -1;
        if (object instanceof String) {
            String string = (String)object;
            int length = string.length();
            arrayElementCount = ObjectAccess.UTF8Length(this.getChars(string, length), length);
        }
        return arrayElementCount;
    }

    public ObjectManager(String host, Properties plist, String name) {
        super(name);
        this.serverHost = host;
        this.plist = new Properties(plist);
        this.setSessionProperties();
        this.objRefFactory = ObjectReferenceFactory.createFactory(this);
        this.tempObjRef = this.objRefFactory.createMutating();
        this.sv = Server.create(this, host, name, 1, false);
        this.OT = new ObjectTable(this);
        boolean bl = this.cachingIsDisabled = this.sv.supportsObjectCaching() ? Boolean.valueOf(this.getProperty("com.odi.disableObjectCaching")) : true;
        if (!this.cachingIsDisabled) {
            this.txnAgeForCaching = Integer.parseInt(this.getProperty("com.odi.cachedObjectTransactionAge"));
            if (this.txnAgeForCaching <= 0) {
                throw new IllegalArgumentException("The transaction age for object caching should be greater than 0.");
            }
            if (this.txnAgeForCaching > 255) {
                this.txnAgeForCaching = 255;
            }
            this.maxCachedObjects = Integer.parseInt(this.getProperty("com.odi.cachedObjectCount"));
            if (this.maxCachedObjects <= 0) {
                throw new IllegalArgumentException("The cached object count for object caching should be greater than 0.");
            }
        }
    }

    protected void setSessionProperties() {
        String value = this.getProperty("com.odi.trapUnregisteredType", "false");
        this.plist.put("com.odi.trapUnregisteredType", value);
        value = this.getProperty("com.odi.disableObjectCaching", "true");
        this.plist.put("com.odi.disableObjectCaching", value);
        value = this.getProperty("com.odi.cachedObjectTransactionAge", new Integer(this.txnAgeForCaching).toString());
        this.plist.put("com.odi.cachedObjectTransactionAge", value);
        value = this.getProperty("com.odi.cachedObjectCount", new Integer(this.maxCachedObjects).toString());
        this.plist.put("com.odi.cachedObjectCount", value);
        value = this.getProperty("com.odi.GC.assertNoRetainedReferences", "false");
        this.plist.put("com.odi.GC.assertNoRetainedReferences", value);
        value = this.getProperty("com.odi.printCounters", "false");
        this.plist.put("com.odi.printCounters", value);
    }

    @Override
    public Properties getSessionProperties() {
        Properties props = new Properties();
        Enumeration<?> names = this.plist.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            props.put(name, this.plist.getProperty(name));
        }
        return props;
    }

    @Override
    public String getSessionProperty(String name) {
        return this.plist.getProperty(name);
    }

    @Override
    protected void terminateInternal() {
        if (this.tx != null) {
            this.tx.aborted = true;
            this.tx = null;
        }
        this.sv.shutdown(this);
        this.schemaManager = null;
        this.theGOPool.clear();
    }

    public void setSMandOA(SchemaManager schemaManager, ObjectAccess objectAccess) {
        this.schemaManager = schemaManager;
        this.objectAccess = objectAccess;
    }

    char[] getChars(String string, int length) {
        char[] result = this.getCharBuffer(length);
        string.getChars(0, length, result, 0);
        return result;
    }

    char[] getCharBuffer(int length) {
        if (length > this.charBuffer.length) {
            this.charBuffer = new char[length + 127 & 0xFFFFFF80];
        }
        return this.charBuffer;
    }

    public static int whichProduct() {
        return ObjectManager.assureCurrent().product;
    }

    public static String productName() {
        return ObjectManager.assureCurrent().productNameString;
    }

    public static String storageSystemName() {
        return ObjectManager.assureCurrent().storageSystem;
    }

    public void setStorageSystemInfo(String product, String name) {
        this.productNameString = product;
        this.storageSystem = name;
    }

    @Override
    public void terminate(boolean fatal) {
        super.terminate(fatal);
    }

    public static ObjectManager assureCurrent() {
        Session s = ObjectManager.getCurrent();
        if (s == null) {
            throw new NoSessionException("Attempt to perform an operation from a thread (" + Thread.currentThread() + ") that is not associated with a session.");
        }
        s.assureActive("perform an operation in");
        return (ObjectManager)s;
    }

    static ObjectManager assureCurrent(int transactionType) {
        ObjectManager om = ObjectManager.assureCurrent();
        if (transactionType == 0) {
            return om;
        }
        om.assureTransactionCompatible(transactionType);
        return om;
    }

    private static ObjectManager findCurrent() {
        return (ObjectManager)ObjectManager.getCurrent();
    }

    public ObjectManager checkCurrent() {
        this.assureActive("perform an operation on an object from");
        ObjectManager current = (ObjectManager)ObjectManager.getCurrent();
        if (current == null) {
            this.join();
        } else if (current != this) {
            throw new WrongSessionException("Attempt to perform an operation from session " + current.getName() + " on an object from session " + this.getName() + ".");
        }
        return this;
    }

    @Override
    public synchronized Transaction currentTransaction() {
        this.assureActive("get the current transaction of");
        if (this.tx == null) {
            throw new NoTransactionInProgressException("There is no transaction in progress for session " + this.getName() + ".");
        }
        return this.tx;
    }

    @Override
    public synchronized boolean inTransaction() {
        this.assureActive("check for transaction in progress in");
        return this.tx != null;
    }

    public void assureTransactionCompatible(int transactionType) {
        if (this.tx == null || this.tx.isPreparedButNotCommitted()) {
            throw new NoTransactionInProgressException();
        }
        if (this.tx.type == 7 || this.tx.type == 4 || (this.tx.type == 6 || this.tx.type == 5) && transactionType == 6 || this.tx.type == transactionType) {
            return;
        }
        throw new UpdateReadOnlyException("Attempt to make database modifications in a read-only transaction.");
    }

    void assureDatabaseCompatible(Database db, int openMode) {
        int currentOpenMode = db.getOpenMode();
        if (currentOpenMode == 7 || currentOpenMode == openMode) {
            return;
        }
        throw new UpdateReadOnlyException("Attempt to modify a read-only database.");
    }

    private void enableLazyObjectCreation() {
        this.createObjectsLazily = true;
        if (this.lazyArrayRefObjects == null) {
            this.lazyArrayRefObjects = new Hashtable(53);
        }
    }

    private void disableLazyObjectCreation() {
        this.createObjectsLazily = false;
    }

    private boolean isLazyObject(Object object) {
        if (object instanceof IPersistent) {
            return Persistent.isLazyObject((IPersistent)object);
        }
        if (object instanceof Object[]) {
            return this.lazyArrayRefObjects.containsKey(object);
        }
        return false;
    }

    private void noteLazyObject(Object object) {
        if (object instanceof IPersistent) {
            Persistent.setLazyObject((IPersistent)object, true);
        } else if (object instanceof Object[]) {
            this.lazyArrayRefObjects.put(object, object);
        }
    }

    private void forgetLazyObject(Object object) {
        if (object instanceof IPersistent) {
            Persistent.setLazyObject((IPersistent)object, false);
        } else if (object instanceof Object[]) {
            this.lazyArrayRefObjects.remove(object);
        }
    }

    public String getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    public String getProperty(String propertyName, String defaultValue) {
        return Utilities.getProperty(this.plist, propertyName, defaultValue);
    }

    @Override
    public synchronized Properties getCounters(boolean reset) {
        this.assureActive("getCounters");
        Properties props = new Properties();
        com.odi.imp.mtsonic.ObjectTable.getMetrics(props);
        StringBuffer sb = new StringBuffer("com.odi.imp.ObjectManager.count");
        Utilities.putIntegerProperty(props, sb, "Fetch", this.countFetch);
        Utilities.putIntegerProperty(props, sb, "DeepFetch", this.countDeepFetch);
        Utilities.putIntegerProperty(props, sb, "Dirty", this.countDirty);
        Utilities.putIntegerProperty(props, sb, "Evict", this.countEvict);
        Utilities.putIntegerProperty(props, sb, "Commit", this.countCommit);
        Utilities.putIntegerProperty(props, sb, "Abort", this.countAbort);
        Utilities.putIntegerProperty(props, sb, "FlushContents", this.countFlushContents);
        Utilities.putIntegerProperty(props, sb, "ClearContents", this.countClearContents);
        Utilities.putIntegerProperty(props, sb, "InitializeContents", this.countInitializeContents);
        Utilities.putIntegerProperty(props, sb, "InitializeContentsFromCache", this.countInitializeContentsFromCache);
        Utilities.putIntegerProperty(props, sb, "ClientInvalidatedObjects", this.countClientInvalidatedObjects);
        Utilities.putIntegerProperty(props, sb, "Create", this.countCreate);
        Utilities.putIntegerProperty(props, sb, "MigrateEmpty", this.countMigrateEmpty);
        Utilities.putIntegerProperty(props, sb, "MigrateFull", this.countMigrateFull);
        Utilities.putIntegerProperty(props, sb, "ResolveLazyRefs", this.countResolveLazyRefs);
        Utilities.putIntegerProperty(props, sb, "GetLazyRefs", this.countGetLazyRefs);
        if (reset) {
            this.countFetch = 0;
            this.countDeepFetch = 0;
            this.countDirty = 0;
            this.countEvict = 0;
            this.countCommit = 0;
            this.countAbort = 0;
            this.countFlushContents = 0;
            this.countClearContents = 0;
            this.countInitializeContents = 0;
            this.countInitializeContentsFromCache = 0;
            this.countClientInvalidatedObjects = 0;
            this.countCreate = 0;
            this.countMigrateEmpty = 0;
            this.countMigrateFull = 0;
            this.countResolveLazyRefs = 0;
            this.countGetLazyRefs = 0;
        }
        this.sv.serverGetCounters(props, reset);
        this.OT.updateCounters(props, reset);
        return props;
    }

    public final boolean getGCAssertNoRetainedReferences() {
        return this.getProperty("com.odi.GC.assertNoRetainedReferences").equalsIgnoreCase("true");
    }

    @Override
    protected void abortTransactionInTerminate() {
        if (this.tx != null) {
            this.tx.abort();
        }
    }

    private void decrementCachedObjectCount() {
        --this.cachedObjectCount;
        if (this.cachedObjectCount < 0) {
            this.cachedObjectCount = 0;
        }
    }

    public synchronized IPersistent remapObjectInternal(IPersistent object) {
        this.assureActive("remapObject");
        this.assureTransactionCompatible(6);
        if (object == null) {
            return null;
        }
        ObjectReference objRef = object.ODIgetRef();
        if (objRef == null) {
            return object;
        }
        if (ObjRefUtils.isStale(objRef)) {
            throw new ObjectException("The reference to the object being mapped is stale");
        }
        if (ObjRefUtils.isDestroyed(objRef)) {
            throw new ObjectNotFoundException("The object being mapped was destroyed.");
        }
        Database otherSessionDB = ObjRefUtils.getDatabase(objRef);
        if (otherSessionDB.om == this) {
            return object;
        }
        Database db = this.sv.getOpenDatabase(otherSessionDB.getPath());
        this.tempObjRef.setAttributes(db.getDatabaseId(), ObjRefUtils.getSegmentId(objRef), ObjRefUtils.getClusterId(objRef), objRef.getLocation(), this.schemaManager.getAFTypeCode(object), objRef.getArrayElementCount());
        Object mappedObject = this.findObject(this.tempObjRef);
        return (IPersistent)(mappedObject == null ? this.createHollowObject(this.tempObjRef) : mappedObject);
    }

    public int getDefaultCommitRetain() {
        return this.defaultCommitRetain;
    }

    public int getDefaultAbortRetain() {
        return this.defaultAbortRetain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLockTimeout(int milliseconds) {
        ObjectManager om;
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            if (milliseconds < 0 && milliseconds != -1) {
                throw new IllegalArgumentException("Invalid timeout value: " + milliseconds);
            }
            om.sv.setLockTimeout(milliseconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLockTimeout() {
        ObjectManager om;
        ObjectManager objectManager = om = ObjectManager.assureCurrent();
        synchronized (objectManager) {
            return om.sv.getLockTimeout();
        }
    }

    @Override
    public void addTransactionSynchronization(TransactionSynchronization ts) {
        if (this.tx != null) {
            throw new TransactionInProgressException(this.tx);
        }
        if (this.transactionSynchronizationHandlers == null) {
            this.transactionSynchronizationHandlers = new Vector();
        }
        if (!this.transactionSynchronizationHandlers.contains(ts)) {
            this.transactionSynchronizationHandlers.addElement(ts);
        }
        if (ts instanceof ChangeSynchronization) {
            if (this.changeSynchronizationHandlers == null) {
                this.changeSynchronizationHandlers = new Vector();
            }
            if (!this.changeSynchronizationHandlers.contains(ts)) {
                this.changeSynchronizationHandlers.addElement(ts);
            }
        }
    }

    @Override
    public void removeTransactionSynchronization(TransactionSynchronization ts) {
        if (this.tx != null) {
            throw new TransactionInProgressException(this.tx);
        }
        if (this.transactionSynchronizationHandlers != null) {
            this.transactionSynchronizationHandlers.remove(ts);
        }
        if (this.transactionSynchronizationHandlers.isEmpty()) {
            this.transactionSynchronizationHandlers = null;
        }
        if (ts instanceof ChangeSynchronization) {
            if (this.changeSynchronizationHandlers != null) {
                this.changeSynchronizationHandlers.remove(ts);
            }
            if (this.changeSynchronizationHandlers.isEmpty()) {
                this.changeSynchronizationHandlers = null;
            }
        }
    }

    public void callAfterCompletionHandlers(boolean success) {
        if (this.transactionSynchronizationHandlers != null) {
            int csize = this.transactionSynchronizationHandlers.size();
            for (int i = 0; i < csize; ++i) {
                ((TransactionSynchronization)this.transactionSynchronizationHandlers.get(i)).afterCompletion(success);
            }
        }
    }

    public void callDestroyHandlers(Object object) {
        if (this.changeSynchronizationEnabled) {
            int csize = this.changeSynchronizationHandlers.size();
            for (int i = 0; i < csize; ++i) {
                ((ChangeSynchronization)this.changeSynchronizationHandlers.get(i)).beforeDestroyed(object);
                if (this.tx != null) continue;
                throw new NoTransactionInProgressException();
            }
        }
    }

    static class CachedObjectIterator
    implements Iterator {
        private ObjectManager om;
        private WeakCache.ChainedBucketEnumeration internalIterator;
        private HashBucket lastHashBucket;
        private HashBucket nextHashBucket;
        private Object nextCachedObject;

        CachedObjectIterator(ObjectManager om) {
            this.om = om;
            om.addCachedObjectIterator(this);
            this.internalIterator = om.OT.getOldestCachedBuckets();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void terminate() {
            if (this.internalIterator != null) {
                ObjectManager objectManager = this.om;
                synchronized (objectManager) {
                    this.internalIterator.terminate();
                    this.internalIterator = null;
                    this.om.removeCachedObjectIterator(this);
                }
            }
        }

        private boolean isCachedBucket(HashBucket bucket, Object o) {
            if (o != null) {
                return this.om.isCachedObject(o, (ObjectReference)((Object)bucket));
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            ObjectManager objectManager = this.om;
            synchronized (objectManager) {
                if (this.internalIterator != null) {
                    if (this.nextHashBucket != null) {
                        if (this.isCachedBucket(this.nextHashBucket, this.nextCachedObject)) {
                            return true;
                        }
                        this.nextCachedObject = null;
                    }
                    while (this.internalIterator.hasMoreElements()) {
                        this.nextHashBucket = (HashBucket)this.internalIterator.nextElement();
                        this.nextCachedObject = this.nextHashBucket.getElement();
                        if (!this.isCachedBucket(this.nextHashBucket, this.nextCachedObject)) continue;
                        return true;
                    }
                    this.nextHashBucket = null;
                    this.nextCachedObject = null;
                    this.terminate();
                }
            }
            return false;
        }

        public Object next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more cached objects available");
            }
            Object nextCached = this.nextCachedObject;
            this.lastHashBucket = this.nextHashBucket;
            this.nextCachedObject = null;
            this.nextHashBucket = null;
            return nextCached;
        }

        @Override
        public void remove() throws NoSuchElementException {
            if (this.lastHashBucket != null) {
                Object o = this.nextHashBucket.getElement();
                if (this.isCachedBucket(this.lastHashBucket, o)) {
                    this.om.decacheObject(o);
                }
            } else {
                throw new NoSuchElementException("There is no previous element to remove");
            }
            this.lastHashBucket = null;
        }
    }

    public static class IdentitySet {
        private IdentitySetEntry[] table;
        private int count;
        private int threshold;
        private float loadFactor;

        public IdentitySet(int initialCapacity, float loadFactor) {
            if (initialCapacity <= 0 || (double)loadFactor <= 0.0) {
                throw new IllegalArgumentException();
            }
            this.loadFactor = loadFactor;
            this.table = new IdentitySetEntry[initialCapacity];
            this.threshold = (int)((float)initialCapacity * loadFactor);
        }

        public IdentitySet(int initialCapacity) {
            this(initialCapacity, 0.75f);
        }

        public IdentitySet() {
            this(101, 0.75f);
        }

        public int size() {
            return this.count;
        }

        public boolean isEmpty() {
            return this.count == 0;
        }

        public Object get(Object o) {
            IdentitySetEntry[] tab = this.table;
            int hash = System.identityHashCode(o);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            IdentitySetEntry e = tab[index];
            while (e != null) {
                if (e.object == o) {
                    return o;
                }
                e = e.next;
            }
            return null;
        }

        public Object pop() {
            IdentitySetEntry[] tab = this.table;
            for (int i = 0; i < tab.length; ++i) {
                if (tab[i] == null) continue;
                IdentitySetEntry e = tab[i];
                tab[i] = e.next;
                --this.count;
                return e.object;
            }
            return null;
        }

        public Object put(Object o) {
            IdentitySetEntry[] tab = this.table;
            int hash = System.identityHashCode(o);
            int index = (hash & Integer.MAX_VALUE) % tab.length;
            IdentitySetEntry e = tab[index];
            while (e != null) {
                if (e.object == o) {
                    return o;
                }
                e = e.next;
            }
            if (this.count >= this.threshold) {
                this.rehash();
                return this.put(o);
            }
            e = new IdentitySetEntry();
            e.object = o;
            e.next = tab[index];
            tab[index] = e;
            ++this.count;
            return null;
        }

        public void clear() {
            for (int i = 0; i < this.table.length; ++i) {
                this.table[i] = null;
            }
            this.count = 0;
        }

        protected void rehash() {
            int oldCapacity = this.table.length;
            IdentitySetEntry[] oldTable = this.table;
            int newCapacity = oldCapacity * 2 + 1;
            IdentitySetEntry[] newTable = new IdentitySetEntry[newCapacity];
            this.threshold = (int)((float)newCapacity * this.loadFactor);
            this.table = newTable;
            int i = oldCapacity;
            while (i-- > 0) {
                IdentitySetEntry old = oldTable[i];
                while (old != null) {
                    IdentitySetEntry e = old;
                    old = old.next;
                    int index = (System.identityHashCode(e.object) & Integer.MAX_VALUE) % newCapacity;
                    e.next = newTable[index];
                    newTable[index] = e;
                }
            }
        }

        static class IdentitySetEntry {
            Object object;
            IdentitySetEntry next;

            IdentitySetEntry() {
            }
        }
    }
}

