/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.Cluster;
import com.odi.Database;
import com.odi.DatabaseSegmentEnumeration;
import com.odi.ObjectNotPersistenceCapableException;
import com.odi.ObjectNotPersistentException;
import com.odi.ObjectStoreException;
import com.odi.Placement;
import com.odi.Segment;
import com.odi.imp.DatabaseObjectIterator;
import com.odi.imp.Utilities;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

public class DynamicExtent
implements Collection {
    private Placement solePlacement;
    private Set placementSetFromCtor = null;
    private Set placementSet = null;
    private Class ofType;

    public DynamicExtent(Placement placement) {
        this(placement, null);
    }

    public DynamicExtent(Placement placement, Class ofType) {
        this.solePlacement = placement;
        this.ofType = ofType;
    }

    public DynamicExtent(Set placementSet) {
        this(placementSet, null);
    }

    public DynamicExtent(Set placementSet, Class ofType) {
        this.placementSetFromCtor = placementSet;
        this.ofType = ofType;
    }

    @Override
    public Iterator iterator() {
        this.checkPlacementSet();
        return new DynamicExtentObjectIterator();
    }

    private Iterator iterator(Placement placement) {
        if (placement instanceof Segment) {
            if (this.ofType == null) {
                return ((Segment)placement).getObjects();
            }
            return ((Segment)placement).getObjects(this.ofType);
        }
        if (placement instanceof Cluster) {
            if (this.ofType == null) {
                return ((Cluster)placement).getObjects();
            }
            return ((Cluster)placement).getObjects(this.ofType);
        }
        if (placement instanceof Database) {
            return new DatabaseObjectIterator((com.odi.imp.Database)placement, this.ofType);
        }
        throw new ObjectStoreException("Placement not recognized.");
    }

    @Override
    public int size() {
        this.checkPlacementSet();
        Iterator iterator = this.iterator();
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        this.checkPlacementSet();
        Iterator iterator = this.iterator();
        return !iterator.hasNext();
    }

    @Override
    public boolean contains(Object obj) {
        this.checkPlacementSet();
        if (obj == null) {
            Utilities.throwNullArgumentException("DynamicExtent", "contains", "obj");
        }
        try {
            return this.passesTypeFilter(obj) && this.containsPlacement(Cluster.of(obj));
        }
        catch (ObjectNotPersistentException e) {
            return false;
        }
        catch (ObjectNotPersistenceCapableException e) {
            return false;
        }
    }

    @Override
    public Object[] toArray() {
        this.checkPlacementSet();
        Iterator iterator = this.iterator();
        Vector collection = new Vector();
        while (iterator.hasNext()) {
            collection.addElement(iterator.next());
        }
        int length = collection.size();
        Object[] a = new Object[length];
        for (int i = 0; i < length; ++i) {
            a[i] = collection.elementAt(i);
        }
        return a;
    }

    public Object[] toArray(Object[] a) {
        this.checkPlacementSet();
        Class<?> elementType = a.getClass().getComponentType();
        if (this.ofType != null && this.ofType.isAssignableFrom(elementType)) {
            throw new ArrayStoreException("Invalid runtime type for allocation of the extent type.");
        }
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator iterator = this.iterator();
        int length = a.length;
        int i = 0;
        while (iterator.hasNext() && i < length) {
            Object object = iterator.next();
            a[i++] = object;
        }
        if (i < length) {
            a[i] = null;
        }
        return a;
    }

    public boolean add(Object obj) {
        throw new UnsupportedOperationException("com.odi.util.DynamicExtent.add() not implemented.");
    }

    @Override
    public boolean remove(Object obj) {
        throw new UnsupportedOperationException("com.odi.util.DynamicExtent.remove() not implemented.");
    }

    public boolean containsAll(Collection collection) {
        this.checkPlacementSet();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection coll) {
        throw new UnsupportedOperationException("com.odi.util.DynamicExtent.addAll() not implemented.");
    }

    public boolean removeAll(Collection coll) {
        throw new UnsupportedOperationException("com.odi.util.DynamicExtent.removeAll() not implemented.");
    }

    public boolean retainAll(Collection coll) {
        throw new UnsupportedOperationException("com.odi.util.DynamicExtent.retainAll() not implemented.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("com.odi.util.DynamicExtent.clear() not implemented.");
    }

    public Placement getPlacement() {
        this.checkPlacementSet();
        if (this.solePlacement == null) {
            throw new ObjectStoreException("This DynamicExtent consists of more than Placement.");
        }
        return this.solePlacement;
    }

    public Class getType() {
        return this.ofType;
    }

    public Set getPlacementSet() {
        return this.placementSetFromCtor;
    }

    public boolean containsPlacement(Placement placement) {
        this.checkPlacementSet();
        if (placement == null) {
            Utilities.throwNullArgumentException("DynamicExtent", "containsPlacement", "placement");
        }
        for (Placement extentPlacement : this.placementSet) {
            if (!DynamicExtent.containsPlacement(extentPlacement, placement)) continue;
            return true;
        }
        return false;
    }

    public Set getPrunedPlacementSet() {
        this.checkPlacementSet();
        return this.placementSet;
    }

    private synchronized void checkPlacementSet() {
        if (this.placementSet == null) {
            this.placementSet = new HashSet();
            if (this.placementSetFromCtor == null) {
                this.placementSet.add(this.solePlacement);
            } else {
                this.addPlacementSet(this.placementSetFromCtor);
                if (this.placementSet.size() == 1) {
                    this.solePlacement = (Placement)this.placementSet.iterator().next();
                }
            }
        }
    }

    private static boolean containsPlacement(Placement owner, Placement candidate) {
        if (owner == candidate) {
            return true;
        }
        if (owner.getClass().equals(candidate.getClass())) {
            return false;
        }
        if (owner instanceof Database) {
            Database database = (Database)owner;
            if (candidate instanceof Cluster) {
                DatabaseSegmentEnumeration segments = database.getSegments();
                while (segments.hasMoreElements()) {
                    if (!DynamicExtent.containsPlacement(segments.nextSegment(), candidate)) continue;
                    return true;
                }
            } else {
                DatabaseSegmentEnumeration segments = database.getSegments();
                while (segments.hasMoreElements()) {
                    if (!segments.nextSegment().equals(candidate)) continue;
                    return true;
                }
            }
            return false;
        }
        if (owner instanceof Segment) {
            if (candidate instanceof Database) {
                return false;
            }
            Segment segment = (Segment)owner;
            Iterator clusters = segment.getClusters();
            while (clusters.hasNext()) {
                if (!clusters.next().equals(candidate)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private void addPlacementSet(Set unprunedSet) {
        for (Object object : unprunedSet) {
            if (object == null || !(object instanceof Placement)) continue;
            this.prune((Placement)object);
        }
    }

    private void prune(Placement candidate) {
        if (this.containsPlacement(candidate)) {
            return;
        }
        HashSet<Placement> removeSet = new HashSet<Placement>();
        for (Placement existingPlacement : this.placementSet) {
            if (!DynamicExtent.containsPlacement(candidate, existingPlacement)) continue;
            removeSet.add(existingPlacement);
        }
        this.placementSet.removeAll(removeSet);
        this.placementSet.add(candidate);
    }

    private boolean passesTypeFilter(Object object) {
        if (this.ofType == null) {
            return true;
        }
        if (object == null) {
            return true;
        }
        return this.ofType.isInstance(object);
    }

    class DynamicExtentObjectIterator
    implements Iterator {
        private Iterator placements = null;
        private Iterator currentIterator = null;
        private Object lastElement = null;
        private boolean needToUpdateHasNext = true;
        private boolean hasNext = false;

        public DynamicExtentObjectIterator() {
            this.placements = DynamicExtent.this.getPrunedPlacementSet().iterator();
            this.needToUpdateHasNext = true;
        }

        @Override
        public boolean hasNext() {
            this.checkHasNext();
            return this.hasNext;
        }

        public Object next() {
            this.checkHasNext();
            if (!this.hasNext) {
                throw new NoSuchElementException("DynamicExtentIterator");
            }
            this.lastElement = this.currentIterator.next();
            this.needToUpdateHasNext = true;
            return this.lastElement;
        }

        @Override
        public void remove() {
            if (this.lastElement == null) {
                throw new IllegalStateException("DynamicExtentIterator");
            }
            DynamicExtent.this.remove(this.lastElement);
        }

        private void checkHasNext() {
            if (this.needToUpdateHasNext) {
                this.updateHasNext();
            }
        }

        private void updateHasNext() {
            this.needToUpdateHasNext = false;
            if (this.currentIterator == null) {
                this.refreshIterator();
                if (this.currentIterator == null) {
                    this.hasNext = false;
                    return;
                }
            }
            if (!this.currentIterator.hasNext()) {
                this.refreshIterator();
            }
            this.hasNext = this.currentIterator.hasNext();
        }

        private void refreshIterator() {
            if (this.placements.hasNext()) {
                Placement placement = (Placement)this.placements.next();
                this.currentIterator = DynamicExtent.this.iterator(placement);
                if (!this.currentIterator.hasNext()) {
                    this.refreshIterator();
                }
            }
        }
    }
}

