/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util.query;

import com.odi.FatalApplicationException;
import com.odi.Session;
import com.odi.imp.ObjectManager;
import com.odi.imp.Utilities;
import com.odi.util.IndexDescriptorSet;
import com.odi.util.IndexedCollection;
import com.odi.util.query.FreeVariableBindings;
import com.odi.util.query.FreeVariables;
import com.odi.util.query.QPT;
import com.odi.util.query.QueryEvalTree;
import com.odi.util.query.QueryIndexMismatchException;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;

public class Query {
    private QPT qpt;
    private QPT.Expr node;
    private QueryEvalTree tree;
    private boolean optimized;
    private int indexLookups;
    private int nonIndexLookups;
    private static boolean isPSE = true;

    public Query(Class elementType, String queryExpression, FreeVariables freeVariables) {
        this.initialize(elementType, queryExpression, freeVariables);
    }

    public Query(Class elementType, String queryExpression) {
        this.initialize(elementType, queryExpression, null);
    }

    private void initialize(Class elementType, String queryExpression, FreeVariables freeVariables) {
        if (isPSE) {
            throw new FatalApplicationException("\ncom.odi.util.query.Query not available.");
        }
        if (elementType == null) {
            Utilities.throwNullArgumentException("Query", "Query", "elementType");
        }
        if (queryExpression == null) {
            Utilities.throwNullArgumentException("Query", "Query", "queryExpression");
        }
        this.tree = null;
        this.qpt = new QPT(elementType, queryExpression, freeVariables, 1);
        this.optimized = false;
    }

    public Set select(Collection coll, FreeVariableBindings freeVariableBindings) {
        if (coll == null) {
            Utilities.throwNullArgumentException("Query", "select", "coll");
        }
        QueryEvalTree bound = this.bind(coll, freeVariableBindings);
        Set result = bound.getSet();
        bound.collectStatistics();
        this.indexLookups += bound.indexLookups;
        this.nonIndexLookups += bound.nonIndexLookups;
        return result;
    }

    public Set select(Collection coll) {
        return this.select(coll, null);
    }

    public Object pick(Collection coll, FreeVariableBindings freeVariableBindings) {
        if (coll == null) {
            Utilities.throwNullArgumentException("Query", "pick", "coll");
        }
        QueryEvalTree bound = this.bind(coll, freeVariableBindings);
        Object result = null;
        NoSuchElementException exception = null;
        try {
            result = bound.pick();
        }
        catch (NoSuchElementException e) {
            exception = e;
        }
        bound.collectStatistics();
        this.indexLookups += bound.indexLookups;
        this.nonIndexLookups += bound.nonIndexLookups;
        if (exception == null) {
            return result;
        }
        throw exception;
    }

    public Object pick(Collection coll) {
        return this.pick(coll, null);
    }

    public Iterator iterator(Collection coll, FreeVariableBindings freeVariableBindings) {
        if (coll == null) {
            Utilities.throwNullArgumentException("Query", "iterator", "coll");
        }
        QueryEvalTree bound = this.bind(coll, freeVariableBindings);
        Iterator result = bound.iterator();
        this.indexLookups += bound.indexLookups;
        this.nonIndexLookups += bound.nonIndexLookups;
        return result;
    }

    public Iterator iterator(Collection coll) {
        return this.iterator(coll, null);
    }

    private synchronized QueryEvalTree bind(Collection coll, FreeVariableBindings freeVariableBindings) {
        if (freeVariableBindings == null) {
            freeVariableBindings = new FreeVariableBindings();
        }
        if (this.tree == null) {
            this.tree = new QueryEvalTree(this.qpt, this.qpt.optimize(Query.getIndexes(coll)));
        } else {
            IndexDescriptorSet requiredIndexes = this.qpt.getRequiredIndexes();
            IndexDescriptorSet currentIndexes = Query.getIndexes(coll);
            if (!(requiredIndexes == null || requiredIndexes.isEmpty() || currentIndexes != null && currentIndexes.isSupersetOf(requiredIndexes))) {
                if (this.optimized) {
                    throw new QueryIndexMismatchException("This query was optimized for indexes that are not present on the specified collection.");
                }
                this.tree = new QueryEvalTree(this.qpt, this.qpt.optimize(currentIndexes));
            }
        }
        this.maybePrintIndexInfo();
        return this.tree.bind(freeVariableBindings, coll);
    }

    public synchronized void optimize(IndexDescriptorSet indexes) {
        this.tree = new QueryEvalTree(this.qpt, this.qpt.optimize(indexes));
        this.optimized = true;
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    private static IndexDescriptorSet getIndexes(Collection collection) {
        if (collection instanceof IndexedCollection) {
            return ((IndexedCollection)collection).getIndexes();
        }
        return null;
    }

    public Query(Query q) {
        this.initialize(q.qpt.elementType, q.qpt.queryExpression, q.qpt.freeVariables);
    }

    public Class getElementType() {
        return this.qpt.elementType;
    }

    public String getQueryExpression() {
        return this.qpt.queryExpression;
    }

    public IndexDescriptorSet getDesirableIndexes() {
        return this.qpt.getDesirableIndexes();
    }

    public IndexDescriptorSet getRequiredIndexes() {
        return this.qpt.getRequiredIndexes();
    }

    public Properties getCounters(boolean reset) {
        Properties props = new Properties();
        props.put("com.odi.indexLookups", Integer.toString(this.indexLookups));
        props.put("com.odi.nonIndexLookups", Integer.toString(this.nonIndexLookups));
        if (reset) {
            this.indexLookups = 0;
            this.nonIndexLookups = 0;
        }
        return props;
    }

    static int debugLevel() {
        ObjectManager om = (ObjectManager)Session.getCurrent();
        if (om != null) {
            String value = om.getProperty("com.odi.queryDebugLevel", null);
            return value == null ? 0 : Integer.parseInt(value);
        }
        return Utilities.getProperty(null, "com.odi.queryDebugLevel", 0);
    }

    private void maybePrintIndexInfo() {
        if (Query.debugLevel() < 1) {
            return;
        }
        System.err.println("\nQuery debugging -- required indexes:");
        IndexDescriptorSet requiredIndexes = this.qpt.getRequiredIndexes();
        if (requiredIndexes.isEmpty()) {
            System.err.println("  None");
        } else {
            Iterator iterator = requiredIndexes.iterator();
            while (iterator.hasNext()) {
                System.err.println("  " + iterator.next());
            }
        }
        System.err.println("\nQuery debugging -- desirable indexes:");
        IndexDescriptorSet desirableIndexes = this.qpt.getDesirableIndexes();
        if (desirableIndexes.isEmpty()) {
            System.err.println("  None");
        } else {
            Iterator iterator = desirableIndexes.iterator();
            while (iterator.hasNext()) {
                System.err.println("  " + iterator.next());
            }
        }
    }

    static {
        isPSE = false;
        try {
            Class.forName("com.odi.util.query.QPT");
        }
        catch (ClassNotFoundException e) {
            isPSE = true;
        }
    }
}

