/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.evs.nio;

import com.progress.blackbird.evs.EEvsException;
import com.progress.blackbird.evs.EEvsIOCancelledException;
import com.progress.blackbird.evs.EEvsIOException;
import com.progress.blackbird.evs.EEvsIONotPendingException;
import com.progress.blackbird.evs.EEvsIOPendingException;
import com.progress.blackbird.evs.EEvsIOWouldAsyncException;
import com.progress.blackbird.evs.IEvsDispatcher;
import com.progress.blackbird.evs.IEvsIOBuf;
import com.progress.blackbird.evs.IEvsIOBufList;
import com.progress.blackbird.evs.IEvsNetworkPort;
import com.progress.blackbird.evs.IEvsNetworkPortStatistics;
import com.progress.blackbird.evs.IEvsPortEventHandler;
import com.progress.blackbird.evs.nio.EvsDispatcher;
import com.progress.blackbird.evs.nio.EvsDispatcherEvent;
import com.progress.blackbird.evs.nio.EvsIOBuf;
import com.progress.blackbird.evs.nio.EvsIOBufList;
import com.progress.blackbird.evs.nio.EvsListElement;
import com.progress.blackbird.evs.nio.EvsListHead;
import com.progress.blackbird.evs.nio.EvsNetworkPortDataEvent;
import com.progress.blackbird.evs.nio.EvsNetworkPortPortEvent;
import com.progress.blackbird.evs.nio.EvsPort;
import com.progress.blackbird.evs.nio.EvsPortEvent;
import com.progress.blackbird.nwlink.ENwLinkException;
import com.progress.blackbird.nwlink.INwLink;
import com.progress.blackbird.nwlink.NwLinkFactory;
import com.progress.blackbird.sys.ESysIoctlException;
import com.progress.blackbird.sys.ISysIoctl;
import com.progress.blackbird.sys.SysConfig;
import com.progress.blackbird.sys.SysListElement;
import com.progress.blackbird.sys.SysStatistics;
import java.nio.ByteBuffer;
import java.text.NumberFormat;

public final class EvsNetworkPort
extends EvsPort
implements IEvsNetworkPort,
ISysIoctl {
    private final ConnectContext connectContext = new ConnectContext();
    private final AcceptContext acceptContext = new AcceptContext();
    private final ReadContext readContext = new ReadContext();
    private final WriteContext writeContext = new WriteContext();
    private INwLink link;
    private Statistics statistics;

    private EvsNetworkPort(INwLink iNwLink, boolean bl) {
        super(2, bl);
        this.init(iNwLink);
    }

    private EvsNetworkPort(int n, String string, boolean bl) throws EEvsException {
        super(2, bl);
        try {
            this.init(NwLinkFactory.create(n, string));
        }
        catch (ENwLinkException eNwLinkException) {
            throw new EEvsIOException("link create", eNwLinkException);
        }
    }

    private void init(INwLink iNwLink) {
        int n;
        this.trace.updateLevelFromProperty(SysConfig.getProperties(), "bb.evs.nio.nwport.trace");
        this.link = iNwLink;
        this.statistics = new Statistics(this.threaded);
        if (this.getNetworkPortType() == 1 && (n = (int)SysConfig.getConfigValue(SysConfig.getProperties(), "bb.io.rawStatsInterval", 0.0)) > 0) {
            this.statistics.startDump(n);
        }
    }

    private boolean connectInternal() throws EEvsIOException {
        try {
            return this.link.connect();
        }
        catch (ENwLinkException eNwLinkException) {
            throw new EEvsIOException("link connect", eNwLinkException);
        }
    }

    private void connectPostScheduleCompletion(EEvsIOException eEvsIOException, boolean bl) {
        if (this.trace.debug) {
            this.trace.debugln("Scheduling port connect completion event (immediateDispatch=" + bl + ", status=" + eEvsIOException + ")...");
        }
        this.connectContext.post.prepareCompletionEvent(this, eEvsIOException);
        if (bl) {
            this.connectPostEventHandler(this.connectContext.post.event);
        } else {
            this.connectContext.post.dispatcher.scheduleUserEvent(this.connectContext.post.event);
        }
    }

    private void connectPostCancelCompletion() {
        if (this.trace.debug) {
            this.trace.debugln("Cancelling port connect completion event...");
        }
        this.connectContext.post.cancelCompletionEvent();
    }

    private void connectPostScheduleReady() {
        if (this.trace.debug) {
            this.trace.debugln("Scheduling dispatcher connect ready event...");
        }
        this.connectContext.prepareReadyEvent();
        this.connectContext.post.dispatcher.scheduleNetworkEvent(this.link.getChannel(), this.connectContext.event);
    }

    private void connectPostUnscheduleReady() {
        if (this.trace.debug) {
            this.trace.debugln("Unscheduling dispatcher connect ready event...");
        }
        this.connectContext.event.getSource().unscheduleNetworkEvent(this.link.getChannel(), this.connectContext.event);
        this.connectContext.clearReadyEvent();
    }

    private void connectPostInternalCore(int n) throws EEvsIOException {
        boolean bl;
        boolean bl2 = (n & 1) > 0;
        boolean bl3 = bl = (n & 2) > 0;
        if (this.connectInternal()) {
            if (this.trace.debug) {
                this.trace.debugln("Connect succeeded.");
            }
            this.connectPostScheduleCompletion(null, bl2);
        } else if (bl) {
            if (this.trace.debug) {
                this.trace.debugln("Connect pending...user requested no async operation.");
            }
            this.connectPostScheduleCompletion(new EEvsIOWouldAsyncException("connect post"), bl2);
        } else {
            if (this.trace.debug) {
                this.trace.debugln("Connect pending...user requested async operation.");
            }
            this.connectPostScheduleReady();
        }
    }

    private boolean connectPostEventHandler(EvsDispatcherEvent evsDispatcherEvent) {
        if (evsDispatcherEvent == this.connectContext.post.event || evsDispatcherEvent == this.connectContext.event) {
            if (evsDispatcherEvent == this.connectContext.post.event) {
                if (this.checked && 0 != evsDispatcherEvent.getClazz()) {
                    throw new InternalError("connect completion event is not a USER event");
                }
                if (this.trace.debug) {
                    this.trace.debugln("Received connect completion event. Dispatching...");
                }
                this.connectContext.post.deactivate();
                this.setColdAndDispatch((EvsPortEvent)evsDispatcherEvent);
            } else {
                if (this.checked && 3 != evsDispatcherEvent.getClazz()) {
                    throw new InternalError("connect ready event is not a CONNECT_READY event");
                }
                if (this.trace.debug) {
                    this.trace.debugln("Received connect ready event. Completing connection...");
                }
                try {
                    this.connectContext.clearReadyEvent();
                    this.connectPostInternalCore(1);
                }
                catch (EEvsIOException eEvsIOException) {
                    if (this.trace.debug) {
                        this.trace.debugln("Connect failed.");
                    }
                    this.connectPostScheduleCompletion(eEvsIOException, true);
                }
            }
            return true;
        }
        return false;
    }

    private void connectPostInternal(EvsDispatcher evsDispatcher, byte by, IEvsPortEventHandler iEvsPortEventHandler, Object object, int n) throws EEvsIOPendingException, EEvsIOException {
        if (!this.connectContext.post.active) {
            try {
                this.setHot();
                this.connectContext.post.activate(evsDispatcher, by, iEvsPortEventHandler, object);
                this.connectPostInternalCore(n);
            }
            catch (EEvsIOException eEvsIOException) {
                this.connectContext.post.deactivate();
                this.setCold();
                throw eEvsIOException;
            }
        } else {
            throw new EEvsIOPendingException("connect post");
        }
    }

    private void connectCancelInternalCore() {
        if (this.connectContext.post.event != null) {
            if (this.trace.debug) {
                this.trace.debugln("Completion event set on connect cancel.");
            }
            if (this.checked && this.connectContext.event != null) {
                throw new InternalError("both completion AND ready event set on connect cancel");
            }
            if (((EvsNetworkPortPortEvent)this.connectContext.post.event).getStatus() == null) {
                if (this.trace.debug) {
                    this.trace.debugln("Closing connection....");
                }
                try {
                    this.closeInternal();
                }
                catch (EEvsIOException eEvsIOException) {
                    throw new RuntimeException("Failure on closing during connect cancel - " + eEvsIOException);
                }
            }
            this.connectPostCancelCompletion();
        } else if (this.connectContext.event != null) {
            if (this.trace.debug) {
                this.trace.debugln("Ready event set on connect cancel.");
            }
            if (this.checked && this.connectContext.post.event != null) {
                throw new InternalError("both completion AND ready event set on connect cancel");
            }
            this.connectPostUnscheduleReady();
            this.connectPostScheduleCompletion(new EEvsIOCancelledException("connect"), false);
        } else {
            throw new InternalError("one of completion and ready event must be set on connect cancel");
        }
    }

    private void connectCancelInternal() throws EEvsIONotPendingException {
        if (this.connectContext.post.active) {
            if (this.checked && this.connectContext.post.dispatcher.getOwner() != Thread.currentThread()) {
                throw new RuntimeException("calling thread is not dispatcher owner");
            }
        } else {
            throw new EEvsIONotPendingException("connect cancel");
        }
        this.connectCancelInternalCore();
    }

    private EvsNetworkPort acceptInternal() throws EEvsIOException {
        try {
            INwLink iNwLink = this.link.accept();
            if (iNwLink != null) {
                return new EvsNetworkPort(iNwLink, this.isThreaded());
            }
            return null;
        }
        catch (ENwLinkException eNwLinkException) {
            throw new EEvsIOException("link accept", eNwLinkException);
        }
    }

    private void acceptPostScheduleCompletion(IEvsNetworkPort iEvsNetworkPort, EEvsIOException eEvsIOException, boolean bl) {
        if (this.trace.debug) {
            this.trace.debugln("Scheduling port accept completion event (immediateDispatch=" + bl + ", status=" + eEvsIOException + ", port=" + iEvsNetworkPort + ")...");
        }
        this.acceptContext.post.prepareCompletionEvent(iEvsNetworkPort, eEvsIOException);
        if (bl) {
            this.acceptPostEventHandler(this.acceptContext.post.event);
        } else {
            this.acceptContext.post.dispatcher.scheduleUserEvent(this.acceptContext.post.event);
        }
    }

    private void acceptPostCancelCompletion() {
        if (this.trace.debug) {
            this.trace.debugln("Cancelling port accept completion event...");
        }
        this.acceptContext.post.cancelCompletionEvent();
    }

    private void acceptPostScheduleReady() {
        if (this.trace.debug) {
            this.trace.debugln("Scheduling dispatcher accept ready event...");
        }
        this.acceptContext.prepareReadyEvent();
        this.acceptContext.post.dispatcher.scheduleNetworkEvent(this.link.getServerChannel(), this.acceptContext.event);
    }

    private void acceptPostUnscheduleReady() {
        if (this.trace.debug) {
            this.trace.debugln("Unscheduling dispatcher accept ready event...");
        }
        this.acceptContext.event.getSource().unscheduleNetworkEvent(this.link.getServerChannel(), this.acceptContext.event);
        this.acceptContext.clearReadyEvent();
    }

    private void acceptPostInternalCore(int n) throws EEvsIOException {
        boolean bl = (n & 1) > 0;
        boolean bl2 = (n & 2) > 0;
        EvsNetworkPort evsNetworkPort = this.acceptInternal();
        if (evsNetworkPort != null) {
            if (this.trace.debug) {
                this.trace.debugln("Accept succeeded.");
            }
            this.acceptPostScheduleCompletion(evsNetworkPort, null, bl);
        } else if (bl2) {
            if (this.trace.debug) {
                this.trace.debugln("Accept pending...user requested no async operation.");
            }
            this.acceptPostScheduleCompletion(evsNetworkPort, new EEvsIOWouldAsyncException("accept post"), bl);
        } else {
            if (this.trace.debug) {
                this.trace.debugln("Accept pending...user requested async operation.");
            }
            this.acceptPostScheduleReady();
        }
    }

    private boolean acceptPostEventHandler(EvsDispatcherEvent evsDispatcherEvent) {
        if (evsDispatcherEvent == this.acceptContext.post.event || evsDispatcherEvent == this.acceptContext.event) {
            if (evsDispatcherEvent == this.acceptContext.post.event) {
                if (this.checked && 0 != evsDispatcherEvent.getClazz()) {
                    throw new InternalError("accept completion event is not a USER event");
                }
                if (this.trace.debug) {
                    this.trace.debugln("Received accept completion event. Dispatching...");
                }
                this.acceptContext.post.deactivate();
                this.setColdAndDispatch((EvsPortEvent)evsDispatcherEvent);
            } else {
                if (this.checked && 2 != evsDispatcherEvent.getClazz()) {
                    throw new InternalError("accept ready event is not a ACCEPT_READY event");
                }
                if (this.trace.debug) {
                    this.trace.debugln("Received accept ready event. Completing accept...");
                }
                try {
                    this.acceptContext.clearReadyEvent();
                    this.acceptPostInternalCore(1);
                }
                catch (EEvsIOException eEvsIOException) {
                    if (this.trace.debug) {
                        this.trace.debugln("Accept failed.");
                    }
                    this.acceptPostScheduleCompletion(null, eEvsIOException, true);
                }
            }
            return true;
        }
        return false;
    }

    private void acceptPostInternal(EvsDispatcher evsDispatcher, byte by, IEvsPortEventHandler iEvsPortEventHandler, Object object, int n) throws EEvsIOPendingException, EEvsIOException {
        if (!this.acceptContext.post.active) {
            try {
                this.setHot();
                this.acceptContext.post.activate(evsDispatcher, by, iEvsPortEventHandler, object);
                this.acceptPostInternalCore(n);
            }
            catch (EEvsIOException eEvsIOException) {
                this.acceptContext.post.deactivate();
                this.setCold();
                throw eEvsIOException;
            }
        } else {
            throw new EEvsIOPendingException("accept post");
        }
    }

    private void acceptCancelInternalCore() {
        if (this.acceptContext.post.event != null) {
            if (this.trace.debug) {
                this.trace.debugln("Completion event set on accept cancel.");
            }
            if (this.checked && this.acceptContext.event != null) {
                throw new InternalError("both completion AND ready event set on accept cancel");
            }
            if (((EvsNetworkPortPortEvent)this.acceptContext.post.event).getStatus() == null) {
                if (this.trace.debug) {
                    this.trace.debugln("Closing accepted port...");
                }
                try {
                    ((EvsNetworkPortPortEvent)this.acceptContext.post.event).getNetworkPort().close();
                }
                catch (EEvsIOException eEvsIOException) {
                    throw new RuntimeException("Failure on closing accepted port during accept cancel - " + eEvsIOException);
                }
            }
            this.acceptPostCancelCompletion();
        } else if (this.acceptContext.event != null) {
            if (this.trace.debug) {
                this.trace.debugln("Ready event set on accept cancel.");
            }
            if (this.checked && this.acceptContext.post.event != null) {
                throw new InternalError("both completion AND ready event set on accept cancel");
            }
            this.acceptPostUnscheduleReady();
            this.acceptPostScheduleCompletion(null, new EEvsIOCancelledException("accept"), false);
        } else {
            throw new InternalError("one of completion and ready event must be set on accept cancel");
        }
    }

    private void acceptCancelInternal() throws EEvsIONotPendingException {
        if (this.acceptContext.post.active) {
            if (this.checked && this.acceptContext.post.dispatcher.getOwner() != Thread.currentThread()) {
                throw new RuntimeException("calling thread is not dispatcher owner");
            }
        } else {
            throw new EEvsIONotPendingException("accept cancel");
        }
        this.acceptCancelInternalCore();
    }

    private int readInternal() throws EEvsIOException {
        try {
            return this.link.read(this.readContext.post.iobuf.getBuffer());
        }
        catch (ENwLinkException eNwLinkException) {
            throw new EEvsIOException("link read", eNwLinkException);
        }
    }

    private void readPostScheduleCompletion(int n, EEvsIOException eEvsIOException, boolean bl) {
        if (this.trace.debug) {
            this.trace.debugln("Scheduling port read completion event (immediateDispatch=" + bl + ", status=" + eEvsIOException + ", bytesRead=" + n + ")...");
        }
        this.readContext.post.prepareCompletionEvent(n, eEvsIOException);
        if (bl) {
            this.readPostEventHandler(this.readContext.post.event);
        } else {
            this.readContext.post.dispatcher.scheduleUserEvent(this.readContext.post.event);
        }
    }

    private void readPostCancelCompletion() {
        if (this.trace.debug) {
            this.trace.debugln("Cancelling port read completion event...");
        }
        this.readContext.post.cancelCompletionEvent();
    }

    private void readPostScheduleReady() {
        if (this.trace.debug) {
            this.trace.debugln("Scheduling port read ready event...");
        }
        this.readContext.prepareReadyEvent();
        this.readContext.post.dispatcher.scheduleNetworkEvent(this.link.getChannel(), this.readContext.event);
    }

    private void readPostUnscheduleReady() {
        if (this.trace.debug) {
            this.trace.debugln("Unscheduling dispatcher read ready event...");
        }
        this.readContext.event.getSource().unscheduleNetworkEvent(this.link.getChannel(), this.readContext.event);
        this.readContext.clearReadyEvent();
    }

    private void readPostInternalCore(int n) throws EEvsIOException {
        boolean bl = (n & 1) > 0;
        boolean bl2 = (n & 2) > 0;
        int n2 = this.readInternal();
        if (n2 != 0) {
            if (this.trace.debug) {
                this.trace.debugln("Read complete (count=" + n2 + ").");
            }
            if (n2 > 0) {
                this.statistics.numBitsRead += (long)(n2 * 8);
            }
            this.readPostScheduleCompletion(n2, null, bl);
        } else if (bl2) {
            if (this.trace.debug) {
                this.trace.debugln("Read pending...user requested no async operation");
            }
            this.readPostScheduleCompletion(n2, new EEvsIOWouldAsyncException("read post"), bl);
        } else {
            if (this.trace.debug) {
                this.trace.debugln("Read pending...user requested async operation");
            }
            this.readPostScheduleReady();
        }
    }

    private boolean readPostEventHandler(EvsDispatcherEvent evsDispatcherEvent) {
        if (evsDispatcherEvent == this.readContext.post.event || evsDispatcherEvent == this.readContext.event) {
            if (evsDispatcherEvent == this.readContext.post.event) {
                if (this.checked && 0 != evsDispatcherEvent.getClazz()) {
                    throw new InternalError("read completion event is not a USER event");
                }
                if (this.trace.debug) {
                    this.trace.debugln("Received read completion event. Dispatching...");
                }
                this.readContext.post.deactivate();
                this.setColdAndDispatch((EvsPortEvent)evsDispatcherEvent);
            } else {
                if (this.checked && 4 != evsDispatcherEvent.getClazz()) {
                    throw new InternalError("read ready event is not a READ_READY event");
                }
                if (this.trace.debug) {
                    this.trace.debugln("Received read ready event. Completing read...");
                }
                try {
                    this.readContext.clearReadyEvent();
                    this.readPostInternalCore(1);
                }
                catch (EEvsIOException eEvsIOException) {
                    if (this.trace.debug) {
                        this.trace.debugln("Read failed.");
                    }
                    this.readPostScheduleCompletion(0, eEvsIOException, true);
                }
            }
            return true;
        }
        return false;
    }

    private void readPostInternal(EvsIOBuf evsIOBuf, EvsDispatcher evsDispatcher, byte by, IEvsPortEventHandler iEvsPortEventHandler, Object object, int n) throws EEvsIOPendingException, EEvsIOException {
        if (!this.readContext.post.active) {
            try {
                this.setHot();
                this.readContext.post.activate(evsIOBuf, evsDispatcher, by, iEvsPortEventHandler, object);
                this.readPostInternalCore(n);
            }
            catch (EEvsIOException eEvsIOException) {
                this.readContext.post.deactivate();
                this.setCold();
                throw eEvsIOException;
            }
        } else {
            throw new EEvsIOPendingException("read post");
        }
    }

    private void readCancelInternalCore() {
        if (this.readContext.post.event != null) {
            if (this.trace.debug) {
                this.trace.debugln("Completion event set on read cancel.");
            }
            if (this.checked && this.readContext.event != null) {
                throw new InternalError("both completion AND ready event set on read cancel");
            }
            this.readPostCancelCompletion();
        } else if (this.readContext.event != null) {
            if (this.trace.debug) {
                this.trace.debugln("Ready event set on read cancel.");
            }
            if (this.checked && this.readContext.post.event != null) {
                throw new InternalError("both completion AND ready event set on read cancel");
            }
            this.readPostUnscheduleReady();
            this.readPostScheduleCompletion(0, new EEvsIOCancelledException("read"), false);
        } else {
            throw new InternalError("one of completion and ready event must be set on connect cancel");
        }
    }

    private void readCancelInternal(EvsIOBuf evsIOBuf) throws EEvsIONotPendingException {
        if (this.readContext.post.active && this.readContext.post.iobuf == evsIOBuf) {
            if (this.checked && this.readContext.post.dispatcher.getOwner() != Thread.currentThread()) {
                throw new RuntimeException("calling thread is not dispatcher owner");
            }
        } else {
            throw new EEvsIONotPendingException("read cancel");
        }
        this.readCancelInternalCore();
    }

    private long writeInternal() throws EEvsIOException {
        try {
            return this.link.write(this.writeContext.bufferArray);
        }
        catch (ENwLinkException eNwLinkException) {
            throw new EEvsIOException("link write", eNwLinkException);
        }
    }

    private void writePostScheduleCompletion(WritePost writePost, EEvsIOException eEvsIOException, boolean bl) {
        if (this.trace.debug) {
            this.trace.debugln("Scheduling port write completion event (status=" + eEvsIOException + ", post=" + writePost + ", bytesWritten=" + writePost.bytesWritten + ")...");
        }
        writePost.prepareCompletionEvent(eEvsIOException);
        this.writeContext.completeList.add(writePost);
        if (bl) {
            this.writePostEventHandler(writePost.event);
        } else {
            writePost.dispatcher.scheduleUserEvent(writePost.event);
        }
    }

    private void writePostCancelCompletion(WritePost writePost) {
        if (this.trace.debug) {
            this.trace.debugln("Cancelling port write completion event (post=" + writePost + ")...");
        }
        writePost.cancelCompletionEvent();
    }

    private void writePostScheduleReady(WritePost writePost) {
        if (this.trace.debug) {
            this.trace.debugln("Scheduling port write ready event on post=" + writePost + "to " + writePost.dispatcher.getOwner() + "...");
        }
        this.writeContext.prepareReadyEvent(writePost, true);
        writePost.dispatcher.scheduleNetworkEvent(this.link.getChannel(), this.writeContext.event);
    }

    private void writePostUnscheduleReady() {
        if (this.trace.debug) {
            this.trace.debugln("Unscheduling port write ready event...");
        }
        this.writeContext.event.getSource().unscheduleNetworkEvent(this.link.getChannel(), this.writeContext.event);
        this.writeContext.clearReadyEvent();
    }

    private void writePostScheduleFuse(WritePost writePost) {
        if (this.trace.debug) {
            this.trace.debugln("Scheduling port write fuse event on post=" + writePost + "to " + writePost.dispatcher.getOwner() + "...");
        }
        this.writeContext.prepareFuse(writePost);
        writePost.dispatcher.scheduleUserEvent(this.writeContext.fuse);
    }

    private void writePostPendingFail(EEvsIOException eEvsIOException) {
        WritePost writePost;
        if (this.trace.debug) {
            this.trace.debugln("Scheduling port write failure completion events for all pending posts...");
        }
        while ((writePost = (WritePost)this.writeContext.pendingList.list.getNext()) != null) {
            if (this.trace.debug) {
                this.trace.debugln("Scheduled write failure completion for post " + writePost);
            }
            this.writeContext.pendingList.remove(writePost);
            this.writePostScheduleCompletion(writePost, eEvsIOException, false);
        }
    }

    private WritePost writePostDone(WritePost writePost, int n, EEvsIOException eEvsIOException, boolean bl) {
        this.writeContext.bufferArray.reset();
        writePost.incrementBytesWritten(n);
        this.writeContext.pendingList.remove(writePost);
        this.writePostScheduleCompletion(writePost, eEvsIOException, bl);
        return (WritePost)this.writeContext.pendingList.list.getNext();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writePostInternalCore(int n) throws EEvsIOException {
        boolean bl;
        boolean bl2 = (n & 1) > 0;
        boolean bl3 = bl = (n & 2) > 0;
        if (!this.writeContext.pendingList.isEmpty()) {
            try {
                if (this.checked && ((WritePost)this.writeContext.pendingList.list.getNext()).dispatcher.getOwner() != Thread.currentThread()) {
                    throw new RuntimeException("calling thread is not dispatcher owner");
                }
                if (this.checked && bl && this.writeContext.pendingList.list.getListSize() > 1) {
                    throw new InternalError("write post driver invoked with no async flag and more than one write post in pending list!");
                }
                if (!this.writeContext.bufferArray.isSet()) {
                    if (this.trace.debug) {
                        this.trace.debugln("Preparing write buffer array...");
                    }
                    this.writeContext.bufferArray.set(this.writeContext.pendingList);
                } else if (this.trace.debug) {
                    this.trace.debugln("Write buffer array currently set...");
                }
                this.writeContext.clearReadyEvent();
                this.writeContext.clearFuse();
                if (this.trace.debug) {
                    this.trace.debugln("Writing data (count=" + this.writeContext.bufferArray.bytesPending + ")...");
                }
                int n2 = (int)this.writeInternal();
                if (this.trace.debug) {
                    this.trace.debugln("Written data (count=" + n2 + ")...");
                }
                this.statistics.numBitsWritten += (long)(n2 * 8);
                this.writeContext.bufferArray.decrementBytesPending(n2);
                WritePost writePost = (WritePost)this.writeContext.pendingList.list.getNext();
                if (writePost.bytesRemaining() <= n2) {
                    if (this.trace.debug) {
                        this.trace.debugln("Atleast one write post is complete. Scheduling completion events...");
                    }
                    while (writePost != null && (n2 > 0 || writePost.isInitialized() && writePost.bytesRemaining() == 0)) {
                        if (this.trace.debug) {
                            this.trace.debugln("post.bytesRemaining= " + writePost.bytesRemaining() + " bytesWritten=" + n2);
                        }
                        if (n2 < writePost.bytesRemaining()) break;
                        n2 -= writePost.bytesRemaining();
                        writePost = this.writePostDone(writePost, writePost.bytesRemaining(), null, bl2);
                    }
                    if (writePost != null) {
                        this.writePostScheduleFuse(writePost);
                    }
                } else if (bl) {
                    writePost = this.writePostDone(writePost, n2, new EEvsIOWouldAsyncException("write post"), bl2);
                } else {
                    this.writePostScheduleReady(writePost);
                }
                if (writePost == null) return;
                writePost.incrementBytesWritten(n2);
                return;
            }
            catch (EEvsIOException eEvsIOException) {
                this.writeContext.bufferArray.reset();
                throw eEvsIOException;
            }
        } else {
            System.out.print("%");
        }
    }

    private int writePostEventHandlerCore(EvsDispatcherEvent evsDispatcherEvent) {
        int n = 0;
        int n2 = evsDispatcherEvent.getClazz();
        if (evsDispatcherEvent == this.writeContext.event || evsDispatcherEvent == this.writeContext.fuse) {
            if (0 == n2) {
                if (this.trace.debug) {
                    this.trace.debugln("Received write fuse event. Resuming write...");
                }
            } else if (this.trace.debug) {
                this.trace.debugln("Received write ready event. Resuming write...");
            }
            try {
                this.writePostInternalCore(0);
            }
            catch (EEvsIOException eEvsIOException) {
                if (this.trace.debug) {
                    this.trace.debugln("Write failed.");
                }
                this.writePostPendingFail(eEvsIOException);
            }
            n = 1;
        } else if (0 == n2 && this.writeContext.completeList.remove(evsDispatcherEvent)) {
            if (this.trace.debug) {
                this.trace.debugln("Received write completion event. Dispatching...");
            }
            n = 2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writePostEventHandler(EvsDispatcherEvent evsDispatcherEvent) {
        int n;
        if (this.isThreaded()) {
            WriteContext writeContext = this.writeContext;
            synchronized (writeContext) {
                n = this.writePostEventHandlerCore(evsDispatcherEvent);
            }
        } else {
            n = this.writePostEventHandlerCore(evsDispatcherEvent);
        }
        if (n == 2) {
            if (this.trace.debug) {
                this.trace.debugln("Received write completion event. Dispatching...");
            }
            this.setColdAndDispatch((EvsPortEvent)evsDispatcherEvent);
        }
        return n > 0;
    }

    private void writePostInternal(EvsIOBufList evsIOBufList, EvsDispatcher evsDispatcher, byte by, IEvsPortEventHandler iEvsPortEventHandler, Object object, int n) throws EEvsIOException {
        WritePost writePost = null;
        try {
            this.setHot();
            writePost = new WritePost(evsIOBufList, evsDispatcher, by, iEvsPortEventHandler, object);
            boolean bl = this.writeContext.pendingList.isEmpty();
            this.writeContext.pendingList.add(writePost);
            if (bl) {
                this.writePostInternalCore(n);
            } else if ((n & 2) > 0) {
                throw new EEvsIOWouldAsyncException("write post");
            }
        }
        catch (EEvsIOException eEvsIOException) {
            if (writePost != null) {
                this.writeContext.pendingList.remove(writePost);
            }
            if (!(eEvsIOException instanceof EEvsIOWouldAsyncException)) {
                this.writePostPendingFail(eEvsIOException);
            }
            this.setCold();
            throw eEvsIOException;
        }
    }

    private boolean writeCancelInternalCore(EvsIOBufList evsIOBufList) {
        WritePost writePost = null;
        writePost = this.writeContext.pendingList.lookup(evsIOBufList);
        if (writePost != null) {
            if (this.trace.debug) {
                this.trace.debugln("post=" + writePost + ") present in pending list on write cancel. Removing event..");
            }
            String string = "";
            string = string + "*";
            if (this.checked && writePost.dispatcher.getOwner() != Thread.currentThread()) {
                throw new RuntimeException("calling thread is not dispatcher owner");
            }
            boolean bl = writePost == this.writeContext.pendingList.list.getNext();
            this.writeContext.pendingList.remove(writePost);
            this.writeContext.bufferArray.reset();
            if (bl) {
                if (this.writeContext.event != null) {
                    string = string + "<";
                    this.writePostUnscheduleReady();
                }
                if (!this.writeContext.pendingList.isEmpty()) {
                    string = string + ">";
                    this.writePostScheduleFuse((WritePost)this.writeContext.pendingList.list.getNext());
                }
            }
            this.writePostScheduleCompletion(writePost, new EEvsIOCancelledException("write"), false);
            System.out.print(string);
        } else {
            writePost = this.writeContext.completeList.lookup(evsIOBufList);
            if (writePost != null) {
                System.out.print("x");
                if (this.trace.debug) {
                    this.trace.debugln("post=" + writePost + ") present in completion list on write cancel.");
                }
                this.writePostCancelCompletion(writePost);
            }
        }
        return writePost != null;
    }

    private void writeCancelInternal(EvsIOBufList evsIOBufList) throws EEvsIONotPendingException {
        if (!this.writeCancelInternalCore(evsIOBufList)) {
            throw new EEvsIONotPendingException("write cancel");
        }
    }

    private void closeInternal() throws EEvsIOException {
        try {
            this.link.close();
            this.statistics.stopDump();
        }
        catch (ENwLinkException eNwLinkException) {
            throw new EEvsIOException("link close", eNwLinkException);
        }
    }

    private Object ioctlInternal(String string, Object object) throws ESysIoctlException, EEvsIOException {
        if (this.link instanceof ISysIoctl) {
            try {
                return ((ISysIoctl)((Object)this.link)).ioctl(string, object);
            }
            catch (ESysIoctlException eSysIoctlException) {
                throw eSysIoctlException;
            }
            catch (Exception exception) {
                throw new EEvsIOException("ioctl", exception);
            }
        }
        throw new ESysIoctlException("command not supported");
    }

    public static IEvsNetworkPort create(int n, String string, boolean bl) throws EEvsException {
        return new EvsNetworkPort(n == 1 ? 1 : 0, string, bl);
    }

    @Override
    final void handleEvent(EvsDispatcherEvent evsDispatcherEvent) {
        if (!(this.readPostEventHandler(evsDispatcherEvent) || this.writePostEventHandler(evsDispatcherEvent) || this.acceptPostEventHandler(evsDispatcherEvent) || this.connectPostEventHandler(evsDispatcherEvent))) {
            System.out.print("#");
            if (this.trace.debug) {
                this.trace.debugln("Received orphaned event.");
            }
            if (this.checked && 0 != evsDispatcherEvent.getClazz()) {
                throw new InternalError("Received invalid orphaned event");
            }
        }
    }

    @Override
    public final IEvsNetworkPortStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public final int getNetworkPortType() {
        if (this.link.getType() == 1) {
            return 1;
        }
        if (this.link.getType() == 0) {
            return 0;
        }
        throw new InternalError("Internal error : Port type is invalid");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void connectPost(IEvsDispatcher iEvsDispatcher, byte by, IEvsPortEventHandler iEvsPortEventHandler, Object object, int n) throws EEvsIOPendingException, EEvsIOException {
        if (this.checked) {
            if (iEvsDispatcher == null) {
                throw new IllegalArgumentException("null dispatcher");
            }
            if (by < 0 || by > 31) {
                throw new IllegalArgumentException("invalid priority");
            }
            if (iEvsPortEventHandler == null) {
                throw new IllegalArgumentException("null event handler");
            }
            if (iEvsDispatcher.getOwner() != Thread.currentThread()) {
                throw new IllegalArgumentException("calling thread is not dispatcher owner");
            }
            if (this.getNetworkPortType() != 1) {
                throw new IllegalStateException("This method cannot be invoked on a passive port");
            }
        }
        if (this.isThreaded()) {
            ConnectContext connectContext = this.connectContext;
            synchronized (connectContext) {
                this.connectPostInternal((EvsDispatcher)iEvsDispatcher, by, iEvsPortEventHandler, object, n);
            }
        } else {
            this.connectPostInternal((EvsDispatcher)iEvsDispatcher, by, iEvsPortEventHandler, object, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void connectCancel() throws EEvsIONotPendingException {
        if (this.checked && this.getNetworkPortType() != 1) {
            throw new IllegalStateException("This method cannot be invoked on a passive port");
        }
        if (this.isThreaded()) {
            ConnectContext connectContext = this.connectContext;
            synchronized (connectContext) {
                this.connectCancelInternal();
            }
        } else {
            this.connectCancelInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void acceptPost(IEvsDispatcher iEvsDispatcher, byte by, IEvsPortEventHandler iEvsPortEventHandler, Object object, int n) throws EEvsIOPendingException, EEvsIOException {
        if (this.checked) {
            if (iEvsDispatcher == null) {
                throw new IllegalArgumentException("null dispatcher");
            }
            if (by < 0 || by > 31) {
                throw new IllegalArgumentException("invalid priority");
            }
            if (iEvsPortEventHandler == null) {
                throw new IllegalArgumentException("null event handler");
            }
            if (iEvsDispatcher.getOwner() != Thread.currentThread()) {
                throw new IllegalArgumentException("calling thread is not dispatcher owner");
            }
            if (this.getNetworkPortType() != 0) {
                throw new IllegalStateException("This method cannot be invoked on an active port");
            }
        }
        if (this.isThreaded()) {
            AcceptContext acceptContext = this.acceptContext;
            synchronized (acceptContext) {
                this.acceptPostInternal((EvsDispatcher)iEvsDispatcher, by, iEvsPortEventHandler, object, n);
            }
        } else {
            this.acceptPostInternal((EvsDispatcher)iEvsDispatcher, by, iEvsPortEventHandler, object, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void acceptCancel() throws EEvsIONotPendingException {
        if (this.checked && this.getNetworkPortType() != 0) {
            throw new IllegalStateException("This method cannot be invoked on an active port");
        }
        if (this.isThreaded()) {
            AcceptContext acceptContext = this.acceptContext;
            synchronized (acceptContext) {
                this.acceptCancelInternal();
            }
        } else {
            this.acceptCancelInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void readPost(IEvsIOBuf iEvsIOBuf, IEvsDispatcher iEvsDispatcher, byte by, IEvsPortEventHandler iEvsPortEventHandler, Object object, int n) throws EEvsIOPendingException, EEvsIOException {
        if (this.checked) {
            if (iEvsIOBuf == null) {
                throw new IllegalArgumentException("null I/O buffer");
            }
            if (iEvsDispatcher == null) {
                throw new IllegalArgumentException("null dispatcher");
            }
            if (by < 0 || by > 31) {
                throw new IllegalArgumentException("invalid priority");
            }
            if (iEvsPortEventHandler == null) {
                throw new IllegalArgumentException("null event handler");
            }
            if (iEvsDispatcher.getOwner() != Thread.currentThread()) {
                throw new IllegalArgumentException("calling thread is not dispatcher owner");
            }
            if (this.getNetworkPortType() != 1) {
                throw new IllegalStateException("This method cannot be invoked on a passive port");
            }
        }
        if (this.isThreaded()) {
            ReadContext readContext = this.readContext;
            synchronized (readContext) {
                this.readPostInternal((EvsIOBuf)iEvsIOBuf, (EvsDispatcher)iEvsDispatcher, by, iEvsPortEventHandler, object, n);
            }
        } else {
            this.readPostInternal((EvsIOBuf)iEvsIOBuf, (EvsDispatcher)iEvsDispatcher, by, iEvsPortEventHandler, object, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void readCancel(IEvsIOBuf iEvsIOBuf) throws EEvsIONotPendingException {
        if (this.checked && this.getNetworkPortType() != 1) {
            throw new IllegalStateException("This method cannot be invoked on a passive port");
        }
        if (this.isThreaded()) {
            ReadContext readContext = this.readContext;
            synchronized (readContext) {
                this.readCancelInternal((EvsIOBuf)iEvsIOBuf);
            }
        } else {
            this.readCancelInternal((EvsIOBuf)iEvsIOBuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writePost(IEvsIOBufList iEvsIOBufList, IEvsDispatcher iEvsDispatcher, byte by, IEvsPortEventHandler iEvsPortEventHandler, Object object, int n) throws EEvsIOWouldAsyncException, EEvsIOException {
        if (this.checked) {
            if (iEvsIOBufList == null) {
                throw new IllegalArgumentException("null I/O buffer list");
            }
            if (iEvsDispatcher == null) {
                throw new IllegalArgumentException("null dispatcher");
            }
            if (by < 0 || by > 31) {
                throw new IllegalArgumentException("invalid priority");
            }
            if (iEvsPortEventHandler == null) {
                throw new IllegalArgumentException("null event handler");
            }
            if (iEvsDispatcher.getOwner() != Thread.currentThread()) {
                throw new IllegalArgumentException("calling thread is not dispatcher owner");
            }
            if (this.getNetworkPortType() != 1) {
                throw new IllegalStateException("This method cannot be invoked on a passive port");
            }
        }
        if (this.isThreaded()) {
            WriteContext writeContext = this.writeContext;
            synchronized (writeContext) {
                this.writePostInternal((EvsIOBufList)iEvsIOBufList, (EvsDispatcher)iEvsDispatcher, by, iEvsPortEventHandler, object, n);
            }
        } else {
            this.writePostInternal((EvsIOBufList)iEvsIOBufList, (EvsDispatcher)iEvsDispatcher, by, iEvsPortEventHandler, object, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void writeCancel(IEvsIOBufList iEvsIOBufList) throws EEvsIONotPendingException {
        if (this.checked && this.getNetworkPortType() != 1) {
            throw new IllegalStateException("This method cannot be invoked on a passive port");
        }
        if (this.isThreaded()) {
            WriteContext writeContext = this.writeContext;
            synchronized (writeContext) {
                this.writeCancelInternal((EvsIOBufList)iEvsIOBufList);
            }
        } else {
            this.writeCancelInternal((EvsIOBufList)iEvsIOBufList);
        }
    }

    @Override
    public final void close() throws EEvsIOPendingException, EEvsIOException {
        if (this.connectContext.post.active || this.acceptContext.post.active || this.readContext.post.active || this.writeContext.isBusy()) {
            throw new EEvsIOPendingException("close");
        }
        this.closeInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object ioctl(String string, Object object) throws ESysIoctlException, EEvsIOException {
        if (this.threaded) {
            EvsNetworkPort evsNetworkPort = this;
            synchronized (evsNetworkPort) {
                return this.ioctlInternal(string, object);
            }
        }
        return this.ioctlInternal(string, object);
    }

    private class Statistics
    extends SysStatistics
    implements IEvsNetworkPortStatistics {
        private NumberFormat format = NumberFormat.getInstance();
        private long startTime;
        private long deltaStartTime;
        private long numBitsWrittenLast;
        private long numBitsReadLast;
        long numBitsWritten;
        long numBitsRead;

        private Statistics(boolean bl) {
            this.format.setMaximumFractionDigits(2);
        }

        @Override
        protected final void init() {
            this.startTime = this.deltaStartTime = System.currentTimeMillis();
            this.numBitsWrittenLast = this.numBitsWritten;
            this.numBitsReadLast = this.numBitsRead;
        }

        @Override
        protected final void dump() {
            long l = System.currentTimeMillis();
            long l2 = this.numBitsWritten;
            long l3 = this.numBitsRead;
            long l4 = l - this.startTime;
            long l5 = l - this.deltaStartTime;
            String string = this.format.format(l2 / 0x100000L) + "M";
            String string2 = this.format.format((l2 - this.numBitsWrittenLast) / 0x100000L) + "M";
            String string3 = this.format.format(l2 * 1000L / l4 / 0x100000L) + "M";
            String string4 = this.format.format((l2 - this.numBitsWrittenLast) * 1000L / l5 / 0x100000L) + "M";
            String string5 = this.format.format(l3 / 0x100000L) + "M";
            String string6 = this.format.format((l3 - this.numBitsReadLast) / 0x100000L) + "M";
            String string7 = this.format.format(l3 * 1000L / l4 / 0x100000L) + "M";
            String string8 = this.format.format((l3 - this.numBitsReadLast) * 1000L / l5 / 0x100000L) + "M";
            this.deltaStartTime = l;
            this.numBitsWrittenLast = l2;
            this.numBitsReadLast = l3;
            String string9 = "[" + EvsNetworkPort.this + " STATS] DT=" + l5 + "\n";
            string9 = string9 + " Read{";
            string9 = string9 + string5 + "(" + string6 + ") ";
            string9 = string9 + string7 + "(" + string8 + ")";
            string9 = string9 + "}";
            string9 = string9 + " Write{";
            string9 = string9 + string + "(" + string2 + ") ";
            string9 = string9 + string3 + "(" + string4 + ")";
            string9 = string9 + "}\n";
            EvsNetworkPort.this.trace.out(string9, -1);
        }
    }

    private class WriteContext
    extends Context {
        PendingList pendingList;
        CompleteList completeList;
        BufferArray bufferArray;

        WriteContext() {
            this.pendingList = new PendingList();
            this.completeList = new CompleteList();
            this.bufferArray = new BufferArray();
        }

        final boolean isBusy() {
            return !this.pendingList.isEmpty() || !this.completeList.isEmpty() || this.event != null;
        }

        final void prepareReadyEvent(WritePost writePost, boolean bl) {
            super.prepareReadyEvent(5, writePost.dispatcher, (byte)31);
            this.event.setCritical(bl);
        }

        final void prepareFuse(WritePost writePost) {
            super.prepareFuse(writePost.dispatcher, (byte)31);
        }

        private class BufferArray
        extends INwLink.WriteBufferArray {
            int bytesPending;

            private BufferArray() {
            }

            final boolean isSet() {
                return this.array != null;
            }

            final void set(PendingList pendingList) {
                int n = 0;
                if (EvsNetworkPort.this.checked && this.array != null) {
                    throw new InternalError("Array initialize when non-null");
                }
                this.array = new ByteBuffer[pendingList.bufferCount];
                this.offset = 0;
                this.bytesPending = 0;
                SysListElement sysListElement = pendingList.list;
                while ((sysListElement = sysListElement.getNext()) != null) {
                    boolean bl;
                    WritePost writePost = (WritePost)sysListElement;
                    boolean bl2 = bl = writePost.bytesTotal == -1;
                    if (bl) {
                        writePost.incrementBytesTotal(0);
                    }
                    if (((EvsNetworkPort)EvsNetworkPort.this).trace.debug) {
                        EvsNetworkPort.this.trace.debugln("Setting array - post=" + writePost);
                    }
                    SysListElement sysListElement2 = writePost.iobufList.getBufferList();
                    while ((sysListElement2 = sysListElement2.getNext()) != null) {
                        EvsIOBuf evsIOBuf = (EvsIOBuf)sysListElement2;
                        int n2 = evsIOBuf.getLimit() - evsIOBuf.getPos();
                        this.array[n++] = evsIOBuf.getBuffer();
                        this.bytesPending += n2;
                        if (!bl) continue;
                        writePost.incrementBytesTotal(n2);
                    }
                }
            }

            final void decrementBytesPending(int n) {
                this.bytesPending -= n;
            }

            final void reset() {
                this.array = null;
                this.offset = 0;
                this.bytesPending = 0;
            }
        }

        private class CompleteList {
            EvsListHead[] list = new EvsListHead[32];

            CompleteList() {
                for (int i = 0; i < this.list.length; ++i) {
                    this.list[i] = EvsListHead.create();
                }
            }

            final void add(WritePost writePost) {
                this.list[writePost.priority].append(writePost);
            }

            final void remove(WritePost writePost) {
                writePost.remove();
            }

            final boolean remove(EvsDispatcherEvent evsDispatcherEvent) {
                SysListElement sysListElement = this.list[evsDispatcherEvent.getPriority()];
                while ((sysListElement = sysListElement.getNext()) != null) {
                    if (evsDispatcherEvent != ((WritePost)sysListElement).event) continue;
                    sysListElement.remove();
                    break;
                }
                return sysListElement != null;
            }

            final WritePost lookup(EvsIOBufList evsIOBufList) {
                for (int i = 0; i < this.list.length; ++i) {
                    SysListElement sysListElement = this.list[i];
                    while ((sysListElement = sysListElement.getNext()) != null) {
                        if (evsIOBufList != ((WritePost)sysListElement).iobufList) continue;
                        return (WritePost)sysListElement;
                    }
                }
                return null;
            }

            final boolean isEmpty() {
                int n;
                for (n = 0; n < this.list.length && this.list[n].getListSize() <= 0; ++n) {
                }
                return n == this.list.length;
            }
        }

        private class PendingList {
            EvsListHead list = EvsListHead.create();
            int bufferCount;

            PendingList() {
            }

            final void add(WritePost writePost) {
                if (((EvsNetworkPort)EvsNetworkPort.this).trace.debug) {
                    EvsNetworkPort.this.trace.debugln("Adding post " + writePost + " to write context pending list");
                }
                this.list.append(writePost);
                this.bufferCount += writePost.iobufList.getBufferList().getListSize();
            }

            final void remove(WritePost writePost) {
                if (((EvsNetworkPort)EvsNetworkPort.this).trace.debug) {
                    EvsNetworkPort.this.trace.debugln("Removing post " + writePost + " from write context pending list");
                }
                this.bufferCount -= writePost.iobufList.getBufferList().getListSize();
                writePost.remove();
            }

            final WritePost lookup(EvsIOBufList evsIOBufList) {
                SysListElement sysListElement = this.list;
                while ((sysListElement = sysListElement.getNext()) != null) {
                    if (evsIOBufList != ((WritePost)sysListElement).iobufList) continue;
                    return (WritePost)sysListElement;
                }
                return null;
            }

            final boolean isEmpty() {
                return this.list.getListSize() == 0;
            }
        }
    }

    private class ReadContext
    extends Context {
        ReadPost post;

        ReadContext() {
            this.post = new ReadPost();
        }

        final void prepareReadyEvent() {
            super.prepareReadyEvent(4, this.post.dispatcher, (byte)31);
        }
    }

    private class AcceptContext
    extends ConnectAcceptContext {
        AcceptContext() {
            super(false);
        }
    }

    private class ConnectContext
    extends ConnectAcceptContext {
        ConnectContext() {
            super(true);
        }
    }

    private class ConnectAcceptContext
    extends Context {
        boolean isConnect;
        ConnectAcceptPost post;

        ConnectAcceptContext(boolean bl) {
            this.isConnect = bl;
            this.post = bl ? new ConnectPost() : new AcceptPost();
        }

        final void prepareReadyEvent() {
            super.prepareReadyEvent(this.isConnect ? 3 : 2, this.post.dispatcher, (byte)31);
        }
    }

    private class Context {
        private EvsDispatcherEvent storedEvent;
        EvsDispatcherEvent event;
        EvsDispatcherEvent fuse;

        Context() {
            this.storedEvent = EvsDispatcherEvent.create(0, null, EvsNetworkPort.this, (byte)15);
        }

        final void prepareReadyEvent(int n, EvsDispatcher evsDispatcher, byte by) {
            this.event = this.storedEvent;
            this.event.init(n, evsDispatcher, EvsNetworkPort.this, by, this.event.getSource() == evsDispatcher ? this.event.getAttachment() : null);
        }

        final void clearReadyEvent() {
            this.event = null;
        }

        final void prepareFuse(EvsDispatcher evsDispatcher, byte by) {
            this.fuse = EvsDispatcherEvent.create(0, evsDispatcher, EvsNetworkPort.this, by);
        }

        final void clearFuse() {
            this.fuse = null;
        }
    }

    private class WritePost
    extends Post {
        EvsIOBufList iobufList;
        int bytesTotal;
        int bytesWritten;

        WritePost(EvsIOBufList evsIOBufList, EvsDispatcher evsDispatcher, byte by, IEvsPortEventHandler iEvsPortEventHandler, Object object) {
            super.activate(evsDispatcher, by, iEvsPortEventHandler, object);
            this.iobufList = evsIOBufList;
            this.bytesTotal = -1;
        }

        final boolean isInitialized() {
            return this.bytesTotal != -1;
        }

        final int bytesRemaining() {
            if (this.bytesTotal == -1) {
                throw new InternalError("Bytes remaining called for an uninitialized write post!");
            }
            return this.bytesTotal - this.bytesWritten;
        }

        final void incrementBytesTotal(int n) {
            if (this.bytesTotal == -1) {
                this.bytesTotal = 0;
            }
            this.bytesTotal += n;
            if (this.trace.debug) {
                this.trace.debugln("Post " + this + " bytes total incremented to " + this.bytesTotal);
            }
        }

        final void resetBytesWritten() {
            this.bytesWritten = 0;
            if (this.trace.debug) {
                this.trace.debugln("Post " + this + " bytes written reset");
            }
        }

        final void incrementBytesWritten(int n) {
            this.bytesWritten += n;
            if (this.trace.debug) {
                this.trace.debugln("Post " + this + " bytes written incremented to " + this.bytesWritten);
            }
        }

        @Override
        final void prepareCompletionEvent() {
            this.event = EvsNetworkPortDataEvent.create(5, EvsNetworkPort.this, this.dispatcher, this.priority, this.iobufList, this.handler, this.data);
        }

        final void prepareCompletionEvent(EEvsIOException eEvsIOException) {
            this.prepareCompletionEvent();
            ((EvsNetworkPortDataEvent)this.event).setBytesTransferred(this.bytesWritten);
            ((EvsNetworkPortDataEvent)this.event).setStatus(eEvsIOException);
        }

        final void cancelCompletionEvent() {
            ((EvsNetworkPortDataEvent)this.event).setStatus(new EEvsIOCancelledException("write"));
        }
    }

    private class ReadPost
    extends Post {
        EvsIOBuf iobuf;

        private ReadPost() {
        }

        final void activate(EvsIOBuf evsIOBuf, EvsDispatcher evsDispatcher, byte by, IEvsPortEventHandler iEvsPortEventHandler, Object object) {
            super.activate(evsDispatcher, by, iEvsPortEventHandler, object);
            this.iobuf = evsIOBuf;
        }

        @Override
        final void deactivate() {
            super.deactivate();
            this.iobuf = null;
        }

        @Override
        final void prepareCompletionEvent() {
            this.event = EvsNetworkPortDataEvent.create(4, EvsNetworkPort.this, this.dispatcher, this.priority, this.iobuf, this.handler, this.data);
        }

        final void prepareCompletionEvent(int n, EEvsIOException eEvsIOException) {
            this.prepareCompletionEvent();
            ((EvsNetworkPortDataEvent)this.event).setBytesTransferred(n);
            ((EvsNetworkPortDataEvent)this.event).setStatus(eEvsIOException);
        }

        void cancelCompletionEvent() {
            ((EvsNetworkPortDataEvent)this.event).setStatus(new EEvsIOCancelledException("read"));
        }
    }

    private class AcceptPost
    extends ConnectAcceptPost {
        AcceptPost() {
            super(false);
        }
    }

    private class ConnectPost
    extends ConnectAcceptPost {
        ConnectPost() {
            super(true);
        }
    }

    private class ConnectAcceptPost
    extends Post {
        boolean isConnect;

        ConnectAcceptPost(boolean bl) {
            this.isConnect = bl;
        }

        @Override
        final void prepareCompletionEvent() {
            this.event = EvsNetworkPortPortEvent.create(this.isConnect ? 2 : 3, EvsNetworkPort.this, this.dispatcher, this.priority, this.handler, this.data);
        }

        final void prepareCompletionEvent(IEvsNetworkPort iEvsNetworkPort, EEvsIOException eEvsIOException) {
            this.prepareCompletionEvent();
            ((EvsNetworkPortPortEvent)this.event).setNetworkPort(iEvsNetworkPort);
            ((EvsNetworkPortPortEvent)this.event).setStatus(eEvsIOException);
        }

        final void cancelCompletionEvent() {
            ((EvsNetworkPortPortEvent)this.event).setStatus(new EEvsIOCancelledException(this.isConnect ? "connect" : "accept"));
            if (!this.isConnect) {
                ((EvsNetworkPortPortEvent)this.event).setNetworkPort(null);
            }
        }
    }

    private abstract class Post
    extends EvsListElement {
        boolean active;
        EvsDispatcher dispatcher;
        byte priority;
        IEvsPortEventHandler handler;
        EvsDispatcherEvent event;
        Object data;

        private Post() {
        }

        final void activate(EvsDispatcher evsDispatcher, byte by, IEvsPortEventHandler iEvsPortEventHandler, Object object) {
            this.active = true;
            this.dispatcher = evsDispatcher;
            this.priority = by;
            this.handler = iEvsPortEventHandler;
            this.data = object;
            this.event = null;
        }

        void deactivate() {
            this.active = false;
            this.dispatcher = null;
            this.handler = null;
            this.data = null;
            this.event = null;
            this.priority = 0;
        }

        abstract void prepareCompletionEvent();
    }
}

