/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.io.evs;

import cern.colt.list.ObjectArrayList;
import com.progress.blackbird.io.EIOConnectionClosedException;
import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOFlushPendingException;
import com.progress.blackbird.io.EIOInboundStreamOpenException;
import com.progress.blackbird.io.EIOTimeoutException;
import com.progress.blackbird.io.IIOConnection;
import com.progress.blackbird.io.IIOConnectionEventHandler;
import com.progress.blackbird.io.IIOPacketSerializer;
import com.progress.blackbird.io.evs.IIONetworkConnectionPingPacketManager;
import com.progress.blackbird.io.evs.IOMultiNetworkConnection;
import com.progress.blackbird.io.evs.IOMultiNetworkConnectionActive;
import com.progress.blackbird.io.evs.IOMultiNetworkConnectionEvents;
import com.progress.blackbird.io.evs.IONetworkConnection;
import com.progress.blackbird.io.evs.IOObject;
import com.progress.blackbird.io.multi.IIOMultiConnectionFlowBalancer;
import com.progress.blackbird.io.multi.IIOMultiConnectionPacketManager;
import com.progress.blackbird.io.multi.IOMultiConnectionHandshaker;
import com.progress.blackbird.sys.SysConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

final class IOMultiNetworkConnectionPassive
extends IOObject {
    private IOMultiNetworkConnection.Parameters parameters;
    private IIOConnectionEventHandler eventHandler;
    private IIOMultiConnectionPacketManager packetManager;
    private IIOMultiConnectionFlowBalancer flowBalancer;
    private Acceptor acceptor;
    private LinkedList passiveConnections;
    private HashMap acceptedConnections;
    private LinkedHashMap acceptQueue;
    private boolean userThreaded;
    private boolean flgWaitingForAccept;
    private boolean flgClosed;

    IOMultiNetworkConnectionPassive(String[] stringArray, boolean bl, IONetworkConnection.Parameters[] parametersArray, IIOPacketSerializer iIOPacketSerializer, IIONetworkConnectionPingPacketManager iIONetworkConnectionPingPacketManager, IIOConnectionEventHandler iIOConnectionEventHandler, IIOMultiConnectionPacketManager iIOMultiConnectionPacketManager, IIOMultiConnectionFlowBalancer iIOMultiConnectionFlowBalancer, IOMultiNetworkConnection.Parameters parameters) throws EIOException {
        this.init(true, bl, iIOConnectionEventHandler, iIOMultiConnectionPacketManager, iIOMultiConnectionFlowBalancer, parameters);
        try {
            this.trace.outln("Creating passive connections to listen for incoming connections...", 4);
            for (int i = 0; i < stringArray.length; ++i) {
                this.passiveConnections.add(new Connection(stringArray[i], this.userThreaded, null, iIOPacketSerializer, iIONetworkConnectionPingPacketManager, parametersArray != null ? parametersArray[i] : null));
            }
            this.trace.outln("Starting acceptor...", 4);
            this.acceptor.start();
            this.trace.outln("Creation complete.", 4);
        }
        catch (EIOException eIOException) {
            this.trace.outln("Creation error [" + eIOException.getMessage() + "]...", 1);
            Iterator iterator = this.passiveConnections.iterator();
            while (iterator.hasNext()) {
                try {
                    ((Connection)iterator.next()).close(null);
                }
                catch (Exception exception) {
                    this.trace.outln("Error in closing underlying passive connection [" + ((Connection)iterator.next()).descriptor + "] during cleanup after creation failure [" + exception.getMessage() + "]", 2);
                }
            }
            throw eIOException;
        }
    }

    private void init(boolean bl, boolean bl2, IIOConnectionEventHandler iIOConnectionEventHandler, IIOMultiConnectionPacketManager iIOMultiConnectionPacketManager, IIOMultiConnectionFlowBalancer iIOMultiConnectionFlowBalancer, IOMultiNetworkConnection.Parameters parameters) throws EIOException {
        this.threaded = bl;
        this.userThreaded = bl2;
        this.parameters = parameters;
        this.eventHandler = iIOConnectionEventHandler;
        this.packetManager = iIOMultiConnectionPacketManager;
        this.flowBalancer = iIOMultiConnectionFlowBalancer;
        this.flgClosed = false;
        this.passiveConnections = new LinkedList();
        this.acceptedConnections = new HashMap();
        this.acceptQueue = new LinkedHashMap();
        this.acceptor = new Acceptor();
        this.trace.updateLevelFromProperty(SysConfig.getProperties(), "bb.io.multi.trace");
    }

    private IOMultiNetworkConnectionActive acceptInternal(int n) throws EIOConnectionClosedException, EIOTimeoutException, EIOException {
        if (!this.flgClosed) {
            this.trace.outln("Accepting multi-connection with timeout=" + n + "ms...", 3);
            if (this.acceptQueue.size() == 0) {
                try {
                    this.trace.outln("Accept queue empty. Waiting...", 4);
                    this.flgWaitingForAccept = true;
                    this.acceptQueue.wait(n);
                    this.flgWaitingForAccept = false;
                    if (this.acceptQueue.size() == 0) {
                        this.trace.outln("Accept timed out.", 3);
                        throw new EIOTimeoutException("timed out during accept");
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new EIOException(interruptedException);
                }
            }
            this.trace.outln("Accept queue not empty. Retriving entry at head...", 4);
            Map.Entry entry = this.acceptQueue.entrySet().iterator().next();
            String string = (String)entry.getKey();
            ObjectArrayList objectArrayList = (ObjectArrayList)this.acceptQueue.remove(string);
            this.trace.outln("Preparing multi-connection [id=" + string + "]...", 4);
            Object[] objectArray = objectArrayList.elements();
            int n2 = objectArrayList.size();
            IIOConnection[] iIOConnectionArray = new IIOConnection[n2];
            String[] stringArray = new String[n2];
            for (int i = 0; i < n2; ++i) {
                this.trace.outln("\tAdding connection" + (Connection)objectArray[i] + " to multi-connection...", 4);
                Connection connection = (Connection)objectArray[i];
                iIOConnectionArray[i] = connection.getUnderlyingConnection();
                stringArray[i] = connection.getDescriptor();
            }
            IOMultiNetworkConnectionActive iOMultiNetworkConnectionActive = new IOMultiNetworkConnectionActive(this, this.threaded, stringArray, iIOConnectionArray, string, this.eventHandler, this.packetManager, this.flowBalancer, this.parameters);
            this.trace.outln("Adding prepared multi-connection " + iOMultiNetworkConnectionActive + " to accepted connection set...", 4);
            this.acceptedConnections.put(string, iOMultiNetworkConnectionActive);
            this.trace.outln("Successfully accepted multi-connection " + iOMultiNetworkConnectionActive, 3);
            return iOMultiNetworkConnectionActive;
        }
        throw new EIOConnectionClosedException();
    }

    private void closeInternal() throws EIOInboundStreamOpenException, EIOFlushPendingException, EIOException {
        if (!this.flgClosed) {
            this.trace.outln("Closing...", 4);
            this.trace.outln("Closing passive connections...", 4);
            for (Connection connection : this.passiveConnections) {
                try {
                    connection.close(null);
                }
                catch (Exception exception) {
                    this.trace.outln("Failed to close individual connection " + connection + " during close", 2);
                }
            }
            this.trace.outln("Closing orphaned accepted connections...", 4);
            Iterator<Object> iterator = this.acceptQueue.entrySet().iterator();
            while (iterator.hasNext()) {
                ObjectArrayList objectArrayList = (ObjectArrayList)((Map.Entry)iterator.next()).getValue();
                Object[] objectArray = objectArrayList.elements();
                int n = objectArrayList.size();
                for (int i = 0; i < n; ++i) {
                    Connection connection;
                    connection = (Connection)objectArray[i];
                    try {
                        connection.close(null);
                        continue;
                    }
                    catch (EIOException eIOException) {
                        this.trace.outln("Failed to close orphan network connection " + connection + " during close", 2);
                    }
                }
            }
            this.acceptQueue.clear();
            this.flgClosed = true;
            this.trace.outln("Close complete.", 4);
        }
    }

    private boolean isClosedInternal() throws EIOException {
        return this.flgClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void handleAcceptedConnectionClosed(String string) {
        this.trace.outln("Active connection [" + string + "] closed. Removing from accepted connection set");
        HashMap hashMap = this.acceptedConnections;
        synchronized (hashMap) {
            this.acceptedConnections.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final IOMultiNetworkConnectionActive accept(int n) throws EIOConnectionClosedException, EIOTimeoutException, EIOException {
        if (this.threaded) {
            LinkedHashMap linkedHashMap = this.acceptQueue;
            synchronized (linkedHashMap) {
                return this.acceptInternal(n);
            }
        }
        return this.acceptInternal(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() throws EIOInboundStreamOpenException, EIOFlushPendingException, EIOException {
        block6: {
            this.trace.outln("Stopping acceptor...", 4);
            this.acceptor.stop();
            try {
                if (this.threaded) {
                    LinkedHashMap linkedHashMap = this.acceptQueue;
                    synchronized (linkedHashMap) {
                        this.closeInternal();
                        break block6;
                    }
                }
                this.closeInternal();
            }
            catch (EIOException eIOException) {
                this.acceptor.start();
                throw eIOException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isClosed() throws EIOException {
        if (this.threaded) {
            LinkedHashMap linkedHashMap = this.acceptQueue;
            synchronized (linkedHashMap) {
                return this.isClosedInternal();
            }
        }
        return this.isClosedInternal();
    }

    private final class Acceptor
    implements Runnable {
        private volatile boolean flgRunning;
        private Thread thread;

        Acceptor() throws EIOException {
        }

        private void createNewAcceptQueueEntry(Connection connection) {
            ObjectArrayList objectArrayList = new ObjectArrayList();
            objectArrayList.add(connection);
            IOMultiNetworkConnectionPassive.this.acceptQueue.put(connection.getId(), objectArrayList);
            IOMultiNetworkConnectionPassive.this.acceptQueue.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processAcceptedConnection(Connection connection) {
            LinkedHashMap linkedHashMap = IOMultiNetworkConnectionPassive.this.acceptQueue;
            synchronized (linkedHashMap) {
                ObjectArrayList objectArrayList = (ObjectArrayList)IOMultiNetworkConnectionPassive.this.acceptQueue.get(connection.getId());
                if (objectArrayList != null) {
                    IOMultiNetworkConnectionPassive.this.trace.outln("Found entry in accept queue for connection " + connection + ". Adding connection to entry and notifying waiting user...", 4);
                    objectArrayList.add(connection);
                    IOMultiNetworkConnectionPassive.this.acceptQueue.notify();
                } else {
                    IOMultiNetworkConnectionPassive.this.trace.outln("No entry in accept queue for connection " + connection, 4);
                    HashMap hashMap = IOMultiNetworkConnectionPassive.this.acceptedConnections;
                    synchronized (hashMap) {
                        IOMultiNetworkConnectionActive iOMultiNetworkConnectionActive = (IOMultiNetworkConnectionActive)IOMultiNetworkConnectionPassive.this.acceptedConnections.get(connection.getId());
                        if (iOMultiNetworkConnectionActive == null) {
                            int n = IOMultiNetworkConnectionPassive.this.parameters.getMaxAcceptBacklog();
                            if (IOMultiNetworkConnectionPassive.this.acceptQueue.size() < n || n == 0 && IOMultiNetworkConnectionPassive.this.acceptQueue.size() == 0 && IOMultiNetworkConnectionPassive.this.flgWaitingForAccept) {
                                IOMultiNetworkConnectionPassive.this.trace.outln("No entry in accepted connections for connection " + connection + ". Creating new entry in accept queue and notifying waiting user...", 4);
                                this.createNewAcceptQueueEntry(connection);
                            } else {
                                IOMultiNetworkConnectionPassive.this.trace.outln("No entry in accepted connections for connection " + connection + ". No space in multi-conn accept queue [maxBacklog=" + n + ", queueSize=" + IOMultiNetworkConnectionPassive.this.acceptQueue.size() + ", userWait=" + IOMultiNetworkConnectionPassive.this.flgWaitingForAccept + "]. Rejecting connection.", 4);
                                try {
                                    connection.close(new EIOException("No space in multi-connection accept queue"));
                                }
                                catch (Exception exception) {
                                    IOMultiNetworkConnectionPassive.this.trace.outln("Failed to close accepted connection after rejecting due to full accept queue [" + exception.getMessage() + "]", 2);
                                }
                            }
                        } else {
                            IOMultiNetworkConnectionPassive.this.trace.outln("Found multi-connection " + iOMultiNetworkConnectionActive + " for connection " + connection + " found. Adding connection to multi-connection...", 4);
                            try {
                                iOMultiNetworkConnectionActive.add(connection.getDescriptor(), connection.getUnderlyingConnection());
                            }
                            catch (EIOException eIOException) {
                                IOMultiNetworkConnectionPassive.this.trace.outln("Failed to add accepted connection " + connection + " to multi-connection " + iOMultiNetworkConnectionActive + " - [" + eIOException.getMessage() + "]. Closing connection.", 4);
                                try {
                                    connection.close(new EIOException("Failed to add accepted connection to existing multi-connection [" + eIOException.getMessage() + "]"));
                                }
                                catch (Exception exception) {
                                    IOMultiNetworkConnectionPassive.this.trace.outln("Failed to close accepted connection after failed attempt to add to existing multi-connection [" + exception.getMessage() + "]", 2);
                                }
                            }
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void start() {
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this, "Acceptor");
                this.thread.setDaemon(true);
                this.thread.start();
                Acceptor acceptor = this;
                synchronized (acceptor) {
                    while (!this.flgRunning) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }

        final void stop() {
            if (this.thread != null) {
                this.flgRunning = false;
                while (true) {
                    try {
                        this.thread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                this.thread = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Iterator iterator = this;
            synchronized (iterator) {
                this.flgRunning = true;
                this.notify();
            }
            iterator = IOMultiNetworkConnectionPassive.this.passiveConnections.iterator();
            while (this.flgRunning) {
                if (!iterator.hasNext()) {
                    iterator = IOMultiNetworkConnectionPassive.this.passiveConnections.iterator();
                }
                Connection connection = (Connection)iterator.next();
                try {
                    Connection connection2 = connection.accept(100);
                    this.processAcceptedConnection(connection2);
                }
                catch (EIOException eIOException) {}
            }
        }
    }

    private final class Connection {
        private boolean active;
        private String descriptor;
        private IIOConnection ioConnection;
        private String id;
        private int counter;

        private Connection(String string, IIOConnection iIOConnection, String string2) {
            this.init(true, string, iIOConnection, string2);
        }

        Connection(String string, boolean bl, String string2, IIOPacketSerializer iIOPacketSerializer, IIONetworkConnectionPingPacketManager iIONetworkConnectionPingPacketManager, IONetworkConnection.Parameters parameters) throws EIOException {
            this.init(false, string, null, string2);
            IOMultiNetworkConnectionPassive.this.trace.outln("Creating connection " + this + "...", 4);
            this.ioConnection = IONetworkConnection.create(false, string, bl, iIOPacketSerializer, iIONetworkConnectionPingPacketManager, parameters);
        }

        private void init(boolean bl, String string, IIOConnection iIOConnection, String string2) {
            this.active = bl;
            this.descriptor = string;
            this.ioConnection = iIOConnection;
            this.id = string2;
        }

        final Connection accept(int n) throws EIOException {
            if (((IOMultiNetworkConnectionPassive)IOMultiNetworkConnectionPassive.this).trace.debug) {
                IOMultiNetworkConnectionPassive.this.trace.debugln("Accepting connection through " + this);
            }
            IIOConnection iIOConnection = null;
            try {
                iIOConnection = this.ioConnection.accept(n);
                if (((IOMultiNetworkConnectionPassive)IOMultiNetworkConnectionPassive.this).trace.debug) {
                    IOMultiNetworkConnectionPassive.this.trace.debugln("Accepted connection. Starting hanshake...");
                }
                IOMultiConnectionHandshaker.HandshakeCompletionData handshakeCompletionData = IOMultiConnectionHandshaker.doSynchronousHandshake(iIOConnection, null, IOMultiNetworkConnectionPassive.this.parameters.getHandshakeTimeout(), null, IOMultiNetworkConnectionPassive.this.packetManager);
                if (((IOMultiNetworkConnectionPassive)IOMultiNetworkConnectionPassive.this).trace.debug) {
                    IOMultiNetworkConnectionPassive.this.trace.debugln("Handshake completion status " + handshakeCompletionData);
                }
                if (handshakeCompletionData.status != null) {
                    if (handshakeCompletionData.status instanceof EIOException) {
                        throw (EIOException)handshakeCompletionData.status;
                    }
                    throw new EIOException(handshakeCompletionData.status);
                }
                if (IOMultiNetworkConnectionPassive.this.eventHandler != null) {
                    IOMultiNetworkConnectionPassive.this.eventHandler.handleEvent(301, new IOMultiNetworkConnectionEvents.ConnectionUpEventData(this.descriptor));
                }
                Connection connection = new Connection(this.descriptor + ":" + ++this.counter, iIOConnection, handshakeCompletionData.requestData.id);
                IOMultiNetworkConnectionPassive.this.trace.outln("Connection " + connection + " successfully accepted.", 4);
                return connection;
            }
            catch (EIOException eIOException) {
                IOMultiNetworkConnectionPassive.this.trace.outln("Acceptance of connection through " + this + " failed [" + eIOException.getMessage() + "]", 4);
                if (iIOConnection != null) {
                    try {
                        iIOConnection.close();
                    }
                    catch (Exception exception) {
                        IOMultiNetworkConnectionPassive.this.trace.outln("Failed to close accepted connection after failed accept attempt [" + exception.getMessage() + "]", 2);
                    }
                }
                throw eIOException;
            }
        }

        final void close(EIOException eIOException) throws EIOException {
            IOMultiNetworkConnectionPassive.this.trace.outln("Closing connection " + this + "...", 4);
            if (this.active && eIOException != null && IOMultiNetworkConnectionPassive.this.eventHandler != null) {
                IOMultiNetworkConnectionPassive.this.eventHandler.handleEvent(302, new IOMultiNetworkConnectionEvents.ConnectionDownEventData(this.descriptor, eIOException));
            }
            this.ioConnection.close();
        }

        final String getId() {
            return this.id;
        }

        final IIOConnection getUnderlyingConnection() {
            return this.ioConnection;
        }

        final String getDescriptor() {
            return this.descriptor;
        }

        public final String toString() {
            return "[" + (this.active ? "active" : "passive") + ", url=" + this.descriptor + ", id=" + this.id + "]";
        }
    }
}

