/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.pdu;

import com.progress.blackbird.io.EIOException;
import com.progress.blackbird.io.EIOInsufficientDataException;
import com.progress.blackbird.pdu.EPDUPacketFormatException;
import com.progress.blackbird.pdu.PDUPacketSubHeader;
import com.progress.blackbird.sys.SysInteractive;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class PDUPacketSubHeaderMultiConnection
extends PDUPacketSubHeader {
    private byte version = 1;
    private long sno;

    public PDUPacketSubHeaderMultiConnection() {
    }

    public PDUPacketSubHeaderMultiConnection(long l) {
        this.setSequenceNumber(l);
    }

    @Override
    final void serialize(DataOutputStream dataOutputStream) throws EIOException {
        try {
            dataOutputStream.writeByte(this.version);
            dataOutputStream.writeLong(this.sno);
        }
        catch (IOException iOException) {
            throw new EIOException(iOException.getMessage());
        }
    }

    @Override
    final void deserialize(DataInputStream dataInputStream) throws EIOInsufficientDataException, EIOException {
        block7: {
            try {
                if (dataInputStream.available() >= 1) {
                    byte by = dataInputStream.readByte();
                    switch (by) {
                        case 1: {
                            if (dataInputStream.available() >= 8) {
                                this.setSequenceNumber(dataInputStream.readLong());
                                break;
                            }
                            throw new EIOInsufficientDataException(8 - dataInputStream.available());
                        }
                        default: {
                            throw new EPDUPacketFormatException("Invalid version in multi-connection subheader");
                        }
                    }
                    break block7;
                }
                throw new EIOInsufficientDataException(1);
            }
            catch (IOException iOException) {
                throw new EIOException(iOException.getMessage());
            }
        }
    }

    @Override
    final void deserialize(PrintStream printStream, BufferedReader bufferedReader) throws IOException {
        do {
            this.version = (byte)SysInteractive.ask("Version", printStream, bufferedReader, 1.0);
        } while (this.version != 1);
        if (this.version == 1) {
            this.setSequenceNumber((long)SysInteractive.ask("Version", printStream, bufferedReader, 0.0));
        }
    }

    @Override
    final int getWireSize() {
        return 9;
    }

    @Override
    public final Object clone() {
        PDUPacketSubHeaderMultiConnection pDUPacketSubHeaderMultiConnection = (PDUPacketSubHeaderMultiConnection)super.clone();
        pDUPacketSubHeaderMultiConnection.setVersion(this.getVersion());
        pDUPacketSubHeaderMultiConnection.setSequenceNumber(this.getSequenceNumber());
        return pDUPacketSubHeaderMultiConnection;
    }

    final void setVersion(byte by) {
        this.version = by;
    }

    final byte getVersion() {
        return this.version;
    }

    public final void setSequenceNumber(long l) {
        this.sno = l;
    }

    public final long getSequenceNumber() {
        return this.sno;
    }

    public final String toString() {
        return "mconn" + this.hashCode() + "{v" + this.version + ",[" + this.sno + "]}";
    }
}

