/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.sys;

import com.progress.blackbird.sys.SysLogger;
import com.progress.blackbird.sys.SysLoggerDefault;
import java.util.Hashtable;
import java.util.Properties;

public class SysConfig {
    private static Hashtable checkedTable = new Hashtable();
    private static Hashtable threadedTable = new Hashtable();
    private static Hashtable traceLevelTable = new Hashtable();
    private static Hashtable testModeTable = new Hashtable();
    private static PackageConfig defPackageConfig;
    private static SysLogger logger;
    private static Properties properties;
    public static final int TESTMODE_NONE = 0;
    public static final int TESTMODE_REGULAR = 1;
    public static final int TESTMODE_LOAD = 2;
    public static final int TESTMODE_PERFORMANCE = 3;
    public static final int TESTMODE_RECOVERY = 4;
    public static final int TRACE_LEVEL_ALWAYS = -1;
    public static final int TRACE_LEVEL_NONE = 0;
    public static final int TRACE_LEVEL_ERROR = 1;
    public static final int TRACE_LEVEL_WARN = 2;
    public static final int TRACE_LEVEL_INFO = 3;
    public static final int TRACE_LEVEL_VERBOSE = 4;
    public static final int TRACE_LEVEL_DEBUG = 9;
    public static final int TRACE_LEVEL_DEFAULT = 0;

    public static SysLogger setLogger(SysLogger sysLogger) {
        SysLogger sysLogger2 = logger;
        logger = sysLogger;
        return sysLogger2;
    }

    public static SysLogger getLogger() {
        return logger;
    }

    public static void setProperties(Properties properties) {
        SysConfig.properties = properties;
    }

    public static Properties getProperties() {
        return properties;
    }

    public static void setChecked(String string, boolean bl) {
        if (string == null) {
            SysConfig.defPackageConfig.checked = bl;
        } else {
            checkedTable.put(string, new Boolean(bl));
        }
    }

    public static boolean getChecked(String string) {
        if (string == null) {
            return SysConfig.defPackageConfig.checked;
        }
        Boolean bl = (Boolean)checkedTable.get(string);
        return bl == null ? SysConfig.defPackageConfig.checked : bl;
    }

    public static void setThreaded(String string, boolean bl) {
        if (string == null) {
            SysConfig.defPackageConfig.threaded = bl;
        } else {
            threadedTable.put(string, new Boolean(bl));
        }
    }

    public static boolean getThreaded(String string) {
        if (string == null) {
            return SysConfig.defPackageConfig.threaded;
        }
        Boolean bl = (Boolean)threadedTable.get(string);
        return bl == null ? false : bl;
    }

    public static void setTraceLevel(String string, int n) {
        if (string == null) {
            SysConfig.defPackageConfig.traceLevel = n;
        } else {
            traceLevelTable.put(string, new Integer(n));
        }
    }

    public static int getTraceLevel(String string) {
        if (string == null) {
            return SysConfig.defPackageConfig.traceLevel;
        }
        Integer n = (Integer)traceLevelTable.get(string);
        return n == null ? 0 : n;
    }

    public static void setDebug(String string, boolean bl) {
        SysConfig.setTraceLevel(string, bl ? 9 : 0);
    }

    public static boolean getDebug(String string) {
        return SysConfig.getTraceLevel(string) >= 9;
    }

    public static void setTestMode(String string, int n) {
        if (string == null) {
            SysConfig.defPackageConfig.testMode = n;
        } else {
            testModeTable.put(string, new Integer(n));
        }
    }

    public static int getTestMode(String string) {
        if (string == null) {
            return SysConfig.defPackageConfig.testMode;
        }
        Integer n = (Integer)testModeTable.get(string);
        return n == null ? 0 : n;
    }

    public static String getConfigValue(Properties properties, String string) {
        String string2 = null;
        try {
            string2 = properties.getProperty(string).trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String getConfigValue(Properties properties, String string, String string2) {
        String string3 = string2;
        String string4 = null;
        try {
            string4 = SysConfig.getConfigValue(properties, string);
            if (string4 != null) {
                string3 = string4;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3;
    }

    public static double getConfigValue(Properties properties, String string, double d) {
        double d2 = d;
        String string2 = null;
        try {
            string2 = SysConfig.getConfigValue(properties, string);
            if (string2 != null) {
                d2 = new Double(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d2;
    }

    public static boolean getConfigValue(Properties properties, String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = null;
        try {
            string2 = SysConfig.getConfigValue(properties, string);
            if (string2 != null) {
                bl2 = new Boolean(string2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl2;
    }

    static {
        logger = SysLoggerDefault.create();
        properties = System.getProperties();
        defPackageConfig = new PackageConfig(true, false, 0, 0);
    }

    public static class PackageConfig {
        public boolean checked;
        public boolean threaded;
        public int traceLevel;
        public int testMode;

        private PackageConfig(boolean bl, boolean bl2, int n, int n2) {
            this.checked = bl;
            this.threaded = bl2;
            this.traceLevel = n;
            this.testMode = n2;
        }

        private PackageConfig(String string) {
            this(SysConfig.getChecked(string), SysConfig.getThreaded(string), SysConfig.getTraceLevel(string), SysConfig.getTestMode(string));
        }

        public static PackageConfig create(String string) {
            return new PackageConfig(string);
        }
    }
}

