/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory;

import com.sonicsw.mf.common.IDirectoryAdminService;
import com.sonicsw.mf.common.IDirectoryFileSystemService;
import com.sonicsw.mf.common.config.IAttributeList;
import com.sonicsw.mf.common.config.IAttributeSet;
import com.sonicsw.mf.common.config.IElementIdentity;
import com.sonicsw.mf.common.config.Reference;
import com.sonicsw.mf.common.dirconfig.IDeltaDirElement;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.common.dirconfig.IDirIdentity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class RepairNoStorageReferences {
    public static void repairReferences(IDirectoryFileSystemService ds, String[] exclusionList) throws Exception {
        RepairNoStorageReferences.fixReferences((IDirectoryAdminService)ds, "/", exclusionList);
    }

    public static void repairReferences(IDirectoryFileSystemService ds) throws Exception {
        RepairNoStorageReferences.fixReferences((IDirectoryAdminService)ds, "/", new String[0]);
    }

    public static void repairReferences(IDirectoryFileSystemService ds, String directoryName) throws Exception {
        RepairNoStorageReferences.fixReferences((IDirectoryAdminService)ds, directoryName, new String[0]);
    }

    public static void repairReferences(IDirectoryFileSystemService ds, ArrayList elementNameList) throws Exception {
        for (int i = 0; i < elementNameList.size(); ++i) {
            RepairNoStorageReferences.fixReferences(ds, ds.getFSElement((String)elementNameList.get(i), true));
        }
    }

    private static void fixReferences(IDirectoryAdminService ds, String dirName, String[] exclusionList) throws Exception {
        if (dirName.equals("/_MFSystem")) {
            return;
        }
        for (int i = 0; i < exclusionList.length; ++i) {
            if (dirName.indexOf(exclusionList[i]) == -1) continue;
            return;
        }
        IElementIdentity[] elements = ds.listElements(dirName);
        for (int i = 0; i < elements.length; ++i) {
            IDirElement element = RepairNoStorageReferences.getLogicalElement((IDirectoryFileSystemService)ds, elements[i].getName());
            if (element == null) continue;
            RepairNoStorageReferences.fixReferences((IDirectoryFileSystemService)ds, element);
        }
        IDirIdentity[] directories = ds.listDirectories(dirName);
        for (int i = 0; i < directories.length; ++i) {
            RepairNoStorageReferences.fixReferences(ds, directories[i].getName(), exclusionList);
        }
    }

    private static IDirElement getLogicalElement(IDirectoryFileSystemService ds, String storageName) {
        try {
            return ds.getFSElement(ds.storageToLogical(storageName), true);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void fixReferences(IDirectoryFileSystemService ds, IDirElement element) throws Exception {
        if (RepairNoStorageReferences.fixReferences(element.getAttributes())) {
            ds.updateFSElement((IDeltaDirElement)element.doneUpdate());
        }
    }

    static boolean fixReferences(IAttributeSet attSet) throws Exception {
        boolean needFix = false;
        HashMap map = attSet.getAttributes();
        Set keys = map.keySet();
        Iterator iter = keys.iterator();
        ArrayList<String> targetList = new ArrayList<String>();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = map.get(key);
            if (value instanceof IAttributeSet) {
                if (!RepairNoStorageReferences.fixReferences((IAttributeSet)value)) continue;
                needFix = true;
                continue;
            }
            if (value instanceof IAttributeList) {
                if (!RepairNoStorageReferences.fixReferences((IAttributeList)value)) continue;
                needFix = true;
                continue;
            }
            if (!(value instanceof Reference) || !((Reference)value).getElementName().startsWith("/NO_STORAGE:")) continue;
            targetList.add(key);
        }
        for (int i = 0; i < targetList.size(); ++i) {
            needFix = true;
            String key = (String)targetList.get(i);
            Reference newRef = RepairNoStorageReferences.removeNoStorageLabel((Reference)attSet.getAttribute(key));
            attSet.setReferenceAttribute(key, newRef);
        }
        return needFix;
    }

    private static Reference removeNoStorageLabel(Reference ref) throws Exception {
        String oldRefValue = ref.getElementName();
        return new Reference(oldRefValue.substring("/NO_STORAGE:".length()));
    }

    private static boolean fixReferences(IAttributeList attList) throws Exception {
        int i;
        ArrayList<Integer> targetList = new ArrayList<Integer>();
        boolean needFix = false;
        for (i = 0; i < attList.getCount(); ++i) {
            Object value = attList.getItem(i);
            if (value instanceof IAttributeSet) {
                if (!RepairNoStorageReferences.fixReferences((IAttributeSet)value)) continue;
                needFix = true;
                continue;
            }
            if (value instanceof IAttributeList) {
                if (!RepairNoStorageReferences.fixReferences((IAttributeList)value)) continue;
                needFix = true;
                continue;
            }
            if (!(value instanceof Reference) || !((Reference)value).getElementName().startsWith("/NO_STORAGE:")) continue;
            targetList.add(new Integer(i));
        }
        for (i = 0; i < targetList.size(); ++i) {
            needFix = true;
            int position = (Integer)targetList.get(i);
            Reference newRef = RepairNoStorageReferences.removeNoStorageLabel((Reference)attList.getItem(position));
            attList.setNewReferenceItem(position, newRef);
        }
        return needFix;
    }
}

