/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AllocateAction;
import com.sonicsw.mtstorage.impl.AllocateLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeCreateAction;
import com.sonicsw.mtstorage.impl.BTreeCreateTreeLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeDeleteAction;
import com.sonicsw.mtstorage.impl.BTreeDeleteLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeKeyValuePairAbstractAction;
import com.sonicsw.mtstorage.impl.BTreeKeyValuePairAbstractLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeLifeCycleAbstractAction;
import com.sonicsw.mtstorage.impl.BTreeLifeCycleAbstractLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeNoteInterface;
import com.sonicsw.mtstorage.impl.BTreePutAction;
import com.sonicsw.mtstorage.impl.BTreePutLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeRemoveAction;
import com.sonicsw.mtstorage.impl.BTreeRemoveAnyLogicalNote;
import com.sonicsw.mtstorage.impl.BTreeRemoveLogicalNote;
import com.sonicsw.mtstorage.impl.CreateNote;
import com.sonicsw.mtstorage.impl.DeleteAction;
import com.sonicsw.mtstorage.impl.DeleteBlobNote;
import com.sonicsw.mtstorage.impl.DeleteByAsyncThreadLogicalNote;
import com.sonicsw.mtstorage.impl.DeleteLogicalNote;
import com.sonicsw.mtstorage.impl.DeleteNote;
import com.sonicsw.mtstorage.impl.IAction;
import com.sonicsw.mtstorage.impl.ILogicalNote;
import com.sonicsw.mtstorage.impl.INote;
import com.sonicsw.mtstorage.impl.IObjectsBufferNote;
import com.sonicsw.mtstorage.impl.LogReader;
import com.sonicsw.mtstorage.impl.ReplaceNote;
import com.sonicsw.mtstorage.impl.UpdateAction;
import com.sonicsw.mtstorage.impl.UpdateLogicalNote;
import java.io.IOException;
import java.util.ArrayList;

final class ActionReader {
    private static final int INITIAL_SIZE = 4096;
    private ArrayList m_notes;
    private byte[] m_buffer = new byte[4096];
    private int m_currentBufferIndex;
    private AllocateAction m_allocateAction = new AllocateAction();
    private UpdateAction m_updateAction = new UpdateAction();
    private DeleteAction m_deleteAction = new DeleteAction();
    private BTreePutAction m_BTreePutAction = new BTreePutAction();
    private BTreeRemoveAction m_BTreeRemoveAction = new BTreeRemoveAction();
    private BTreeCreateAction m_BTreeCreateAction = new BTreeCreateAction();
    private BTreeDeleteAction m_BTreeDeleteAction = new BTreeDeleteAction();

    ActionReader() {
    }

    private void ensureBufferCapacity(int amountNeeded) {
        if (amountNeeded > this.m_buffer.length - this.m_currentBufferIndex) {
            int newSize = this.m_buffer.length * 2;
            if (amountNeeded > newSize - this.m_currentBufferIndex) {
                newSize = this.m_currentBufferIndex + amountNeeded;
            }
            byte[] tempBuffer = new byte[newSize];
            if (this.m_currentBufferIndex > 0) {
                System.arraycopy(this.m_buffer, 0, tempBuffer, 0, this.m_currentBufferIndex);
            }
            this.m_buffer = tempBuffer;
        }
    }

    IAction getAction(LogReader logReader, ILogicalNote logicalNote) throws IOException {
        return this.getAction(logReader, logicalNote, false);
    }

    IAction getAction(LogReader logReader, ILogicalNote logicalNote, boolean infoOnly) throws IOException {
        this.m_currentBufferIndex = 0;
        this.m_notes = new ArrayList();
        if (logicalNote.noteStart()) {
            if (!infoOnly) {
                this.readNoteForward(logReader);
            } else {
                this.readNoteInfoOnlyForward(logReader);
            }
        } else {
            this.readNoteBackward(logReader);
        }
        long transID = logicalNote.getTransactionNum();
        if (logicalNote instanceof AllocateLogicalNote) {
            return this.createAllocateAction(transID);
        }
        if (logicalNote instanceof UpdateLogicalNote) {
            return this.createUpdateAction(transID, infoOnly);
        }
        if (logicalNote instanceof DeleteLogicalNote) {
            return this.createDeleteAction(transID, infoOnly, logicalNote instanceof DeleteByAsyncThreadLogicalNote);
        }
        if (logicalNote instanceof BTreePutLogicalNote) {
            return this.createPutAction((BTreePutLogicalNote)logicalNote, this.m_BTreePutAction);
        }
        if (logicalNote instanceof BTreeRemoveLogicalNote || logicalNote instanceof BTreeRemoveAnyLogicalNote) {
            return this.createBTreeKeyValuePairAction((BTreeKeyValuePairAbstractLogicalNote)logicalNote, this.m_BTreeRemoveAction);
        }
        if (logicalNote instanceof BTreeCreateTreeLogicalNote) {
            return this.createBTreeLifeCycleAbstractAction((BTreeLifeCycleAbstractLogicalNote)logicalNote, this.m_BTreeCreateAction);
        }
        if (logicalNote instanceof BTreeDeleteLogicalNote) {
            return this.createBTreeLifeCycleAbstractAction((BTreeLifeCycleAbstractLogicalNote)logicalNote, this.m_BTreeDeleteAction);
        }
        return null;
    }

    private void readNoteForward(LogReader reader) throws IOException {
        INote note;
        while (!((note = reader.getNext()) instanceof ILogicalNote)) {
            if (!(note instanceof IObjectsBufferNote)) continue;
            this.m_notes.add(note);
        }
        return;
    }

    private void readNoteInfoOnlyForward(LogReader reader) throws IOException {
        INote note;
        do {
            if (!((note = reader.getNext()) instanceof ILogicalNote)) continue;
            return;
        } while (!(note instanceof IObjectsBufferNote));
        this.m_notes.add(note);
    }

    private void readNoteBackward(LogReader reader) throws IOException {
        ArrayList<INote> tempList = new ArrayList<INote>();
        while (true) {
            INote note;
            if ((note = reader.getPrev()) instanceof ILogicalNote) {
                for (int i = tempList.size() - 1; i >= 0; --i) {
                    this.m_notes.add(tempList.get(i));
                }
                return;
            }
            if (!(note instanceof IObjectsBufferNote) && !(note instanceof BTreeNoteInterface)) continue;
            tempList.add(note);
        }
    }

    private void addDataChunk(byte[] buffer, int offset, short length) {
        if (length == 0) {
            return;
        }
        this.ensureBufferCapacity(length);
        System.arraycopy(buffer, offset, this.m_buffer, this.m_currentBufferIndex, length);
        this.m_currentBufferIndex += length;
    }

    private AllocateAction createAllocateAction(long transID) {
        CreateNote firstNote = (CreateNote)this.m_notes.get(0);
        this.m_allocateAction.init(transID, firstNote.getDbkey());
        return this.m_allocateAction;
    }

    private DeleteAction createDeleteAction(long transID, boolean infoOnly, boolean deleteByAsyncThread) {
        if (this.m_notes.get(0) instanceof DeleteBlobNote) {
            this.m_deleteAction.init(transID, ((DeleteBlobNote)this.m_notes.get(0)).getDbkey(), deleteByAsyncThread);
            return this.m_deleteAction;
        }
        long dbkey = ((DeleteNote)this.m_notes.get(0)).getDbkey();
        byte pageType = 0;
        int classType = 0;
        long objectLength = 0L;
        for (int i = 0; i < this.m_notes.size() && this.m_notes.get(i) instanceof DeleteNote; ++i) {
            DeleteNote deleteNote = (DeleteNote)this.m_notes.get(i);
            if (deleteNote.m_lead) {
                pageType = deleteNote.m_pageType;
                classType = deleteNote.m_classType;
                objectLength = deleteNote.getObjectLength();
                if (infoOnly) break;
            }
            this.addDataChunk(deleteNote.m_oldValue, deleteNote.m_offset, deleteNote.m_length);
        }
        this.m_deleteAction.init(transID, dbkey, pageType, classType, this.m_buffer, objectLength, deleteByAsyncThread);
        return this.m_deleteAction;
    }

    private UpdateAction createUpdateAction(long transID, boolean infoOnly) {
        if (this.m_notes.get(0) instanceof DeleteNote) {
            this.m_updateAction.init(transID, this.createDeleteAction(transID, infoOnly, false));
            return this.m_updateAction;
        }
        long dbkey = ((ReplaceNote)this.m_notes.get(0)).getDbkey();
        int classType = 0;
        long objectLength = 0L;
        boolean noData = false;
        for (int i = 0; i < this.m_notes.size(); ++i) {
            ReplaceNote replaceNote = (ReplaceNote)this.m_notes.get(i);
            if (replaceNote.m_lead) {
                classType = replaceNote.m_classType;
                objectLength = replaceNote.getObjectOldLength();
                noData = replaceNote.m_noUndoData;
                if (infoOnly) break;
            }
            if (noData) continue;
            this.addDataChunk(replaceNote.m_oldValue, replaceNote.m_oldOffset, replaceNote.m_oldLength);
        }
        this.m_updateAction.init(transID, dbkey, noData, classType, this.m_buffer, objectLength);
        return this.m_updateAction;
    }

    private BTreeKeyValuePairAbstractAction createBTreeKeyValuePairAction(BTreeKeyValuePairAbstractLogicalNote note, BTreeKeyValuePairAbstractAction action) {
        action.init(note.getTransactionNum(), note.getBTreeDbk(), note.getKey(), note.keyOffset(), note.keyLength(), note.getValue(), note.valueOffset(), note.valueLength(), note.getNoAction());
        return action;
    }

    private BTreePutAction createPutAction(BTreePutLogicalNote note, BTreePutAction action) {
        action.init(note.getTransactionNum(), note.getBTreeDbk(), note.getKey(), note.keyOffset(), note.keyLength(), note.getValue(), note.valueOffset(), note.valueLength(), note.hasOldValue(), note.getOldValue(), note.oldValueOffset(), note.oldValueLength(), note.valueExisted());
        return action;
    }

    private BTreeLifeCycleAbstractAction createBTreeLifeCycleAbstractAction(BTreeLifeCycleAbstractLogicalNote note, BTreeLifeCycleAbstractAction action) {
        action.init(note.isUnique(), note.getTransactionNum(), note.getDbk());
        return action;
    }
}

