/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BTreeNoteInterface;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class BTreeInitRootNote
extends AbstractNote
implements BTreeNoteInterface,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 19;
    byte[] m_scratchBuffer = new byte[8];
    long m_pageNum;

    BTreeInitRootNote() {
    }

    public String toString() {
        return this.getClass().getName() + " page " + this.m_pageNum;
    }

    @Override
    public long getPageNum() {
        return this.m_pageNum;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)19);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_pageNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        return 9;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        this.m_pageNum = BitUtil.getLong(buffer, offset);
    }

    void initNote(long pageNum) {
        this.m_pageNum = pageNum;
    }
}

