/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BTreeKeyBuffer;
import com.sonicsw.mtstorage.impl.BTreeNoteInterface;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

abstract class BTreeKeyValueAbstractNote
extends AbstractNote
implements BTreeNoteInterface,
IRedoNoteInfo {
    private static final byte KEY_NULL = 1;
    private static final byte KEY_INIFINITE = 2;
    private static final byte NEW_VALUE_NULL = 4;
    byte[] m_scratchBuffer = new byte[8];
    long m_pageNum;
    byte[] m_keyBuffer;
    int m_keyStart;
    int m_keyLength;
    boolean m_keyNull;
    boolean m_keyInifinite;
    int m_keyOffset;
    byte[] m_newValueBuffer;
    boolean m_newValueNull;
    int m_newValueLength;
    int m_newValueOffset;
    byte[] m_noteBuffer;

    abstract byte getType();

    BTreeKeyValueAbstractNote() {
    }

    byte[] getValue() {
        if (this.m_newValueNull) {
            return null;
        }
        byte[] buffer = new byte[this.m_newValueLength];
        System.arraycopy(this.m_noteBuffer, this.m_newValueOffset, buffer, 0, this.m_newValueLength);
        return buffer;
    }

    BTreeKeyBuffer.BufferKey getKey() {
        return new BTreeKeyBuffer.BufferKey(this.m_noteBuffer, this.m_keyOffset, this.m_keyLength, this.m_keyInifinite, this.m_keyNull);
    }

    public String toString() {
        return this.getClass().getName() + " page " + this.m_pageNum;
    }

    @Override
    public long getPageNum() {
        return this.m_pageNum;
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write(this.getType());
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_pageNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        byte flags = 0;
        if (this.m_keyNull) {
            flags = (byte)(flags | 1);
        }
        if (this.m_keyInifinite) {
            flags = (byte)(flags | 2);
        }
        if (this.m_newValueNull) {
            flags = (byte)(flags | 4);
        }
        writer.write(flags);
        int currentLength = 10;
        if (!this.m_keyNull && !this.m_keyInifinite) {
            BitUtil.putShort(this.m_scratchBuffer, 0, (short)this.m_keyLength);
            writer.write(this.m_scratchBuffer, 0, 2);
            currentLength += 2;
            writer.write(this.m_keyBuffer, this.m_keyStart, this.m_keyLength);
            currentLength += this.m_keyLength;
        }
        if (!this.m_newValueNull) {
            BitUtil.putShort(this.m_scratchBuffer, 0, (short)this.m_newValueLength);
            writer.write(this.m_scratchBuffer, 0, 2);
            currentLength += 2;
            writer.write(this.m_newValueBuffer, 0, this.m_newValueLength);
            currentLength += this.m_newValueLength;
        }
        return currentLength;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        this.m_noteBuffer = buffer;
        int currentOffset = offset;
        this.m_pageNum = BitUtil.getLong(buffer, currentOffset);
        this.m_keyNull = (buffer[currentOffset += 8] & 1) != 0;
        this.m_keyInifinite = (buffer[currentOffset] & 2) != 0;
        this.m_newValueNull = (buffer[currentOffset] & 4) != 0;
        ++currentOffset;
        if (!this.m_keyNull && !this.m_keyInifinite) {
            this.m_keyLength = BitUtil.getShort(buffer, currentOffset);
            this.m_keyOffset = currentOffset += 2;
            currentOffset += this.m_keyLength;
        }
        if (!this.m_newValueNull) {
            this.m_newValueLength = BitUtil.getShort(buffer, currentOffset);
            this.m_newValueOffset = currentOffset += 2;
            currentOffset += this.m_newValueLength;
        }
    }

    void initNote(long pageNum, byte[] keyBuffer, int keyStart, int keyLengthm, boolean keyNull, boolean keyInfinite, byte[] newValue) {
        this.m_pageNum = pageNum;
        this.m_keyBuffer = keyBuffer;
        this.m_keyStart = keyStart;
        this.m_keyLength = keyLengthm;
        this.m_keyNull = keyNull;
        this.m_keyInifinite = keyInfinite;
        this.m_newValueBuffer = newValue;
        this.m_newValueNull = newValue == null;
        this.m_newValueLength = newValue != null ? newValue.length : 0;
    }
}

