/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.ITransactionControl;
import java.io.IOException;

final class TransactionBeginNote
extends AbstractNote
implements ITransactionControl {
    static final byte NOTE_TYPE = 40;
    byte[] m_scratchBuffer = new byte[8];
    long m_transactionNum;

    @Override
    public long getPageNum() {
        return 0L;
    }

    @Override
    public long getTransactionNum() {
        return this.m_transactionNum;
    }

    TransactionBeginNote() {
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)40);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_transactionNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        return 9;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        this.m_transactionNum = BitUtil.getLong(buffer, offset);
    }

    void initNote(long transactionNum) {
        this.m_transactionNum = transactionNum;
    }
}

