/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.util.OSHashSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

class OSHashSetIterator
implements Iterator {
    private OSHashSet theSet;
    private Iterator hashIter;
    private Object currentObject;
    private boolean removed;
    private int modificationTick;

    OSHashSetIterator(OSHashSet set) {
        this.theSet = set;
        this.hashIter = this.theSet.keyIterator();
        this.currentObject = null;
        this.removed = true;
        this.modificationTick = set.getTick();
    }

    @Override
    public boolean hasNext() {
        this.checkStale();
        return this.hashIter.hasNext();
    }

    public Object next() {
        this.checkStale();
        this.removed = false;
        this.currentObject = this.hashIter.next();
        return this.currentObject;
    }

    @Override
    public void remove() {
        this.checkStale();
        if (this.removed) {
            throw new IllegalStateException("OSHashSetIterator.remove");
        }
        this.removed = true;
        this.theSet.remove(this.currentObject);
        this.modificationTick = this.theSet.getTick();
    }

    private void checkStale() {
        if (this.modificationTick != this.theSet.getTick()) {
            throw new ConcurrentModificationException("OSHashSet modified while iterating");
        }
    }
}

