/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.evs.nio;

import com.progress.blackbird.evs.EEvsIOException;
import com.progress.blackbird.evs.EEvsNotOwnerException;
import com.progress.blackbird.evs.EEvsObjectBusyException;
import com.progress.blackbird.evs.EEvsObjectHotException;
import com.progress.blackbird.evs.EEvsTimeoutException;
import com.progress.blackbird.evs.IEvsDispatcher;
import com.progress.blackbird.evs.IEvsDispatcherStatistics;
import com.progress.blackbird.evs.nio.EvsChannelInterestHeap;
import com.progress.blackbird.evs.nio.EvsDispatcherEvent;
import com.progress.blackbird.evs.nio.EvsListHead;
import com.progress.blackbird.evs.nio.EvsObject;
import com.progress.blackbird.evs.nio.EvsPort;
import com.progress.blackbird.evs.nio.EvsScheduler;
import com.progress.blackbird.evs.nio.EvsTimerHeap;
import com.progress.blackbird.sys.SysAtomicInteger;
import com.progress.blackbird.sys.SysConfig;
import com.progress.blackbird.sys.SysStatistics;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Random;

public final class EvsDispatcher
extends EvsObject
implements IEvsDispatcher {
    private static SysAtomicInteger nameIndex = SysAtomicInteger.create(true, 0);
    private final String name;
    private Parameters parameters;
    private Selector selector;
    private EvsScheduler scheduler;
    private EvsTimerHeap timerHeap;
    private EvsChannelInterestHeap interestHeap;
    private volatile EvsListHead readyEventList;
    private EvsListHead expiredTimerEventList;
    private EvsListHead selectedNetworkEventList;
    private volatile Thread owner;
    private volatile boolean inDispatch;
    private boolean inFlowControl;
    private Statistics statistics;
    private int numCriticalNetworkEventsScheduled;
    private Object attachment;

    private EvsDispatcher(String string, boolean bl, Parameters parameters) throws IOException {
        super(bl);
        int n;
        this.trace.updateLevelFromProperty(SysConfig.getProperties(), "bb.evs.nio.dispatcher.trace");
        String string2 = this.name = string == null ? "EVSDispatcher#" + EvsDispatcher.nameIndex.increment().value : new String(string);
        this.parameters = parameters == null ? parameters.create() : (Parameters)parameters.clone();
        Random random = new Random();
        for (n = 0; n < 50; ++n) {
            try {
                this.selector = Selector.open();
                break;
            }
            catch (NullPointerException nullPointerException) {
                if (n == 49) {
                    System.err.println("The workaround for sun bug 6427854 failed");
                    throw nullPointerException;
                }
                try {
                    Thread.sleep(random.nextInt(10) + 1);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        this.scheduler = EvsScheduler.create();
        this.timerHeap = EvsTimerHeap.create();
        this.interestHeap = EvsChannelInterestHeap.create(this.selector);
        this.readyEventList = EvsListHead.create();
        this.expiredTimerEventList = EvsListHead.create();
        this.selectedNetworkEventList = EvsListHead.create();
        this.owner = Thread.currentThread();
        this.statistics = new Statistics(bl);
        n = (int)SysConfig.getConfigValue(SysConfig.getProperties(), "bb.dispatcherStatsInterval", 0.0);
        if (n > 0) {
            this.statistics.startDump(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scheduleReadyNetworkEvents(int n) throws IOException {
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        boolean bl2 = false;
        if (this.interestHeap.getCloseQueueSize() > 0) {
            this.interestHeap.flushCloseQueue();
            bl2 = true;
        }
        if ((n4 = Math.min(n, n3 = this.timerHeap.getMinExpiryTime())) == 0 && (bl2 || this.interestHeap.getSize() > 0)) {
            ++this.statistics.numSelectsNow;
            n2 = this.selector.selectNow();
        } else if (n4 > 0) {
            ++this.statistics.numSelects;
            n2 = this.selector.select(n4 == Integer.MAX_VALUE ? 0L : (long)n4);
        } else {
            n2 = 0;
        }
        if (n2 > 0) {
            Object object;
            Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                EvsDispatcherEvent evsDispatcherEvent;
                object = iterator.next();
                EvsChannelInterestHeap.Interest interest = (EvsChannelInterestHeap.Interest)((SelectionKey)object).attachment();
                if (interest.isAcceptReady()) {
                    evsDispatcherEvent = interest.getAcceptEvent();
                    this.interestHeap.removeInterest(interest.getChannel(), evsDispatcherEvent);
                    this.selectedNetworkEventList.append(evsDispatcherEvent);
                    ++this.statistics.numAcceptReadyEvSchedForDispatch;
                }
                if (interest.isConnectReady()) {
                    evsDispatcherEvent = interest.getConnectEvent();
                    this.interestHeap.removeInterest(interest.getChannel(), evsDispatcherEvent);
                    this.selectedNetworkEventList.append(evsDispatcherEvent);
                    ++this.statistics.numConnectReadyEvSchedForDispatch;
                }
                if (interest.isReadReady()) {
                    evsDispatcherEvent = interest.getReadEvent();
                    this.interestHeap.removeInterest(interest.getChannel(), evsDispatcherEvent);
                    this.selectedNetworkEventList.append(evsDispatcherEvent);
                    ++this.statistics.numReadReadyEvSchedForDispatch;
                }
                if (interest.isWriteReady()) {
                    evsDispatcherEvent = interest.getWriteEvent();
                    this.interestHeap.removeInterest(interest.getChannel(), evsDispatcherEvent);
                    this.selectedNetworkEventList.append(evsDispatcherEvent);
                    ++this.statistics.numWriteReadyEvSchedForDispatch;
                }
                iterator.remove();
            }
            if (this.selectedNetworkEventList.getListSize() > 0) {
                bl = true;
            }
            if (this.threaded) {
                object = this.scheduler;
                synchronized (object) {
                    this.scheduler.addEvents(this.selectedNetworkEventList);
                }
            } else {
                this.scheduler.addEvents(this.selectedNetworkEventList);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean scheduleReadyTimerEvents() {
        EvsDispatcherEvent evsDispatcherEvent;
        while ((evsDispatcherEvent = this.timerHeap.getExpired()) != null) {
            ++this.statistics.numTimerEvSchedForDispatch;
            this.expiredTimerEventList.append(evsDispatcherEvent);
        }
        if (this.expiredTimerEventList.getListSize() > 0) {
            for (evsDispatcherEvent = (EvsDispatcherEvent)this.expiredTimerEventList.getNext(); evsDispatcherEvent != null; evsDispatcherEvent = (EvsDispatcherEvent)evsDispatcherEvent.getNext()) {
                this.timerHeap.addTimer(0, evsDispatcherEvent);
            }
            if (this.threaded) {
                EvsScheduler evsScheduler = this.scheduler;
                synchronized (evsScheduler) {
                    this.scheduler.addEvents(this.expiredTimerEventList);
                }
            } else {
                this.scheduler.addEvents(this.expiredTimerEventList);
            }
            return true;
        }
        return false;
    }

    public static IEvsDispatcher create(String string, boolean bl, Parameters parameters) throws EEvsIOException {
        try {
            return new EvsDispatcher(string, bl, parameters);
        }
        catch (IOException iOException) {
            throw new EEvsIOException("Dispatcher Create", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void scheduleUserEvent(EvsDispatcherEvent evsDispatcherEvent) {
        if (this.checked) {
            if (evsDispatcherEvent == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (0 != evsDispatcherEvent.getClazz()) {
                throw new IllegalArgumentException("Invalid event class");
            }
            if (this != evsDispatcherEvent.getSource()) {
                throw new IllegalArgumentException("Event is not owned by dispatcher");
            }
        }
        ++this.statistics.numUserEvSchedByUser;
        if (this.parameters.tsNonTimerEvents) {
            evsDispatcherEvent.setScheduleTime();
        }
        if (this.threaded) {
            EvsScheduler evsScheduler = this.scheduler;
            synchronized (evsScheduler) {
                while (this.inFlowControl = this.inFlowControl || this.parameters.readyEventCountMAX > 0 && this.scheduler.getSize() >= this.parameters.readyEventCountHWM && Thread.currentThread() != this.owner) {
                    try {
                        ++this.statistics.numUserEvSchedFCWaits;
                        this.scheduler.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.statistics.scheduledEventCount.increment();
                ++this.statistics.numUserEvSchedForDispatch;
                this.scheduler.addEvent(evsDispatcherEvent);
            }
            if (this.inDispatch && Thread.currentThread() != this.owner) {
                ++this.statistics.numSelectWakeups;
                this.selector.wakeup();
            }
        } else {
            this.statistics.scheduledEventCount.increment();
            ++this.statistics.numUserEvSchedForDispatch;
            this.scheduler.addEvent(evsDispatcherEvent);
        }
    }

    final void scheduleTimerEvent(int n, EvsDispatcherEvent evsDispatcherEvent) {
        if (this.checked) {
            if (n < 0) {
                throw new IllegalArgumentException("Interval cannot be negative");
            }
            if (evsDispatcherEvent == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (1 != evsDispatcherEvent.getClazz()) {
                throw new IllegalArgumentException("Invalid event class");
            }
            if (this != evsDispatcherEvent.getSource()) {
                throw new IllegalArgumentException("Event is not owned by dispatcher");
            }
            if (Thread.currentThread() != this.owner) {
                throw new RuntimeException("Calling thread is not dispatcher owner");
            }
        }
        ++this.statistics.numTimerEvSchedByUser;
        this.statistics.scheduledEventCount.increment();
        this.timerHeap.addTimer(n, evsDispatcherEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resetTimerEvent(EvsDispatcherEvent evsDispatcherEvent, long l) {
        if (this.checked) {
            if (Thread.currentThread() != this.owner) {
                throw new RuntimeException("Calling thread is not dispatcher owner");
            }
            if (evsDispatcherEvent == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (1 != evsDispatcherEvent.getClazz()) {
                throw new IllegalArgumentException("Invalid event class");
            }
            if (this != evsDispatcherEvent.getSource()) {
                throw new IllegalArgumentException("Event is not owned by dispatcher");
            }
        }
        if (this.timerHeap.resetTimer(evsDispatcherEvent, l)) {
            if (this.threaded) {
                EvsScheduler evsScheduler = this.scheduler;
                synchronized (evsScheduler) {
                    this.scheduler.removeEvent(evsDispatcherEvent);
                }
            } else {
                this.scheduler.removeEvent(evsDispatcherEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unscheduleTimerEvent(EvsDispatcherEvent evsDispatcherEvent) {
        if (this.checked) {
            if (Thread.currentThread() != this.owner) {
                throw new RuntimeException("Calling thread is not dispatcher owner");
            }
            if (evsDispatcherEvent == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (this != evsDispatcherEvent.getSource()) {
                throw new IllegalArgumentException("Event is not owned by dispatcher");
            }
        }
        if (this.timerHeap.removeTimer(evsDispatcherEvent)) {
            if (this.threaded) {
                EvsScheduler evsScheduler = this.scheduler;
                synchronized (evsScheduler) {
                    this.scheduler.removeEvent(evsDispatcherEvent);
                    this.statistics.scheduledEventCount.decrement();
                }
            } else {
                this.scheduler.removeEvent(evsDispatcherEvent);
                this.statistics.scheduledEventCount.decrement();
            }
        }
    }

    final void scheduleNetworkEvent(SelectableChannel selectableChannel, EvsDispatcherEvent evsDispatcherEvent) {
        if (this.checked) {
            if (selectableChannel == null) {
                throw new IllegalArgumentException("Null channel");
            }
            if (evsDispatcherEvent == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (this != evsDispatcherEvent.getSource()) {
                throw new IllegalArgumentException("Event is not owned by dispatcher");
            }
            if (Thread.currentThread() != this.owner) {
                throw new RuntimeException("Calling thread is not dispatcher owner");
            }
        }
        switch (evsDispatcherEvent.getClazz()) {
            case 2: {
                ++this.statistics.numAcceptReadyEvSchedByUser;
                break;
            }
            case 3: {
                ++this.statistics.numConnectReadyEvSchedByUser;
                break;
            }
            case 4: {
                ++this.statistics.numReadReadyEvSchedByUser;
                break;
            }
            case 5: {
                ++this.statistics.numWriteReadyEvSchedByUser;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid event class");
            }
        }
        if (evsDispatcherEvent.getCritical()) {
            ++this.statistics.numCriticalNetworkEventsScheduled;
        }
        if (this.parameters.tsNonTimerEvents) {
            evsDispatcherEvent.setScheduleTime();
        }
        this.statistics.scheduledEventCount.increment();
        this.interestHeap.addInterest(selectableChannel, evsDispatcherEvent);
        if (evsDispatcherEvent.getCritical()) {
            ++this.numCriticalNetworkEventsScheduled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unscheduleNetworkEvent(SelectableChannel selectableChannel, EvsDispatcherEvent evsDispatcherEvent) {
        if (this.checked) {
            if (Thread.currentThread() != this.owner) {
                throw new RuntimeException("Calling thread is not dispatcher owner");
            }
            if (selectableChannel == null) {
                throw new IllegalArgumentException("Null channel");
            }
            if (evsDispatcherEvent == null) {
                throw new IllegalArgumentException("Null event");
            }
            if (this != evsDispatcherEvent.getSource()) {
                throw new IllegalArgumentException("Event is not owned by dispatcher");
            }
        }
        if (this.interestHeap.removeInterest(selectableChannel, evsDispatcherEvent)) {
            if (this.threaded) {
                EvsScheduler evsScheduler = this.scheduler;
                synchronized (evsScheduler) {
                    this.scheduler.removeEvent(evsDispatcherEvent);
                    this.statistics.scheduledEventCount.decrement();
                }
            } else {
                this.scheduler.removeEvent(evsDispatcherEvent);
                this.statistics.scheduledEventCount.decrement();
            }
        }
    }

    final int getScheduledEventCount() {
        return this.statistics.scheduledEventCount.value;
    }

    final int getReadyEventCount() {
        return this.scheduler.getSize() + this.readyEventList.getListSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean dispatchReadyEvents() {
        EvsDispatcherEvent evsDispatcherEvent;
        if (this.readyEventList.getListSize() == 0) {
            if (this.threaded) {
                EvsScheduler evsScheduler = this.scheduler;
                synchronized (evsScheduler) {
                    this.readyEventList = this.scheduler.getReadyList(this.readyEventList);
                    if (this.inFlowControl && this.scheduler.getSize() <= this.parameters.readyEventCountLWM) {
                        this.inFlowControl = false;
                        ++this.statistics.numUserEvSchedFCNotifies;
                        this.scheduler.notifyAll();
                    }
                }
            } else {
                this.readyEventList = this.scheduler.getReadyList(this.readyEventList);
            }
        }
        int n = 0;
        while ((evsDispatcherEvent = (EvsDispatcherEvent)this.readyEventList.getNext()) != null) {
            EvsPort evsPort;
            evsDispatcherEvent.remove();
            int n2 = evsDispatcherEvent.getClazz();
            if (n2 != 1) {
                this.statistics.scheduledEventCount.decrement();
            }
            if (this.parameters.tsNonTimerEvents || n2 == 1) {
                evsDispatcherEvent.setDispatchTime();
            }
            switch (n2) {
                case 0: {
                    ++this.statistics.numUserEvDispatched;
                    break;
                }
                case 1: {
                    ++this.statistics.numTimerEvDispatched;
                    break;
                }
                case 2: {
                    ++this.statistics.numAcceptReadyEvDispatched;
                    break;
                }
                case 3: {
                    ++this.statistics.numConnectReadyEvDispatched;
                    break;
                }
                case 4: {
                    ++this.statistics.numReadReadyEvDispatched;
                    break;
                }
                case 5: {
                    ++this.statistics.numWriteReadyEvDispatched;
                    break;
                }
                default: {
                    throw new InternalError("Event class not supported!");
                }
            }
            if (evsDispatcherEvent.getCritical() && n2 != 0 && n2 != 1) {
                --this.numCriticalNetworkEventsScheduled;
            }
            if ((evsPort = evsDispatcherEvent.getSink()) != null) {
                evsPort.handleEvent(evsDispatcherEvent);
            }
            ++n;
        }
        return n > 0;
    }

    @Override
    public final boolean isHot() {
        return this.statistics.scheduledEventCount.value > 0;
    }

    @Override
    public final boolean isThreaded() {
        return this.threaded;
    }

    @Override
    public final Thread getOwner() {
        return this.owner;
    }

    @Override
    public final IEvsDispatcherStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public final void setAttachment(Object object) {
        this.attachment = object;
    }

    @Override
    public final Object getAttachment() {
        return this.attachment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void acquire() throws EEvsObjectHotException, EEvsObjectBusyException {
        Thread thread = Thread.currentThread();
        if (this.owner == thread) return;
        if (this.inDispatch) throw new EEvsObjectBusyException();
        if (this.isHot()) throw new EEvsObjectHotException();
        this.owner = thread;
    }

    @Override
    public final void dispatch(int n) throws EEvsTimeoutException, EEvsNotOwnerException {
        block11: {
            if (this.owner == Thread.currentThread()) {
                long l = 0L;
                this.inDispatch = true;
                try {
                    boolean bl;
                    int n2 = n = n < 0 ? Integer.MAX_VALUE : n;
                    do {
                        if (n != Integer.MAX_VALUE) {
                            l = System.currentTimeMillis();
                        }
                        boolean bl2 = !(bl = this.dispatchReadyEvents()) || this.numCriticalNetworkEventsScheduled > 0 ? this.scheduleReadyNetworkEvents(bl ? 0 : n) : false;
                        if (bl2 |= this.scheduleReadyTimerEvents()) {
                            bl |= this.dispatchReadyEvents();
                        }
                        if (bl) break;
                        if (n == Integer.MAX_VALUE) continue;
                        n = (int)((long)n - (System.currentTimeMillis() - l));
                    } while (n > 0);
                    if (!bl) {
                        throw new EEvsTimeoutException();
                    }
                    break block11;
                }
                catch (Exception exception) {
                    if (exception instanceof EEvsTimeoutException) {
                        throw (EEvsTimeoutException)exception;
                    }
                    this.trace.outln("Unhandled exception during dispatch [" + exception + "(" + exception.getMessage() + ")]", -1);
                    throw new RuntimeException(exception);
                }
                finally {
                    this.inDispatch = false;
                }
            }
            throw new EEvsNotOwnerException();
        }
    }

    @Override
    public final void close() throws EEvsNotOwnerException, EEvsIOException {
        if (this.owner == Thread.currentThread()) {
            while (this.dispatchReadyEvents()) {
            }
            try {
                this.selector.close();
            }
            catch (IOException iOException) {
                throw new EEvsIOException("close", iOException);
            }
            finally {
                this.statistics.stopDump();
            }
        } else {
            throw new EEvsNotOwnerException();
        }
    }

    public static class Parameters {
        final int readyEventCountMAX;
        final int readyEventCountLWMPct;
        final int readyEventCountLWM;
        final int readyEventCountHWMPct;
        final int readyEventCountHWM;
        final boolean tsNonTimerEvents;

        private Parameters(int n, int n2, int n3, boolean bl) {
            this.readyEventCountMAX = n;
            if (this.readyEventCountMAX > 0) {
                if (n2 >= n3) {
                    throw new IllegalArgumentException("LWM cannot be greater or equal to the HWM");
                }
                if (n2 < 0 || n2 > 100) {
                    throw new IllegalArgumentException("LWM is a percentage and must be >= 0 and <= 100");
                }
                if (n3 < 0 || n3 > 100) {
                    throw new IllegalArgumentException("HWM is a percentage and must be >= 0 and <= 100");
                }
                this.readyEventCountLWMPct = n2;
                this.readyEventCountLWM = this.readyEventCountLWMPct * this.readyEventCountMAX / 100;
                this.readyEventCountHWMPct = n3;
                this.readyEventCountHWM = this.readyEventCountHWMPct * this.readyEventCountMAX / 100;
            } else {
                this.readyEventCountLWMPct = 0;
                this.readyEventCountLWM = 0;
                this.readyEventCountHWMPct = 0;
                this.readyEventCountHWM = 0;
            }
            this.tsNonTimerEvents = bl;
        }

        public static Parameters create(int n, int n2, int n3, boolean bl) {
            return new Parameters(n, n2, n3, bl);
        }

        public static Parameters create() {
            return new Parameters(0, 0, 0, false);
        }

        public Object clone() {
            return Parameters.create(this.readyEventCountMAX, this.readyEventCountLWMPct, this.readyEventCountHWMPct, this.tsNonTimerEvents);
        }
    }

    private class Statistics
    extends SysStatistics
    implements IEvsDispatcherStatistics {
        private long numUserEvSchedByUserLast;
        private long numUserEvSchedFCWaitsLast;
        private long numUserEvSchedFCNotifiesLast;
        private long numUserEvSchedForDispatchLast;
        private long numUserEvDispatchedLast;
        private long numTimerEvSchedByUserLast;
        private long numTimerEvSchedForDispatchLast;
        private long numTimerEvDispatchedLast;
        private long numAcceptReadyEvSchedByUserLast;
        private long numAcceptReadyEvSchedForDispatchLast;
        private long numAcceptReadyEvDispatchedLast;
        private long numConnectReadyEvSchedByUserLast;
        private long numConnectReadyEvSchedForDispatchLast;
        private long numConnectReadyEvDispatchedLast;
        private long numReadReadyEvSchedByUserLast;
        private long numReadReadyEvSchedForDispatchLast;
        private long numReadReadyEvDispatchedLast;
        private long numWriteReadyEvSchedByUserLast;
        private long numWriteReadyEvSchedForDispatchLast;
        private long numWriteReadyEvDispatchedLast;
        private long numSelectsLast;
        private long numSelectsNowLast;
        private long numSelectWakeupsLast;
        private long numCriticalNetworkEventsScheduledLast;
        SysAtomicInteger scheduledEventCount;
        long numUserEvSchedByUser;
        long numUserEvSchedFCWaits;
        long numUserEvSchedFCNotifies;
        long numUserEvSchedForDispatch;
        long numUserEvDispatched;
        long numTimerEvSchedByUser;
        long numTimerEvSchedForDispatch;
        long numTimerEvDispatched;
        long numAcceptReadyEvSchedByUser;
        long numAcceptReadyEvSchedForDispatch;
        long numAcceptReadyEvDispatched;
        long numConnectReadyEvSchedByUser;
        long numConnectReadyEvSchedForDispatch;
        long numConnectReadyEvDispatched;
        long numReadReadyEvSchedByUser;
        long numReadReadyEvSchedForDispatch;
        long numReadReadyEvDispatched;
        long numWriteReadyEvSchedByUser;
        long numWriteReadyEvSchedForDispatch;
        long numWriteReadyEvDispatched;
        long numSelects;
        long numSelectsNow;
        long numSelectWakeups;
        long numCriticalNetworkEventsScheduled;

        private Statistics(boolean bl) {
            this.scheduledEventCount = SysAtomicInteger.create(bl, 0);
        }

        private void stampLast() {
            this.numUserEvSchedByUserLast = this.numUserEvSchedByUser;
            this.numUserEvSchedFCWaitsLast = this.numUserEvSchedFCWaits;
            this.numUserEvSchedFCNotifiesLast = this.numUserEvSchedFCNotifies;
            this.numUserEvSchedForDispatchLast = this.numUserEvSchedForDispatch;
            this.numUserEvDispatchedLast = this.numUserEvDispatched;
            this.numTimerEvSchedByUserLast = this.numTimerEvSchedByUser;
            this.numTimerEvSchedForDispatchLast = this.numTimerEvSchedForDispatch;
            this.numTimerEvDispatchedLast = this.numTimerEvDispatched;
            this.numAcceptReadyEvSchedByUserLast = this.numAcceptReadyEvSchedByUser;
            this.numAcceptReadyEvSchedForDispatchLast = this.numAcceptReadyEvSchedForDispatch;
            this.numAcceptReadyEvDispatchedLast = this.numAcceptReadyEvDispatched;
            this.numConnectReadyEvSchedByUserLast = this.numConnectReadyEvSchedByUser;
            this.numConnectReadyEvSchedForDispatchLast = this.numConnectReadyEvSchedForDispatch;
            this.numConnectReadyEvDispatchedLast = this.numConnectReadyEvDispatched;
            this.numReadReadyEvSchedByUserLast = this.numReadReadyEvSchedByUser;
            this.numReadReadyEvSchedForDispatchLast = this.numReadReadyEvSchedForDispatch;
            this.numReadReadyEvDispatchedLast = this.numReadReadyEvDispatched;
            this.numWriteReadyEvSchedByUserLast = this.numWriteReadyEvSchedByUser;
            this.numWriteReadyEvSchedForDispatchLast = this.numWriteReadyEvSchedForDispatch;
            this.numWriteReadyEvDispatchedLast = this.numWriteReadyEvDispatched;
            this.numSelectsLast = this.numSelects;
            this.numSelectsNowLast = this.numSelectsNow;
            this.numSelectWakeupsLast = this.numSelectWakeups;
            this.numCriticalNetworkEventsScheduledLast = this.numCriticalNetworkEventsScheduled;
        }

        @Override
        protected final void init() {
            this.stampLast();
        }

        @Override
        protected final void dump() {
            String string = "[" + EvsDispatcher.this.name + " STATS]\n";
            string = string + " UsrEv{";
            string = string + this.numUserEvSchedByUser + "(" + (this.numUserEvSchedByUser - this.numUserEvSchedByUserLast) + ") ";
            string = string + this.numUserEvSchedFCWaits + "(" + (this.numUserEvSchedFCWaits - this.numUserEvSchedFCWaitsLast) + ") ";
            string = string + this.numUserEvSchedFCNotifies + "(" + (this.numUserEvSchedFCNotifies - this.numUserEvSchedFCNotifiesLast) + ") ";
            string = string + this.numUserEvSchedForDispatch + "(" + (this.numUserEvSchedForDispatch - this.numUserEvSchedForDispatchLast) + ") ";
            string = string + this.numUserEvDispatched + "(" + (this.numUserEvDispatched - this.numUserEvDispatchedLast) + ")";
            string = string + "}";
            string = string + " TmrEv{";
            string = string + this.numTimerEvSchedByUser + "(" + (this.numTimerEvSchedByUser - this.numTimerEvSchedByUserLast) + ") ";
            string = string + this.numTimerEvSchedForDispatch + "(" + (this.numTimerEvSchedForDispatch - this.numTimerEvSchedForDispatchLast) + ") ";
            string = string + this.numTimerEvDispatched + "(" + (this.numTimerEvDispatched - this.numTimerEvDispatchedLast) + ")";
            string = string + "}";
            string = string + " AcptRdyEv{";
            string = string + this.numAcceptReadyEvSchedByUser + "(" + (this.numAcceptReadyEvSchedByUser - this.numAcceptReadyEvSchedByUserLast) + ") ";
            string = string + this.numAcceptReadyEvSchedForDispatch + "(" + (this.numAcceptReadyEvSchedForDispatch - this.numAcceptReadyEvSchedForDispatchLast) + ") ";
            string = string + this.numAcceptReadyEvDispatched + "(" + (this.numAcceptReadyEvDispatched - this.numAcceptReadyEvDispatchedLast) + ")";
            string = string + "}";
            string = string + " CnctRdyEv{";
            string = string + this.numConnectReadyEvSchedByUser + "(" + (this.numConnectReadyEvSchedByUser - this.numConnectReadyEvSchedByUserLast) + ") ";
            string = string + this.numConnectReadyEvSchedForDispatch + "(" + (this.numConnectReadyEvSchedForDispatch - this.numConnectReadyEvSchedForDispatchLast) + ") ";
            string = string + this.numConnectReadyEvDispatched + "(" + (this.numConnectReadyEvDispatched - this.numConnectReadyEvDispatchedLast) + ")";
            string = string + "}";
            string = string + " RdRdyEv{";
            string = string + this.numReadReadyEvSchedByUser + "(" + (this.numReadReadyEvSchedByUser - this.numReadReadyEvSchedByUserLast) + ") ";
            string = string + this.numReadReadyEvSchedForDispatch + "(" + (this.numReadReadyEvSchedForDispatch - this.numReadReadyEvSchedForDispatchLast) + ") ";
            string = string + this.numReadReadyEvDispatched + "(" + (this.numReadReadyEvDispatched - this.numReadReadyEvDispatchedLast) + ")";
            string = string + "}";
            string = string + " WrtRdy{";
            string = string + this.numWriteReadyEvSchedByUser + "(" + (this.numWriteReadyEvSchedByUser - this.numWriteReadyEvSchedByUserLast) + ") ";
            string = string + this.numWriteReadyEvSchedForDispatch + "(" + (this.numWriteReadyEvSchedForDispatch - this.numWriteReadyEvSchedForDispatchLast) + ") ";
            string = string + this.numWriteReadyEvDispatched + "(" + (this.numWriteReadyEvDispatched - this.numWriteReadyEvDispatchedLast) + ")";
            string = string + "}";
            string = string + " sel " + this.numSelects + "(" + (this.numSelects - this.numSelectsLast) + ")";
            string = string + " selNow " + this.numSelectsNow + "(" + (this.numSelectsNow - this.numSelectsNowLast) + ")";
            string = string + " selWk " + this.numSelectWakeups + "(" + (this.numSelectWakeups - this.numSelectWakeupsLast) + ")";
            string = string + " critNWEvSched " + this.numCriticalNetworkEventsScheduled + "(" + (this.numCriticalNetworkEventsScheduled - this.numCriticalNetworkEventsScheduledLast) + ")\n";
            EvsDispatcher.this.trace.out(string, -1);
            this.stampLast();
        }
    }
}

