/*
 * Decompiled with CFR 0.152.
 */
package com.odi;

import com.odi.ClassNotRegisteredException;
import com.odi.Field;
import com.odi.IPersistent;
import com.odi.ObjectStoreException;
import com.odi.Persistent;
import com.odi.SchemaException;
import com.odi.imp.ArrayField;
import com.odi.imp.SchemaManager;
import com.odi.imp.Utilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Hashtable;

public abstract class ClassInfo {
    protected Class theClass;
    protected String theClassName;
    protected boolean initialized = false;
    public int fieldNumberOffset = 0;
    private static boolean isIBMJava = System.getProperty("java.vendor").equalsIgnoreCase("IBM Corporation");
    private static boolean isIBMJava2 = isIBMJava && System.getProperty("java.version").compareTo("1.2") >= 0;
    private static boolean isIBMJava5 = isIBMJava && System.getProperty("java.version").compareTo("1.5") >= 0;
    private static boolean fieldsInReverseOrder = isIBMJava2 && !isIBMJava5;
    private static final Hashtable registry = new Hashtable(50);
    private static Hashtable persistentFields = new Hashtable(10);
    private static Hashtable transientFields = new Hashtable(10);
    private static Hashtable indexableFields = new Hashtable(10);
    private static HashMap embeddableFields = new HashMap(10);
    private static final int NOTE_FIELD_PERSISTENT = 1;
    private static final int NOTE_FIELD_TRANSIENT = 2;
    private static final int NOTE_FIELD_INDEXABLE = 3;
    private static final int NOTE_FIELD_EMBEDDED = 4;

    public abstract IPersistent create();

    public abstract Class getClassDescriptor() throws ClassNotFoundException;

    public abstract Field[] getFields();

    public static ClassInfo register(ClassInfo classInfo) {
        if (classInfo == null) {
            Utilities.throwNullArgumentException("ClassInfo", "register", "classInfo");
        }
        if (classInfo.theClassName == null) {
            try {
                classInfo.theClassName = classInfo.getClassDescriptor().getName();
            }
            catch (ClassNotFoundException e) {
                throw new SchemaException(e.getMessage(), e);
            }
        }
        registry.put(classInfo.theClassName, classInfo);
        return classInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void initialize() {
        ClassInfo classInfo = this;
        synchronized (classInfo) {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            this.initializeInternal();
        }
    }

    protected void initializeInternal() {
        try {
            if (this.theClass == null) {
                this.theClass = this.getClassDescriptor();
            }
            if (this.theClassName == null) {
                this.theClassName = this.theClass.getName();
            } else if (!this.theClassName.equals(this.theClass.getName())) {
                throw new SchemaException("Class obtained via getClassDescriptor():" + this.theClass.getName() + " differs from the class name used toregister the class:" + this.theClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new SchemaException(e.getMessage(), e);
        }
        if (this.theClass.isInterface()) {
            return;
        }
        if (this.theClass == Persistent.class) {
            throw new SchemaException("Attempt to register class com.odi.Persistent");
        }
        String superName = this.theClass.getSuperclass().getName();
        if (SchemaManager.isPredefinedSuperClass(superName)) {
            this.fieldNumberOffset = 0;
        } else {
            ClassInfo supClassInfo;
            try {
                supClassInfo = ClassInfo.get(superName);
            }
            catch (ClassNotRegisteredException e) {
                throw new SchemaException("While initializing " + this.theClassName + ": ClassInfo for " + superName + " should have been registered.", e);
            }
            supClassInfo.initialize();
            this.fieldNumberOffset = supClassInfo.fieldNumberOffset + (supClassInfo.getFields() == null ? 0 : supClassInfo.getFields().length);
        }
    }

    public static ClassInfo get(String className) {
        ClassInfo classInfo;
        if (className == null) {
            Utilities.throwNullArgumentException("ClassInfo", "get", "className");
        }
        if ((classInfo = (ClassInfo)registry.get(className)) != null) {
            return classInfo;
        }
        Class theClass = null;
        try {
            theClass = Utilities.findClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            theClass = null;
        }
        classInfo = (ClassInfo)registry.get(className);
        if (classInfo != null) {
            return classInfo;
        }
        return ClassInfo.findAndRegister(className, theClass);
    }

    public static ClassInfo get(Class theClass) {
        String className;
        ClassInfo classInfo;
        if (theClass == null) {
            Utilities.throwNullArgumentException("ClassInfo", "get", "theClass");
        }
        if ((classInfo = (ClassInfo)registry.get(className = theClass.getName())) != null) {
            return classInfo;
        }
        return ClassInfo.findAndRegister(className, theClass);
    }

    private static ClassInfo findAndRegister(String className, Class theClass) {
        if (theClass == null) {
            throw new ClassNotRegisteredException(className);
        }
        String ciName = className + "ClassInfo";
        ClassInfo classInfo = ClassInfo.findClassInfo(ciName, className, theClass.getClassLoader());
        if (classInfo == null) {
            if (theClass.isInterface()) {
                classInfo = new InterfaceInfo(theClass);
            } else if (IPersistent.class.isAssignableFrom(theClass)) {
                classInfo = new DynamicClassInfo(theClass);
            }
        }
        if (classInfo == null) {
            throw new ClassNotRegisteredException(className);
        }
        return ClassInfo.register(classInfo);
    }

    public static ClassInfo getDynamic(String className) {
        return ClassInfo.getDynamic(className, null);
    }

    public static ClassInfo getDynamic(String className, Field[] fields) {
        return new DynamicClassInfo(className, fields);
    }

    public static void remove(String className) {
        if (className == null) {
            Utilities.throwNullArgumentException("ClassInfo", "remove", "className");
        }
        registry.remove(className);
    }

    protected ClassInfo() {
    }

    protected ClassInfo(Class descriptor) {
        this.theClass = descriptor;
    }

    private static ClassInfo findClassInfo(String classInfoClassName, String className, ClassLoader classLoader) {
        Class<?> aClass = null;
        try {
            aClass = Class.forName(classInfoClassName, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (aClass == null) {
            return null;
        }
        if (!ClassInfo.class.isAssignableFrom(aClass)) {
            return null;
        }
        ClassInfo aClassInfo = null;
        try {
            aClassInfo = (ClassInfo)aClass.newInstance();
        }
        catch (InstantiationException ie) {
        }
        catch (IllegalAccessException iace) {
            // empty catch block
        }
        if (aClassInfo == null) {
            return null;
        }
        try {
            Class aClassDescriptor = aClassInfo.getClassDescriptor();
            if (aClassDescriptor.getName().equals(className)) {
                return aClassInfo;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return null;
    }

    public static void noteEmbeddedField(String fieldName) {
        ClassInfo.checkFieldDeclaration(fieldName, 4);
        if (transientFields.get(fieldName) != null) {
            throw new SchemaException("Field: " + fieldName + " was previously declared to be transient via a " + "call to ClassInfo.notePersistentField()");
        }
        embeddableFields.put(fieldName, fieldName);
    }

    public static void noteEmbeddedString(String fieldName, int size) {
        ClassInfo.noteEmbeddedField(fieldName);
        embeddableFields.put(fieldName, new Integer(size));
    }

    public static void notePersistentField(String fieldName) {
        ClassInfo.checkFieldDeclaration(fieldName, 1);
        if (transientFields.get(fieldName) != null) {
            throw new SchemaException("Field: " + fieldName + " was previously declared to be transient via a " + "call to ClassInfo.notePersistentField()");
        }
        persistentFields.put(fieldName, fieldName);
    }

    public static void noteTransientField(String fieldName) {
        ClassInfo.checkFieldDeclaration(fieldName, 2);
        if (persistentFields.get(fieldName) != null) {
            throw new SchemaException("Field: " + fieldName + " was previously declared to be persistent via a " + "call to ClassInfo.notePersistentField()");
        }
        transientFields.put(fieldName, fieldName);
    }

    public static void noteIndexableField(String fieldName) {
        ClassInfo.checkFieldDeclaration(fieldName, 3);
        indexableFields.put(fieldName, fieldName);
    }

    private static void checkFieldDeclaration(String fieldName, int noteType) {
        int cnameEnd = fieldName.lastIndexOf(46);
        if (cnameEnd < 0) {
            throw new IllegalArgumentException("the field name must be fully qualified.");
        }
        String cname = fieldName.substring(0, cnameEnd);
        String fname = fieldName.substring(cnameEnd + 1);
        ClassInfo ci = (ClassInfo)registry.get(cname);
        if (ci != null) {
            Field[] existingFields = ci.getFields();
            int i = 0;
            for (i = 0; i < existingFields.length && !existingFields[i].getName().equals(fieldName); ++i) {
            }
            if (i == existingFields.length) {
                if (noteType != 2) {
                    throw new SchemaException("Field: " + fieldName + " was assumed to be transient when the schema for it was built earlier.");
                }
            } else {
                if (noteType == 2) {
                    throw new SchemaException("Field: " + fieldName + " was assumed to be persistent when the schema for it was built earlier.");
                }
                if (noteType == 3 && !existingFields[i].isIndexable()) {
                    throw new SchemaException("Field: " + fieldName + " was assumed to be non-indexable when the schema for it was built earlier.");
                }
            }
        }
    }

    static class DynamicClassInfo
    extends ClassInfo {
        private Constructor hollowConstructor;
        private Field[] fields;
        private static final Object[] hollowConstructorArguments = new Object[1];

        DynamicClassInfo(Class dclass) {
            super(dclass);
            this.theClassName = dclass.getName();
            this.initialize();
        }

        DynamicClassInfo(String dclassName, Field[] fields) {
            this.theClassName = dclassName;
            this.fields = fields;
        }

        @Override
        protected void initializeInternal() {
            super.initializeInternal();
            if (this.fields == null) {
                this.fields = this.computeFields();
            }
            if ((this.theClass.getModifiers() & 0x400) == 0) {
                try {
                    this.hollowConstructor = this.theClass.getConstructor(ClassInfo.class);
                }
                catch (NoSuchMethodException e) {
                    throw new ClassNotRegisteredException(this.theClass, "The class " + this.theClass + " requires a public constructor which takes a " + " com.odi.ClassInfo argument.");
                }
            }
        }

        private Field computeField(java.lang.reflect.Field jf) {
            Class<?> fieldType = jf.getType();
            String fieldName = jf.getName();
            if (fieldType.isPrimitive()) {
                return new com.odi.imp.Field(fieldName, Field.getPrimFieldTypeEnum(fieldType));
            }
            if (fieldType.isArray()) {
                Class<?> elementType = null;
                int dims = 0;
                for (Class<?> current = fieldType.getComponentType(); current != null; current = current.getComponentType()) {
                    ++dims;
                    elementType = current;
                }
                if (elementType.isPrimitive()) {
                    return new ArrayField(fieldName, Field.getPrimFieldTypeEnum(elementType), dims);
                }
                if (elementType.isInterface()) {
                    return Field.createInterfaceArray(fieldName, elementType.getName(), dims);
                }
                return Field.createClassArray(fieldName, elementType.getName(), dims);
            }
            if (fieldType.isInterface()) {
                return Field.createInterface(fieldName, fieldType.getName());
            }
            if (fieldType == String.class) {
                return Field.createString(fieldName);
            }
            return Field.createClass(fieldName, fieldType.getName());
        }

        private Field[] computeFields() {
            java.lang.reflect.Field[] jfields = this.theClass.getDeclaredFields();
            Field[] fields = new Field[jfields.length];
            int j = 0;
            for (int i = 0; i < jfields.length; ++i) {
                java.lang.reflect.Field jf = jfields[i];
                if ((jf.getModifiers() & 8) != 0) continue;
                String qualifiedFieldName = this.theClassName + '.' + jf.getName();
                if (transientFields.get(qualifiedFieldName) != null || (jf.getModifiers() & 0x80) != 0 && persistentFields.get(qualifiedFieldName) == null) continue;
                fields[j] = this.computeField(jf);
                if (indexableFields.get(qualifiedFieldName) != null) {
                    fields[j].makeIndexable();
                }
                if (embeddableFields.get(qualifiedFieldName) != null) {
                    if (jf.getType() == String.class || jf.getType().isArray()) {
                        Object size = embeddableFields.get(qualifiedFieldName);
                        if (!(size instanceof Integer)) {
                            throw new SchemaException(qualifiedFieldName + " needs a length so it can be embedded");
                        }
                        fields[j].makeEmbedded((Integer)size);
                    } else {
                        fields[j].makeEmbedded();
                    }
                }
                ++j;
            }
            if (!fieldsInReverseOrder && j == fields.length) {
                return fields;
            }
            Field[] retFields = new Field[j];
            if (fieldsInReverseOrder) {
                int k = 0;
                for (int i = j - 1; i >= 0; --i) {
                    retFields[i] = fields[k++];
                }
            } else {
                System.arraycopy(fields, 0, retFields, 0, j);
            }
            return retFields;
        }

        @Override
        public IPersistent create() {
            this.initialize();
            try {
                return (IPersistent)this.hollowConstructor.newInstance(hollowConstructorArguments);
            }
            catch (IllegalAccessException e) {
                throw new ObjectStoreException("Could not access constructor. " + e.getMessage(), e);
            }
            catch (InvocationTargetException e) {
                throw new ObjectStoreException("Could not invoke constructor. " + e.getMessage(), e);
            }
            catch (InstantiationException e) {
                throw new ObjectStoreException("Could not invoke constructor. " + e.getMessage(), e);
            }
            catch (NullPointerException e) {
                if (this.hollowConstructor == null) {
                    throw new ObjectStoreException("Attempt to create an instance of class " + this.theClassName + ", which is an abstract class.");
                }
                throw e;
            }
        }

        @Override
        public Field[] getFields() {
            this.initialize();
            return this.fields;
        }

        @Override
        public Class getClassDescriptor() throws ClassNotFoundException {
            return this.theClass != null ? this.theClass : Class.forName(this.theClassName);
        }
    }

    static class InterfaceInfo
    extends ClassInfo {
        Class iface;

        InterfaceInfo(Class iface) {
            this.iface = iface;
        }

        @Override
        public IPersistent create() {
            return null;
        }

        @Override
        public Class getClassDescriptor() {
            return this.iface;
        }

        @Override
        public Field[] getFields() {
            return null;
        }
    }
}

