/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.FatalInternalException;
import com.odi.util.BTreeIndex;
import com.odi.util.BTreeIterator;
import com.odi.util.CharIterator;
import com.odi.util.IndexIterator;
import com.odi.util.MapKeys;
import java.util.ConcurrentModificationException;

class BTreeIndexIterator
implements IndexIterator {
    private BTreeIndex btreeIndex;
    private BTreeIterator treeIter;
    private byte[] buffer;
    private MapKeys.ByteToCharIterator stringKeyCharIterator;
    private transient int modificationTick;

    BTreeIndexIterator(BTreeIndex index, BTreeIterator btIter, int keySize) {
        this.btreeIndex = index;
        this.treeIter = btIter;
        this.buffer = new byte[keySize];
        this.modificationTick = this.btreeIndex.getModifications();
    }

    @Override
    public boolean hasNext() {
        this.checkTick();
        return this.treeIter.hasNext();
    }

    @Override
    public boolean hasMoreElements() {
        this.checkTick();
        return this.treeIter.hasNext();
    }

    public Object next() {
        this.checkTick();
        return this.treeIter.next();
    }

    public Object nextElement() {
        this.checkTick();
        return this.treeIter.next();
    }

    @Override
    public void remove() {
        this.treeIter.remove();
        this.modificationTick = this.btreeIndex.getModifications();
    }

    @Override
    public Object currentKey() {
        this.checkTick();
        byte[] key = this.treeIter.currentKey(this.buffer);
        return this.btreeIndex.byteArrayToKey(key);
    }

    @Override
    public int compareKey(Object key) {
        this.checkTick();
        byte[] keybuf = this.btreeIndex.keyToByteArray(key, false);
        if (keybuf == null) {
            return -1;
        }
        return this.treeIter.compareKey(keybuf);
    }

    @Override
    public CharIterator currentStringKeyCharIterator() {
        this.checkTick();
        if (this.stringKeyCharIterator == null) {
            if (this.btreeIndex.getKeyType() != 7) {
                throw new FatalInternalException("Index does not have String keys");
            }
            this.stringKeyCharIterator = new MapKeys.ByteToCharIterator(this.treeIter.currentKeyByteIterator());
        } else {
            this.stringKeyCharIterator.reset(this.treeIter.currentKeyByteIterator());
        }
        return this.stringKeyCharIterator;
    }

    @Override
    public Object currentValue() {
        this.checkTick();
        return this.treeIter.currentValue();
    }

    @Override
    public void advance() {
        this.checkTick();
        this.treeIter.advance();
    }

    private void checkTick() {
        if (this.modificationTick != this.btreeIndex.getModifications()) {
            throw new ConcurrentModificationException("BTreeIndex modified while iterating");
        }
    }

    @Override
    public boolean advanceToSubstringMatch(String substring, boolean caseInsensitive) {
        if (this.btreeIndex.getKeyType() != 7) {
            throw new FatalInternalException("cannot be called with non-string keys.");
        }
        this.checkTick();
        return this.treeIter.advanceToSubstringMatch(substring, caseInsensitive);
    }
}

