/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.io.evs;

import com.progress.blackbird.io.evs.IOMultiNetworkConnectionActive;
import com.progress.blackbird.io.evs.IOObject;
import com.progress.blackbird.sys.SysConfig;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;

final class IOMultiNetworkConnectionActiveConnector
extends IOObject
implements Runnable {
    private volatile boolean flgRunning;
    private Thread thread;
    private HashSet registeredMultiConnections = new HashSet();
    private LinkedHashSet scheduleList = new LinkedHashSet();
    private static IOMultiNetworkConnectionActiveConnector instance;

    private IOMultiNetworkConnectionActiveConnector() {
        this.trace.updateLevelFromProperty(SysConfig.getProperties(), "bb.io.multi.trace");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Connector");
            this.thread.setDaemon(true);
            this.thread.start();
            IOMultiNetworkConnectionActiveConnector iOMultiNetworkConnectionActiveConnector = this;
            synchronized (iOMultiNetworkConnectionActiveConnector) {
                while (!this.flgRunning) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    private void stop() {
        if (this.thread != null) {
            this.flgRunning = false;
            this.thread.interrupt();
            while (true) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.thread = null;
        }
    }

    static IOMultiNetworkConnectionActiveConnector getInstance() {
        if (instance == null) {
            instance = new IOMultiNetworkConnectionActiveConnector();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void register(IOMultiNetworkConnectionActive iOMultiNetworkConnectionActive) {
        if (this.trace.debug) {
            this.trace.debugln(iOMultiNetworkConnectionActive + " is registering...");
        }
        HashSet hashSet = this.registeredMultiConnections;
        synchronized (hashSet) {
            if (this.registeredMultiConnections.isEmpty()) {
                this.trace.outln("Starting connector thread...", 4);
                this.start();
            }
            this.registeredMultiConnections.add(iOMultiNetworkConnectionActive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void schedule(IOMultiNetworkConnectionActive iOMultiNetworkConnectionActive, IOMultiNetworkConnectionActive.Connection connection, int n) {
        HashSet hashSet = this.registeredMultiConnections;
        synchronized (hashSet) {
            this.trace.outln("Scheduling reconnect (retry=" + n + " seconds) for " + connection + "...", 4);
            if (this.registeredMultiConnections.contains(iOMultiNetworkConnectionActive)) {
                LinkedHashSet linkedHashSet = this.scheduleList;
                synchronized (linkedHashSet) {
                    this.scheduleList.add(new ScheduleListElement(iOMultiNetworkConnectionActive, connection, n));
                }
            } else {
                throw new InternalError("Request to schedule a reconnect by an unregistsred multi-connection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void suspend(IOMultiNetworkConnectionActive iOMultiNetworkConnectionActive) {
        if (this.trace.debug) {
            this.trace.debugln(iOMultiNetworkConnectionActive + " is suspending...");
        }
        LinkedHashSet linkedHashSet = this.scheduleList;
        synchronized (linkedHashSet) {
            for (ScheduleListElement scheduleListElement : this.scheduleList) {
                if (scheduleListElement.multiConnection != iOMultiNetworkConnectionActive) continue;
                if (this.trace.debug) {
                    this.trace.debugln("Suspending " + scheduleListElement + " in schedule list");
                }
                scheduleListElement.suspended = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void resume(IOMultiNetworkConnectionActive iOMultiNetworkConnectionActive) {
        if (this.trace.debug) {
            this.trace.debugln(iOMultiNetworkConnectionActive + " is resuming...");
        }
        LinkedHashSet linkedHashSet = this.scheduleList;
        synchronized (linkedHashSet) {
            for (ScheduleListElement scheduleListElement : this.scheduleList) {
                if (scheduleListElement.multiConnection != iOMultiNetworkConnectionActive) continue;
                if (this.trace.debug) {
                    this.trace.debugln("Resuming " + scheduleListElement + " in schedule list");
                }
                scheduleListElement.suspended = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregister(IOMultiNetworkConnectionActive iOMultiNetworkConnectionActive) {
        if (this.trace.debug) {
            this.trace.debugln(iOMultiNetworkConnectionActive + " is deregistering...");
        }
        HashSet hashSet = this.registeredMultiConnections;
        synchronized (hashSet) {
            LinkedHashSet linkedHashSet = this.scheduleList;
            synchronized (linkedHashSet) {
                Iterator iterator = this.scheduleList.iterator();
                while (iterator.hasNext()) {
                    ScheduleListElement scheduleListElement = (ScheduleListElement)iterator.next();
                    if (scheduleListElement.multiConnection != iOMultiNetworkConnectionActive) continue;
                    if (this.trace.debug) {
                        this.trace.debugln("Removing " + scheduleListElement + " from schedule list");
                    }
                    iterator.remove();
                }
            }
            if (this.registeredMultiConnections.remove(iOMultiNetworkConnectionActive) && this.registeredMultiConnections.isEmpty()) {
                this.trace.outln("Stopping connector thread...", 4);
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Object object = this;
        synchronized (object) {
            this.flgRunning = true;
            this.notify();
        }
        while (this.flgRunning) {
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
                object = this.scheduleList;
                synchronized (object) {
                    Iterator iterator = this.scheduleList.iterator();
                    while (iterator.hasNext()) {
                        ScheduleListElement scheduleListElement = (ScheduleListElement)iterator.next();
                        if (!scheduleListElement.suspended) {
                            --scheduleListElement.countdown;
                            if (this.trace.debug) {
                                this.trace.debugln("Element " + scheduleListElement + " reconnect countdown=" + scheduleListElement.countdown);
                            }
                            if (scheduleListElement.countdown != 0) continue;
                            try {
                                scheduleListElement.connection.connect();
                                try {
                                    scheduleListElement.multiConnection.add(scheduleListElement.connection.descriptor, scheduleListElement.connection.ioConnection);
                                }
                                catch (Exception exception) {
                                    this.trace.outln("Failed to add connected connection " + scheduleListElement.connection + " to multi-connection " + scheduleListElement.multiConnection + " - [" + exception.getMessage() + "]. Closing connection.", 4);
                                    try {
                                        scheduleListElement.connection.close();
                                    }
                                    catch (Exception exception2) {
                                        this.trace.outln("Failed to close connected connection after failed attempt to add to multi-connection [" + exception2.getMessage() + "]", 2);
                                    }
                                }
                                iterator.remove();
                            }
                            catch (Exception exception) {
                                scheduleListElement.countdown = scheduleListElement.reconnectInterval;
                            }
                            continue;
                        }
                        if (!this.trace.debug) continue;
                        this.trace.debugln("Element " + scheduleListElement + " is suspended. Moving onto next one...");
                    }
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private final class ScheduleListElement {
        final IOMultiNetworkConnectionActive multiConnection;
        final IOMultiNetworkConnectionActive.Connection connection;
        final int reconnectInterval;
        int countdown;
        boolean suspended;

        ScheduleListElement(IOMultiNetworkConnectionActive iOMultiNetworkConnectionActive, IOMultiNetworkConnectionActive.Connection connection, int n) {
            this.multiConnection = iOMultiNetworkConnectionActive;
            this.connection = connection;
            this.reconnectInterval = n;
            this.countdown = n;
            this.suspended = false;
        }

        public final String toString() {
            return this.connection.toString();
        }

        public final boolean equals(Object object) {
            return ((ScheduleListElement)object).connection == this.connection;
        }

        public final int hashCode() {
            return this.connection.hashCode();
        }
    }
}

