/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mf.framework.directory;

import com.sonicsw.mf.common.config.ConfigException;
import com.sonicsw.mf.common.config.impl.EntityName;
import com.sonicsw.mf.common.dirconfig.DirectoryServiceException;
import com.sonicsw.mf.common.dirconfig.IDirElement;
import com.sonicsw.mf.framework.IFrameworkComponentContext;
import com.sonicsw.mf.framework.IPermissionsManager;
import com.sonicsw.mf.framework.directory.DSComponent;
import com.sonicsw.mf.framework.directory.IDirectoryService;
import java.util.HashMap;

public class SharedPermissionChecks {
    private IPermissionsManager m_manager;
    private IDirectoryService m_ds;
    private IFrameworkComponentContext m_context;
    private static String DOMAIN_LOGICAL_NAME = "/_Default";

    public SharedPermissionChecks(IFrameworkComponentContext context, IDirectoryService ds) {
        if (context != null) {
            this.m_manager = context.getPermissionsManager();
        }
        this.m_ds = ds;
        this.m_context = context;
    }

    public void updateFSElementCheck(String elementName) throws DirectoryServiceException {
        if (elementName.equals(DOMAIN_LOGICAL_NAME)) {
            this.configurePermissionCheck(DSComponent.MF_DIR_SEPARATOR_STRING, false, 4);
        } else {
            this.configurePermissionWriteCheck(elementName);
        }
    }

    public void setMetaAttributesCheck(String path) throws DirectoryServiceException {
        String parentPath = "";
        try {
            EntityName eName = new EntityName(path);
            parentPath = eName.getParent();
            parentPath = this.appendSeparator(parentPath);
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Unable to check permissions for path " + path + ": " + e.toString());
        }
        this.configurePermissionWriteCheck(parentPath);
    }

    public void createFSElementsCheck(IDirElement[] elements) throws DirectoryServiceException {
        for (int i = 0; i < elements.length; ++i) {
            EntityName elEName;
            String elName = elements[i].getIdentity().getName();
            try {
                elEName = new EntityName(elName);
            }
            catch (Exception e) {
                throw new DirectoryServiceException("Unable to check permissions while creating elements: " + e.toString());
            }
            String parentFolder = elEName.getParent();
            if (elName.endsWith("_Default") || elName.endsWith("_MFDomainDescriptor") || elName.endsWith("_MQPolicyDescriptor")) {
                try {
                    EntityName parentEName = new EntityName(parentFolder);
                    parentFolder = parentEName.getParent();
                }
                catch (Exception e) {
                    throw new DirectoryServiceException("Unable to check permissions while creating elements: " + e.toString());
                }
            }
            this.checkParentFolderSlash(parentFolder);
        }
    }

    public void createFolderCheck(String folderPath, boolean existingOk) throws DirectoryServiceException {
        EntityName folderPathEName = null;
        HashMap test = this.m_ds.getMetaAttributes(folderPath);
        if (test != null && existingOk) {
            String folderName = folderPath;
            folderName = this.appendSeparator(folderName);
            this.configurePermissionReadCheck(folderName);
        } else {
            String parentFolder = "";
            try {
                folderPathEName = new EntityName(folderPath);
                parentFolder = folderPathEName.getParent();
            }
            catch (ConfigException e) {
                throw new DirectoryServiceException("Error while checking permissions to createFolder: " + e.toString());
            }
            this.checkParentFolderSlash(parentFolder);
        }
    }

    private String appendSeparator(String folderNameParam) {
        String folderName = folderNameParam;
        if (!folderName.endsWith(DSComponent.MF_DIR_SEPARATOR_STRING)) {
            folderName = folderName + DSComponent.MF_DIR_SEPARATOR_STRING;
        }
        return folderName;
    }

    private void checkParentFolderSlash(String parentFolderParam) throws DirectoryServiceException {
        String parentFolder = parentFolderParam;
        parentFolder = this.addDirSeparator(parentFolder);
        this.configurePermissionWriteCheck(parentFolder);
    }

    public void deleteFolderCheck(String folderPath) throws DirectoryServiceException {
        String checkFolder = folderPath.endsWith("/") ? folderPath : folderPath + '/';
        String hierarchicalPath = this.m_ds.getHierarchicalPath(folderPath);
        if (hierarchicalPath != null) {
            if (hierarchicalPath.equals(folderPath)) {
                this.configurePermissionDeleteCheck(hierarchicalPath);
            } else {
                this.configurePermissionWriteCheck(hierarchicalPath);
            }
        } else {
            this.configurePermissionDeleteCheck(checkFolder);
        }
    }

    public void attachFSBlobCheck(String blobName) throws DirectoryServiceException {
        this.configurePermissionWriteCheck(blobName);
    }

    public void appendFSBlobCheck(String blobName) throws DirectoryServiceException {
        this.configurePermissionWriteCheck(blobName);
    }

    public void subclassFSElementCheck(String superClassName, String newElementName) throws DirectoryServiceException {
        EntityName newEName;
        this.configurePermissionReadCheck(superClassName);
        try {
            newEName = new EntityName(newElementName);
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Unable to check permissions while subclassing " + superClassName + e.toString());
        }
        this.checkParentSlash(newEName);
    }

    public void cloneFSElementCheck(String elementPath, String newElementPath) throws DirectoryServiceException {
        EntityName newEName;
        this.configurePermissionReadCheck(elementPath);
        try {
            newEName = new EntityName(newElementPath);
        }
        catch (Exception e) {
            throw new DirectoryServiceException("Unable to check permissions while cloning " + elementPath + e.toString());
        }
        this.checkParentSlash(newEName);
    }

    private void checkParentSlash(EntityName newEName) throws DirectoryServiceException {
        String parent = this.retrieveOldParent(newEName);
        this.configurePermissionWriteCheck(parent);
    }

    public void deleteFSElementCheck(String elementName) throws DirectoryServiceException {
        String hierarchicalPath = this.m_ds.getHierarchicalPath(elementName);
        if (hierarchicalPath != null && !this.m_ds.isHierarchicalPath(elementName)) {
            this.configurePermissionWriteCheck(hierarchicalPath);
        } else {
            this.configurePermissionDeleteCheck(elementName);
        }
    }

    public void renameCheck(String oldName, String newName) throws DirectoryServiceException {
        EntityName newEName;
        EntityName oldEName;
        if (oldName.equals(newName)) {
            return;
        }
        try {
            oldEName = new EntityName(oldName);
            newEName = new EntityName(newName);
        }
        catch (ConfigException e) {
            throw new DirectoryServiceException(e.toString());
        }
        String oldParent = this.retrieveOldParent(oldEName);
        this.configurePermissionWriteCheck(newEName, oldEName, oldName, oldParent);
    }

    private void configurePermissionWriteCheck(EntityName newEName, EntityName oldEName, String oldName, String oldParent) throws DirectoryServiceException {
        String newParent = this.retrieveOldParent(newEName);
        this.configurePermissionWriteCheck(oldParent);
        this.configurePermissionWriteCheck(newParent);
        String oldLeaf = oldEName.getBaseName();
        String newLeaf = newEName.getBaseName();
        if (!oldLeaf.equals(newLeaf)) {
            String hierarchicalPath;
            int type = this.m_ds.getNameSpaceType(oldName);
            if (type == 3) {
                this.configurePermissionWriteCheck(oldName);
            } else if (type == 1 && (hierarchicalPath = this.m_ds.getHierarchicalPath(oldName)) != null && hierarchicalPath.equals(oldName)) {
                this.configurePermissionWriteCheck(oldName);
            }
        }
    }

    private String retrieveOldParent(EntityName oldEName) {
        String oldParent = oldEName.getParent();
        oldParent = this.addDirSeparator(oldParent);
        return oldParent;
    }

    private String addDirSeparator(String oldParentParam) {
        String oldParent = oldParentParam;
        if (!oldParent.equals("/")) {
            oldParent = oldParent + '/';
        }
        return oldParent;
    }

    public void detachFSBlobCheck(String blobName) throws DirectoryServiceException {
        this.configurePermissionDeleteCheck(blobName);
    }

    public void configurePermissionReadCheck(String path) throws DirectoryServiceException {
        this.configurePermissionCheck(path, true, 1);
    }

    public void configurePermissionWriteCheck(String path) throws DirectoryServiceException {
        this.configurePermissionCheck(path, true, 4);
    }

    public void configurePermissionDeleteCheck(String path) throws DirectoryServiceException {
        this.configurePermissionCheck(path, true, 16);
    }

    public void configurePermissionCheck(String path, boolean isLogical, int permission) throws DirectoryServiceException {
        if (this.isPermissionsCheckingEnabled()) {
            this.m_manager.configurePermissionCheck(this.m_context, this.m_ds.getPermissionsPath(path), isLogical, permission);
        }
    }

    public boolean isPermissionsCheckingEnabled() {
        return this.m_manager != null && this.m_manager.isPermissionsCheckingEnabled();
    }
}

