/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.BTreeValueNotFoundException;
import com.sonicsw.mtstorage.impl.BTree;
import com.sonicsw.mtstorage.impl.BTreeAbstractBufferSupply;
import com.sonicsw.mtstorage.impl.BTreeIteratorState;
import com.sonicsw.mtstorage.impl.Logger;
import java.io.IOException;
import java.util.ArrayList;

final class BTreeSecondary {
    private static final int NO_OPERATION = 0;
    private static final int CREATE_OPERATION = 1;
    private static final int DELETE_OPERATION = 2;
    private static final int ADD_OPERATION = 3;
    private static final int REMOVE_OPERATION = 4;
    private BTreeAbstractBufferSupply m_bufferSupply;
    private Logger m_logger;
    private long m_transactionNum;
    private int m_operation;
    private Status m_status;
    private long m_inputTreeDBK;
    private int m_inputEntryPosition;
    private byte[] m_inputValue;
    private ArrayList m_inputValues;

    public void UNIT_TEST() throws IOException {
        byte[] val1 = new byte[8];
        val1[0] = 1;
        byte[] val2 = new byte[8];
        val2[0] = 2;
        ArrayList<byte[]> values = new ArrayList<byte[]>();
        values.add(val1);
        values.add(val2);
        this.create(values, 0);
        Status stat = this.exec();
        System.out.println("Created status " + stat);
        long treeDBK = stat.m_treeDBK;
        val1 = new byte[8];
        val1[0] = 1;
        System.out.println("Contains value 1 " + this.contains(treeDBK, val1));
        System.out.println("Contains value null " + this.contains(treeDBK, null));
        val1 = new byte[8];
        val1[0] = 4;
        this.add(treeDBK, val1);
        stat = this.exec();
        System.out.println("Added status " + stat);
        System.out.println("Contains value 4 " + this.contains(treeDBK, val1));
        val1[0] = 2;
        System.out.println("Next after 2 " + this.next(treeDBK, val1)[0]);
        val1[0] = 4;
        System.out.println("Prev before 4 " + this.prev(treeDBK, val1)[0]);
        val1[0] = 2;
        System.out.println("Prev before 2 " + this.prev(treeDBK, val1)[0]);
        System.out.println("first " + this.first(treeDBK)[0]);
        System.out.println("last " + this.last(treeDBK)[0]);
        this.delete(treeDBK);
        stat = this.exec();
        System.out.println("DELETED TREE " + stat);
        System.exit(0);
    }

    BTreeSecondary(BTreeAbstractBufferSupply bufferSupply, Logger logger) {
        this.m_bufferSupply = bufferSupply;
        this.m_logger = logger;
        this.m_operation = 0;
        this.m_status = new Status();
    }

    void setTransNum(long transactionNum) {
        this.m_transactionNum = transactionNum;
    }

    long getTransNum() {
        return this.m_transactionNum;
    }

    BTreeAbstractBufferSupply getBufferSupply() {
        return this.m_bufferSupply;
    }

    Logger getLogger() {
        return this.m_logger;
    }

    void create(ArrayList values, int inputEntryPosition) {
        if (this.m_operation != 0) {
            throw new Error("BTreeSecondary: Pending request was not executed");
        }
        this.m_operation = 1;
        this.m_inputValues = values;
        this.m_inputEntryPosition = inputEntryPosition;
    }

    void delete(long treeDBK) {
        if (this.m_operation != 0) {
            throw new Error("BTreeSecondary: Pending request was not executed");
        }
        this.m_operation = 2;
        this.m_inputTreeDBK = treeDBK;
    }

    void add(long treeDBK, byte[] value) {
        if (this.m_operation != 0) {
            throw new Error("BTreeSecondary: Pending request was not executed");
        }
        this.m_operation = 3;
        this.m_inputTreeDBK = treeDBK;
        this.m_inputValue = value;
    }

    void remove(long treeDBK, byte[] value) {
        if (this.m_operation != 0) {
            throw new Error("BTreeSecondary: Pending request was not executed");
        }
        this.m_operation = 4;
        this.m_inputTreeDBK = treeDBK;
        this.m_inputValue = value;
    }

    Status exec() throws IOException {
        this.m_status.m_treeCreated = false;
        this.m_status.m_treeModified = false;
        try {
            switch (this.m_operation) {
                case 0: {
                    Status status = null;
                    return status;
                }
                case 1: {
                    Status status = this.doCreate();
                    return status;
                }
                case 2: {
                    Status status = this.doDelete();
                    return status;
                }
                case 3: {
                    Status status = this.doAdd();
                    return status;
                }
                case 4: {
                    Status status = this.doRemove();
                    return status;
                }
            }
            throw new Error("Unknown operation " + this.m_operation);
        }
        finally {
            this.m_operation = 0;
        }
    }

    private Status doCreate() throws IOException {
        BTree tree = new BTree(this.m_logger, null, true, this.m_bufferSupply, this.m_transactionNum, 0L);
        int sz = this.m_inputValues.size();
        for (int i = 0; i < sz; ++i) {
            tree.put((byte[])this.m_inputValues.get(i), null, this.m_transactionNum, null);
        }
        this.m_status.m_treeDBK = tree.getTreeDbk();
        this.m_status.m_treeCreated = true;
        return this.m_status;
    }

    int getEntryPosition() {
        return this.m_inputEntryPosition;
    }

    private Status doDelete() throws IOException {
        BTree tree = new BTree(this.m_logger, null, this.m_inputTreeDBK, this.m_bufferSupply);
        tree.delete(this.m_transactionNum);
        this.m_status.m_treeModified = true;
        return this.m_status;
    }

    private Status doAdd() throws IOException {
        BTree tree = new BTree(this.m_logger, null, this.m_inputTreeDBK, this.m_bufferSupply);
        ArrayList allreadyExists = new ArrayList();
        tree.put(this.m_inputValue, null, this.m_transactionNum, allreadyExists);
        this.m_status.m_treeModified = allreadyExists.size() == 0;
        return this.m_status;
    }

    private Status doRemove() throws IOException {
        BTree tree = new BTree(this.m_logger, null, this.m_inputTreeDBK, this.m_bufferSupply);
        ArrayList allreadyRemoved = new ArrayList();
        tree.remove(this.m_inputValue, null, this.m_transactionNum, allreadyRemoved);
        this.m_status.m_treeModified = allreadyRemoved.size() == 0;
        return this.m_status;
    }

    byte[] first(long treeDBK) throws IOException {
        BTree tree = new BTree(this.m_logger, null, treeDBK, this.m_bufferSupply);
        return tree.getFirstKey();
    }

    byte[] last(long treeDBK) throws IOException {
        BTree tree = new BTree(this.m_logger, null, treeDBK, this.m_bufferSupply);
        return tree.getLastKey();
    }

    boolean contains(long treeDBK, byte[] value) throws IOException {
        BTree tree = new BTree(this.m_logger, null, treeDBK, this.m_bufferSupply);
        return tree.contains(value, null);
    }

    boolean containsSingleValue(long treeDBK) throws IOException {
        BTree tree = new BTree(this.m_logger, null, treeDBK, this.m_bufferSupply);
        BTreeIteratorState iterator = new BTreeIteratorState(treeDBK, false);
        tree.advance(iterator);
        if (iterator.getAfterLast()) {
            throw new Error("containsSingleValue: The tree is empty");
        }
        tree.advance(iterator);
        return iterator.getAfterLast();
    }

    byte[] next(long treeDBK, byte[] value) throws IOException {
        return this.nextInternal(treeDBK, value, false);
    }

    byte[] prev(long treeDBK, byte[] value) throws IOException {
        return this.nextInternal(treeDBK, value, true);
    }

    byte[] nextInternal(long treeDBK, byte[] value, boolean reverse) throws IOException {
        BTree tree = new BTree(this.m_logger, null, treeDBK, this.m_bufferSupply);
        BTreeIteratorState iterator = new BTreeIteratorState(treeDBK, value, null, reverse);
        tree.advance(iterator);
        if (iterator.getAfterLast()) {
            throw new BTreeValueNotFoundException();
        }
        return iterator.getCurrentKey();
    }

    static class Status {
        long m_treeDBK;
        boolean m_treeModified;
        boolean m_treeCreated;

        Status() {
        }

        public String toString() {
            return " treeDBK " + this.m_treeDBK + " treeModified " + this.m_treeModified + " treeCreated " + this.m_treeCreated;
        }
    }
}

