/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.Dbkey;
import com.sonicsw.mtstorage.impl.INoteWriter;
import com.sonicsw.mtstorage.impl.IObjectsBufferNote;
import com.sonicsw.mtstorage.impl.IRedoNoteInfo;
import java.io.IOException;

final class NextFragmentNote
extends AbstractNote
implements IObjectsBufferNote,
IRedoNoteInfo {
    static final byte NOTE_TYPE = 11;
    byte[] m_scratchBuffer = new byte[8];
    long m_dbkey;
    long m_nextFragmentDbk;

    NextFragmentNote() {
    }

    public String toString() {
        return this.getClass().getName() + " dbk " + this.m_dbkey;
    }

    @Override
    public long getDbkey() {
        return this.m_dbkey;
    }

    @Override
    public long getPageNum() {
        return Dbkey.getPageNumber(this.m_dbkey);
    }

    @Override
    public byte getSlotNum() {
        return Dbkey.getSlot(this.m_dbkey);
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write((byte)11);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_dbkey);
        writer.write(this.m_scratchBuffer, 0, 8);
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_nextFragmentDbk);
        writer.write(this.m_scratchBuffer, 0, 8);
        return 17;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_dbkey = BitUtil.getLong(buffer, currentOffset);
        this.m_nextFragmentDbk = BitUtil.getLong(buffer, currentOffset += 8);
    }

    void initNote(long dbkey, long nextFragmentDbk) {
        this.m_dbkey = dbkey;
        this.m_nextFragmentDbk = nextFragmentDbk;
    }
}

