/*
 * Decompiled with CFR 0.152.
 */
package jal.BYTE;

import jal.BYTE.BinaryPredicate;
import jal.BYTE.Modification;
import jal.BYTE.Range;

public final class Sorting {
    private static final int partitionCutoff = 13;
    private static final int qsort_stacksize = 56;
    private static final int stableSortCutoff = 9;

    public static void sort(byte[] byArray, int n, int n2) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(byArray, n, n2);
        }
        Sorting.insertion_sort(byArray, n, n2);
    }

    public static void sort(byte[] byArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(byArray, n, n2, binaryPredicate);
        }
        Sorting.insertion_sort(byArray, n, n2, binaryPredicate);
    }

    public static void insertion_sort(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (++n3 < n2) {
            byte by = byArray[n3];
            int n4 = n3;
            byte by2 = byArray[n4 - 1];
            while (by < by2) {
                byArray[n4] = by2;
                if (n == n4 - 1) {
                    --n4;
                    break;
                }
                by2 = byArray[--n4 - 1];
            }
            byArray[n4] = by;
        }
    }

    public static void insertion_sort(byte[] byArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int n3 = n;
        while (++n3 < n2) {
            byte by = byArray[n3];
            int n4 = n3;
            byte by2 = byArray[n4 - 1];
            while (binaryPredicate.apply(by, by2)) {
                byArray[n4] = by2;
                if (n == n4 - 1) {
                    --n4;
                    break;
                }
                by2 = byArray[--n4 - 1];
            }
            byArray[n4] = by;
        }
    }

    private static int quickPartition(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        byte by2 = byArray[n2 - 1];
        byte by3 = byArray[n + (n2 - n) / 2];
        if (by3 < by) {
            if (by < by2) {
                by3 = by;
            } else if (by3 < by2) {
                by3 = by2;
            }
        } else if (by2 < by) {
            by3 = by;
        } else if (by2 < by3) {
            by3 = by2;
        }
        --n;
        while (true) {
            if (byArray[++n] < by3) {
                continue;
            }
            while (by3 < byArray[--n2]) {
            }
            if (n >= n2) {
                return n;
            }
            byte by4 = byArray[n];
            byArray[n] = byArray[n2];
            byArray[n2] = by4;
        }
    }

    private static int quickPartition(byte[] byArray, int n, int n2, BinaryPredicate binaryPredicate) {
        byte by = byArray[n];
        byte by2 = byArray[n2 - 1];
        byte by3 = byArray[n + (n2 - n) / 2];
        if (binaryPredicate.apply(by3, by)) {
            if (binaryPredicate.apply(by, by2)) {
                by3 = by;
            } else if (binaryPredicate.apply(by3, by2)) {
                by3 = by2;
            }
        } else if (binaryPredicate.apply(by2, by)) {
            by3 = by;
        } else if (binaryPredicate.apply(by2, by3)) {
            by3 = by2;
        }
        --n;
        while (true) {
            if (binaryPredicate.apply(byArray[++n], by3)) {
                continue;
            }
            while (binaryPredicate.apply(by3, byArray[--n2])) {
            }
            if (n >= n2) {
                return n;
            }
            byte by4 = byArray[n];
            byArray[n] = byArray[n2];
            byArray[n2] = by4;
        }
    }

    private static void qsortLoop(byte[] byArray, int n, int n2) {
        int[] nArray = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(byArray, n, n2)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray[--n3];
                    n = nArray[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray[n3++] = n4;
                nArray[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray[n3++] = n;
            nArray[n3++] = n4;
            n = n4;
        }
    }

    private static void qsortLoop(byte[] byArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int[] nArray = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(byArray, n, n2, binaryPredicate)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray[--n3];
                    n = nArray[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray[n3++] = n4;
                nArray[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray[n3++] = n;
            nArray[n3++] = n4;
            n = n4;
        }
    }

    public static void stable_sort(byte[] byArray, int n, int n2) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(byArray, n, n2);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(byArray, n, n3);
            Sorting.stable_sort(byArray, n3, n2);
            Sorting.inplace_merge(byArray, n, n3, n2);
        }
    }

    public static void stable_sort(byte[] byArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(byArray, n, n2, binaryPredicate);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(byArray, n, n3, binaryPredicate);
            Sorting.stable_sort(byArray, n3, n2, binaryPredicate);
            Sorting.inplace_merge(byArray, n, n3, n2, binaryPredicate);
        }
    }

    public static void partial_sort(byte[] byArray, int n, int n2, int n3) {
        Sorting.make_heap(byArray, n, n2);
        int n4 = n2;
        while (n4 < n3) {
            if (byArray[n4] < byArray[n]) {
                byte by = byArray[n4];
                byArray[n4] = byArray[n];
                byArray[n] = by;
                Sorting.adjust_heap(byArray, n, n, n2);
            }
            ++n4;
        }
        Sorting.sort_heap(byArray, n, n2);
    }

    public static void partial_sort(byte[] byArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        Sorting.make_heap(byArray, n, n2, binaryPredicate);
        int n4 = n2;
        while (n4 < n3) {
            if (binaryPredicate.apply(byArray[n4], byArray[n])) {
                byte by = byArray[n4];
                byArray[n4] = byArray[n];
                byArray[n] = by;
                Sorting.adjust_heap(byArray, n, n, n2, binaryPredicate);
            }
            ++n4;
        }
        Sorting.sort_heap(byArray, n, n2, binaryPredicate);
    }

    public static int partial_sort_copy(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(byArray, byArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(byArray2, n3, n4);
        n += n5;
        while (n < n2) {
            if (byArray[n] < byArray2[n3]) {
                byArray2[n3] = byArray[n];
                Sorting.adjust_heap(byArray2, n3, n3, n4);
            }
            ++n;
        }
        Sorting.sort_heap(byArray2, n3, n4);
        return n4;
    }

    public static int partial_sort_copy(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(byArray, byArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(byArray2, n3, n4, binaryPredicate);
        n += n5;
        while (n < n2) {
            if (binaryPredicate.apply(byArray[n], byArray2[n3])) {
                byArray2[n3] = byArray[n];
                Sorting.adjust_heap(byArray2, n3, n3, n4, binaryPredicate);
            }
            ++n;
        }
        Sorting.sort_heap(byArray2, n3, n4, binaryPredicate);
        return n4;
    }

    public static void nth_element(byte[] byArray, int n, int n2, int n3) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(byArray, n, n3);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(byArray, n, n3);
    }

    public static void nth_element(byte[] byArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(byArray, n, n3, binaryPredicate);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(byArray, n, n3, binaryPredicate);
    }

    public static int lower_bound(byte[] byArray, int n, int n2, byte by) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (byArray[n5] < by) {
                n = n5 + 1;
                n3 -= n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n;
    }

    public static int lower_bound(byte[] byArray, int n, int n2, byte by, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(byArray[n5], by)) {
                n = n5 + 1;
                n3 -= n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n;
    }

    public static int upper_bound(byte[] byArray, int n, int n2, byte by) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (by < byArray[n5]) {
                n3 = n4;
                continue;
            }
            n = n5 + 1;
            n3 -= n4 + 1;
        }
        return n;
    }

    public static int upper_bound(byte[] byArray, int n, int n2, byte by, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(by, byArray[n5])) {
                n3 = n4;
                continue;
            }
            n = n5 + 1;
            n3 -= n4 + 1;
        }
        return n;
    }

    public static Range equal_range(byte[] byArray, int n, int n2, byte by) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (byArray[n5] < by) {
                n = n5 + 1;
                n3 = n3 - n4 + 1;
                continue;
            }
            if (by < byArray[n5]) {
                n3 = n4;
                continue;
            }
            int n6 = Sorting.lower_bound(byArray, n, n5, by);
            int n7 = Sorting.upper_bound(byArray, n5 + 1, n + n3, by);
            return new Range(byArray, n6, n7);
        }
        return new Range(byArray, n, n);
    }

    public static Range equal_range(byte[] byArray, int n, int n2, byte by, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(byArray[n5], by)) {
                n = n5 + 1;
                n3 = n3 - n4 + 1;
                continue;
            }
            if (binaryPredicate.apply(by, byArray[n5])) {
                n3 = n4;
                continue;
            }
            int n6 = Sorting.lower_bound(byArray, n, n5, by, binaryPredicate);
            int n7 = Sorting.upper_bound(byArray, n5 + 1, n + n3, by, binaryPredicate);
            return new Range(byArray, n6, n7);
        }
        return new Range(byArray, n, n);
    }

    public static boolean binary_search(byte[] byArray, int n, int n2, byte by) {
        int n3 = Sorting.lower_bound(byArray, n, n2, by);
        return n3 < n2 && by >= byArray[n3];
    }

    public static boolean binary_search(byte[] byArray, int n, int n2, byte by, BinaryPredicate binaryPredicate) {
        int n3 = Sorting.lower_bound(byArray, n, n2, by, binaryPredicate);
        return n3 < n2 && !binaryPredicate.apply(by, byArray[n3]);
    }

    public static int merge(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            byArray3[n5++] = byArray2[n3] < byArray[n] ? byArray2[n3++] : byArray[n++];
        }
        Modification.copy(byArray, byArray3, n, n2, n5);
        Modification.copy(byArray2, byArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int merge(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            byArray3[n5++] = binaryPredicate.apply(byArray2[n3], byArray[n]) ? byArray2[n3++] : byArray[n++];
        }
        Modification.copy(byArray, byArray3, n, n2, n5);
        Modification.copy(byArray2, byArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void inplace_merge(byte[] byArray, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (byArray[n2] < byArray[n]) {
                byte by = byArray[n];
                byArray[n] = byArray[n2];
                byArray[n2] = by;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(byArray, n2, n3, byArray[n5]);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(byArray, n, n2, byArray[n4]);
        }
        Modification.rotate(byArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(byArray, n, n5, n2);
        Sorting.inplace_merge(byArray, n2, n4, n3);
    }

    public static void inplace_merge(byte[] byArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (binaryPredicate.apply(byArray[n2], byArray[n])) {
                byte by = byArray[n];
                byArray[n] = byArray[n2];
                byArray[n2] = by;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(byArray, n2, n3, byArray[n5], binaryPredicate);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(byArray, n, n2, byArray[n4], binaryPredicate);
        }
        Modification.rotate(byArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(byArray, n, n5, n2, binaryPredicate);
        Sorting.inplace_merge(byArray, n2, n4, n3, binaryPredicate);
    }

    public static boolean includes(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (byArray2[n3] < byArray[n]) {
                return false;
            }
            if (byArray[n] < byArray2[n3]) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static boolean includes(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(byArray2[n3], byArray[n])) {
                return false;
            }
            if (binaryPredicate.apply(byArray[n], byArray2[n3])) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static int set_union(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (byArray[n] < byArray2[n3]) {
                byArray3[n5++] = byArray[n++];
                continue;
            }
            if (byArray2[n3] < byArray[n]) {
                byArray3[n5++] = byArray2[n3++];
                continue;
            }
            byArray3[n5++] = byArray[n++];
            ++n3;
        }
        Modification.copy(byArray, byArray3, n, n2, n5);
        Modification.copy(byArray2, byArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_union(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(byArray[n], byArray2[n3])) {
                byArray3[n5++] = byArray[n++];
                continue;
            }
            if (binaryPredicate.apply(byArray2[n3], byArray[n])) {
                byArray3[n5++] = byArray2[n3++];
                continue;
            }
            byArray3[n5++] = byArray[n++];
            ++n3;
        }
        Modification.copy(byArray, byArray3, n, n2, n5);
        Modification.copy(byArray2, byArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_intersection(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (byArray[n] < byArray2[n3]) {
                ++n;
                continue;
            }
            if (byArray2[n3] < byArray[n]) {
                ++n3;
                continue;
            }
            byArray3[n5++] = byArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_intersection(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(byArray[n], byArray2[n3])) {
                ++n;
                continue;
            }
            if (binaryPredicate.apply(byArray2[n3], byArray[n])) {
                ++n3;
                continue;
            }
            byArray3[n5++] = byArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_difference(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (byArray[n] < byArray2[n3]) {
                byArray3[n5++] = byArray[n++];
                continue;
            }
            if (byArray2[n3] < byArray[n]) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(byArray, byArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_difference(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(byArray[n], byArray2[n3])) {
                byArray3[n5++] = byArray[n++];
                continue;
            }
            if (binaryPredicate.apply(byArray2[n3], byArray[n])) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(byArray, byArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_symmetric_difference(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (byArray[n] < byArray2[n3]) {
                byArray3[n5++] = byArray[n++];
                continue;
            }
            if (byArray2[n3] < byArray[n]) {
                byArray3[n5++] = byArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(byArray, byArray3, n, n2, n5);
        Modification.copy(byArray2, byArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_symmetric_difference(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(byArray[n], byArray2[n3])) {
                byArray3[n5++] = byArray[n++];
                continue;
            }
            if (binaryPredicate.apply(byArray2[n3], byArray[n])) {
                byArray3[n5++] = byArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(byArray, byArray3, n, n2, n5);
        Modification.copy(byArray2, byArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void push_heap(byte[] byArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        byte by = byArray[--n2];
        int n3 = n + (n2 - n - 1) / 2;
        while (n2 > n && byArray[n3] < by) {
            byArray[n2] = byArray[n3];
            n2 = n3;
            n3 = n + (n2 - n - 1) / 2;
        }
        byArray[n2] = by;
    }

    public static void push_heap(byte[] byArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        byte by = byArray[--n2];
        int n3 = n + (n2 - n - 1) / 2;
        while (n2 > n && binaryPredicate.apply(byArray[n3], by)) {
            byArray[n2] = byArray[n3];
            n2 = n3;
            n3 = n + (n2 - n - 1) / 2;
        }
        byArray[n2] = by;
    }

    private static void adjust_heap(byte[] byArray, int n, int n2, int n3) {
        byte by = byArray[n2];
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = 2 * n5 + 2;
        while (n6 < n4) {
            if (byArray[n + n6] < byArray[n + (n6 - 1)]) {
                --n6;
            }
            byArray[n + n5] = byArray[n + n6];
            n5 = n6++;
            n6 *= 2;
        }
        if (n6-- == n4) {
            byArray[n + n5] = byArray[n + n6];
            n5 = n6;
        }
        int n7 = (n5 - 1) / 2;
        int n8 = n2 - n;
        while (n5 != n8 && byArray[n + n7] < by) {
            byArray[n + n5] = byArray[n + n7];
            n5 = n7;
            n7 = (n5 - 1) / 2;
        }
        byArray[n + n5] = by;
    }

    private static void adjust_heap(byte[] byArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        byte by = byArray[n2];
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = 2 * n5 + 2;
        while (n6 < n4) {
            if (binaryPredicate.apply(byArray[n + n6], byArray[n + (n6 - 1)])) {
                --n6;
            }
            byArray[n + n5] = byArray[n + n6];
            n5 = n6++;
            n6 *= 2;
        }
        if (n6-- == n4) {
            byArray[n + n5] = byArray[n + n6];
            n5 = n6;
        }
        int n7 = (n5 - 1) / 2;
        int n8 = n2 - n;
        while (n5 != n8 && binaryPredicate.apply(byArray[n + n7], by)) {
            byArray[n + n5] = byArray[n + n7];
            n5 = n7;
            n7 = (n5 - 1) / 2;
        }
        byArray[n + n5] = by;
    }

    public static void pop_heap(byte[] byArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        byte by = byArray[--n2];
        byArray[n2] = byArray[n];
        byArray[n] = by;
        Sorting.adjust_heap(byArray, n, n, n2);
    }

    public static void pop_heap(byte[] byArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        byte by = byArray[--n2];
        byArray[n2] = byArray[n];
        byArray[n] = by;
        Sorting.adjust_heap(byArray, n, n, n2, binaryPredicate);
    }

    public static void make_heap(byte[] byArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(byArray, n, n + n3, n2);
        } while (n3-- != 0);
    }

    public static void make_heap(byte[] byArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(byArray, n, n + n3, n2, binaryPredicate);
        } while (n3-- != 0);
    }

    public static void sort_heap(byte[] byArray, int n, int n2) {
        while (n2 - n > 1) {
            byte by = byArray[--n2];
            byArray[n2] = byArray[n];
            byArray[n] = by;
            Sorting.adjust_heap(byArray, n, n, n2);
        }
    }

    public static void sort_heap(byte[] byArray, int n, int n2, BinaryPredicate binaryPredicate) {
        while (n2 - n > 1) {
            byte by = byArray[--n2];
            byArray[n2] = byArray[n];
            byArray[n] = by;
            Sorting.adjust_heap(byArray, n, n, n2, binaryPredicate);
        }
    }

    public static int max_element(byte[] byArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (byArray[n3] >= byArray[n]) continue;
            n3 = n;
        }
        return n3;
    }

    public static int max_element(byte[] byArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(byArray[n3], byArray[n])) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(byte[] byArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (byArray[n] >= byArray[n3]) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(byte[] byArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(byArray[n], byArray[n3])) continue;
            n3 = n;
        }
        return n3;
    }

    public static boolean lexicographical_compare(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (byArray[n] < byArray2[n3]) {
                return true;
            }
            if (byArray2[n3++] >= byArray[n++]) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean lexicographical_compare(byte[] byArray, byte[] byArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(byArray[n], byArray2[n3])) {
                return true;
            }
            if (!binaryPredicate.apply(byArray2[n3++], byArray[n++])) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean next_permutation(byte[] byArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (byArray[--n3] >= byArray[n4]) continue;
            int n5 = n2;
            while (byArray[n3] >= byArray[--n5]) {
            }
            byte by = byArray[n3];
            byArray[n3] = byArray[n5];
            byArray[n5] = by;
            Modification.reverse(byArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(byArray, n, n2);
        return false;
    }

    public static boolean next_permutation(byte[] byArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(byArray[--n3], byArray[n4])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(byArray[n3], byArray[--n5])) {
            }
            byte by = byArray[n3];
            byArray[n3] = byArray[n5];
            byArray[n5] = by;
            Modification.reverse(byArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(byArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(byte[] byArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (byArray[n4] >= byArray[--n3]) continue;
            int n5 = n2;
            while (byArray[--n5] >= byArray[n3]) {
            }
            byte by = byArray[n3];
            byArray[n3] = byArray[n5];
            byArray[n5] = by;
            Modification.reverse(byArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(byArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(byte[] byArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(byArray[n4], byArray[--n3])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(byArray[--n5], byArray[n3])) {
            }
            byte by = byArray[n3];
            byArray[n3] = byArray[n5];
            byArray[n5] = by;
            Modification.reverse(byArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(byArray, n, n2);
        return false;
    }

    private Sorting() {
    }
}

