/*
 * Decompiled with CFR 0.152.
 */
package com.odi;

import com.odi.Database;
import com.odi.ObjectStoreException;
import com.odi.Session;
import com.odi.Transaction;

public class Snapshot {
    private Database m_db;
    private Session m_session;
    private Transaction m_txn;
    private long m_startTime;
    private int m_numJoinedThreads;
    private static ThreadLocal s_currentSnapshot = new ThreadLocal();

    public Snapshot(String ssName, String dbName) {
        this.m_session = Session.create(null, null, ssName);
        this.m_session.join();
        this.m_db = Database.open(dbName, 3);
        Snapshot snapshot = this;
        snapshot.m_session.leave();
        this.m_txn = null;
        this.m_startTime = 0L;
        this.m_numJoinedThreads = 0;
    }

    public static Snapshot getCurrent() {
        return (Snapshot)s_currentSnapshot.get();
    }

    private static void setCurrent(Snapshot ss) {
        s_currentSnapshot.set(ss);
    }

    public static void leaveCurrent() {
        Snapshot ss = Snapshot.getCurrent();
        if (ss != null) {
            ss.leave();
        }
    }

    public synchronized boolean isActive() {
        return this.m_numJoinedThreads > 0;
    }

    public synchronized Database getDb() {
        return this.m_db;
    }

    public synchronized Object getDbRoot(String rootName) {
        return this.m_db.getRoot(rootName);
    }

    public synchronized Session getSession() {
        return this.m_session;
    }

    public synchronized String getName() {
        return this.m_session.getName();
    }

    public synchronized long getStartTime() {
        return this.m_startTime;
    }

    public synchronized void join() {
        Snapshot ss = Snapshot.getCurrent();
        if (ss == this) {
            return;
        }
        if (ss != null) {
            throw new ObjectStoreException("Already joined to a different Snapshot.");
        }
        this.m_session.join();
        if (this.m_numJoinedThreads == 0) {
            this.m_txn = Transaction.begin(6);
            this.m_startTime = System.currentTimeMillis();
        }
        ++this.m_numJoinedThreads;
        Snapshot.setCurrent(this);
    }

    public synchronized void leave() {
        Snapshot ss = Snapshot.getCurrent();
        if (ss == null) {
            throw new ObjectStoreException("Not joined to any Snapshot.");
        }
        if (ss != this) {
            throw new ObjectStoreException("Not joined to this Snapshot.");
        }
        Snapshot.setCurrent(null);
        --this.m_numJoinedThreads;
        if (this.m_numJoinedThreads == 0) {
            this.m_txn.commit();
            this.m_txn = null;
            this.m_startTime = 0L;
        }
        Snapshot snapshot = this;
        snapshot.m_session.leave();
    }

    public synchronized void terminate() {
        if (this.isActive()) {
            throw new ObjectStoreException("Cannot terminate Snapshot while in use.");
        }
        this.m_session.join();
        this.m_db.close();
        Snapshot snapshot = this;
        snapshot.m_session.leave();
        this.m_session.terminate();
    }
}

