/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter.classfile;

import com.odi.filter.classfile.InsnError;
import com.odi.filter.classfile.VMConstants;
import java.util.Hashtable;
import java.util.Stack;

public class Descriptor
implements VMConstants {
    public static int countMethodArgWords(String sig) {
        if (sig.charAt(0) != '(') {
            throw new InsnError("not a method signature");
        }
        int count = 0;
        int idx = 1;
        while (sig.charAt(idx) != ')') {
            switch (sig.charAt(idx)) {
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++count;
                    break;
                }
                case 'D': 
                case 'J': {
                    count += 2;
                    break;
                }
                case 'L': {
                    ++count;
                    idx = sig.indexOf(59, idx);
                    break;
                }
                case '[': {
                    ++count;
                    while (sig.charAt(idx) == '[' || sig.charAt(idx) == ']') {
                        ++idx;
                    }
                    if (sig.charAt(idx) != 'L') break;
                    idx = sig.indexOf(59, idx);
                    break;
                }
                default: {
                    throw new InsnError("missing case");
                }
            }
            ++idx;
        }
        return count;
    }

    public static int countMethodReturnWords(String sig) {
        int idx = sig.lastIndexOf(41) + 1;
        if (idx == 0) {
            throw new InsnError("not a method signature");
        }
        switch (sig.charAt(idx)) {
            case 'D': 
            case 'J': {
                return 2;
            }
            case 'B': 
            case 'C': 
            case 'F': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                return 1;
            }
            case 'V': {
                return 0;
            }
        }
        throw new InsnError("missing case");
    }

    public static String extractResultSig(String methodSig) {
        return methodSig.substring(methodSig.indexOf(41) + 1);
    }

    public static String extractArgSig(String methodSig) {
        return methodSig.substring(1, methodSig.indexOf(41));
    }

    public static String extractReversedArgSig(String methodSig) {
        StringBuffer buf = new StringBuffer();
        Descriptor.reverseArgSig(buf, methodSig, 1);
        return buf.toString();
    }

    private static void reverseArgSig(StringBuffer buf, String methodSig, int idx) {
        char c = methodSig.charAt(idx);
        if (c == ')') {
            return;
        }
        int startIdx = idx++;
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                break;
            }
            case '[': {
                while (methodSig.charAt(idx) == '[' || methodSig.charAt(idx) == ']') {
                    ++idx;
                }
                if (methodSig.charAt(idx) != 'L') {
                    ++idx;
                    break;
                }
            }
            case 'L': {
                idx = methodSig.indexOf(59, idx) + 1;
                break;
            }
            default: {
                throw new InsnError("bad signature char");
            }
        }
        Descriptor.reverseArgSig(buf, methodSig, idx);
        while (startIdx < idx) {
            buf.append(methodSig.charAt(startIdx++));
        }
    }

    public static String elementSig(int valueType) {
        switch (valueType) {
            case 8: {
                return "B";
            }
            case 5: {
                return "C";
            }
            case 4: {
                return "Z";
            }
            case 9: {
                return "S";
            }
            case 10: {
                return "I";
            }
            case 6: {
                return "F";
            }
            case 11: {
                return "J";
            }
            case 7: {
                return "D";
            }
            case 12: {
                return "Ljava/lang/Object;";
            }
        }
        throw new InsnError("bad element type");
    }

    public static int elementSize(int elementType) {
        switch (elementType) {
            case 7: 
            case 11: 
            case 17: {
                return 2;
            }
        }
        return 1;
    }

    public static void computeStackTypes(String stackSig, Stack stack) {
        for (int idx = 0; idx < stackSig.length(); ++idx) {
            int tp = 0;
            switch (stackSig.charAt(idx)) {
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    tp = 10;
                    break;
                }
                case 'F': {
                    tp = 6;
                    break;
                }
                case 'J': {
                    tp = 11;
                    break;
                }
                case 'D': {
                    tp = 7;
                    break;
                }
                case '?': {
                    tp = 15;
                    break;
                }
                case 'W': {
                    tp = 16;
                    break;
                }
                case 'X': {
                    tp = 17;
                    break;
                }
                case 'A': {
                    tp = 12;
                    break;
                }
                case '[': {
                    tp = 12;
                    while (stackSig.charAt(idx) == '[' || stackSig.charAt(idx) == ']') {
                        ++idx;
                    }
                    if (stackSig.charAt(idx) != 'L') break;
                }
                case 'L': {
                    tp = 12;
                    idx = stackSig.indexOf(59, idx);
                    break;
                }
                default: {
                    throw new InsnError("bad signature char");
                }
            }
            stack.push(new Integer(tp));
        }
    }

    public static int nextSigElement(String stackSig, int idx) {
        switch (stackSig.charAt(idx)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                break;
            }
            case '[': {
                while (stackSig.charAt(idx) == '[' || stackSig.charAt(idx) == ']') {
                    ++idx;
                }
                if (stackSig.charAt(idx) != 'L') break;
            }
            case 'L': {
                idx = stackSig.indexOf(59, idx);
                break;
            }
            default: {
                throw new InsnError("bad signature char");
            }
        }
        return ++idx;
    }

    public static String remapTypes(String sig, Hashtable classTranslations) {
        StringBuffer buf = null;
        for (int idx = 0; idx < sig.length(); ++idx) {
            int c = sig.charAt(idx);
            switch (c) {
                case 91: {
                    while ((c = sig.charAt(idx)) == 91 || c == 93) {
                        ++idx;
                        if (buf == null) continue;
                        buf.append((char)c);
                    }
                    if (sig.charAt(idx) != 'L') break;
                }
                case 76: {
                    int endIdx = sig.indexOf(59, ++idx);
                    String typeName = sig.substring(idx, endIdx);
                    String mapTo = (String)classTranslations.get(typeName);
                    if (mapTo != null) {
                        if (buf == null) {
                            buf = new StringBuffer(sig.length() + 20);
                            buf.append(sig.substring(0, idx - 1));
                        }
                        typeName = mapTo;
                    }
                    if (buf != null) {
                        buf.append('L');
                        buf.append(typeName);
                    }
                    idx = endIdx;
                    c = 59;
                }
            }
            if (buf == null) continue;
            buf.append((char)c);
        }
        return buf == null ? sig : buf.toString();
    }

    public static String translateClass(String cls, Hashtable classTranslations) {
        if (cls.charAt(0) == '[') {
            return Descriptor.remapTypes(cls, classTranslations);
        }
        String mapTo = (String)classTranslations.get(cls);
        if (mapTo != null) {
            return mapTo;
        }
        return cls;
    }

    public static String userFieldSig(String vmSig) {
        return Descriptor.userFieldSig(vmSig, 0);
    }

    public static String userFieldSig(String vmSig, int idx) {
        String sigElement = "";
        int arrayDims = 0;
        boolean moreSig = true;
        block13: while (moreSig) {
            moreSig = false;
            char c = vmSig.charAt(idx);
            switch (c) {
                case 'B': {
                    sigElement = "byte";
                    continue block13;
                }
                case 'C': {
                    sigElement = "char";
                    continue block13;
                }
                case 'Z': {
                    sigElement = "boolean";
                    continue block13;
                }
                case 'S': {
                    sigElement = "short";
                    continue block13;
                }
                case 'I': {
                    sigElement = "int";
                    continue block13;
                }
                case 'F': {
                    sigElement = "float";
                    continue block13;
                }
                case 'J': {
                    sigElement = "long";
                    continue block13;
                }
                case 'D': {
                    sigElement = "double";
                    continue block13;
                }
                case 'V': {
                    sigElement = "void";
                    continue block13;
                }
                case '[': {
                    ++idx;
                    ++arrayDims;
                    moreSig = true;
                    continue block13;
                }
                case 'L': {
                    int nextIdx = vmSig.indexOf(59, idx);
                    sigElement = vmSig.substring(idx + 1, nextIdx).replace('/', '.');
                    continue block13;
                }
            }
            throw new InsnError("bad signature char");
        }
        if (arrayDims == 0) {
            return sigElement;
        }
        StringBuffer buf = new StringBuffer(sigElement.length() + 2 * arrayDims);
        buf.append(sigElement);
        while (arrayDims-- > 0) {
            buf.append("[]");
        }
        return buf.toString();
    }

    public static String userMethodArgs(String methodSig) {
        if (methodSig.charAt(0) != '(') {
            throw new InsnError("Invalid method signature");
        }
        StringBuffer buf = new StringBuffer();
        buf.append('(');
        int idx = 1;
        boolean firstArg = true;
        while (methodSig.charAt(idx) != ')') {
            if (firstArg) {
                firstArg = false;
            } else {
                buf.append(", ");
            }
            buf.append(Descriptor.userFieldSig(methodSig, idx));
            idx = Descriptor.nextSigElement(methodSig, idx);
        }
        buf.append(')');
        return buf.toString();
    }
}

