/*
 * Decompiled with CFR 0.152.
 */
package com.odi.filter.classfile;

import com.odi.filter.classfile.ClassPrint;
import com.odi.filter.classfile.CodeEnv;
import com.odi.filter.classfile.ConstUtf8;
import com.odi.filter.classfile.InsnTarget;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class LocalVariable {
    private InsnTarget varStartPC;
    private InsnTarget varEndPC;
    private ConstUtf8 varName;
    private ConstUtf8 varSig;
    private int varSlot;

    public LocalVariable(InsnTarget startPC, InsnTarget endPC, ConstUtf8 name, ConstUtf8 sig, int slot) {
        this.varStartPC = startPC;
        this.varEndPC = endPC;
        this.varName = name;
        this.varSig = sig;
        this.varSlot = slot;
    }

    static LocalVariable read(DataInputStream data, CodeEnv env) throws IOException {
        int startPC = data.readUnsignedShort();
        InsnTarget startPCTarget = env.getTarget(startPC);
        int length = data.readUnsignedShort();
        InsnTarget endPCTarget = env.getTarget(startPC + length);
        ConstUtf8 name = (ConstUtf8)env.pool().constantAt(data.readUnsignedShort());
        ConstUtf8 sig = (ConstUtf8)env.pool().constantAt(data.readUnsignedShort());
        int slot = data.readUnsignedShort();
        return new LocalVariable(startPCTarget, endPCTarget, name, sig, slot);
    }

    void write(DataOutputStream out) throws IOException {
        out.writeShort(this.varStartPC.offset());
        out.writeShort(this.varEndPC.offset() - this.varStartPC.offset());
        out.writeShort(this.varName == null ? 0 : this.varName.getIndex());
        out.writeShort(this.varSig == null ? 0 : this.varSig.getIndex());
        out.writeShort(this.varSlot);
    }

    public void print(PrintStream out, int indent) {
        ClassPrint.spaces(out, indent);
        out.print("'" + (this.varName == null ? "(null)" : this.varName.asString()) + "'");
        out.print(" sig = " + (this.varSig == null ? "(null)" : this.varSig.asString()));
        out.print(" start_pc = " + Integer.toString(this.varStartPC.offset()));
        out.print(" length = " + Integer.toString(this.varEndPC.offset() - this.varStartPC.offset()));
        out.println(" slot = " + Integer.toString(this.varSlot));
    }
}

