/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util;

import com.odi.ClassInfo;
import com.odi.FatalInternalException;
import com.odi.GenericObject;
import com.odi.IPersistent;
import com.odi.IPersistentHooks;
import com.odi.NoSessionException;
import com.odi.ObjectNotFoundException;
import com.odi.ObjectStore;
import com.odi.ObjectStoreException;
import com.odi.ReferencedObjectNotFoundException;
import com.odi.imp.IPersistentCacheHooks;
import com.odi.imp.ObjectReference;
import com.odi.util.OSAbstractCollection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class OSSmallMap
implements Map,
Serializable,
IPersistent,
IPersistentHooks,
IPersistentCacheHooks {
    static final long serialVersionUID = 3271815175239695142L;
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    protected Object[] kvPairs;
    protected int nEntries;
    private static final byte versionNumber = 1;
    transient ObjectReference ref;
    transient byte objectState;
    private static final ClassInfo classInfo = ClassInfo.register(ClassInfo.getDynamic("com.odi.util.OSSmallMap"));

    @Override
    public void initializeContents(GenericObject genObject) {
        this.kvPairs = (Object[])genObject.getArrayField(1, classInfo);
        this.nEntries = genObject.getIntField(2, classInfo);
        if (this.kvPairs != null) {
            ObjectStore.fetch(this.kvPairs);
        }
    }

    @Override
    public void flushContents(GenericObject genObject) {
        if (this.kvPairs != null && !this.hasWriteBarrier()) {
            ObjectStore.dirty(this.kvPairs);
        }
        genObject.setArrayField(1, this.kvPairs, classInfo);
        genObject.setIntField(2, this.nEntries, classInfo);
    }

    @Override
    public void clearContents() {
        this.kvPairs = null;
        this.nEntries = 0;
    }

    public OSSmallMap(ClassInfo ignored) {
    }

    @Override
    public final ObjectReference ODIgetRef() {
        return this.ref;
    }

    @Override
    public final void ODIsetRef(ObjectReference ref) {
        this.ref = ref;
    }

    @Override
    public final byte ODIgetState() {
        return this.objectState;
    }

    @Override
    public final void ODIsetState(byte objectState) {
        this.objectState = objectState;
    }

    private boolean hasReadBarrier() {
        return this.objectState < 0;
    }

    private boolean hasWriteBarrier() {
        return (this.objectState & 2) != 0;
    }

    private void fetch() {
        if (this.hasReadBarrier()) {
            ObjectStore.fetch(this);
        }
    }

    private void dirty() {
        if (this.hasWriteBarrier()) {
            ObjectStore.dirty(this);
        }
    }

    @Override
    public void preDestroyPersistent() {
        this.fetch();
        if (this.kvPairs != null && ObjectStore.isPersistent(this)) {
            ObjectStore.destroy(this.kvPairs);
        }
    }

    @Override
    public void preFlushContents() {
    }

    @Override
    public void preClearContents() {
    }

    @Override
    public void postInitializeContents() {
    }

    @Override
    public void preFlushContentsToCache() {
    }

    @Override
    public void postInitializeContentsFromCache() {
        if (this.kvPairs != null) {
            ObjectStore.fetch(this.kvPairs);
        }
    }

    protected boolean needsToGrow() {
        return this.nEntries >= (this.nSlots() * 3 + 1) / 4;
    }

    protected void grow() {
        int newSlots = this.nSlots() * 2 - 1;
        this.reorg(newSlots);
    }

    protected int recommendedSize(int capacity) {
        int size = capacity <= 4 ? 5 : (capacity * 4 + 1) / 3;
        return size % 2 == 1 ? size : size + 1;
    }

    protected void allocateLazyTable() {
        if (this.nEntries >= 0) {
            throw new FatalInternalException("Corrupt OSSmallMap.nEntries");
        }
        this.reorg(-this.nEntries);
        this.nEntries = 0;
    }

    private int nSlots() {
        return this.kvPairs == null ? 0 : this.kvPairs.length / 2;
    }

    private int nextSlot(int slot) {
        return (slot + 2) % this.kvPairs.length;
    }

    private int findEntry(Object key) {
        return this.findEntry(key, false);
    }

    private int findEntry(Object key, boolean noThrow) {
        ObjectNotFoundException firstONFException = null;
        int slot = (key.hashCode() & 0x7FFFFFFE) % this.kvPairs.length;
        Object k = this.kvPairs[slot];
        while (k != null) {
            block5: {
                try {
                    if (key.equals(k)) {
                        return slot;
                    }
                }
                catch (ObjectNotFoundException onfe) {
                    if (firstONFException != null) break block5;
                    firstONFException = onfe;
                }
            }
            slot = this.nextSlot(slot);
            k = this.kvPairs[slot];
        }
        if (firstONFException != null && !noThrow) {
            OSSmallMap.throwReferencedObjectNotFound(firstONFException, true);
        }
        return -slot - 1;
    }

    private void removeFromSlot(int keySlot) {
        this.dirty();
        --this.nEntries;
        this.kvPairs[keySlot] = null;
        this.kvPairs[keySlot + 1] = null;
        int emptySlot = keySlot;
        int slot = this.nextSlot(emptySlot);
        while (this.kvPairs[slot] != null) {
            Object k = this.kvPairs[slot];
            int findSlot = this.findEntry(k, true);
            if (findSlot < 0) {
                if ((findSlot = -findSlot - 1) != emptySlot) {
                    throw new FatalInternalException("Corruption in OSSmallMap.remove");
                }
                this.kvPairs[emptySlot] = k;
                this.kvPairs[emptySlot + 1] = this.kvPairs[slot + 1];
                this.kvPairs[slot] = null;
                this.kvPairs[slot + 1] = null;
                emptySlot = slot;
            }
            slot = this.nextSlot(slot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reorg(int newTableSlots) {
        this.dirty();
        Object[] oldPairs = this.kvPairs;
        int oldNumEntries = this.nEntries;
        boolean done = false;
        this.kvPairs = new Object[newTableSlots * 2];
        this.nEntries = 0;
        if (oldPairs != null) {
            try {
                int end = oldPairs.length - 1;
                for (int i = 0; i < end; i += 2) {
                    Object key = oldPairs[i];
                    if (key == null) continue;
                    this.put(key, oldPairs[i + 1]);
                }
                if (ObjectStore.isPersistent(this)) {
                    ObjectStore.destroy(oldPairs);
                }
                done = true;
            }
            catch (ObjectNotFoundException e) {
                OSSmallMap.throwReferencedObjectNotFound(e, true);
            }
            finally {
                if (!done) {
                    this.kvPairs = oldPairs;
                    this.nEntries = oldNumEntries;
                }
            }
        }
    }

    private static void checkNullKey(Object k, String method) {
        if (k == null) {
            throw new NullPointerException("The key argument to OSSmallMap." + method + " is null.");
        }
    }

    private static void throwReferencedObjectNotFound(ObjectNotFoundException origException, boolean wasKey) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(stream);
        origException.printStackTrace(pw);
        pw.flush();
        String objKind = wasKey ? "key" : "value";
        throw new ReferencedObjectNotFoundException("A " + objKind + " object referenced by this OSSmallMap was " + "not found.  This object may have been destroyed by an " + "earlier operation.  You can use the clearDestroyed() method to " + "clear any entries from this OSSmallMap which reference " + "destroyed objects.\n" + "Stack trace at point of original failure:\n" + "*****************************************\n" + stream + "*****************************************\n");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.hasReadBarrier()) {
            throw new ObjectStoreException("OSSmallMap.writeObject() invoked without a preceding call to ObjectStore.deepFetch()");
        }
        out.writeByte(1);
        out.writeInt(this.kvPairs == null ? 0 : this.kvPairs.length);
        out.writeInt(this.nEntries);
        if (this.kvPairs == null) {
            return;
        }
        int entryCount = 0;
        for (int slot = 0; slot < this.kvPairs.length - 1; slot += 2) {
            Object k = this.kvPairs[slot];
            if (k == null) continue;
            ++entryCount;
            out.writeObject(this.kvPairs[slot]);
            out.writeObject(this.kvPairs[slot + 1]);
        }
        if (entryCount != this.nEntries) {
            throw new ObjectStoreException("OSSmallMap.writeObject() seems to have been invoked without a preceding call to ObjectStore.deepFetch(), since its cached element count (" + this.nEntries + ") != computed count (" + entryCount + ")");
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte ver = in.readByte();
        if (ver != 1) {
            throw new IOException("Wrong version of OSSmallMap found.");
        }
        int length = in.readInt();
        int nElements = in.readInt();
        if (nElements < 0) {
            this.kvPairs = null;
            this.nEntries = nElements;
        } else {
            this.kvPairs = new Object[length];
            this.nEntries = 0;
            for (int i = 0; i < nElements; ++i) {
                Object key = in.readObject();
                Object element = in.readObject();
                this.put(key, element);
            }
        }
    }

    public OSSmallMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("negative initialCapacity");
        }
        this.nEntries = -this.recommendedSize(initialCapacity);
    }

    public OSSmallMap() {
        this(3);
    }

    public OSSmallMap(Map m) {
        this(m.size());
        this.putAll(m);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        Map otherMap = (Map)obj;
        if (this.size() != otherMap.size()) {
            return false;
        }
        if (this.kvPairs == null) {
            return true;
        }
        for (int slot = 0; slot < this.kvPairs.length - 1; slot += 2) {
            Object k = this.kvPairs[slot];
            if (k == null) continue;
            Object v = this.kvPairs[slot + 1];
            if (v == null) {
                if (otherMap.get(k) == null) continue;
                return false;
            }
            try {
                if (v.equals(otherMap.get(k))) continue;
                return false;
            }
            catch (ObjectNotFoundException e) {
                boolean wasKey = ObjectStore.isDestroyed(k);
                OSSmallMap.throwReferencedObjectNotFound(e, wasKey);
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash;
        block6: {
            hash = 0;
            try {
                this.fetch();
                if (this.kvPairs == null) {
                    return 0;
                }
                for (int slot = 0; slot < this.kvPairs.length - 1; slot += 2) {
                    try {
                        if (this.kvPairs[slot] == null) continue;
                        int v = this.kvPairs[slot + 1] == null ? 0 : this.kvPairs[slot + 1].hashCode();
                        hash += this.kvPairs[slot].hashCode() ^ v;
                        continue;
                    }
                    catch (ObjectNotFoundException e) {
                        boolean wasKey = ObjectStore.isDestroyed(this.kvPairs[slot]);
                        OSSmallMap.throwReferencedObjectNotFound(e, wasKey);
                    }
                }
            }
            catch (NoSessionException e) {
                if (Boolean.getBoolean("com.odi.debugHashCodes")) break block6;
                throw e;
            }
        }
        return hash;
    }

    @Override
    public int size() {
        this.fetch();
        if (this.nEntries < 0) {
            return 0;
        }
        return this.nEntries;
    }

    @Override
    public boolean isEmpty() {
        this.fetch();
        return this.nEntries <= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        this.fetch();
        if (this.kvPairs == null) {
            return false;
        }
        ObjectNotFoundException firstONFException = null;
        int end = this.kvPairs.length - 1;
        for (int slot = 0; slot < end; slot += 2) {
            try {
                Object k = this.kvPairs[slot];
                if (k == null || !(value == null ? this.kvPairs[slot + 1] == null : value.equals(this.kvPairs[slot + 1]))) continue;
                return true;
            }
            catch (ObjectNotFoundException onfe) {
                if (firstONFException != null) continue;
                firstONFException = onfe;
            }
        }
        if (firstONFException != null) {
            OSSmallMap.throwReferencedObjectNotFound(firstONFException, false);
        }
        return false;
    }

    public boolean containsAll(Collection coll) {
        Iterator iter = coll.iterator();
        while (iter.hasNext()) {
            if (this.containsValue(iter.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        OSSmallMap.checkNullKey(key, "containsKey");
        this.fetch();
        if (this.kvPairs == null) {
            return false;
        }
        return this.findEntry(key) >= 0;
    }

    public Object get(Object key) {
        OSSmallMap.checkNullKey(key, "get");
        this.fetch();
        if (this.kvPairs == null) {
            return null;
        }
        int keySlot = this.findEntry(key);
        return keySlot >= 0 ? this.kvPairs[keySlot + 1] : null;
    }

    public Object getKey(Object key) {
        OSSmallMap.checkNullKey(key, "getKey");
        this.fetch();
        if (this.kvPairs == null) {
            return null;
        }
        int keySlot = this.findEntry(key);
        return keySlot >= 0 ? this.kvPairs[keySlot] : null;
    }

    public Object put(Object key, Object value) {
        int keySlot;
        OSSmallMap.checkNullKey(key, "put");
        this.fetch();
        if (this.kvPairs == null) {
            this.allocateLazyTable();
        }
        if ((keySlot = this.findEntry(key)) >= 0) {
            Object old = this.kvPairs[keySlot + 1];
            if (old != value) {
                this.dirty();
                this.kvPairs[keySlot + 1] = value;
            }
            return old;
        }
        if (this.needsToGrow()) {
            this.grow();
            keySlot = this.findEntry(key);
            if (keySlot >= 0) {
                throw new FatalInternalException("Unfound key mysteriously found after growing the OSSmallMap");
            }
        }
        keySlot = -keySlot - 1;
        this.dirty();
        ++this.nEntries;
        this.kvPairs[keySlot] = key;
        this.kvPairs[keySlot + 1] = value;
        return null;
    }

    public Object remove(Object key) {
        OSSmallMap.checkNullKey(key, "remove");
        this.fetch();
        if (this.kvPairs == null) {
            return null;
        }
        int keySlot = this.findEntry(key);
        if (keySlot < 0) {
            return null;
        }
        Object old = this.kvPairs[keySlot + 1];
        this.removeFromSlot(keySlot);
        return old;
    }

    @Override
    public void clear() {
        this.fetch();
        if (this.kvPairs == null) {
            return;
        }
        this.dirty();
        if (ObjectStore.isPersistent(this)) {
            ObjectStore.destroy(this.kvPairs);
        }
        this.kvPairs = null;
        this.nEntries = -this.recommendedSize(3);
    }

    public void clearDestroyed() {
        this.fetch();
        if (this.kvPairs == null) {
            return;
        }
        boolean found = false;
        for (int slot = 0; slot < this.kvPairs.length - 1; slot += 2) {
            if (!ObjectStore.isDestroyed(this.kvPairs[slot]) && !ObjectStore.isDestroyed(this.kvPairs[slot + 1])) continue;
            found = true;
            this.dirty();
            --this.nEntries;
            this.kvPairs[slot] = null;
            this.kvPairs[slot + 1] = null;
        }
        if (found) {
            this.rehash();
        }
    }

    public void rehash() {
        this.fetch();
        this.reorg(this.recommendedSize(this.size()));
    }

    public void resize(int newCapacity) {
        if (newCapacity < 0) {
            throw new IllegalArgumentException("negative newCapicity");
        }
        this.fetch();
        int newSize = this.recommendedSize(Math.max(newCapacity, this.size()));
        if (this.kvPairs == null) {
            this.nEntries = -newSize;
        } else if (newSize < this.nSlots() * 2 / 3 || newSize > this.nSlots() * 3 / 2) {
            this.reorg(newSize);
        }
    }

    public void putAll(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public synchronized String toString() {
        this.fetch();
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.entrySet().iterator();
        buf.append("{");
        while (iter.hasNext()) {
            Map.Entry e = (Map.Entry)iter.next();
            buf.append(e.getKey().toString());
            buf.append("=");
            Object val = e.getValue();
            buf.append(val == this ? "this" : val.toString());
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    public Set keySet() {
        return new SmallMapSetView(0);
    }

    public Collection values() {
        return new SmallMapCollectionView(1);
    }

    public Set entrySet() {
        return new SmallMapSetView(2);
    }

    protected class SmallMapEntry
    implements Map.Entry {
        int keySlot;

        SmallMapEntry(int keySlot) {
            this.keySlot = keySlot;
        }

        void wasRemoved() {
            this.keySlot = -1;
        }

        protected void checkState() {
            OSSmallMap.this.fetch();
            if (this.keySlot < 0) {
                throw new IllegalStateException("The current map entry was removed");
            }
            if (OSSmallMap.this.kvPairs[this.keySlot] == null) {
                throw new ConcurrentModificationException("On an OSSmallMap entry");
            }
        }

        public Object getKey() {
            this.checkState();
            return OSSmallMap.this.kvPairs[this.keySlot];
        }

        public Object getValue() {
            this.checkState();
            return OSSmallMap.this.kvPairs[this.keySlot + 1];
        }

        public Object setValue(Object newValue) {
            this.checkState();
            Object old = OSSmallMap.this.kvPairs[this.keySlot + 1];
            OSSmallMap.this.dirty();
            OSSmallMap.this.kvPairs[this.keySlot + 1] = newValue;
            return old;
        }

        @Override
        public boolean equals(Object obj) {
            this.checkState();
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry ent = (Map.Entry)obj;
            try {
                if (!OSSmallMap.this.kvPairs[this.keySlot].equals(ent.getKey())) {
                    return false;
                }
                Object v1 = OSSmallMap.this.kvPairs[this.keySlot + 1];
                Object v2 = ent.getValue();
                return v1 == null ? v2 == null : v1.equals(v2);
            }
            catch (ObjectNotFoundException e) {
                boolean wasKey = ObjectStore.isDestroyed(OSSmallMap.this.kvPairs[this.keySlot]);
                OSSmallMap.throwReferencedObjectNotFound(e, wasKey);
                return false;
            }
        }

        @Override
        public int hashCode() {
            this.checkState();
            try {
                int v = OSSmallMap.this.kvPairs[this.keySlot + 1] == null ? 0 : OSSmallMap.this.kvPairs[this.keySlot + 1].hashCode();
                return OSSmallMap.this.kvPairs[this.keySlot].hashCode() ^ v;
            }
            catch (ObjectNotFoundException e) {
                boolean wasKey = ObjectStore.isDestroyed(OSSmallMap.this.kvPairs[this.keySlot]);
                OSSmallMap.throwReferencedObjectNotFound(e, wasKey);
                return 0;
            }
        }
    }

    protected class SmallMapSetView
    extends SmallMapCollectionView
    implements Set {
        SmallMapSetView(int what) {
            super(what);
        }
    }

    protected class SmallMapCollectionView
    extends OSAbstractCollection {
        int viewWhat;

        SmallMapCollectionView(int what) {
            this.viewWhat = what;
        }

        @Override
        public int size() {
            return OSSmallMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            switch (this.viewWhat) {
                case 0: {
                    return OSSmallMap.this.containsKey(o);
                }
                case 1: {
                    return OSSmallMap.this.containsValue(o);
                }
                case 2: {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Object v1 = OSSmallMap.this.get(entry.getKey());
                    Object v2 = entry.getValue();
                    return v1 == null ? v2 == null : v1.equals(v2);
                }
            }
            throw new FatalInternalException("Corrupt OSSmallMap view");
        }

        @Override
        public Iterator iterator() {
            return new SmallMapIterator(this.viewWhat);
        }

        @Override
        public boolean remove(Object o) {
            switch (this.viewWhat) {
                case 0: {
                    if (!OSSmallMap.this.containsKey(o)) {
                        return false;
                    }
                    OSSmallMap.this.remove(o);
                    return true;
                }
                case 1: {
                    Iterator iter = this.iterator();
                    while (iter.hasNext()) {
                        if (!o.equals(iter.next())) continue;
                        iter.remove();
                        return true;
                    }
                    return false;
                }
                case 2: {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    if (!this.contains(entry)) {
                        return false;
                    }
                    OSSmallMap.this.remove(entry.getKey());
                    return true;
                }
            }
            throw new FatalInternalException("Corrupt OSSmallMap view");
        }

        @Override
        public void clear() {
            OSSmallMap.this.clear();
        }

        @Override
        public synchronized boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Collection)) {
                return false;
            }
            Collection coll = (Collection)o;
            return coll.size() == this.size() && this.containsAll(coll);
        }

        @Override
        public synchronized int hashCode() {
            int h;
            block3: {
                h = 0;
                try {
                    for (Object o : this) {
                        if (o == null) continue;
                        h += o.hashCode();
                    }
                }
                catch (NoSessionException e) {
                    if (Boolean.getBoolean("com.odi.debugHashCodes")) break block3;
                    throw e;
                }
            }
            return h;
        }
    }

    protected class SmallMapIterator
    implements Iterator {
        protected int iterateWhat;
        protected int currSlot;
        protected int nextSlot;
        protected boolean currentRemoved;
        SmallMapEntry currentEntry;

        SmallMapIterator(int what) {
            this.nextSlot = this.currSlot = -2;
            this.currentRemoved = false;
            this.currentEntry = null;
            this.iterateWhat = what;
        }

        @Override
        public boolean hasNext() {
            OSSmallMap.this.fetch();
            if (OSSmallMap.this.kvPairs == null) {
                return false;
            }
            if (this.nextSlot == this.currSlot) {
                Object k;
                if (!this.currentRemoved) {
                    this.nextSlot += 2;
                }
                while (this.nextSlot < OSSmallMap.this.kvPairs.length - 1 && (k = OSSmallMap.this.kvPairs[this.nextSlot]) == null) {
                    this.nextSlot += 2;
                }
            }
            return this.nextSlot < OSSmallMap.this.kvPairs.length - 1;
        }

        public Object next() {
            Object obj = null;
            if (!this.hasNext()) {
                throw new NoSuchElementException("OSSmallMap.Iterator has no next");
            }
            this.currSlot = this.nextSlot;
            this.currentRemoved = false;
            switch (this.iterateWhat) {
                case 0: {
                    obj = OSSmallMap.this.kvPairs[this.currSlot];
                    break;
                }
                case 1: {
                    obj = OSSmallMap.this.kvPairs[this.currSlot + 1];
                    break;
                }
                case 2: {
                    this.currentEntry = new SmallMapEntry(this.currSlot);
                    obj = this.currentEntry;
                    break;
                }
                default: {
                    throw new FatalInternalException("Corrupt OSSmallMap iterator");
                }
            }
            return obj;
        }

        @Override
        public void remove() {
            Object key;
            OSSmallMap.this.fetch();
            Object object = key = this.currSlot < 0 ? null : OSSmallMap.this.kvPairs[this.currSlot];
            if (key == null || this.currentRemoved) {
                throw new IllegalStateException("OSSmallMap.Iterator");
            }
            OSSmallMap.this.removeFromSlot(this.currSlot);
            this.currentRemoved = true;
            if (this.currentEntry != null) {
                this.currentEntry.wasRemoved();
            }
        }
    }
}

