/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.evs.nio;

import com.progress.blackbird.evs.IEvsIOBuf;
import com.progress.blackbird.evs.nio.EvsListElement;
import java.nio.ByteBuffer;

public final class EvsIOBuf
extends EvsListElement
implements IEvsIOBuf {
    private ByteBuffer buf;
    private int mark;

    private EvsIOBuf(int n) {
        this.init(n);
    }

    private void init(int n) {
        this.buf = ByteBuffer.allocateDirect(n);
        this.buf.mark();
        this.mark = this.getPos();
    }

    public static IEvsIOBuf create(int n) {
        return new EvsIOBuf(n);
    }

    final ByteBuffer getBuffer() {
        return this.buf;
    }

    @Override
    public final int write(byte[] byArray, int n, int n2) {
        int n3 = Math.min(n2, this.buf.remaining());
        this.buf.put(byArray, n, n3);
        return n3;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) {
        int n3 = Math.min(n2, this.buf.remaining());
        this.buf.get(byArray, n, n3);
        return n3;
    }

    @Override
    public final IEvsIOBuf setPos(int n) {
        this.buf.position(n);
        if (this.getPos() < this.mark) {
            this.buf.mark();
            this.mark = this.getPos();
        }
        return this;
    }

    @Override
    public final IEvsIOBuf setLimit(int n) {
        this.buf.limit(n);
        if (this.getPos() < this.mark) {
            this.buf.mark();
            this.mark = this.getPos();
        }
        return this;
    }

    @Override
    public final IEvsIOBuf setSize(int n) {
        this.init(n);
        return this;
    }

    @Override
    public final int getPos() {
        return this.buf.position();
    }

    @Override
    public final int getLimit() {
        return this.buf.limit();
    }

    @Override
    public final int getSize() {
        return this.buf.capacity();
    }

    @Override
    public final IEvsIOBuf mark() {
        this.buf.mark();
        this.mark = this.getPos();
        return this;
    }

    @Override
    public final IEvsIOBuf reset() {
        this.buf.clear();
        this.mark = this.getPos();
        return this;
    }

    @Override
    public final IEvsIOBuf flip() {
        this.buf.flip();
        this.mark = this.getPos();
        return this;
    }

    @Override
    public final IEvsIOBuf rewind() {
        this.buf.rewind();
        this.mark = this.getPos();
        return this;
    }

    @Override
    public final IEvsIOBuf rewindMark() {
        this.buf.reset();
        return this;
    }

    @Override
    public final IEvsIOBuf compact() {
        this.buf.compact();
        this.mark = this.getPos();
        return this;
    }

    @Override
    public final IEvsIOBuf compact(IEvsIOBuf iEvsIOBuf) {
        iEvsIOBuf.reset();
        iEvsIOBuf.write(this.buf.array(), this.buf.position(), this.buf.remaining());
        return iEvsIOBuf;
    }
}

