/*
 * Decompiled with CFR 0.152.
 */
package com.progress.blackbird.sys;

import com.progress.blackbird.sys.SysConfig;
import com.progress.blackbird.sys.SysLogger;
import java.util.Properties;

public final class SysTrace {
    private volatile int level;
    private volatile String prefix = "...";
    private SysLogger logger = SysConfig.getLogger();
    public volatile boolean debug;

    private SysTrace(int n) {
        this.updateLevel(n);
    }

    public static SysTrace create(int n) {
        return new SysTrace(n);
    }

    public static SysTrace create(Properties properties, String string) {
        return new SysTrace(SysTrace.getLevelFromProperty(properties, string));
    }

    public static int getLevelFromString(String string) {
        int n = string.compareToIgnoreCase("error") == 0 || string.compareToIgnoreCase("err") == 0 || string.compareToIgnoreCase("1") == 0 ? 1 : (string.compareToIgnoreCase("warning") == 0 || string.compareToIgnoreCase("warn") == 0 || string.compareToIgnoreCase("2") == 0 ? 2 : (string.compareToIgnoreCase("information") == 0 || string.compareToIgnoreCase("info") == 0 || string.compareToIgnoreCase("3") == 0 ? 3 : (string.compareToIgnoreCase("verbose") == 0 || string.compareToIgnoreCase("4") == 0 ? 4 : (string.compareToIgnoreCase("debug") == 0 || string.compareToIgnoreCase("dbg") == 0 || string.compareToIgnoreCase("9") == 0 ? 9 : 0))));
        return n;
    }

    public static int getLevelFromProperty(Properties properties, String string) {
        String string2 = SysConfig.getConfigValue(properties, string);
        return string2 != null ? SysTrace.getLevelFromString(string2) : 0;
    }

    public final void updateLevel(int n) {
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("Invalid trace level");
        }
        this.level = n;
        this.debug = this.level == 9;
    }

    public final void updateLevelFromProperty(Properties properties, String string) {
        if (SysConfig.getConfigValue(properties, string) != null) {
            this.updateLevel(SysTrace.getLevelFromProperty(properties, string));
        }
    }

    public final void updatePrefix(String string) {
        this.prefix = string;
    }

    public final void out(String string, int n) {
        if (this.logger != null && n <= this.level) {
            String string2 = n == -1 ? "always" : (n == 1 ? "error" : (n == 2 ? "warn" : (n == 3 ? "info" : (n == 4 ? "verbose" : (n == 9 ? "debug" : "unkwn")))));
            this.logger.log(System.currentTimeMillis() + ":" + Thread.currentThread().getName() + "[" + this.prefix + "] " + "(" + string2 + ") " + string);
        }
    }

    public final void out(String string) {
        this.out(string, 3);
    }

    public final void outln(String string, int n) {
        this.out(string + "\n", n);
    }

    public void outln(String string) {
        this.outln(string, 3);
    }

    public final void debug(String string) {
        this.out(string, 9);
    }

    public final void debugln(String string) {
        this.outln(string, 9);
    }
}

