/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.lm.impl;

import com.sonicsw.lm.impl.LockRequest;
import java.util.ArrayList;
import java.util.LinkedList;

class TransactionLocks {
    long m_tid;
    LinkedList m_lockRequests = new LinkedList();
    LinkedList m_waitReq = new LinkedList();
    TransactionLocks m_cycle = null;
    boolean m_visited;

    TransactionLocks(long tid) {
        this.m_tid = tid;
    }

    long getTransactionId() {
        return this.m_tid;
    }

    synchronized void addRequest(LockRequest req) {
        this.m_lockRequests.add(req);
    }

    synchronized void beginWaitRequest(LockRequest req) {
        if (!(req.getStatus() != 0 && req.getStatus() != 2 || this.m_waitReq.contains(req))) {
            this.m_waitReq.add(req);
        }
    }

    synchronized void endWaitRequest(LockRequest req) {
        this.m_waitReq.remove(req);
    }

    synchronized void requestGranted(LockRequest req) {
        this.m_waitReq.remove(req);
    }

    synchronized void removeRequest(LockRequest req) {
        this.m_lockRequests.remove(req);
        this.m_waitReq.remove(req);
    }

    void setCycle(TransactionLocks tlocks) {
        this.m_cycle = tlocks;
    }

    TransactionLocks getCycle() {
        return this.m_cycle;
    }

    void setVisited(boolean visited) {
        this.m_visited = visited;
    }

    boolean getVisited() {
        return this.m_visited;
    }

    int getCount() {
        return this.m_lockRequests.size();
    }

    LinkedList getLocks() {
        return this.m_lockRequests;
    }

    synchronized void printAllLocks() {
        this.debug("Txn= " + this.m_tid + " LockCount " + this.m_lockRequests.size());
        for (LockRequest req : this.m_lockRequests) {
            req.toStringAll();
        }
    }

    ArrayList getDynamicDependencies() {
        ArrayList dependencies = new ArrayList();
        for (LockRequest req : this.m_waitReq) {
            if (req.getStatus() != 0 && req.getStatus() != 2) continue;
            req.getLock().getDependencies(req, dependencies);
        }
        return dependencies;
    }

    synchronized ArrayList getWaitingRequests() {
        ArrayList<LockRequest> waitingReq = new ArrayList<LockRequest>();
        for (LockRequest req : this.m_waitReq) {
            waitingReq.add(req);
        }
        return waitingReq;
    }

    private void debug(String s) {
        System.out.println(s);
    }
}

