/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

class BTreeLockID {
    private final long m_treeID;
    private final byte[] m_key;
    private final byte[] m_value;
    private int m_hash;
    final boolean m_keyLock;

    BTreeLockID(boolean keyLock, long treeID, byte[] key, byte[] value) {
        this.m_keyLock = keyLock;
        this.m_treeID = treeID;
        this.m_key = key;
        this.m_value = value;
    }

    public int hashCode() {
        if (!this.m_keyLock && this.m_value != null) {
            return this.hashByteArray(this.m_value);
        }
        if (this.m_key != null) {
            return this.hashByteArray(this.m_key);
        }
        return 1;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (!(anObject instanceof BTreeLockID)) {
            return false;
        }
        BTreeLockID anotherID = (BTreeLockID)anObject;
        if (this.m_keyLock != anotherID.m_keyLock) {
            return false;
        }
        if (this.m_treeID != anotherID.m_treeID) {
            return false;
        }
        if (!this.arraysEquals(this.m_key, anotherID.m_key)) {
            return false;
        }
        if (this.m_keyLock) {
            return true;
        }
        return this.arraysEquals(this.m_value, anotherID.m_value);
    }

    private boolean arraysEquals(byte[] array1, byte[] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return array1 == null;
        }
        if (array1.length != array2.length) {
            return false;
        }
        int length = array1.length;
        for (int i = 0; i < length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    private int hashByteArray(byte[] bytes) {
        int h = this.m_hash;
        if (h == 0) {
            int len = bytes.length;
            for (int i = 0; i < len; ++i) {
                h = 31 * h + bytes[i];
            }
            this.m_hash = h;
        }
        return h;
    }

    public String toString() {
        return "tree ID: " + this.m_treeID + " key lock: " + this.m_keyLock + " key length: " + (this.m_key == null ? 0 : this.m_key.length) + " value length: " + (this.m_value == null ? 0 : this.m_value.length);
    }
}

