/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractNote;
import com.sonicsw.mtstorage.impl.BitUtil;
import com.sonicsw.mtstorage.impl.ILogicalNote;
import com.sonicsw.mtstorage.impl.INoteWriter;
import java.io.IOException;

abstract class LogicalNote
extends AbstractNote
implements ILogicalNote {
    byte[] m_scratchBuffer = new byte[8];
    long m_transactionNum;
    boolean m_start;

    abstract byte getType();

    @Override
    public boolean noteStart() {
        return this.m_start;
    }

    @Override
    public long getPageNum() {
        return 0L;
    }

    @Override
    public long getTransactionNum() {
        return this.m_transactionNum;
    }

    LogicalNote() {
    }

    @Override
    public int writeNote(INoteWriter writer) throws IOException {
        writer.write(this.getType());
        writer.write((byte)(this.m_start ? 1 : 0));
        BitUtil.putLong(this.m_scratchBuffer, 0, this.m_transactionNum);
        writer.write(this.m_scratchBuffer, 0, 8);
        return 10;
    }

    @Override
    public void initNote(byte[] buffer, int offset) {
        int currentOffset = offset;
        this.m_start = buffer[currentOffset++] == 1;
        this.m_transactionNum = BitUtil.getLong(buffer, currentOffset);
    }

    void initNote(long transactionNum, boolean noteStart) {
        this.m_transactionNum = transactionNum;
        this.m_start = noteStart;
    }

    public String toString() {
        return this.getClass().getName() + " transaction: " + this.m_transactionNum + " start: " + this.m_start;
    }
}

