/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.AbstractContentPage;
import com.sonicsw.mtstorage.impl.BitSetUtil;
import com.sonicsw.mtstorage.impl.CachedPagesFile;
import com.sonicsw.mtstorage.impl.ChainAnchorNote;
import com.sonicsw.mtstorage.impl.CorruptPageException;
import com.sonicsw.mtstorage.impl.DataPage;
import com.sonicsw.mtstorage.impl.INote;
import com.sonicsw.mtstorage.impl.IObjectsBufferNote;
import com.sonicsw.mtstorage.impl.IPageNote;
import com.sonicsw.mtstorage.impl.IRollbackAble;
import com.sonicsw.mtstorage.impl.Logger;
import com.sonicsw.mtstorage.impl.MasterPage;
import com.sonicsw.mtstorage.impl.ObjectsBuffer;
import com.sonicsw.mtstorage.impl.Page;
import com.sonicsw.mtstorage.impl.PageAllocationNote;
import com.sonicsw.mtstorage.impl.PageChainNextNote;
import com.sonicsw.mtstorage.impl.PageChainPrevNote;
import com.sonicsw.mtstorage.impl.PageTypeNote;
import com.sonicsw.mtstorage.impl.RecentTransactionNote;
import com.sonicsw.mtstorage.impl.TransactionManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;

final class PageManager
implements IRollbackAble {
    static final String DATA_FILE_NAME = "data";
    public static final String WRITE_DIRTY_PAGES_THRESHOLD_PARAMETER = "WRITE_DIRTY_PAGES_THRESHOLD";
    public static final String DO_FILE_SYNC_PARAMETER = "DO_FILE_SYNC";
    public static final String INDEX_CACHE_SIZE_PARAMETER = "INDEX_CACHE_SIZE";
    public static final String BLOBS_CACHE_SIZE_PARAMETER = "BLOBS_CACHE_SIZE";
    public static final String BTREE_CACHE_SIZE_PARAMETER = "BTREE_CACHE_SIZE";
    public static final String HEADERS_CACHE_SIZE_PARAMETER = "HEADERS_CACHE_SIZE";
    public static final String FREE_PAGES_CACHE_SIZE_PARAMETER = "FREE_PAGES_CACHE_SIZE";
    public static final String REUSE_PAGE_THRESHOLD_PARAMETER = "REUSE_PAGE_THRESHOLD";
    public static final String USE_MORE_FREE_PAGES_FOR_HEADER_OBJECTS_PARAMETER = "USE_MORE_FREE_PAGES_FOR_HEADER_OBJECTS";
    public static final String ASYNC_FILE_QUEUE_SIZE_PARAMETER = "ASYNC_FILE_QUEUE_SIZE";
    public static final String DATA_FILE_PARAMETER = "DATA_FILE";
    private static final int WRITE_DIRTY_PAGES_THRESHOLD_DEFAULT = 1000;
    private static final boolean DO_FILE_SYNC_DEFAULT = true;
    public static final int REUSE_PAGE_THRESHOLD_DEFAULT = 0;
    private static final int NUMBER_OF_CACHES = 5;
    private static final int INDEX_CACHE_SIZE_DEFAULT = 1000;
    private static final int ASYNC_FILE_QUEUE_SIZE_DEFAULT = 2000;
    private static final int BLOBS_CACHE_SIZE_DEFAULT = 500;
    private static final int BTREE_CACHE_SIZE_DEFAULT = 1000;
    private static final int HEADERS_CACHE_SIZE_DEFAULT = 500;
    private static final int FREE_PAGES_CACHE_SIZE_DEFAULT = 500;
    private static final int ASYNC_FILE_QUEUE_SIZE_MIN = 100;
    private String m_fileName;
    private CachedPagesFile m_cachedPagesFile;
    private boolean m_doFileSync;
    private Logger m_logger;
    private TransactionManager m_transactionManager;
    private PageChainNextNote m_pageChainNextNote;
    private PageChainPrevNote m_pageChainPrevNote;
    private PageTypeNote m_pageTypeNote;
    private ChainAnchorNote m_chainAnchorNote;
    private int m_fullPageThreshold;
    private int m_reusePageThreshold;
    private long m_lastHeaderPageUsed;
    private boolean m_useMoreFreePagesForHeaderObjects;

    PageManager(int fullPageThreshold) {
        if (System.getProperty("_UseMoreFreePagesExperiment") != null) {
            throw new Error("_UseMoreFreePagesExperiment is not supported, use the USE_MORE_FREE_PAGES_FOR_HEADER_OBJECTS boolean db parameter.");
        }
        this.m_fullPageThreshold = fullPageThreshold;
        this.m_cachedPagesFile = new CachedPagesFile();
        this.m_pageChainNextNote = new PageChainNextNote();
        this.m_pageChainPrevNote = new PageChainPrevNote();
        this.m_pageTypeNote = new PageTypeNote();
        this.m_chainAnchorNote = new ChainAnchorNote();
        this.m_lastHeaderPageUsed = -1L;
        this.m_useMoreFreePagesForHeaderObjects = false;
    }

    void startAsyncMode(Integer asyncFrequency) {
        this.m_cachedPagesFile.startAsyncMode(asyncFrequency);
    }

    void getMetrics(Properties props, String dbName) {
        this.m_cachedPagesFile.getMetrics(props, dbName);
    }

    @Override
    public void undo(INote note) throws IOException {
        block6: {
            try {
                boolean pageNote = note instanceof IPageNote;
                boolean bufferNote = note instanceof IObjectsBufferNote;
                AbstractContentPage page = null;
                if ((pageNote || bufferNote) && (page = (DataPage)this.m_cachedPagesFile.get(true, note.getPageNum())) == null) {
                    return;
                }
                if (bufferNote) {
                    page.getContentBuffer().undo((IObjectsBufferNote)note);
                    break block6;
                }
                if (pageNote) {
                    this.undo((IPageNote)note, (DataPage)page);
                    break block6;
                }
                if (note instanceof ChainAnchorNote) {
                    this.undoAnchorModification((ChainAnchorNote)note);
                    break block6;
                }
                throw new Error("Unknown note " + note);
            }
            catch (CorruptPageException corruptPageException) {
                // empty catch block
            }
        }
    }

    @Override
    public void redo(INote note) throws IOException {
        block9: {
            try {
                boolean pageNote = note instanceof IPageNote;
                boolean bufferNote = note instanceof IObjectsBufferNote;
                AbstractContentPage page = null;
                if (pageNote || bufferNote) {
                    page = (DataPage)this.m_cachedPagesFile.get(true, note.getPageNum());
                    if (page == null) {
                        throw new IOException("Page " + note.getPageNum() + " was not yet allocated");
                    }
                    if (page.getNoteID() >= note.getNoteID()) {
                        return;
                    }
                }
                if (bufferNote) {
                    page.getContentBuffer().redo((IObjectsBufferNote)note);
                    break block9;
                }
                if (pageNote) {
                    this.redo((IPageNote)note, (DataPage)page);
                    break block9;
                }
                if (note instanceof ChainAnchorNote) {
                    this.redoAnchorModification((ChainAnchorNote)note);
                    break block9;
                }
                if (note instanceof PageAllocationNote) {
                    this.m_cachedPagesFile.redoAllocate(((PageAllocationNote)note).m_allocatedPage);
                    break block9;
                }
                throw new Error("Unknown note " + note);
            }
            catch (CorruptPageException corruptPageException) {
                // empty catch block
            }
        }
    }

    private void undoAnchorModification(ChainAnchorNote note) throws IOException {
        MasterPage master = (MasterPage)this.m_cachedPagesFile.get(true, 0L);
        if (note.m_first) {
            master.setChainFirst(note.m_anchorNumber, note.m_oldPageNumber);
        } else {
            master.setChainLast(note.m_anchorNumber, note.m_oldPageNumber);
        }
    }

    private void redoAnchorModification(ChainAnchorNote note) throws IOException {
        MasterPage master = (MasterPage)this.m_cachedPagesFile.get(true, 0L);
        if (master.getNoteID() >= note.getNoteID()) {
            return;
        }
        if (note.m_first) {
            master.setChainFirst(note.m_anchorNumber, note.m_newPageNumber);
        } else {
            master.setChainLast(note.m_anchorNumber, note.m_newPageNumber);
        }
    }

    private void undo(IPageNote note, DataPage page) throws IOException {
        if (note instanceof PageChainNextNote) {
            PageChainNextNote chainNote = (PageChainNextNote)note;
            page.setChainNext(chainNote.m_oldNextPage);
            page.setChainNum(chainNote.m_oldChainNumber);
        } else if (note instanceof PageChainPrevNote) {
            PageChainPrevNote chainNote = (PageChainPrevNote)note;
            page.setChainPrev(chainNote.m_oldPrevPage);
            page.setChainNum(chainNote.m_oldChainNumber);
        } else if (note instanceof PageTypeNote) {
            PageTypeNote typeNote = (PageTypeNote)note;
            page.setPageType(typeNote.m_oldPageType);
        } else if (note instanceof RecentTransactionNote) {
            RecentTransactionNote transactionNote = (RecentTransactionNote)note;
            page.getContentBuffer().setTransactionNum(transactionNote.m_oldTransactionNum, false);
        } else {
            throw new Error("Unknown note");
        }
    }

    private void redo(IPageNote note, DataPage page) throws IOException {
        if (note instanceof PageChainNextNote) {
            PageChainNextNote chainNote = (PageChainNextNote)note;
            page.setChainNext(chainNote.m_newNextPage);
            page.setChainNum(chainNote.m_newChainNumber);
        } else if (note instanceof PageChainPrevNote) {
            PageChainPrevNote chainNote = (PageChainPrevNote)note;
            page.setChainPrev(chainNote.m_newPrevPage);
            page.setChainNum(chainNote.m_newChainNumber);
        } else if (note instanceof PageTypeNote) {
            PageTypeNote typeNote = (PageTypeNote)note;
            page.setPageType(typeNote.m_newPageType);
        } else if (note instanceof RecentTransactionNote) {
            RecentTransactionNote transactionNote = (RecentTransactionNote)note;
            page.getContentBuffer().setTransactionNum(transactionNote.m_newTransactionNum, false);
        } else {
            throw new Error("Unknown note");
        }
    }

    void deallocate(long lowestNewPageNum, long highestNewPageNum) throws IOException {
        this.m_cachedPagesFile.deallocate(lowestNewPageNum, highestNewPageNum);
    }

    void open(File dbDir, Logger logger, HashMap parameters, boolean initializeFile0) throws IOException {
        this.m_fileName = (String)parameters.get(DATA_FILE_PARAMETER);
        if (this.m_fileName == null) {
            this.m_fileName = new File(dbDir, DATA_FILE_NAME).getPath();
        }
        boolean initializeFile = initializeFile0;
        if (logger.getLastWrittenNoteID() == -1L && !new File(this.m_fileName).exists()) {
            initializeFile = true;
        }
        Integer writeDirtyThreshold = (Integer)parameters.get(WRITE_DIRTY_PAGES_THRESHOLD_PARAMETER);
        Boolean doFileSync = (Boolean)parameters.get(DO_FILE_SYNC_PARAMETER);
        this.m_doFileSync = doFileSync != null ? doFileSync : true;
        this.m_logger = logger;
        Integer reusePageThreshold = (Integer)parameters.get(REUSE_PAGE_THRESHOLD_PARAMETER);
        this.m_reusePageThreshold = reusePageThreshold == null ? 0 : reusePageThreshold;
        Boolean useMoreFreePages = (Boolean)parameters.get(USE_MORE_FREE_PAGES_FOR_HEADER_OBJECTS_PARAMETER);
        if (useMoreFreePages != null) {
            this.m_useMoreFreePagesForHeaderObjects = useMoreFreePages;
        }
        if (this.m_reusePageThreshold != 0) {
            System.out.println("REUSE_PAGE_THRESHOLD is " + this.m_reusePageThreshold);
        }
        if (this.m_reusePageThreshold < 0 || this.m_reusePageThreshold > 100) {
            throw new Error("REUSE_PAGE_THRESHOLD is set to " + this.m_reusePageThreshold + ",  must be in the 0 to 100 range.");
        }
        int asyncQueueSize = 2000;
        Integer asyncQueueSizeObject = (Integer)parameters.get(ASYNC_FILE_QUEUE_SIZE_PARAMETER);
        if (asyncQueueSizeObject != null && (asyncQueueSize = asyncQueueSizeObject.intValue()) < 100) {
            asyncQueueSize = 100;
        }
        String separateDataFile = (String)parameters.get(DATA_FILE_PARAMETER);
        boolean newDataFile = this.m_cachedPagesFile.open(this.m_fileName, logger, this.getCacheCapacities(parameters), asyncQueueSize, initializeFile, this.m_doFileSync, writeDirtyThreshold != null ? writeDirtyThreshold : 1000);
        if (newDataFile) {
            this.m_cachedPagesFile.allocateMasterPage();
            this.m_cachedPagesFile.writeMaster();
            this.forceToDisk();
        }
    }

    String getFileName() {
        return this.m_fileName;
    }

    void setTransactionManager(TransactionManager trManager) {
        this.m_transactionManager = trManager;
    }

    boolean getDoFileSync() {
        return this.m_doFileSync;
    }

    private int[] getCacheCapacities(HashMap parameters) {
        Integer indexCacheSize = (Integer)parameters.get(INDEX_CACHE_SIZE_PARAMETER);
        Integer blobsCacheSize = (Integer)parameters.get(BLOBS_CACHE_SIZE_PARAMETER);
        Integer btreesCacheSize = (Integer)parameters.get(BTREE_CACHE_SIZE_PARAMETER);
        Integer headersCacheSize = (Integer)parameters.get(HEADERS_CACHE_SIZE_PARAMETER);
        Integer freePagesCacheSize = (Integer)parameters.get(FREE_PAGES_CACHE_SIZE_PARAMETER);
        int[] capacities = new int[5];
        capacities[0] = indexCacheSize != null ? indexCacheSize : 1000;
        capacities[1] = blobsCacheSize != null ? blobsCacheSize : 500;
        capacities[3] = btreesCacheSize != null ? btreesCacheSize : 1000;
        capacities[2] = headersCacheSize != null ? headersCacheSize : 500;
        capacities[4] = freePagesCacheSize != null ? freePagesCacheSize : 500;
        return capacities;
    }

    long[] getList(byte pageType) throws IOException {
        ArrayList objectList = new ArrayList();
        MasterPage master = (MasterPage)this.m_cachedPagesFile.get(false, 0L);
        this.getList(master, objectList, PageManager.usedAnchorFromType(pageType));
        this.getList(master, objectList, PageManager.fullAnchorFromType(pageType));
        long[] retVal = new long[objectList.size()];
        for (int i = 0; i < objectList.size(); ++i) {
            retVal[i] = (Long)objectList.get(i);
        }
        return retVal;
    }

    private void getList(MasterPage master, ArrayList objectList, byte chainAnchor) throws IOException {
        long pageNum = master.getChainFirst(chainAnchor);
        while (pageNum != 0L) {
            objectList.add(new Long(pageNum));
            DataPage nextPage = (DataPage)this.m_cachedPagesFile.get(false, pageNum);
            pageNum = nextPage.getChainNext();
        }
    }

    private int getAllListsDEBUG(ArrayList chains) throws IOException {
        MasterPage master = (MasterPage)this.m_cachedPagesFile.get(false, 0L);
        int totalPages = 0;
        for (int i = 0; i <= 8; ++i) {
            ArrayList chainPages = new ArrayList();
            this.getList(master, chainPages, (byte)i);
            chains.add(chainPages);
            totalPages += chainPages.size();
        }
        return totalPages;
    }

    long getHighestAllocatedPageNum() {
        return this.m_cachedPagesFile.getAllocatedCount() - 1L;
    }

    boolean pageConsistencyDEBUG() throws IOException {
        int i;
        boolean consistent = true;
        ArrayList chains = new ArrayList();
        int totalPages = this.getAllListsDEBUG(chains);
        if (this.m_cachedPagesFile.getAllocatedCount() != (long)(totalPages + 1)) {
            System.out.println("DEBUG Total allocated according to m_cachedPagesFile : " + this.m_cachedPagesFile.getAllocatedCount());
            System.out.println("DEBUG Total pages found in lists (plus master) : " + (totalPages + 1));
            System.out.println("ERROR: Page allocation inconsistenct.");
            consistent = false;
        }
        System.out.println("DEBUG: Total pages in chains " + totalPages);
        HashSet allPages = new HashSet();
        for (i = 0; i <= 8; ++i) {
            int currentPageCount = allPages.size();
            ArrayList chainList = (ArrayList)chains.get(i);
            allPages.addAll(chainList);
            if (allPages.size() - currentPageCount == chainList.size()) continue;
            throw new Error("ERROR: Chain " + i + " has duplicate pages.");
        }
        System.out.println("DEBUG: Total pages in page list " + allPages.size());
        if (totalPages != allPages.size()) {
            System.out.println("ERROR: Page Inconsistency - looking for page duplications.");
            consistent = false;
            for (i = 0; i <= 8; ++i) {
                for (int j = i + 1; j <= 8; ++j) {
                    HashSet copy = (HashSet)((HashSet)chains.get(i)).clone();
                    copy.retainAll((HashSet)chains.get(j));
                    if (copy.isEmpty()) continue;
                    System.out.println("ERROR: Chain " + i + " and chain " + j + " contain duplicates: ");
                    Iterator iterator = copy.iterator();
                    while (iterator.hasNext()) {
                        System.out.print(iterator.next() + " ");
                    }
                    System.out.println("");
                }
            }
        }
        return consistent;
    }

    Page getForRead(long pageNumber) throws IOException {
        return this.m_cachedPagesFile.get(false, pageNumber);
    }

    Page getForWrite(long pageNumber) throws IOException {
        return this.m_cachedPagesFile.get(true, pageNumber);
    }

    private static byte usedAnchorFromType(byte anchor) {
        switch (anchor) {
            case 0: {
                return 2;
            }
            case 1: {
                return 6;
            }
            case 3: {
                return 8;
            }
            case 2: {
                return 4;
            }
        }
        throw new Error("Illegal value " + anchor);
    }

    private static byte fullAnchorFromType(byte anchor) {
        switch (anchor) {
            case 0: {
                return 1;
            }
            case 1: {
                return 5;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 3;
            }
        }
        throw new Error("Illegal value " + anchor);
    }

    DataPage.AvailablePage getAvailablePage(byte pageType, int spaceNeeded, long currentTransaction) throws IOException {
        DataPage.AvailablePage availablePage = null;
        if (spaceNeeded < this.m_fullPageThreshold) {
            availablePage = this.getUsedPage(pageType, currentTransaction);
        }
        if (availablePage == null) {
            availablePage = this.getFreePage(currentTransaction);
        }
        if (pageType == 2) {
            this.m_lastHeaderPageUsed = availablePage.m_page.getPageNum();
        }
        return availablePage;
    }

    private DataPage.AvailablePage getUsedPage(byte type, long currentTransaction) throws IOException {
        MasterPage master = (MasterPage)this.m_cachedPagesFile.get(true, 0L);
        byte chainAnchor = PageManager.usedAnchorFromType(type);
        long pageNum = master.getChainFirst(chainAnchor);
        if (this.m_useMoreFreePagesForHeaderObjects && type == 2 && pageNum != this.m_lastHeaderPageUsed) {
            return null;
        }
        if (pageNum == 0L) {
            return null;
        }
        BitSetUtil reservedSlots = this.m_transactionManager.reservedSlots(pageNum);
        if (reservedSlots == null) {
            DataPage page = this.getForWriteAndReorgPage(pageNum, currentTransaction);
            if (page == null) {
                return null;
            }
            return new DataPage.AvailablePage(page);
        }
        DataPage page = (DataPage)this.getForRead(pageNum);
        byte freeSlot = ((ObjectsBuffer)page.getContentBuffer()).getEmptySlot(reservedSlots);
        if (freeSlot == -1) {
            return null;
        }
        page = this.getForWriteAndReorgPage(pageNum, currentTransaction);
        if (page == null) {
            return null;
        }
        return new DataPage.AvailablePage(page, freeSlot);
    }

    private DataPage getForWriteAndReorgPage(long pageNum, long currentTransaction) throws IOException {
        DataPage page = (DataPage)this.m_cachedPagesFile.get(false, pageNum);
        boolean pageCanBeUsed = false;
        if (page.needsReorg()) {
            if (page.canReorg(currentTransaction)) {
                pageCanBeUsed = true;
            }
        } else {
            pageCanBeUsed = true;
        }
        if (pageCanBeUsed) {
            page = (DataPage)this.m_cachedPagesFile.get(true, pageNum);
            if (page.needsReorg()) {
                page.doReorg();
            }
            return page;
        }
        return null;
    }

    DataPage.AvailablePage getFreePage(long currentTransaction) throws IOException {
        MasterPage master = (MasterPage)this.m_cachedPagesFile.get(true, 0L);
        long pageNum = master.getChainFirst((byte)0);
        if (pageNum == 0L) {
            return new DataPage.AvailablePage(this.m_cachedPagesFile.allocate());
        }
        if (this.m_transactionManager.reservedSlots(pageNum) == null) {
            DataPage page = this.getForWriteAndReorgPage(pageNum, currentTransaction);
            if (page == null) {
                page = this.m_cachedPagesFile.allocate();
            }
            return new DataPage.AvailablePage(page);
        }
        return new DataPage.AvailablePage(this.m_cachedPagesFile.allocate());
    }

    private DataPage removeFromChain(long pageNum, byte anchorNum) throws IOException {
        long noteID;
        long noteID2;
        MasterPage master = (MasterPage)this.m_cachedPagesFile.get(true, 0L);
        DataPage page = (DataPage)this.m_cachedPagesFile.get(false, pageNum);
        byte chainNum = page.getChainNum();
        if (chainNum == -1) {
            throw new Error("Not on chain");
        }
        long next = page.getChainNext();
        long prev = page.getChainPrev();
        DataPage nextPage = null;
        if (next != 0L) {
            nextPage = (DataPage)this.m_cachedPagesFile.get(true, next);
        }
        DataPage prevPage = null;
        if (prev != 0L) {
            prevPage = (DataPage)this.m_cachedPagesFile.get(true, prev);
        }
        if (nextPage == null) {
            this.m_chainAnchorNote.initNote(anchorNum, false, master.getChainLast(anchorNum), prev);
            noteID2 = this.m_logger.writeNote(this.m_chainAnchorNote);
            master.setChainLast(anchorNum, prev);
            master.setNoteID(noteID2);
        } else {
            byte nextPageChain = nextPage.getChainNum();
            this.m_pageChainPrevNote.initNote(nextPage.getPageNum(), nextPage.getChainPrev(), prev, nextPageChain, nextPageChain);
            noteID = this.m_logger.writeNote(this.m_pageChainPrevNote);
            nextPage.setChainPrev(prev);
            nextPage.setNoteID(noteID);
        }
        if (prevPage == null) {
            this.m_chainAnchorNote.initNote(anchorNum, true, master.getChainFirst(anchorNum), next);
            noteID2 = this.m_logger.writeNote(this.m_chainAnchorNote);
            master.setChainFirst(anchorNum, next);
            master.setNoteID(noteID2);
        } else {
            byte prevPageChain = prevPage.getChainNum();
            this.m_pageChainNextNote.initNote(prevPage.getPageNum(), prevPage.getChainNext(), next, prevPageChain, prevPageChain);
            noteID = this.m_logger.writeNote(this.m_pageChainNextNote);
            prevPage.setChainNext(next);
            prevPage.setNoteID(noteID);
        }
        return page;
    }

    private void putFirstOnChain(DataPage page, byte chainNum) throws IOException {
        MasterPage master = (MasterPage)this.m_cachedPagesFile.get(true, 0L);
        DataPage currentFirst = null;
        long currentFirstNum = master.getChainFirst(chainNum);
        if (currentFirstNum != 0L) {
            currentFirst = (DataPage)this.m_cachedPagesFile.get(true, currentFirstNum);
        }
        this.m_pageChainPrevNote.initNote(page.getPageNum(), page.getChainPrev(), 0L, page.getChainNum(), chainNum);
        long noteID = this.m_logger.writeNote(this.m_pageChainPrevNote);
        this.m_pageChainNextNote.initNote(page.getPageNum(), page.getChainNext(), currentFirstNum, page.getChainNum(), chainNum);
        noteID = this.m_logger.writeNote(this.m_pageChainNextNote);
        page.setChainNext(currentFirstNum);
        page.setChainPrev(0L);
        page.setChainNum(chainNum);
        page.setNoteID(noteID);
        this.m_chainAnchorNote.initNote(chainNum, true, master.getChainFirst(chainNum), page.getPageNum());
        noteID = this.m_logger.writeNote(this.m_chainAnchorNote);
        master.setChainFirst(chainNum, page.getPageNum());
        master.setNoteID(noteID);
        if (currentFirst != null) {
            byte crntChainNum = currentFirst.getChainNum();
            this.m_pageChainPrevNote.initNote(currentFirst.getPageNum(), currentFirst.getChainPrev(), page.getPageNum(), crntChainNum, crntChainNum);
            noteID = this.m_logger.writeNote(this.m_pageChainPrevNote);
            currentFirst.setChainPrev(page.getPageNum());
            currentFirst.setNoteID(noteID);
        } else {
            this.m_chainAnchorNote.initNote(chainNum, false, master.getChainLast(chainNum), page.getPageNum());
            noteID = this.m_logger.writeNote(this.m_chainAnchorNote);
            master.setChainLast(chainNum, page.getPageNum());
            master.setNoteID(noteID);
        }
    }

    private void putLastOnChain(DataPage page, byte chainNum) throws IOException {
        MasterPage master = (MasterPage)this.m_cachedPagesFile.get(true, 0L);
        DataPage currentLast = null;
        long currentLastNum = master.getChainLast(chainNum);
        if (currentLastNum != 0L) {
            currentLast = (DataPage)this.m_cachedPagesFile.get(true, currentLastNum);
        }
        this.m_pageChainPrevNote.initNote(page.getPageNum(), page.getChainPrev(), currentLastNum, page.getChainNum(), chainNum);
        long noteID = this.m_logger.writeNote(this.m_pageChainPrevNote);
        this.m_pageChainNextNote.initNote(page.getPageNum(), page.getChainNext(), 0L, page.getChainNum(), chainNum);
        noteID = this.m_logger.writeNote(this.m_pageChainNextNote);
        page.setChainPrev(currentLastNum);
        page.setChainNext(0L);
        page.setChainNum(chainNum);
        page.setNoteID(noteID);
        this.m_chainAnchorNote.initNote(chainNum, false, master.getChainLast(chainNum), page.getPageNum());
        noteID = this.m_logger.writeNote(this.m_chainAnchorNote);
        master.setChainLast(chainNum, page.getPageNum());
        master.setNoteID(noteID);
        if (currentLast != null) {
            byte crntChainNum = currentLast.getChainNum();
            this.m_pageChainNextNote.initNote(currentLast.getPageNum(), currentLast.getChainNext(), page.getPageNum(), crntChainNum, crntChainNum);
            noteID = this.m_logger.writeNote(this.m_pageChainNextNote);
            currentLast.setChainNext(page.getPageNum());
            currentLast.setNoteID(noteID);
        } else {
            this.m_chainAnchorNote.initNote(chainNum, true, master.getChainFirst(chainNum), page.getPageNum());
            noteID = this.m_logger.writeNote(this.m_chainAnchorNote);
            master.setChainFirst(chainNum, page.getPageNum());
            master.setNoteID(noteID);
        }
    }

    void doneUpdate(DataPage page, byte newPageTypeParam, long transactionNum) throws IOException {
        this.doneUpdate(page, newPageTypeParam, transactionNum, false);
    }

    void doneUpdate(DataPage page, byte newPageTypeParam, long transactionNum, boolean fromDelete) throws IOException {
        byte newChainNum;
        byte oldPageType = page.getPageType();
        byte oldChainNum = page.getChainNum();
        byte newPageType = newPageTypeParam;
        boolean putLast = false;
        if (page.isFree()) {
            newChainNum = 0;
            newPageType = 4;
            if (page.needsReorg() || this.m_transactionManager.reservedSlots(page.getPageNum()) != null) {
                putLast = true;
            }
        } else if (page.isFull(fromDelete, this.m_reusePageThreshold)) {
            newChainNum = PageManager.fullAnchorFromType(newPageType);
        } else {
            newChainNum = PageManager.usedAnchorFromType(newPageType);
            if (page.needsReorg()) {
                putLast = true;
            }
        }
        page.getContentBuffer().setTransactionNum(transactionNum);
        if (newPageType != oldPageType) {
            this.m_pageTypeNote.initNote(page.getPageNum(), page.getPageType(), newPageType);
            long noteID = this.m_logger.writeNote(this.m_pageTypeNote);
            page.setPageType(newPageType);
            page.setNoteID(noteID);
        }
        if (oldChainNum != -1 && oldChainNum != newChainNum) {
            this.removeFromChain(page.getPageNum(), oldChainNum);
        }
        if (newChainNum != -1 && oldChainNum != newChainNum) {
            if (putLast) {
                this.putLastOnChain(page, newChainNum);
            } else {
                this.putFirstOnChain(page, newChainNum);
            }
        }
        this.writePagesIfNeeded(true);
    }

    void writePagesIfNeeded(boolean forceLog) throws IOException {
        this.m_cachedPagesFile.writePagesIfNeeded(forceLog);
    }

    void clearCache() {
        this.m_cachedPagesFile.clearCache();
    }

    void forceToDisk() throws IOException {
        this.forceToDiskPhase1();
        this.forceToDiskPhase2();
    }

    void forceToDiskPhase1() throws IOException {
        this.m_cachedPagesFile.writePages(true);
        this.m_cachedPagesFile.writeMaster();
    }

    void forceToDiskPhase2() throws IOException {
        this.m_cachedPagesFile.syncBuffers();
    }

    long getFileSize() throws IOException {
        return this.m_cachedPagesFile.getFileSize();
    }

    void close() throws IOException {
        this.m_cachedPagesFile.close();
    }
}

