/*
 * Decompiled with CFR 0.152.
 */
package com.sonicsw.mtstorage.impl;

import com.sonicsw.mtstorage.impl.BitSetUtil;
import com.sonicsw.mtstorage.impl.Dbkey;
import com.sonicsw.mtstorage.impl.ObjectsBuffer;
import com.sonicsw.mtstorage.impl.TransactionContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;

final class TransactionManager
implements Serializable {
    private static final long serialVersionUID = 0L;
    private long m_lastTransactionID;
    private HashMap m_transactions = new HashMap();
    private HashMap m_readonlyTransactions = new HashMap();
    private HashMap m_pages = new HashMap();

    TransactionManager() {
    }

    synchronized byte[] serialize() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeObject(this);
            byte[] bytes = out.toByteArray();
            objectOut.close();
            return bytes;
        }
        catch (Throwable t) {
            throw new Error("TransactionManager serialize failure: " + t.toString());
        }
    }

    static TransactionManager deSerialize(byte[] bytes, int offset) {
        try {
            ObjectInputStream objectIn = new ObjectInputStream(new ByteArrayInputStream(bytes, offset, bytes.length - offset));
            TransactionManager tm = (TransactionManager)objectIn.readObject();
            return tm;
        }
        catch (Exception t) {
            throw new Error("TransactionManager deSerialize failure: " + t.toString());
        }
    }

    synchronized boolean activeUpdateTransaction(Long transID) {
        return this.m_transactions.containsKey(transID);
    }

    synchronized boolean hasActiveUpdateTransaction() {
        return this.m_transactions.size() > 0;
    }

    synchronized boolean writeTransaction(Long transID) {
        return transID != null && this.m_transactions.containsKey(transID);
    }

    synchronized boolean isReadonly(Long transID) throws IOException {
        if (this.m_readonlyTransactions.containsKey(transID)) {
            return true;
        }
        if (this.m_transactions.containsKey(transID)) {
            return false;
        }
        throw new IOException("Transaction " + transID + " is not active.");
    }

    synchronized Long transactionBegin() {
        long currentTransactionNum = ++this.m_lastTransactionID;
        Long trNum = new Long(currentTransactionNum);
        this.m_transactions.put(trNum, new TransactionContext(false));
        return trNum;
    }

    synchronized Long transactionBegin(long transNum) {
        this.m_lastTransactionID = transNum - 1L;
        return this.transactionBegin();
    }

    synchronized Long readonlyTransactionBegin() {
        Long trNum = new Long(++this.m_lastTransactionID);
        this.m_readonlyTransactions.put(trNum, new TransactionContext(true));
        return trNum;
    }

    synchronized long getNextSnapshotID() {
        return ++this.m_lastTransactionID;
    }

    synchronized void setLogTransactionStartID(Long transactionID, long id) {
        ((TransactionContext)this.m_transactions.get(transactionID)).setTransactionStartLogID(id);
    }

    synchronized Long getOldsetLogTransactionID() {
        Long oldset = null;
        Iterator transIter = this.m_transactions.values().iterator();
        while (transIter.hasNext()) {
            long crntOldest = ((TransactionContext)transIter.next()).getTransactionStartLogID();
            if (oldset != null && crntOldest >= oldset) continue;
            oldset = new Long(crntOldest);
        }
        return oldset;
    }

    synchronized void transactionEnd(Long transID) {
        if (this.m_readonlyTransactions.remove(transID) != null) {
            return;
        }
        TransactionContext transaction = (TransactionContext)this.m_transactions.remove(transID);
        if (transaction == null) {
            return;
        }
        HashMap transactionPages = transaction.getTransactionPages();
        if (transactionPages == null) {
            return;
        }
        for (Long pageNum : transactionPages.keySet()) {
            BitSetUtil trSlots = (BitSetUtil)transactionPages.get(pageNum);
            BitSetUtil pageSlots = (BitSetUtil)this.m_pages.get(pageNum);
            if (pageSlots == null) continue;
            pageSlots.andNot(trSlots);
            if (pageSlots.cardinality() != 0) continue;
            this.m_pages.remove(pageNum);
        }
    }

    synchronized void reserveDBK(Long transID, long dbk) {
        Long pageNum = new Long(Dbkey.getPageNumber(dbk));
        byte slot = Dbkey.getSlot(dbk);
        this.transactionReserveDBK(transID, pageNum, slot);
        this.pageReserveDBK(pageNum, slot);
    }

    private void transactionReserveDBK(Long transactionID, Long pageNum, byte slot) {
        ((TransactionContext)this.m_transactions.get(transactionID)).reserveDBK(pageNum, slot);
    }

    private void pageReserveDBK(Long pageNum, byte slot) {
        BitSetUtil pageSlots = (BitSetUtil)this.m_pages.get(pageNum);
        if (pageSlots == null) {
            pageSlots = ObjectsBuffer.createEmptySlots();
            this.m_pages.put(pageNum, pageSlots);
        }
        pageSlots.set(slot);
    }

    synchronized void pageUnreserveDBK(long dbkey) {
        this.pageUnreserveDBK(new Long(Dbkey.getPageNumber(dbkey)), Dbkey.getSlot(dbkey));
    }

    private void pageUnreserveDBK(Long pageNum, byte slot) {
        BitSetUtil pageSlots = (BitSetUtil)this.m_pages.get(pageNum);
        if (pageSlots == null) {
            return;
        }
        pageSlots.clear(slot);
        if (pageSlots.cardinality() == 0) {
            this.m_pages.remove(pageNum);
        }
    }

    synchronized BitSetUtil reservedSlots(long pageNum) {
        return (BitSetUtil)this.m_pages.get(new Long(pageNum));
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.m_transactions);
        s.writeObject(this.m_pages);
        s.writeLong(this.m_lastTransactionID);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.m_transactions = (HashMap)s.readObject();
        this.m_pages = (HashMap)s.readObject();
        this.m_lastTransactionID = s.readLong();
        this.m_readonlyTransactions = new HashMap();
    }
}

