/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.ObjectNotExportedException;
import com.odi.Placement;
import com.odi.imp.Cluster;
import com.odi.imp.MutatingObjRef;
import com.odi.imp.NonWeakReferenceFactory;
import com.odi.imp.ObjRefUtils;
import com.odi.imp.ObjectAccess;
import com.odi.imp.ObjectManager;
import com.odi.imp.ObjectReference;
import com.odi.imp.ReferenceType;
import com.odi.imp.Segment;
import com.odi.imp.WeakReferenceFactory;

public abstract class ObjectReferenceFactory {
    protected ObjectManager om;
    private ObjectReference nullObjectReference;

    protected ObjectReferenceFactory(ObjectManager om) {
        this.om = om;
        this.nullObjectReference = new MutatingObjRef(om, null, 0L, 0);
    }

    static ObjectReferenceFactory createFactory(ObjectManager om) {
        String disableWeakReferences = om.getProperty("com.odi.disableWeakReferences", "false");
        if (Boolean.valueOf(disableWeakReferences).booleanValue()) {
            return new NonWeakReferenceFactory(om);
        }
        return new WeakReferenceFactory(om);
    }

    private final ObjectReference create(Object object, int databaseId, int segmentId, int clusterId, long location, int AFTypeCode, int arrayElementCount) {
        Placement place = this.om.getPlacement(databaseId, segmentId, clusterId);
        return this.create(object, place, location, AFTypeCode, arrayElementCount);
    }

    public final ObjectReference create(Object object, ObjectReference source) {
        return this.create(object, source.getPlacement(), source.getLocation(), source.getAFTypeCode(), source.getArrayElementCount());
    }

    private final ObjectReference create(Object object, byte[] buffer, int objRefOffset) {
        ObjectAccess objectAccess = this.om.objectAccess;
        return this.create(object, this.om.getPlacement(objectAccess.decodeObjRefDatabaseId(buffer, objRefOffset), objectAccess.decodeObjRefSegmentId(buffer, objRefOffset), objectAccess.decodeObjRefClusterId(buffer, objRefOffset)), objectAccess.decodeObjRefLocation(buffer, objRefOffset), objectAccess.decodeObjRefTypeCode(buffer, objRefOffset), objectAccess.decodeObjRefArrayElementCount(buffer, objRefOffset));
    }

    public abstract ObjectReference create(Object var1, Placement var2, long var3, int var5, int var6);

    public boolean supportsWeakReference() {
        return true;
    }

    public final ObjectReference createLocal(Object object, ObjectReference exportedObjRef) {
        MutatingObjRef local = this.createMutating(exportedObjRef);
        long[] result = new long[2];
        Segment segment = ObjRefUtils.getSegment(exportedObjRef);
        segment.getExportedObjectLocation(local, result);
        com.odi.Cluster cluster = segment.getClusterObject((int)result[0]);
        return this.create(object, cluster, result[1], exportedObjRef.getAFTypeCode(), exportedObjRef.getArrayElementCount());
    }

    public final ObjectReference createExported(Object object, ObjectReference localObjRef) {
        ObjectReference exported = this.createExportedNoThrow(object, localObjRef);
        if (exported == null) {
            throw new ObjectNotExportedException("Object was the target of an inter-segment reference but it is not currently exported", object, localObjRef);
        }
        return exported;
    }

    public final ObjectReference createExportedNoThrow(Object object, ObjectReference localObjRef) {
        MutatingObjRef exported = this.createMutating(localObjRef);
        Segment segment = ObjRefUtils.getSegment(localObjRef);
        int exportedObjectId = segment.getExportedObjectId(exported);
        if (exportedObjectId == -1) {
            return null;
        }
        return this.create(object, segment, exportedObjectId, localObjRef.getAFTypeCode(), localObjRef.getArrayElementCount());
    }

    public ObjectReference getNull() {
        return this.nullObjectReference;
    }

    public MutatingObjRef createMutating() {
        return new MutatingObjRef(this.om, null, 0L, 17);
    }

    public MutatingObjRef createMutating(ObjectReference objRef) {
        return new MutatingObjRef(objRef);
    }

    public MutatingObjRef createMutating(Placement place, long location) {
        return new MutatingObjRef(place, location, 17);
    }

    public MutatingObjRef createMutating(Placement place, long location, int AFTypeCode) {
        return new MutatingObjRef(place, location, AFTypeCode);
    }

    public MutatingObjRef createMutating(Placement place, long location, int AFTypeCode, int arrayElementCount) {
        return new MutatingObjRef(place, location, AFTypeCode, arrayElementCount);
    }

    public MutatingObjRef createMutating(byte[] buffer, int offset) {
        MutatingObjRef objRef = new MutatingObjRef(this.om, null, 0L, 17);
        objRef.setAttributes(buffer, offset);
        return objRef;
    }

    ObjectReference createLazyReference(ObjectReference containingObject, ObjectAccess objectAccess, byte[] buffer, int objRefOffset, ReferenceType refType) {
        Cluster cluster = ObjRefUtils.getCluster(containingObject);
        return refType.decode(buffer, objRefOffset, objectAccess).createObjectReference(cluster, 17);
    }
}

