/*
 * Decompiled with CFR 0.152.
 */
package com.odi.imp;

import com.odi.ClassInfo;
import com.odi.Placement;
import com.odi.imp.Cluster;
import com.odi.imp.GenericObject;
import com.odi.imp.ObjectAccess;
import com.odi.imp.ObjectReference;
import com.odi.imp.Ref4ByteLocal;
import com.odi.imp.Ref8ByteLocal;
import com.odi.imp.Reference;

public abstract class ReferenceType {
    public static ReferenceType REF_4BYTE_LOCAL = new Ref4ByteLocal(1);
    public static ReferenceType REF_8BYTE_LOCAL = new Ref8ByteLocal(2);
    public static final int NUM_TYPES = 4;
    public static ReferenceType DEFAULT = REF_4BYTE_LOCAL;
    private int enumeratedValue;

    public int getEnumeratedValue() {
        return this.enumeratedValue;
    }

    public static ReferenceType getKeyReferenceType() {
        return DEFAULT;
    }

    public static int getEnumeratedValue(Class referenceClass) {
        if (referenceClass == REF_4BYTE_LOCAL.getReferenceClass()) {
            return ReferenceType.REF_4BYTE_LOCAL.enumeratedValue;
        }
        if (referenceClass == REF_8BYTE_LOCAL.getReferenceClass()) {
            return ReferenceType.REF_8BYTE_LOCAL.enumeratedValue;
        }
        throw new UnsupportedOperationException(referenceClass.getName() + " not supported");
    }

    public static ReferenceType getReferenceType(Class referenceClass) {
        if (referenceClass == REF_4BYTE_LOCAL.getReferenceClass()) {
            return REF_4BYTE_LOCAL;
        }
        if (referenceClass == REF_8BYTE_LOCAL.getReferenceClass()) {
            return REF_8BYTE_LOCAL;
        }
        throw new UnsupportedOperationException(referenceClass.getName() + " not supported");
    }

    public static ReferenceType getReferenceType(int enumeratedValue) {
        switch (enumeratedValue) {
            case 1: {
                return REF_4BYTE_LOCAL;
            }
            case 2: {
                return REF_8BYTE_LOCAL;
            }
            case 3: {
                return REF_8BYTE_LOCAL;
            }
            case 4: {
                return REF_8BYTE_LOCAL;
            }
        }
        throw new UnsupportedOperationException("Invalid enumerated value " + enumeratedValue);
    }

    public final String toString() {
        switch (this.getEnumeratedValue()) {
            case 1: {
                return "ReferenceType.REF_4BYTE_LOCAL";
            }
            case 2: {
                return "ReferenceType.REF_8BYTE_LOCAL";
            }
            case 3: {
                return "ReferenceType.REF_8BYTE_LOCAL";
            }
            case 4: {
                return "ReferenceType.REF_8BYTE_LOCAL";
            }
        }
        throw new UnsupportedOperationException("Invalid enumerated value " + this.enumeratedValue);
    }

    protected ReferenceType(int enumeratedValue) {
        this.enumeratedValue = enumeratedValue;
    }

    public abstract Reference getFieldValue(GenericObject var1, int var2, ClassInfo var3);

    public Reference[] getEmptyArray(int size) {
        Reference[] refs = new Reference[size];
        for (int i = 0; i < size; ++i) {
            refs[i] = this.NULL();
        }
        return refs;
    }

    public abstract Reference makeReference(byte[] var1, int var2);

    public abstract byte[] getBytes(Reference var1);

    public abstract void setFieldValue(Reference var1, GenericObject var2, int var3, ClassInfo var4);

    public abstract Class getReferenceClass();

    public abstract Reference[] getArrayFieldValue(int var1, GenericObject var2, int var3, ClassInfo var4);

    public abstract void setArrayFieldValue(Reference[] var1, GenericObject var2, int var3, ClassInfo var4);

    public abstract int size();

    public abstract Reference NULL();

    public abstract void copy(Reference var1, Reference var2);

    public abstract boolean areEqualReferences(Reference var1, ObjectReference var2);

    public abstract Object resolve(Reference var1, com.odi.Cluster var2, int var3);

    public abstract Object resolve(Reference var1, com.odi.Cluster var2);

    public abstract Reference getReference(Object var1);

    public abstract Reference getReference(ObjectReference var1);

    public abstract ReferenceType childLeafType();

    public abstract void resolveObjectReference(ObjectReference var1, Placement var2, Reference var3, int var4, int var5);

    public abstract void encodeNull(byte[] var1, int var2, ObjectAccess var3);

    public abstract boolean isNullEncoding(byte[] var1, int var2, ObjectAccess var3);

    public abstract byte[] encodeToByteArray(Reference var1, byte[] var2);

    public abstract void encode(byte[] var1, int var2, Reference var3, ObjectAccess var4);

    public abstract void encode(byte[] var1, int var2, Reference var3);

    public abstract Reference decode(byte[] var1, int var2, ObjectAccess var3);

    public abstract Reference decode(byte[] var1, int var2);

    public abstract Reference decode(byte[] var1);

    public abstract ObjectReference createObjectReference(Reference var1, Cluster var2, int var3);
}

