/*
 * Decompiled with CFR 0.152.
 */
package com.odi.util.query;

import com.odi.util.OSHashSet;
import com.odi.util.query.FreeVariableBindings;
import com.odi.util.query.Methods;
import com.odi.util.query.MethodsGenerator;
import com.odi.util.query.QPT;
import com.odi.util.query.QueryEvalNode;
import com.odi.util.query.QueryEvalTree;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class FilterEvalNode
extends QueryEvalNode {
    QueryEvalNode child;
    private QPT.Expr predicate;
    Methods methods;
    int predicateIndex = -1;
    private Class collectionType;

    public FilterEvalNode(QueryEvalNode child, QPT.Expr predicate) {
        this.child = child;
        this.predicate = predicate;
    }

    public QueryEvalNode getChild() {
        return this.child;
    }

    public void setChild(QueryEvalNode child) {
        this.assertState((byte)1);
        this.child = child;
    }

    public QPT.Expr getPredicate() {
        return this.predicate;
    }

    public void setPredicate(QPT.Expr predicate) {
        this.assertState((byte)1);
        this.predicate = predicate;
    }

    @Override
    protected void computeMethodsInternal(MethodsGenerator generator) {
        this.child.computeMethods(generator);
        this.predicateIndex = generator.addPredicate(this.predicate);
    }

    @Override
    protected QueryEvalNode bindInternal(FreeVariableBindings freeVariableBindings, Collection collection, Methods methods) {
        FilterEvalNode result = new FilterEvalNode(this.child.bind(freeVariableBindings, collection, methods), this.predicate);
        result.predicateIndex = this.predicateIndex;
        result.methods = methods;
        result.collectionType = this.predicate.qpt().elementType;
        return result;
    }

    @Override
    protected void collectStatisticsInternal(QueryEvalTree tree) {
        this.child.collectStatistics(tree);
    }

    @Override
    protected boolean hasFastContainsInternal() {
        return this.child.hasFastContains();
    }

    @Override
    protected boolean containsInternal(Object object) {
        return this.predicate(object) && this.child.contains(object);
    }

    @Override
    protected Iterator iteratorInternal(boolean allowDuplicates) {
        return new NodeIterator(allowDuplicates);
    }

    @Override
    public Set computeSet() {
        Set result = null;
        if (this.child.isSetComputed()) {
            result = this.child.getSet(true);
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (this.predicate(object)) continue;
                iterator.remove();
            }
        } else {
            result = new OSHashSet(1);
            Iterator iterator = this.child.iterator(true);
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!this.predicate(object)) continue;
                result.add(object);
            }
        }
        return result;
    }

    @Override
    public void estimateSize() {
        this.minSize = 0;
        this.maxSize = this.child.getMaxSize();
    }

    @Override
    String toPrintString() {
        return "{filter " + this.child.toPrintString() + " where " + this.predicate.toPrintString() + "}";
    }

    @Override
    public void print(PrintWriter out, int indentLevel) {
        String text = this.indentedString(indentLevel, this.toPrintString());
        if (text.length() > 80) {
            out.println(this.indentedString(indentLevel, "{filter"));
            this.child.print(out, indentLevel + 1);
            out.println(this.indentedString(indentLevel, "where"));
            this.predicate.print(out, indentLevel + 1);
            out.println(this.indentedString(indentLevel, "}"));
        } else {
            out.println(text);
        }
    }

    boolean predicate(Object object) {
        return this.methods.predicate(this.predicateIndex, object);
    }

    @Override
    public String toString() {
        return this.identityToString() + ": child=" + this.child + ", predicate=" + this.predicate + ", methods=" + this.methods + ", predicateIndex=" + this.predicateIndex + ", collectionType=" + this.collectionType + ", " + super.toString();
    }

    final class NodeIterator
    implements Iterator {
        private Iterator childIterator;
        private Object next = this;

        NodeIterator(boolean allowDuplicates) {
            this.childIterator = FilterEvalNode.this.getChild().iterator(allowDuplicates);
        }

        @Override
        public boolean hasNext() {
            if (this.next != this) {
                return true;
            }
            while (this.childIterator.hasNext()) {
                Object possibleNext = this.childIterator.next();
                if (!FilterEvalNode.this.predicate(possibleNext)) continue;
                this.next = possibleNext;
                return true;
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No next element");
            }
            Object result = this.next;
            this.next = this;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("The remove() method is not supported on this iterator.");
        }
    }
}

